#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

int NP_Subscription::add_server( const char *server )
{
   int result;
   if (( result = server_names.add_item( server )))
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "add_server(): %s", server_names.get_error() );
      return result;
   }

   if (( total = server_names.get_total()) < 0 )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "add_server(): %s", server_names.get_error() );
      return 1;
   }
      
   if (( group_list
         = ( group_list_t *)realloc( group_list,
                                     total * sizeof *group_list )) == NULL )
   {
      perror( "realloc" );
      exit( 1 );
   }

   if (( group_list[ total - 1 ].server = strdup( server )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   if (( group_list[ total - 1 ].group_names = new NP_Stringarray()) == NULL )
   {
      perror( "new" );
      exit( 1 );
   }

   group_list[ total - 1 ].group_names->allow_duplicates( 0 );
   
   if (( group_list[ total - 1 ].article_nos = new NP_Stringarray()) == NULL )
   {
      perror( "new" );
      exit( 1 );
   }

   group_list[ total - 1 ].article_nos->allow_duplicates( 1 );
   
   return 0;
}

int NP_Subscription::add_server( const char *server, int i )
{
   int result;
   if (( result = add_server( server )))
      return result;

   if ( authentication.add( "", "" ))
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                " add_server(): %s", authentication.get_error() );
      return 1;
   }

   return 0;
}
