#include <errno.h>
#include <unistd.h>
#include <fcntl.h>

#include "npconfig.h"

void NP_Config::remove_group_files( char *filename )
{
   char buffer[ 1024 ], second_buffer[ 1024 ];

   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s", config->home,
             filename );

   FILE *file;
   snprintf( second_buffer, sizeof second_buffer, "%s:lock", buffer );
   if (( file = fopen( second_buffer, "r" )) != NULL )
   {
      fclose( file );
      snprintf( second_buffer, sizeof second_buffer,
                "Spool file: %s\nis currently locked by another"
                " process. %s will not have any of its data files removed"
                " from ~/.peruser_spool.",
                buffer, group );
      show_message( second_buffer, 0 );
      return;
   }

   if ( remove( buffer ))
      if ( errno != ENOENT )
         perror( "remove" );

   snprintf( second_buffer, sizeof second_buffer, "%s:read", buffer );
   if ( remove( second_buffer ))
      if ( errno != ENOENT )
         perror( "remove" );

   snprintf( second_buffer, sizeof second_buffer, "%s:requests", buffer );
   if ( remove( second_buffer ))
      if ( errno != ENOENT )
         perror( "remove" );

   snprintf( second_buffer, sizeof second_buffer, "%s:threading", buffer );
   if ( remove( second_buffer ))
      if ( errno != ENOENT )
         perror( "remove" );

   snprintf( second_buffer, sizeof second_buffer, "%s:ids", buffer );
   if ( remove( second_buffer ))
      if ( errno != ENOENT )
         perror( "remove" );

   return;
}

