#include <ctype.h>

#include "npconfig.h"

void replace_folder_callback( GtkWidget *widget, gpointer data )
{
   NP_Config *config = ( NP_Config *)data;

   if ( config->folder_clist_line < 0 )
   {
      config->show_message( "Select a folder in the list to replace, first",
                            0 );
      return;
   }

   GtkWidget *entry = ( GtkWidget *)gtk_object_get_data(
      GTK_OBJECT( widget->parent ), "name_entry" );

   char *line[ 2 ];
   if (( line[ 0 ] = gtk_entry_get_text( GTK_ENTRY( entry ))) == '\0' )
      return;

   NP_Folders *folders =
      ( NP_Folders *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                          "object" );

   entry = ( GtkWidget *)gtk_object_get_data(
      GTK_OBJECT( widget->parent->parent->parent ), "filter_entry" );

   if ( entry != NULL )
      line[ 1 ] = gtk_entry_get_text( GTK_ENTRY( entry ));

   GtkWidget *clist =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                         "clist" );

   char *old;
   gtk_clist_get_text( GTK_CLIST( clist ),
                       config->folder_clist_line, 0, &old );

   int result;
   if (( result = folders->alter( old, line[ 0 ], line[ 1 ] )))
   {
      if ( result == 2 )
      {
         char buffer[ 512 ];
         snprintf( buffer, sizeof buffer, "Folder %s already exists.",
                   line[ 0 ] );
         config->show_message( buffer, 0 );
      }
      else
         folders->print_error();
      return;
   }
   
   gtk_clist_set_text( GTK_CLIST( clist ), config->folder_clist_line, 0,
                       line[ 0 ] );

   if ( entry != NULL )
      gtk_clist_set_text( GTK_CLIST( clist ), config->folder_clist_line, 1,
                          line[ 1 ] );

   config->dirty = 1;

   return;
}

