#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

GtkWidget *fs;
char *filename = NULL;

void close_callback( GtkWidget *widget, gpointer data )
{
   gtk_main_quit();
   return;
}


void buttons_callback( GtkWidget *widget, gpointer data )
{
   if ( data )
      filename = gtk_file_selection_get_filename( GTK_FILE_SELECTION( fs));
   else
      filename = NULL;

   close_callback( NULL, NULL );

   return;
}

int main( int argc, char **argv )
{
   gtk_init( &argc, &argv );

   fs = gtk_file_selection_new( "Choose File" );
   gtk_container_border_width( GTK_CONTAINER( fs ), 10 );
   gtk_signal_connect( GTK_OBJECT( fs ), "delete_event",
                       GTK_SIGNAL_FUNC( close_callback ), NULL );
   gtk_signal_connect( GTK_OBJECT( fs ), "destroy",
                       GTK_SIGNAL_FUNC( close_callback ), NULL );
   gtk_window_set_title( GTK_WINDOW( fs ), "Get Filename Dialog" );

   gtk_signal_connect( GTK_OBJECT( GTK_FILE_SELECTION( fs )->ok_button ),
                       "clicked", 
                       GTK_SIGNAL_FUNC( buttons_callback ), ( gpointer)1);
   gtk_signal_connect( GTK_OBJECT( GTK_FILE_SELECTION( fs )->cancel_button ),
                       "clicked",
                       GTK_SIGNAL_FUNC( buttons_callback ), ( gpointer)0 );

   gtk_widget_show( fs );

   gtk_main();

   printf( "%s", (( filename == NULL ) ? "(cancelled)" : filename ));

   return 0;
}
