#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npnews.h"

int NP_News::get_xover_data( int begin, int end,
                             NP_File& spool, NP_File& read )
{
   char buffer[ 4096 ];
   if ( get_string( buffer, sizeof buffer ))
      return 1;

   if ( strncmp( buffer, "224", 3 ))
   {
      snprintf( error_message, sizeof error_message,
                "NP_News: get_xover_data(): %s",
              buffer );
      return 1;
   }

   for( ; ; )
   {
      if ( get_string( buffer, sizeof buffer ))
         return 1;

      if ( !strncmp( buffer, ".\r\n", 3 ))
         break;

      if ( stop )
      {
         strcpy( error_message, "NP_News: get_xover_data(): killed by "
                 "SIGTERM." );
         return 1;
      }
      
      if ( read.put_string( "u\n" ))
      {
         snprintf( error_message, sizeof error_message,
                   "NP_News: get_xover_data(): %s", read.get_error());
         return 1;
      }

      ++total_messages_transferred;

      char *pointer, *old_pointer, second_buffer[ 4096 ], third_buffer[ 4096 ];
      int copy_length, length;

      if ( ( pointer = strstr( buffer, "\t\t" )) == NULL )
         strcpy( second_buffer, buffer );
      else
        {
            old_pointer = buffer;
            second_buffer[ 0 ] = '\0';
            copy_length = length = 0;

            do
            {
                length = pointer - old_pointer;
                copy_length += strlen( second_buffer ) + length;

                strncat( second_buffer, old_pointer, length );
                second_buffer[ copy_length ] = '\0';
                strcat( second_buffer, "\t(empty)" );

                old_pointer = ++pointer;
            }
            while(( pointer = strstr( pointer, "\t\t" )) != NULL );

            if ( *( old_pointer + 1 ) == '\r' )
                strcat( second_buffer, "\t(empty)\r\n" );
            else
                strcat( second_buffer, old_pointer );
        }

        if (( pointer = strtok( second_buffer, "\t" )) == NULL )
        {
            if ( spool.put_string( ".\r\n" ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "get_xover_data(): %s", spool.get_error());
               return 1;
            }

            continue; 
        }

        snprintf( third_buffer, sizeof third_buffer,
                  "@header of article number %s:\r\n", pointer );
        if ( spool.put_string( third_buffer ))
        {
           snprintf( error_message, sizeof error_message, "NP_News: "
                     "get_xover_data(): %s", spool.get_error());
           return 1;
        }

        snprintf( third_buffer, sizeof third_buffer,
                  "Newsgroups: %s\r\n", group );
                  
        if (( pointer = strtok( NULL, "\t" )) == NULL )
        {
            if ( spool.put_string( ".\r\n" ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "get_xover_data(): %s", spool.get_error());
               return 1;
            }

            continue;
        }

        snprintf( third_buffer, sizeof third_buffer,
                  "Subject: %s\r\n", pointer );
        if ( spool.put_string( third_buffer ))
        {
           snprintf( error_message, sizeof error_message, "NP_News: "
                     "get_xover_data(): %s", spool.get_error());
           return 1;
        }
        
        if (( pointer = strtok( NULL, "\t" )) == NULL )
        {
            if ( spool.put_string( ".\r\n" ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "get_xover_data(): %s", spool.get_error());
               return 1;
            }

            continue;
        }

        snprintf( third_buffer, sizeof third_buffer,
                  "From: %s\r\n", pointer );
        if ( spool.put_string( third_buffer ))
        {
           snprintf( error_message, sizeof error_message, "NP_News: "
                     "get_xover_data(): %s", spool.get_error());
           return 1;
        }
        
        if (( pointer = strtok( NULL, "\t" )) == NULL )
        {
            if( spool.put_string( ".\r\n" ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "get_xover_data(): %s", spool.get_error());
               return 1;
            }

            continue;
        }

        snprintf( third_buffer, sizeof third_buffer,
                  "Date: %s\r\n", pointer );
        if ( spool.put_string( third_buffer ))
        {
           snprintf( error_message, sizeof error_message, "NP_News: "
                     "get_xover_data(): %s", spool.get_error());
           return 1;
        }

        if (( pointer = strtok( NULL, "\t" )) == NULL )
        {
           if ( spool.put_string( ".\r\n" ))
           {
              snprintf( error_message, sizeof error_message, "NP_News: "
                        "get_xover_data(): %s", spool.get_error());
              return 1;
           }
 
           continue;
        }

        snprintf( third_buffer, sizeof third_buffer,
                  "Message-ID: %s\r\n", pointer );
        if ( spool.put_string( third_buffer ))
        {
           snprintf( error_message, sizeof error_message, "NP_News: "
                     "get_xover_data(): %s", spool.get_error());
           return 1;
        }
        
        if (( pointer = strtok( NULL, "\t" )) == NULL )
        {
            if( spool.put_string( ".\r\n" ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "get_xover_data(): %s", spool.get_error());
               return 1;
            }

            continue;
        }

        if ( strncmp( pointer, "(empty)", 7 ))
        {
            snprintf( third_buffer, sizeof third_buffer,
                      "References: %s\r\n", pointer );
            if ( spool.put_string( third_buffer ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "get_xover_data(): %s", spool.get_error());
               return 1;
            }
        }        

        if (( pointer = strtok( NULL, "\t" )) == NULL )
        {
            if( spool.put_string( ".\r\n" ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "get_xover_data(): %s", spool.get_error());
               return 1;
            }
        
            continue;
        }

        snprintf( third_buffer, sizeof third_buffer,
                  "Bytes: %s\r\n", pointer );
        if ( spool.put_string( third_buffer ))
        {
           snprintf( error_message, sizeof error_message, "NP_News: "
                     "get_xover_data(): %s", spool.get_error());
           return 1;
        }

        if (( pointer = strtok( NULL, "\t\r\n" )) == NULL )
        {
            if( spool.put_string( ".\r\n" ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "get_xover_data(): %s", spool.get_error());
               return 1;
            }

            continue;
        }

        snprintf( third_buffer, sizeof third_buffer,
                  "Lines: %s\r\n", pointer );
        if ( spool.put_string( third_buffer ))
        {
           snprintf( error_message, sizeof error_message, "NP_News: "
                     "get_xover_data(): %s", spool.get_error());
           return 1;
        }

        if ( spool.put_string( ".\r\n" ))
        {
           snprintf( error_message, sizeof error_message, "NP_News: "
                     "get_xover_data(): %s", spool.get_error());
           return 1;
        }
    }

   return 0;
}
