#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "npnews.h"

int NP_News::post_articles()
{
   NP_File spool, temp, posted;

   char spool_path[ 1024 ];
   snprintf( spool_path, sizeof spool_path, "%s/.peruser_spool/%s-FOLLOW-UPS",
             home, address );
   if ( spool.openr( spool_path ))
   {
      if ( errno == ENOENT )
         return 0;
      
      snprintf( error_message, sizeof error_message, "NP_News: "
                "post_articles(): %s", spool.get_error());
      return 1;
   }

   char temp_path[ 1024 ];
   snprintf( temp_path, sizeof temp_path, "%s:temp", spool_path );
   if ( temp.openw( temp_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "post_articles(): %s", temp.get_error());
      return 1;
   }

   char posted_path[ 1024 ];
   snprintf( posted_path, sizeof posted_path, "%s/.peruser_spool/%s-POSTED",
             home, address );
   if ( posted.opena( posted_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "post_articles(): %s", posted.get_error());
      return 1;
   }

   char *line;   
   if (( line = spool.get_string()) == NULL )
      return 0;

   int total = 0;
   while(( line = spool.get_string()) != NULL )
      if ( !strncmp( line, ".\r\n", 3 ))
         ++total;

   if ( spool.seek( 0, SEEK_SET ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "post_articles(): %s", spool.get_error());
      return 1;
   }

   for( int i = 0; i < total; ++i )
   {
      char buffer[ 1024 ];

      if ( stop )
      {
         strcpy( error_message, "NP_News: post_articles(): killed by "
                 "SIGTERM." );
         return 1;
      }
      
      if ( put_string( "post\r\n" ))
         return 1;

      if ( get_string( buffer, sizeof buffer ))
         return 1;

      if ( strncmp( buffer, "340", 3 ))
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   " post_articles(): server responded to post command: %s",
                   buffer );
         return 1;
      }

      long position = spool.tell();
      if ( position < 0 )
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "post_articles(): %s", spool.get_error());
         return 1;
      }

      do
      {
         if (( line = spool.get_string()) == NULL )
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "post_articles(): %s", spool.get_error());
            return 1;
         }

         if ( put_string( line ))
            return 1;
      }
      while( strncmp( line, ".\r\n", 3 ));

      if ( get_string( buffer, sizeof buffer ))
         return 1;

      if ( spool.seek( position, SEEK_SET ))
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "post_articles(): %s", spool.get_error());
         return 1;
      }

      if ( strncmp( buffer, "240", 3 ))
         do
         {
            fprintf( stderr, "NP_News: post_articles(): "
                     "server rejected article: %s", buffer );
            
            if (( line = spool.get_string()) == NULL )
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "post_articles(): %s", spool.get_error());
               return 1;
            }

            if ( temp.put_string( line ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "post_articles(): %s", temp.get_error());
               return 1;
            }
         }
         while( strncmp( line, ".\r\n", 3 ));
      else
      {
         do
         {
            if (( line = spool.get_string()) == NULL )
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "post_articles(): %s", spool.get_error());
               return 1;
            }

            if ( posted.put_string( line ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "post_articles(): %s", posted.get_error());
               return 1;
            }
         }
         while( strncmp( line, ".\r\n", 3 ));

         ++total_messages_transferred;
      }
   }

   spool.close();
   temp.close();
   posted.close();
   
   rename( temp_path, spool_path );
   remove( temp_path );
   
   return 0;
}
