#ifdef PETSC_RCS_HEADER
"$Id: acconfig.h,v 1.1 2000/03/03 21:48:04 huangp Exp $"
"Defines the configuration for this machine"
#endif

#if !defined(INCLUDED_PETSCCONF_H)
#define INCLUDED_PETSCCONF_H

@TOP@
/* The PRIMARY source of this file is acconfig.h */
/* These are needed for ANY declaration that may be made by an AC_DEFINE */

/* Define with the Petsc machine description string */
#undef PETSC_MACHINE_INFO

/* Define to turn on aggressive debugging */
#undef PETSC_USE_DEBUG

/* Define to turn on logging */
#undef PETSC_USE_LOG

/* Define to turn on manual stack construction */
#undef PETSC_USE_STACK

/* Define to turn on complex arithmetic */
#undef PETSC_USE_COMPLEX

/* Define to turn on dynamic loading of the Petsc libraries */
#undef PETSC_USE_DYNAMIC_LIBRARIES

/* Define if std::complex<type> is available */
#undef PETSC_HAVE_STD_COMPLEX

/* Define if complex<type> is available */
#undef PETSC_HAVE_TEMPLATED_COMPLEX

/* Define if the Fotran names in C are unchanged */
#undef PETSC_HAVE_FORTRAN_NOUNDERSCORE

/* Define if the Fotran names in C have a trailing underscore */
#undef PETSC_HAVE_FORTRAN_UNDERSCORE

/* Define if the Fotran names in C have a traling double underscore */
#undef PETSC_HAVE_FORTRAN_UNDERSCORE_UNDERSCORE

/* Define if the Fotran names in C are uppercase */
#undef PETSC_HAVE_FORTRAN_CAPS

/* Define if the C++ compiler supports namespaces */
#undef PETSC_HAVE_CXX_NAMESPACE

/* Define if __attribute__((format (printf, a, b))) can be used to check printf format strings */
#undef PETSC_PRINTF_FORMAT_CHECK(a,b)

/* Define if floating poitn exceptions conform to the Sun 4 model */
#undef PETSC_HAVE_SUN4_STYLE_FPTRAP

/* Define if floating poitn exceptions conform to the Solaris model */
#undef PETSC_HAVE_SOLARIS_STYLE_FPTRAP

/* Define if floating poitn exceptions conform to the IRIX model */
#undef PETSC_HAVE_IRIX_STYLE_FPTRAP

/* Define if floating poitn exceptions conform to the RS6000 model */
#undef PETSC_HAVE_RS6000_STYLE_FPTRAP

/* Define to be the number of bits per byte */
#undef BITS_PER_BYTE

/* Define if 64 bit values */
#undef HAVE_64BITS

/* Define if RTLD_GLOBAL is a flag for dlopen() */
#undef PETSC_HAVE_RTLD_GLOBAL

/* Define if bytes should be swapped in generic binary output */
#undef HAVE_SWAPPED_BYTES

/* Define if stdarg can be used */
#undef USE_STDARG

/* Define if doubles must be double aligned */
#undef HAVE_DOUBLES_ALIGNED

/* Define as the string that has the name of the architecture */
#undef PETSC_ARCH_NAME

/* Define if MPI_Request_free does NOT work (some IBM systems) */
#undef HAVE_BROKEN_REQUEST_FREE

/* If using the Fortran BLAS, define this */
#undef HAVE_SLOW_NRM2

/* PETSC Arch name */
#undef ARCH_NAME

/* /usr/ucb/ps */
#undef HAVE_UCBPS

/* Define if SIGSYS is not defined */
#undef MISSING_SIGSYS

/* Define if SIGBUS is not defined */
#undef MISSING_SIGBUS

/* Define if SIGQUIT is not defined */
#undef MISSING_SIGQUIT

/* Define if v.printf requires the last argument to be cast as char * */
#undef HAVE_VPRINTF_CHAR

/* Define if free returns an int */
#undef HAVE_FREE_RETURN_INT

/* Define if GETPWUID is not available */
#undef MISSING_GETPWUID

/* Define is socket is not available */
#undef MISSING_SOCKETS

/* Define if Fortran does not allow integer * 4 etc. */
#undef MISSING_FORTRANSTAR

/* Define if DREAL is missing */
#undef MISSING_DREAL

/* Define if CPP macros cannot be recursive */
#undef HAVE_BROKEN_RECURSIVE_MACRO

/* Define if double and complex types will be aligned in memory automatically */
#undef HAVE_DOUBLE_ALIGN_MALLOC

/* Define if (void (*)(int)) casts are required for signals in C++ */
#undef SIGNAL_CAST

/* Define is sysinfo(int,char*,long) is available */
#undef HAVE_SYSINFO_3ARG

/* Define if linux sysinfo is available */
#undef HAVE_SYSINFO

/* Define to be the Petsc Fortran 90 interface header */
#undef PETSC_HAVE_F90_H

/* Define to be the Petsc Fortran 90 interface source */
#undef PETSC_HAVE_F90_C

/* Define if DBX is the default debugger */
#undef PETSC_USE_DBX_DEBUGGER

/* Define if DBX takes -p <pid> */
#undef PETSC_USE_P_FOR_DEBUGGER

/* Define if DBX takes -a <pid> */
#undef PETSC_USE_A_FOR_DEBUGGER

/* Define if DBX takes -pid <pid> */
#undef PETSC_USE_PID_FOR_DEBUGGER

/* Define if XDB is the default debugger */
#undef PETSC_USE_XDB_DEBUGGER

/* Define if XDB is the default debugger, since it takes -P <pid> */
#undef PETSC_USE_LARGEP_FOR_DEBUGGER

/* Define if getrusage() returns the memory size in kilobytes instead of pagesize */
#undef PETSC_USE_KBYTES_FOR_SIZE

/* Define if BLAS is available */
#undef HAVE_LIBBLAS

/* Define if LAPACK is available */
#undef HAVE_LIBLAPACK

/* Define if MPI is available */
#undef HAVE_MPI

/* Define if Petsc uniprocessor MPI is available */
#undef PETSC_HAVE_MPI_UNI

/* Define to be the size of the MPI_Comm type */
#undef SIZEOF_MPI_COMM

/* Define to be the size of the MPI_Fint type */
#undef SIZEOF_MPI_FINT

/* Define to be int if MPI_Fint is not found */
#undef MPI_Fint

/* Define if MPI_Comm_f2c() is available */
#undef HAVE_MPI_COMM_F2C

/* Define if MPI_Comm_c2f() is available */
#undef HAVE_MPI_COMM_C2F

/* Define if MPI_Comm_c2f is missing */
#undef MPI_Comm_c2f(comm)

/* Define if MPI_Comm_f2c is missing */
#undef MPI_Comm_f2c(comm)

/* Define if X11 is available */
#undef PETSC_HAVE_X11

/* Define if the MPICH MPE library is available */
#undef PETSC_HAVE_MPE

/* Define if the ADIC compiler is available */
#undef PETSC_HAVE_ADIC

/* Define if the BlockSolve package is available */
#undef PETSC_HAVE_BLOCKSOLVE

/* Define if the PVODE package is available */
#undef PETSC_HAVE_PVODE

/* Define if Triangle is available */
#undef PETSC_HAVE_TRIANGLE

/* Define if ParMetis is available */
#undef PETSC_HAVE_PARMETIS

/* Define if PLAPACK is available */
#undef PETSC_HAVE_PLAPACK
@BOTTOM@

#endif
