/* $Id: gridConst.h,v 1.3 1999/11/09 19:30:37 knepley Exp $ */

/*
    Routines for working with constrained grids
*/
typedef struct _p_PetscConstraintObject *PetscConstraintObject;
typedef struct _ConstraintOps {
  int (*getsize)(PetscConstraintObject, int *, int *, int *, int *, int *, int *, int *);
  int (*getindices)(PetscConstraintObject, Mesh, VarOrdering, int, ConstraintFlag, int *);
  int (*constrainelemvec)(PetscConstraintObject, Mesh, VarOrdering, int, int, int, PetscTruth, PetscTruth, ConstraintFlag, ElementVec);
  int (*constrainelemmat)(PetscConstraintObject, Mesh, VarOrdering, int, int, int, ConstraintFlag, ElementMat);
  int (*newelemvec)(PetscConstraintObject, VarOrdering, int, ElementVec);
  int (*newelemmat)(PetscConstraintObject, VarOrdering, int, ElementMat);
  int (*applyrhs)(Grid, GVec, GVec);
  int (*applyjac)(Grid, GVec, GVec);
  int (*solvejac)(Grid, GVec, GVec);
  int (*evaluatejac)(Grid, int, PetscScalar, PetscScalar *, PetscConstraintObject);
  int (*jacgetdiag)(GMat, GVec);
} ConstraintOps;

struct _p_PetscConstraintObject {
  PETSCHEADER(ConstraintOps)
};

EXTERN int GridIsConstrained(Grid, PetscTruth *);
EXTERN int GridSetConstrained(Grid, PetscTruth);
EXTERN int GridGetNumNewFields(Grid, int *);
EXTERN int GridSetNumNewFields(Grid, int);
EXTERN int GridIsFieldConstrained(Grid, int, PetscTruth *);
EXTERN int GridSetFieldConstrained(Grid, int, PetscTruth);
EXTERN int GridGetFieldConstraintCompDiff(Grid grid, int, int *);
EXTERN int GridSetFieldConstraintCompDiff(Grid grid, int, int);
EXTERN int GridGetExplicitConstraints(Grid, PetscTruth *);
EXTERN int GridSetExplicitConstraints(Grid, PetscTruth);
EXTERN int GridGetConstraints(Grid, PetscTruth *, int *, int *, int *);
EXTERN int GridGetConstraintContext(Grid, PetscConstraintObject *);
EXTERN int GridSetConstraintContext(Grid, PetscConstraintObject);
EXTERN int GridGetConstraintMatrix(Grid, GMat *);
EXTERN int GridGetConstraintInverse(Grid, GMat *);
