/* gts.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "petscts.h"
#include "petscfix.h"
#include "gsolver.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsview_ PGTSVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsview_ pgtsview
#else
#define gtsview_ pgtsview_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsview_ GTSVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsview_ gtsview
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsserialize_ PGTSSERIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsserialize_ pgtsserialize
#else
#define gtsserialize_ pgtsserialize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsserialize_ GTSSERIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsserialize_ gtsserialize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsgetgrid_ PGTSGETGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsgetgrid_ pgtsgetgrid
#else
#define gtsgetgrid_ pgtsgetgrid_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsgetgrid_ GTSGETGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsgetgrid_ gtsgetgrid
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsgetinitialtimestep_ PGTSGETINITIALTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsgetinitialtimestep_ pgtsgetinitialtimestep
#else
#define gtsgetinitialtimestep_ pgtsgetinitialtimestep_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsgetinitialtimestep_ GTSGETINITIALTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsgetinitialtimestep_ gtsgetinitialtimestep
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsgettimedependence_ PGTSGETTIMEDEPENDENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsgettimedependence_ pgtsgettimedependence
#else
#define gtsgettimedependence_ pgtsgettimedependence_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsgettimedependence_ GTSGETTIMEDEPENDENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsgettimedependence_ gtsgettimedependence
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssetcontext_ PGTSSETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssetcontext_ pgtssetcontext
#else
#define gtssetcontext_ pgtssetcontext_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssetcontext_ GTSSETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssetcontext_ gtssetcontext
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssettimedependence_ PGTSSETTIMEDEPENDENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssettimedependence_ pgtssettimedependence
#else
#define gtssettimedependence_ pgtssettimedependence_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssettimedependence_ GTSSETTIMEDEPENDENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssettimedependence_ gtssettimedependence
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsevaluaterhs_ PGTSEVALUATERHS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsevaluaterhs_ pgtsevaluaterhs
#else
#define gtsevaluaterhs_ pgtsevaluaterhs_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsevaluaterhs_ GTSEVALUATERHS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsevaluaterhs_ gtsevaluaterhs
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsevaluatejacobian_ PGTSEVALUATEJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsevaluatejacobian_ pgtsevaluatejacobian
#else
#define gtsevaluatejacobian_ pgtsevaluatejacobian_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsevaluatejacobian_ GTSEVALUATEJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsevaluatejacobian_ gtsevaluatejacobian
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsevaluatesystemmatrix_ PGTSEVALUATESYSTEMMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsevaluatesystemmatrix_ pgtsevaluatesystemmatrix
#else
#define gtsevaluatesystemmatrix_ pgtsevaluatesystemmatrix_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsevaluatesystemmatrix_ GTSEVALUATESYSTEMMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsevaluatesystemmatrix_ gtsevaluatesystemmatrix
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtscalcbcvalues_ PGTSCALCBCVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtscalcbcvalues_ pgtscalcbcvalues
#else
#define gtscalcbcvalues_ pgtscalcbcvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtscalcbcvalues_ GTSCALCBCVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtscalcbcvalues_ gtscalcbcvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsrhsbc_ PGTSRHSBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsrhsbc_ pgtsrhsbc
#else
#define gtsrhsbc_ pgtsrhsbc_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsrhsbc_ GTSRHSBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsrhsbc_ gtsrhsbc
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssolutionbc_ PGTSSOLUTIONBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssolutionbc_ pgtssolutionbc
#else
#define gtssolutionbc_ pgtssolutionbc_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssolutionbc_ GTSSOLUTIONBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssolutionbc_ gtssolutionbc
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssolutionbcforgsnes_ PGTSSOLUTIONBCFORGSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssolutionbcforgsnes_ pgtssolutionbcforgsnes
#else
#define gtssolutionbcforgsnes_ pgtssolutionbcforgsnes_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssolutionbcforgsnes_ GTSSOLUTIONBCFORGSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssolutionbcforgsnes_ gtssolutionbcforgsnes
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsprestep_ PGTSPRESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsprestep_ pgtsprestep
#else
#define gtsprestep_ pgtsprestep_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsprestep_ GTSPRESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsprestep_ gtsprestep
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsupdate_ PGTSUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsupdate_ pgtsupdate
#else
#define gtsupdate_ pgtsupdate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsupdate_ GTSUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsupdate_ gtsupdate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtspoststep_ PGTSPOSTSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtspoststep_ pgtspoststep
#else
#define gtspoststep_ pgtspoststep_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtspoststep_ GTSPOSTSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtspoststep_ gtspoststep
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtscreate_ PGTSCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtscreate_ pgtscreate
#else
#define gtscreate_ pgtscreate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtscreate_ GTSCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtscreate_ gtscreate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssolutionmonitor_ PGTSSOLUTIONMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssolutionmonitor_ pgtssolutionmonitor
#else
#define gtssolutionmonitor_ pgtssolutionmonitor_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtssolutionmonitor_ GTSSOLUTIONMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtssolutionmonitor_ gtssolutionmonitor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtserrormonitor_ PGTSERRORMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtserrormonitor_ pgtserrormonitor
#else
#define gtserrormonitor_ pgtserrormonitor_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtserrormonitor_ GTSERRORMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtserrormonitor_ gtserrormonitor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtscreatecontext_ PGTSCREATECONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtscreatecontext_ pgtscreatecontext
#else
#define gtscreatecontext_ pgtscreatecontext_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtscreatecontext_ GTSCREATECONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtscreatecontext_ gtscreatecontext
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsdestroycontext_ PGTSDESTROYCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsdestroycontext_ pgtsdestroycontext
#else
#define gtsdestroycontext_ pgtsdestroycontext_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtsdestroycontext_ GTSDESTROYCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtsdestroycontext_ gtsdestroycontext
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtscreateconstraintcontext_ PGTSCREATECONSTRAINTCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtscreateconstraintcontext_ pgtscreateconstraintcontext
#else
#define gtscreateconstraintcontext_ pgtscreateconstraintcontext_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gtscreateconstraintcontext_ GTSCREATECONSTRAINTCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gtscreateconstraintcontext_ gtscreateconstraintcontext
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL gtsview_(GTS ts,PetscViewer *viewer, int *ierr ){
*ierr = GTSView(
	(GTS)PetscToPointer( (ts) ),*viewer);
}
void PETSC_STDCALL gtsserialize_(Grid grid,GTS *ts,PetscViewer *viewer,PetscTruth *store, int *ierr ){
*ierr = GTSSerialize(
	(Grid)PetscToPointer( (grid) ),ts,*viewer,*store);
}
void PETSC_STDCALL gtsgetgrid_(GTS ts,Grid *grid, int *ierr ){
*ierr = GTSGetGrid(
	(GTS)PetscToPointer( (ts) ),grid);
}
void PETSC_STDCALL gtsgetinitialtimestep_(GTS ts,double *dt, int *ierr ){
*ierr = GTSGetInitialTimeStep(
	(GTS)PetscToPointer( (ts) ),dt);
}
void PETSC_STDCALL gtsgettimedependence_(GTS ts,int *field,PetscTruth *flag, int *ierr ){
*ierr = GTSGetTimeDependence(
	(GTS)PetscToPointer( (ts) ),*field,flag);
}
void PETSC_STDCALL gtssetcontext_(GTS ts,void*ctx, int *ierr ){
*ierr = GTSSetContext(
	(GTS)PetscToPointer( (ts) ),ctx);
}
void PETSC_STDCALL gtssettimedependence_(GTS ts,int *field,PetscTruth *flag, int *ierr ){
*ierr = GTSSetTimeDependence(
	(GTS)PetscToPointer( (ts) ),*field,*flag);
}
void PETSC_STDCALL gtsevaluaterhs_(GTS ts,double *t,GVec x,GVec f,PetscObject ctx, int *ierr ){
*ierr = GTSEvaluateRhs(
	(GTS)PetscToPointer( (ts) ),*t,
	(GVec)PetscToPointer( (x) ),
	(GVec)PetscToPointer( (f) ),
	(PetscObject)PetscToPointer( (ctx) ));
}
void PETSC_STDCALL gtsevaluatejacobian_(GTS ts,double *t,GVec x,GMat *J,GMat *M,MatStructure *flag,PetscObject ctx, int *ierr ){
*ierr = GTSEvaluateJacobian(
	(GTS)PetscToPointer( (ts) ),*t,
	(GVec)PetscToPointer( (x) ),J,M,
	(MatStructure* )PetscToPointer( (flag) ),
	(PetscObject)PetscToPointer( (ctx) ));
}
void PETSC_STDCALL gtsevaluatesystemmatrix_(GTS ts,double *t,GMat *A,GMat *M,MatStructure *flag,PetscObject ctx, int *ierr ){
*ierr = GTSEvaluateSystemMatrix(
	(GTS)PetscToPointer( (ts) ),*t,A,M,
	(MatStructure* )PetscToPointer( (flag) ),
	(PetscObject)PetscToPointer( (ctx) ));
}
void PETSC_STDCALL gtscalcbcvalues_(GTS ts, int *ierr ){
*ierr = GTSCalcBCValues(
	(GTS)PetscToPointer( (ts) ));
}
void PETSC_STDCALL gtsrhsbc_(GTS ts,GVec rhs,void*ctx, int *ierr ){
*ierr = GTSRhsBC(
	(GTS)PetscToPointer( (ts) ),
	(GVec)PetscToPointer( (rhs) ),ctx);
}
void PETSC_STDCALL gtssolutionbc_(GTS ts,GVec sol,void*ctx, int *ierr ){
*ierr = GTSSolutionBC(
	(GTS)PetscToPointer( (ts) ),
	(GVec)PetscToPointer( (sol) ),ctx);
}
void PETSC_STDCALL gtssolutionbcforgsnes_(GSNES snes,GVec sol,void*ctx, int *ierr ){
*ierr = GTSSolutionBCforGSNES(
	(GSNES)PetscToPointer( (snes) ),
	(GVec)PetscToPointer( (sol) ),ctx);
}
void PETSC_STDCALL gtsprestep_(GTS ts, int *ierr ){
*ierr = GTSPreStep(
	(GTS)PetscToPointer( (ts) ));
}
void PETSC_STDCALL gtsupdate_(GTS ts,PetscReal *t,PetscReal *dt, int *ierr ){
*ierr = GTSUpdate(
	(GTS)PetscToPointer( (ts) ),*t,dt);
}
void PETSC_STDCALL gtspoststep_(GTS ts, int *ierr ){
*ierr = GTSPostStep(
	(GTS)PetscToPointer( (ts) ));
}
void PETSC_STDCALL gtscreate_(Grid grid,void*ctx,GTS *ts, int *ierr ){
*ierr = GTSCreate(
	(Grid)PetscToPointer( (grid) ),ctx,ts);
}
void PETSC_STDCALL gtssolutionmonitor_(GTS ts,int *step,PetscReal *ltime,GVec sol,void*ctx, int *ierr ){
*ierr = GTSSolutionMonitor(
	(GTS)PetscToPointer( (ts) ),*step,*ltime,
	(GVec)PetscToPointer( (sol) ),ctx);
}
void PETSC_STDCALL gtserrormonitor_(GTS ts,int *step,PetscReal *ltime,GVec sol,void*monCtx, int *ierr ){
*ierr = GTSErrorMonitor(
	(GTS)PetscToPointer( (ts) ),*step,*ltime,
	(GVec)PetscToPointer( (sol) ),monCtx);
}
void PETSC_STDCALL gtscreatecontext_(GTS ts,double *ltime,PetscObject ctx,PetscObject *oldCtx, int *ierr ){
*ierr = GTSCreateContext(
	(GTS)PetscToPointer( (ts) ),*ltime,
	(PetscObject)PetscToPointer( (ctx) ),oldCtx);
}
void PETSC_STDCALL gtsdestroycontext_(GTS ts,PetscObject ctx,PetscObject oldCtx, int *ierr ){
*ierr = GTSDestroyContext(
	(GTS)PetscToPointer( (ts) ),
	(PetscObject)PetscToPointer( (ctx) ),
	(PetscObject)PetscToPointer( (oldCtx) ));
}
void PETSC_STDCALL gtscreateconstraintcontext_(GTS ts, int *ierr ){
*ierr = GTSCreateConstraintContext(
	(GTS)PetscToPointer( (ts) ));
}
#if defined(__cplusplus)
}
#endif
