#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: discregall.c,v 1.3 1999/09/18 16:36:44 knepley Exp $";
#endif

#include "src/grid/discretization/discimpl.h"      /*I "discretization.h"  I*/
EXTERN_C_BEGIN
extern int DiscCreate_Triangular_1D_Constant(Discretization);
extern int DiscCreate_Triangular_1D_Linear(Discretization);
extern int DiscCreate_Triangular_1D_Quadratic(Discretization);

extern int DiscCreate_Triangular_2D_Linear(Discretization);
extern int BoundaryDiscCreate_Triangular_2D_Linear(Discretization);
extern int DiscCreate_Triangular_2D_Quadratic(Discretization);
extern int BoundaryDiscCreate_Triangular_2D_Quadratic(Discretization);

extern int DiscretizationSerialize_Generic(MPI_Comm, Discretization *, PetscViewer, PetscTruth);
EXTERN_C_END

#undef __FUNCT__  
#define __FUNCT__ "DiscretizationRegisterAll"
/*@C
  DiscretizationRegisterAll - Registers all of the generation routines in the Discretization package. 

  Not Collective

  Input parameter:
. path - The dynamic library path

  Level: advanced

.keywords: Discretization, register, all
.seealso: DiscretizationCreate(), DiscretizationRegister(), DiscretizationRegisterDestroy()
@*/
int DiscretizationRegisterAll(const char path[]) {
  int ierr;

  PetscFunctionBegin;
  DiscretizationRegisterAllCalled = PETSC_TRUE;

  ierr = DiscretizationRegisterDynamic(DISCRETIZATION_TRIANGULAR_1D_CONSTANT,     path, "DiscCreate_Triangular_1D_Constant",          DiscCreate_Triangular_1D_Constant);CHKERRQ(ierr);
  ierr = DiscretizationRegisterDynamic(DISCRETIZATION_TRIANGULAR_1D_LINEAR,       path, "DiscCreate_Triangular_1D_Linear",            DiscCreate_Triangular_1D_Linear);CHKERRQ(ierr);
  ierr = DiscretizationRegisterDynamic(DISCRETIZATION_TRIANGULAR_1D_QUADRATIC,    path, "DiscCreate_Triangular_1D_Quadratic",         DiscCreate_Triangular_1D_Quadratic);CHKERRQ(ierr);
  ierr = DiscretizationRegisterDynamic(DISCRETIZATION_TRIANGULAR_2D_LINEAR,       path, "DiscCreate_Triangular_2D_Linear",            DiscCreate_Triangular_2D_Linear);CHKERRQ(ierr);
  ierr = DiscretizationRegisterDynamic(BD_DISCRETIZATION_TRIANGULAR_2D_LINEAR,    path, "BoundaryDiscCreate_Triangular_2D_Linear",    BoundaryDiscCreate_Triangular_2D_Linear);CHKERRQ(ierr);
  ierr = DiscretizationRegisterDynamic(DISCRETIZATION_TRIANGULAR_2D_QUADRATIC,    path, "DiscCreate_Triangular_2D_Quadratic",         DiscCreate_Triangular_2D_Quadratic);CHKERRQ(ierr);
  ierr = DiscretizationRegisterDynamic(BD_DISCRETIZATION_TRIANGULAR_2D_QUADRATIC, path, "BoundaryDiscCreate_Triangular_2D_Quadratic", BoundaryDiscCreate_Triangular_2D_Quadratic);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

#undef __FUNCT__  
#define __FUNCT__ "DiscretizationSerializeRegisterAll"
/*@C
  DiscretizationSerializeRegisterAll - Registers all of the serialization routines in the Discretization package. 

  Not Collective

  Input parameter:
. path - The dynamic library path

  Level: advanced

.keywords: Discretization, register, all, serialize
.seealso: DiscretizationSerialize(), DiscretizationSerializeRegister(), DiscretizationSerializeRegisterDestroy()
@*/
int DiscretizationSerializeRegisterAll(const char path[]) {
  int ierr;

  PetscFunctionBegin;
  DiscretizationSerializeRegisterAllCalled = PETSC_TRUE;

  ierr = DiscretizationSerializeRegisterDynamic(DISCRETIZATION_SER_GENERIC, path, "DiscretizationSerialize_Generic", DiscretizationSerialize_Generic);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
