#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: gridregall.c,v 1.3 1999/09/18 16:36:44 knepley Exp $";
#endif

#include "src/grid/gridimpl.h"     /*I  "grid.h"  I*/
EXTERN_C_BEGIN
extern int GridCreate_Triangular_1D(Grid);
extern int GridCreate_Triangular_2D(Grid);

extern int GridSerialize_Generic(MPI_Comm, Grid *, PetscViewer, PetscTruth);
EXTERN_C_END

#undef __FUNCT__  
#define __FUNCT__ "GridRegisterAll"
/*@C
  GridRegisterAll - Registers all of the generation routines in the Grid package. 

  Not Collective

  Input parameter:
. path - The dynamic library path

  Level: advanced

.keywords: Grid, register, all
.seealso: GridCreate(), GridRegister(), GridRegisterDestroy()
@*/
int GridRegisterAll(const char path[])
{
  int ierr;

  PetscFunctionBegin;
  GridRegisterAllCalled = PETSC_TRUE;

  ierr = GridRegisterDynamic(GRID_TRIANGULAR_1D, path, "GridCreate_Triangular_1D", GridCreate_Triangular_1D);CHKERRQ(ierr);
  ierr = GridRegisterDynamic(GRID_TRIANGULAR_2D, path, "GridCreate_Triangular_2D", GridCreate_Triangular_2D);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

#undef __FUNCT__  
#define __FUNCT__ "GridSerializeRegisterAll"
/*@C
  GridSerializeRegisterAll - Registers all of the serialization routines in the Grid package. 

  Not Collective

  Input parameter:
. path - The dynamic library path

  Level: advanced

.keywords: grid, register, all, serialize
.seealso: GridSerialize(), GridSerializeRegister(), GridSerializeRegisterDestroy()
@*/
int GridSerializeRegisterAll(const char path[])
{
  int ierr;

  PetscFunctionBegin;
  GridSerializeRegisterAllCalled = PETSC_TRUE;

  ierr = GridSerializeRegisterDynamic(GRID_SER_GENERIC, path, "GridSerialize_Generic", GridSerialize_Generic);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
