#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: partregall.c,v 1.1 1999/06/09 20:58:31 knepley Exp $";
#endif

#include "src/mesh/meshimpl.h"     /*I  "mesh.h"  I*/
EXTERN_C_BEGIN
extern int PartitionCreate_Triangular_1D(Partition);
extern int PartitionCreate_Triangular_2D(Partition);

extern int PartitionSerialize_Triangular_2D(Mesh, Partition *, PetscViewer, PetscTruth);
EXTERN_C_END


#undef __FUNCT__  
#define __FUNCT__ "PartitionRegisterAll"
/*@C
  PartitionRegisterAll - Registers all of the serialization routines in the Partition package. 

  Not Collective

  Input parameters:
. path - Dynamic library path

  Level: advanced

.keywords: mesh, register, all, serialization
.seealso: PartitionRegister(), PartitionRegisterDestroy()
@*/
int PartitionRegisterAll(const char path[])
{
  int ierr;

  PetscFunctionBegin;
  PartitionRegisterAllCalled = 1;

  ierr = PartitionRegister(PARTITION_TRIANGULAR_1D, path, "PartitionCreate_Triangular_1D", PartitionCreate_Triangular_1D);
  CHKERRQ(ierr);
  ierr = PartitionRegister(PARTITION_TRIANGULAR_2D, path, "PartitionCreate_Triangular_2D", PartitionCreate_Triangular_2D);
  CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

#undef __FUNCT__  
#define __FUNCT__ "PartitionSerializeRegisterAll"
/*@C
  PartitionSerializeRegisterAll - Registers all of the serialization routines in the Partition package. 

  Not Collective

  Input parameters:
. path - Dynamic library path

  Level: advanced

.keywords: mesh, register, all, serialization
.seealso: PartitionSerializeRegister(), PartitionSerializeRegisterDestroy()
@*/
int PartitionSerializeRegisterAll(const char path[])
{
  int ierr;

  PetscFunctionBegin;
  PartitionSerializeRegisterAllCalled = 1;

  ierr = PartitionSerializeRegister(PARTITION_SER_TRIANGULAR_2D_BINARY, path,
                                    "PartitionSerialize_Triangular_2D", PartitionSerialize_Triangular_2D);
  CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
