#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: test.c,v 1.2 2000/01/10 03:54:22 knepley Exp $";
#endif

#include "src/mesh/impls/triangular/triimpl.h"

EXTERN_C_BEGIN
/*
    MeshOrdering_Triangular_2D_Test - Test ordering for the nodes of a given mesh.
*/    
#undef __FUNCT__  
#define __FUNCT__ "MeshOrdering_Test"
int MeshOrdering_Triangular_2D_Test(Mesh mesh, MatOrderingType type, AO *ordering)
{
  int        numNodes = mesh->numNodes;
  int       *AppOrdering;   /* The initial ordering (0, 1, ...) */
  int       *PetscOrdering; /* The RCM ordering */
  char       typeName[256];
  int        i;
  PetscTruth opt, isidentity, isreverse, isflip;
  int        ierr;

  ierr = PetscMalloc(numNodes * sizeof(int), &AppOrdering);                                               CHKERRQ(ierr);
  ierr = PetscMalloc(numNodes * sizeof(int), &PetscOrdering);                                             CHKERRQ(ierr);

  ierr = PetscStrcpy(typeName, "identity");                                                               CHKERRQ(ierr);
  ierr = PetscOptionsGetString(mesh->prefix, "-mesh_ordering_subtype", typeName, 256, &opt);              CHKERRQ(ierr);
  ierr = PetscStrcasecmp(typeName, "identity", &isidentity);                                              CHKERRQ(ierr);
  ierr = PetscStrcasecmp(typeName, "reverse",  &isreverse);                                               CHKERRQ(ierr);
  ierr = PetscStrcasecmp(typeName, "flip",     &isflip);                                                  CHKERRQ(ierr);
  if (isidentity == PETSC_TRUE) {
    for(i = 0; i < numNodes; i++) {
      AppOrdering[i]   = i;
      PetscOrdering[i] = i;
    }
  } else if (isreverse == PETSC_TRUE) {
    for(i = 0; i < numNodes; i++) {
      AppOrdering[i]   = i;
      PetscOrdering[i] = numNodes-(i+1);
    }
  } else if (isflip == PETSC_TRUE) {
    for(i = 0; i < numNodes; i++) {
      AppOrdering[i]   = i;
      PetscOrdering[i] = i;
    }
    PetscOrdering[0]   = 1;
    PetscOrdering[1]   = 0;
  } else {
    SETERRQ1(PETSC_ERR_ARG_WRONG, "Invalid ordering subtype: %s", typeName);
  }
  /* Create the ordering object */
  ierr = AOCreateBasic(mesh->comm, numNodes, AppOrdering, PetscOrdering, ordering);                       CHKERRQ(ierr);

  ierr = PetscFree(AppOrdering);                                                                          CHKERRQ(ierr);
  ierr = PetscFree(PetscOrdering);                                                                        CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
EXTERN_C_END
