/** 
 * -- The Additional StackHelp TypeCheck Word Set
 * 
 *  Copyright (C) Tektronix, Inc. 1998 - 2001. All rights reserved.
 *
 *  @see     GNU LGPL
 *  @author  Tektronix CTE              @(#) %derived_by: guidod %
 *  @version %version: 33.36 %
 *    (%date_modified: Mon Feb 24 20:02:23 2003 %)
 *
 *  @description
 *    These are routines to add stackchecking capabilities. The
 *    loader routine will hook into the outer interpreter and
 *    _before_ any word is compiled/interpreted it is being 
 *    sent through an stackcheck interpreter. The stackcheck
 *    interpreter code is fully independent from the rest of
 *    the code. It will only work on the stackcheck hints given
 *    with each word. In most cases the stackcheck hints are
 *    simple strings which get parsed for information - these
 *    strings may be taken from the usual stack notation of a
 *    a colon word. The parser is detecting the syntax given
 *    in the OpenFirmware recommendations for specifying a compact
 *    stack and parsing behavior of a word. They are expanded for
 *    extra type hints and tracing through splitstack parts.
 *
 *    Other than pure strings, the stackchecking can be done
 *    through code words that work on the checkstack - they are
 *    similar to immediate words in the normal forth interpreter
 *    whereas the stacknotation strings are checkstacked by the 
 *    checkstack parser directly instead of blackboxing it 
 *    through a call to a routine somewhere. It does however
 *    bring in a lot of flexibility and allows for complex
 *    stackcheck code in extension modules. The core-stk module
 *    is an integral part of the stackcheck behavior for forth
 *    and encompasses stackchecking for IF-ELSE branches and
 *    the various LOOPs and EXIT-points of a ':'-colon word.
 */
/*@{*/
#if defined(__version_control__) && defined(__GNUC__)
static char* id __attribute__((unused)) = 
"@(#) $Id: %full_filespec:  stackhelp-ext.c~33.36:csrc:bln_mpt1!1 % $";
#endif

#define _P4_SOURCE 1
#include <pfe/pfe-base.h>
#include <pfe/def-xtra.h>

#include <string.h>
#include <ctype.h>

#include <pfe/def-comp.h>
#include <pfe/logging.h>

#define ___ {
#define ____ }

#define CHK (*(struct stackhelp*)(PFE.p[slot]))
static int slot = 0;

struct stackhelp
{
    p4char* last;
    struct { char def[255]; char* end; } word;
    int depth['Z'-'A']; /* the param stack 'S' is always last/first */
};

#define X  fprintf (stderr, "%c", *x)
#define XS  fprintf (stderr, "%c.", *x)
#define XC  fprintf (stderr, "%c:", *x)
#define XX fprintf (stderr, "#\n")

static char* find_changer (char* s, char* x)
{
    /*      : x |( a -- a a ) dup ;         */
    while (s < --x)
    {
        if (x[0] == '-' && x[-1] == '-')
        {
            return x;
        }
    }
    return 0;
}

static int stack_depth (char* s, char* x, unsigned char stk)
{
    int depth = 0;
    while (x >= s) 
    {
        do { x--; } while (x >= s && isspace(*x));
        if (x >= s && *x == '|') break;
        if (x >  s && x[0] == ':') {
            if (x[-1] == stk) return depth; /* found */
            do { x--; } while (x >= s && ! isspace(*x));
            depth = 0; continue;
        }
        if (x >= s && ! isspace(*x)) {
            depth ++; 
            do { x--; } while (x >= s && ! isspace(*x));
        }
    }
    if (stk && stk != 'S') return 0; /* untouched */
    return depth; /* default stack - the parameters */
}

static int input_depth (char* s, char* x, unsigned char stk)
{
    x = find_changer (s, x);
    if (! x) return 0;
    if (! stk) stk = 'S';
    return stack_depth (s, x-1, stk);
}

static int output_depth (char* s, char* x, unsigned char stk)
{
    s = find_changer (s, x);
    if (! s) return 0;
    if (! stk) stk = 'S';
    return stack_depth (s+1, x, stk);
}

static FCode (add_last_stackhelp)
{
    int len = CHK.word.end - CHK.word.def;
    if (! CHK.last) return;
    p4_header_comma (CHK.last+1, P4_NFACNT(*CHK.last), PFE.stackhelp_wl);
    FX_RUNTIME1(p4_two_constant);
    FX_COMMA (len);
    FX_COMMA (0);
    ((void**)(PFE.dp))[-1] = PFE.dp;
    memcpy (PFE.dp, CHK.word.def, len);
    PFE.dp += len;
    FX (p4_align);
    CHK.last = 0;
}

/** "|(" ( [string<rp>] -- )
 *  add a checkstack notation for the LAST word or just try to
 *  match the given notation with the stacklayout traced so
 *  far - possibly casting a few types as needed.
 */
FCode (p4_stackhelpcomment)
{
    p4_word_parse(')');
    if (PFE.word.len >= 255) return;

    if (find_changer (PFE.word.ptr, PFE.word.ptr + PFE.word.len))
    {  /* there seems to be a stack notation here */
        if (LAST && CHK.last != LAST)
        {
            /* a new word definition is being started */
            memcpy (CHK.word.def, PFE.word.ptr, PFE.word.len);
            CHK.word.end = CHK.word.def + PFE.word.len;
            CHK.last = LAST;
            memset (CHK.depth, 0, sizeof(CHK.depth));
            return;
        }else{
            /* inside a definition, we need a static cast */
            return;
        }
    } /* no ( ... -- ... ) was found => match stack notation here 
       * and send out error message when it does not match :-)=) */

    
    return;
}

FCode (p4_stackhelp)
{
    p4_word_parseword (' '); *DP = 0; /* PRASE-WORD-NOHERE */
    ___ p4char* nfa = p4_search_wordlist (PFE.word.ptr, PFE.word.len, 
                                          PFE.stackhelp_wl);
    if (! nfa)
    {
        p4_outf (": %.*s has no stackhelp, sorry. ", 
                 PFE.word.len, PFE.word.ptr);
        return;
    } /*else*/
    do {
        p4cell* info = P4_TO_BODY(p4_name_from (nfa));
        if (*P4_TO_CODE(P4_BODY_FROM(info)) != PFX(p4_two_constant_RT))
        {
            p4_outf (": %.*s has complex behavior. ", P4_NFACNT(nfa), nfa+1);
        }else{
            p4_outf (": %.*s ( %.*s ) ", P4_NFACNT(nfa), nfa+1, 
                     info[0], info[1]);
        }
        nfa = p4_next_search_wordlist(nfa, PFE.word.ptr, PFE.word.len,
                                      PFE.stackhelp_wl);
    } while (nfa);
    ____;
}

int stackdepth_change (char* name, int l, unsigned char stk)
{
    p4char* nfa = p4_search_wordlist (PFE.word.ptr, PFE.word.len, 
                                      PFE.stackhelp_wl);
    if (! nfa) return 8888;
    
    ___ p4cell* info = P4_TO_BODY(p4_name_from (nfa));
    if (*P4_TO_CODE(P4_BODY_FROM(info)) != PFX(p4_two_constant_RT))
    {
        /* we can not handle complex behavior at the moment */
        return 8888;
    }else{
        char* s = (char*)(info[1]); char* x = s + info[0];
        if (1) { /* debugging */
            int i_depth = input_depth (s, x, stk);
            int o_depth = output_depth (s, x, stk);
            if (i_depth || o_depth)
                fprintf (stderr, "\\ %.*s (%c:[%i]:[%i])\n", l, name, stk,
                         i_depth, o_depth);
        }
        return output_depth (s, x, stk) - input_depth (s, x, stk);
    }
    ____;
}

static p4ucell 
FXCode (p4_interpret_stackhelp) /* hereclean */
{
    if (! STATE ) { /* quick path */
        CHK.last = 0;  return 0; 
    } 

    /* at the moment, we have no real check code here 
     * but we can atleast attach stackhelp hints when available.
     */
    if (PFE.word.len == 1 && *PFE.word.ptr == ';' && CHK.last)
    {
        register unsigned char stk;
        for (stk = 'A'; stk < 'Z'; stk++)
        {
            int i_depth = input_depth (CHK.word.def, CHK.word.end, stk);
            int o_depth = output_depth (CHK.word.def, CHK.word.end, stk);
            if (CHK.depth[stk-'A'] < 4444 && 
                CHK.depth[stk-'A'] != o_depth-i_depth)
            {
                p4_outf ("\\ WARNING: seen stackchange (%c:[%i]:[%i]) for\n", 
                         stk, i_depth, i_depth+CHK.depth[stk-'A']);
                p4_outf ("\\ %.*s |( %.*s ) (%c:[%i]:[%i])\n", 
                         P4_NFACNT(*CHK.last), CHK.last+1,
                         CHK.word.end-CHK.word.def, CHK.word.def,
                         stk, i_depth, o_depth);
            }else if (i_depth || o_depth) { /* debugging */
                p4_outf ("\\ %.*s |( %.*s ) (%c:[%i]:[%i])\n", 
                         P4_NFACNT(*CHK.last), CHK.last+1,
                         CHK.word.end-CHK.word.def, CHK.word.def,
                         stk, i_depth, o_depth);
            }
        }

        FX (add_last_stackhelp);
        return 0;
    }else{
        register unsigned char stk;
        for (stk = 'A'; stk < 'Z'; stk++)
        {
            register int change;
            if (CHK.depth[stk-'A'] > 4444) continue;
            change = stackdepth_change (PFE.word.ptr, PFE.word.len, stk);
            if (change > 4444) 
                CHK.depth[stk-'A'] = 8888;
            else
                CHK.depth[stk-'A'] += change;
        }
    }

    return 0; /* we do never stop the outer interpreter !! */
}

static const char stackhelp_wl[] = "[STACKHELP]";

static FCode_RT(stackhelp_deinit)
{  FX_USE_BODY_ADDR {
    register struct stackhelp* set = (struct stackhelp*) FX_POP_BODY_ADDR[0];
    P4_note1 ("clean stackhelp area %p", set);
    PFE.stackhelp_wl = 0;
    PFE.interpret[7] = 0;
}}

static FCode(stackhelp_init)
{
    PFE.stackhelp_wl = p4_find_wordlist (stackhelp_wl,sizeof(stackhelp_wl)-1);
    PFE.interpret[7] = PFX (p4_interpret_stackhelp);
    p4_forget_word ("stackhelp:%i", (p4cell) slot,
                    PFX(stackhelp_deinit), (p4cell) &CHK);
}

extern const p4Words P4WORDS(core_check);

P4_LISTWORDS (stackhelp) =
{
    P4_SLOT("", &slot),
    P4_SSIZ("", sizeof(struct stackhelp)),

    P4_INTO ("EXTENSIONS", 0),
    P4_IXco ("|(", p4_stackhelpcomment),
    P4_FXco ("STACKHELP", p4_stackhelp),
    P4_IVOC ("[STACKHELP]", 0),
    P4_DVaL ("STACKHELP-WORDLIST", stackhelp_wl),

    P4_INTO ("ENVIRONMENT", 0 ),
    /* enviroment hints (testing for -EXT will make the wordset present) */
    P4_OCON ("STACKHELP-EXT",	2003 ),
    P4_XXco ("STACKHELP-LOADED",   stackhelp_init),

    P4_LOAD ("", core_check),
};
P4_COUNTWORDS (stackhelp, "StackHelp TypeChecking extension");

/*@}*/

/* 
 * Local variables:
 * c-file-style: "stroustrup"
 * End:
 */
