<?php
/**
* This file is part of French (Casual Honorifics) phpBB Translation.
* Copyright (C) 2010 phpBB.fr
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* help_faq [French (Casual Honorifics)]
*
* @package   language
* @author    Maël Soucaze <maelsoucaze@phpbb.fr> (Maël Soucaze) http://www.phpbb.fr/
* @copyright 2005 phpBB Group
* @license   http://www.gnu.org/licenses/gpl-2.0.txt GNU General Public License
* @version   $Id: help_faq.php 10493 2010-02-16 20:42:55Z bantu $
*/

/**
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$help = array(
	array(
		0 => '--',
		1 => 'Problèmes de connexion et d’inscription'
	),
	array(
		0 => 'Pourquoi ne puis-je pas me connecter ?',
		1 => 'Il y a plusieurs raisons qui peuvent en être la cause. Premièrement, assure-toi que ton nom d’utilisateur et ton mot de passe soient corrects. S’ils le sont, contacte le propriétaire du forum afin de t’assurer de ne pas avoir été banni. Il est également possible que le propriétaire du site Internet ait une erreur de configuration de son côté et qu’il soit nécessaire de la corriger.'
	),
	array(
		0 => 'Pourquoi ai-je besoin de m’inscrire, après tout ?',
		1 => 'Tu peux ne pas le faire, il appartient à l’administrateur du forum d’exiger ou non que tu sois inscrit afin de pouvoir publier des messages. Cependant, l’inscription te donnera accès à des fonctionnalités supplémentaires qui ne sont pas disponibles aux visiteurs, comme les avatars personnalisés, la messagerie privée, l’envoi d’e-mails aux autres utilisateurs, l’adhésion à un groupe d’utilisateurs, etc. Cela ne te prend qu’un court instant et nous te recommandons par conséquence de le faire.'
	),
	array(
		0 => 'Pourquoi suis-je déconnecté automatiquement ?',
		1 => 'Si tu ne coches pas la case <em>Me connecter automatiquement</em> lors de ta connexion au forum, tu ne resteras connecté que pour une période prédéfinie. Cette prévention empêche l’utilisation de ton compte par une personne malveillante. Pour rester connecté, coche cette case lors de ta connexion, mais ce n’est pas recommandé si tu accédes au forum par un ordinateur public, par exemple dans une librairie, un cybercafé, une université, etc. Si tu ne vois pas cette case à cocher, cela signifie que ton administrateur a désactivé cette fonctionnalité.'
	),
	array(
		0 => 'Comment puis-je empêcher l’apparition de mon nom d’utilisateur dans la liste des utilisateurs en ligne ?',
		1 => 'Dans le panneau de contrôle de l’utilisateur, en-dessous de “Préférences du forum”, tu trouveras une option intitulée <em>Masquer ton statut en ligne</em>. Si tu actives cette option en cochant <samp>Oui</samp>, tu ne seras visible qu’aux administrateurs, aux modérateurs et à toi-même. Tu seras compté comme étant un utilisateur invisible.'
	),
	array(
		0 => 'J’ai perdu mon mot de passe !',
		1 => 'Pas de panique ! Bien que ton mot de passe ne puisse pas être récupéré, il peut facilement être réinitialisé. Rends-toi sur la page de connexion et clique sur <em>J’ai perdu mon mot de passe</em>. Suis les instructions et tu devrais pouvoir te connecter de nouveau.'
	),
	array(
		0 => 'Je suis inscrit mais ne peux pas me connecter !',
		1 => 'Premièrement, vérifie ton nom d’utilisateur et ton mot de passe. S’ils sont corrects, alors une des deux choses suivantes a pu s’être produite. Si le support de la COPPA est activé et que tu as spécifié avoir en dessous de 13 ans pendant l’inscription, tu devras suivre les instructions que tu as reçu. Certains forums exigeront également que les nouvelles inscriptions doivent être activées, par toi-même ou par un administrateur, avant que tu puisses ouvrir une session ; cette information était affichée pendant l’inscription. Si un e-mail t’as déjà été envoyé, suis les instructions. Si tu n’as pas reçu d’e-mail, tu as pu avoir spécifié une adresse e-mail incorrecte ou l’e-mail a pu avoir été considéré comme un courrier indésirable. Si tu es certain que l’adresse e-mail que tu as spécifié était correcte, essaie de contacter un administrateur.'
	),
	array(
		0 => 'Je m’étais déjà inscrit mais ne peux plus me connecter à présent ?!',
		1 => 'Essaie de retrouver l’e-mail qui t’as été envoyé lorsque tu t’es inscrit pour la première fois, vérifie ton nom d’utilisateur et ton mot de passe, puis réessaie. Il est possible qu’un administrateur ait désactivé ou supprimé ton compte pour une certaine raison. Beaucoup de forums suppriment périodiquement les utilisateurs qui n’ont rien publiés depuis un certain temps afin de réduire la taille de la base de données. Si tel était le cas, inscris-toi à nouveau et essaie de participer plus activement aux discussions.',
	),
	array(
		0 => 'Qu’est-ce que la COPPA ?',
		1 => 'La COPPA, ou la “Child Online Privacy and Protection Act”, est une loi des États-Unis qui exige que les sites Internet pouvant potentiellement collecter des informations sur des mineurs âgés de moins de 13 ans doivent avoir le consentement écrit des parents ou des tuteurs légaux. Si tu n’es pas sûr que cette loi s’applique également à ton inscription, ou au site Internet dans lequel tu souhaites t’inscrire, contacte des conseillers ou avocats légaux qui pourront t’informer. Sache que les équipes de phpBB ne peuvent pas te fournir d’assistance légale et ne sont pas le contact approprié pour des problèmes légaux de la sorte, excepté comme décrit ci-dessous.',
	),
	array(
		0 => 'Pourquoi ne puis-je pas m’inscrire ?',
		1 => 'Il est possible que le propriétaire du site Internet ait banni ton adresse IP ou interdit le nom d’utilisateur que tu souhaites utiliser afin de t’inscrire. Le propriétaire du site Internet peut également avoir désactivé les inscriptions afin d’empêcher les nouveaux visiteurs de s’inscrire. Pour plus d’informations, contacte l’administrateur du forum.',
	),
	array(
		0 => 'À quoi sert “Supprimer tous les cookies du forum” ?',
		1 => 'L’option “Supprimer tous les cookies du forum” permet d’effacer tous les cookies créés par phpBB3 qui conservent ton authentification et ta connexion sur le forum. Cela fournit également des fonctionnalités telles que l’enregistrement du statut des messages, lu ou non lu, si cela a été activé par le propriétaire du forum. Si tu rencontres des problèmes de connexion ou de déconnexion, la suppression des cookies du forum peut te les corriger.',
	),
	array(
		0 => '--',
		1 => 'Préférences et réglages des utilisateurs'
	),
	array(
		0 => 'Comment puis-je modifier mes réglages ?',
		1 => 'Si tu es un utilisateur inscrit, tous tes réglages sont stockés dans la base de données du forum. Pour les modifier, rends-toi sur ton panneau de contrôle de l’utilisateur ; ce lien se situe en haut de toutes les pages du forum. Ce système te permettra de modifier tous tes réglages et toutes tes préférences.'
	),
	array(
		0 => 'L’heure n’est pas correcte !',
		1 => 'Il est possible que l’heure affichée soit réglée sur un fuseau horaire différent de celui dans lequel tu es. Si tel était le cas, rends-toi sur ton panneau de contrôle de l’utilisateur et modifie le fuseau horaire afin de trouver ta zone adéquate, par exemple Londres, Paris, New York, Sydney, etc. Sache que la modification du fuseau horaire, comme la plupart des réglages, n’est accessible qu’aux utilisateurs inscrits. Si tu n’es pas inscrit, c’est le moment idéal de le faire.'
	),
	array(
		0 => 'J’ai modifié le fuseau horaire et l’heure n’est toujours pas correcte !',
		1 => 'Si tu es certain d’avoir correctement réglé le fuseau horaire et l’heure d’été mais que l’heure est encore erronée, alors l’heure de l’horloge du serveur est incorrecte et les administrateurs devront la corriger.'
	),
	array(
		0 => 'Ma langue n’apparaît pas dans la liste !',
		1 => 'Soit l’administrateur n’a pas installé ta langue, soit personne n’a encore traduit phpBB dans ta langue. Essaie de demander à l’administrateur du forum s’il peut installer l’archive de langue que tu désires. Si l’archive de langue n’existe pas, tu es libre de te porter volontaire afin de créer une nouvelle traduction. Pour plus d’informations, rends-toi sur le site de phpBB.com (accessible depuis le lien situé en bas de toutes les pages du forum).'
	),
	array(
		0 => 'Comment puis-je afficher une image associée à mon nom d’utilisateur ?',
		1 => 'Il y a deux images qui peuvent être associées à un nom d’utilisateur lors de la consultation de messages. L’une d’elles peut être une image associée à ton rang, généralement en forme d’étoiles, de carrés ou de ronds, qui indiquent le nombre de messages à ton actif ou ton statut sur le forum. L’autre, habituellement une plus grande image, est connue sous le nom d’avatar et est généralement unique ou personnelle à chaque utilisateur. C’est à l’administrateur du forum d’activer les avatars et de décider de la manière dont ils sont mis à disposition. Si tu ne peux pas utiliser d’avatars, contacte l’administrateur du forum et demande-lui pour quelles raisons a t-il souhaité désactiver cette fonctionnalité.'
	),
	array(
		0 => 'Quel est mon rang et comment puis-je le modifier ?',
		1 => 'Les rangs, qui apparaissent en dessous de ton nom d’utilisateur, indiquent le nombre de messages que tu as publié ou identifient certains utilisateurs, comme les modérateurs et les administrateurs. Dans la plupart des cas, tu ne peux pas directement modifier le texte des rangs du forum car ils sont réglés par l’administrateur du forum. Merci de ne pas abuser de ce système en publiant inutilement des messages afin d’augmenter seulement ton rang sur le forum. Beaucoup de forums ne toléreront pas cela et un modérateur ou un administrateur abaissera ton compteur de messages.'
	),
	array(
		0 => 'Lorsque je clique sur le lien de l’e-mail d’un utilisateur, il m’est demandé de me connecter ?',
		1 => 'Seuls les utilisateurs inscrits peuvent envoyer des e-mails aux autres utilisateurs par l’intermédiaire du formulaire e-mail intégré, si l’administrateur a activé cette fonctionnalité. Cela a pour but d’empêcher toute utilisation malveillante du système e-mail par des utilisateurs anonymes ou par des agents automatisés.'
	),
	array(
		0 => '--',
		1 => 'Problèmes de publication'
	),
	array(
		0 => 'Comment puis-je publier un sujet dans un forum ?',
		1 => 'Pour publier un nouveau sujet dans un forum, clique sur le bouton adéquat situé sur l’écran du forum ou du sujet. Il se peut que tu aies besoin d’être inscrit avant de pouvoir rédiger un message. Une liste de tes permissions sur chaque forum est disponible en bas de l’écran du forum ou du sujet. Par exemple : tu peux publier de nouveaux sujets, tu peux voter dans les sondages, etc.'
	),
	array(
		0 => 'Comment puis-je éditer ou supprimer un message ?',
		1 => 'À moins que tu ne sois un administrateur ou un modérateur du forum, tu ne peux éditer ou supprimer que tes propres messages. Tu peux éditer un message en cliquant le bouton adéquat, parfois dans une limite de temps après que le message ait été publié. Si quelqu’un a déjà répondu au message, tu trouveras un petit bout de texte en dessous du message lorsque tu reviens au sujet qui énumère le nombre de fois que tu l’as édité, contenant la date et l’heure. Ceci n’apparaîtra que si quelqu’un a effectué une réponse ; cela n’apparaîtra pas si un modérateur ou un administrateur a édité le message, bien qu’ils puissent laisser une note discrète exprimant leur raison. Saches que les utilisateurs normaux ne peuvent pas supprimer de message une fois que quelqu’un y a répondu.'
	),
	array(
		0 => 'Comment puis-je ajouter une signature à un message ?',
		1 => 'Pour ajouter une signature à un message, tu dois tout d’abord en créer une par l’intermédiaire de ton panneau de contrôle de l’utilisateur. Une fois créée, tu peux cocher la case <em>Insérer une signature</em> sur le formulaire de rédaction afin d’ajouter ta signature. Tu peux également ajouter une signature par défaut sur tous vos messages en cochant la case appropriée dans ton profil. Si tu fais cela, tu peux alors empêcher l’ajout individuel de la signature sur les messages en décochant la case d’ajout de la signature dans le formulaire de rédaction.'
	),
	array(
		0 => 'Comment puis-je créer un sondage ?',
		1 => 'Lorsque tu rédiges un nouveau sujet ou édites le premier message d’un sujet, clique sur l’onglet “Création d’un sondage” en-dessous du formulaire principal de rédaction ; si tu ne peux pas le voir, c’est que tu n’as pas les permissions appropriées afin de créer des sondages. Saisi le titre du sondage en incluant au moins deux options dans les champs adéquats, chaque option devant être dans une ligne séparée de la zone du texte. Tu peux également régler le nombre d’options par utilisateur en sélectionnant lors du vote “Options par utilisateur”, puis une limite de temps en jours pour le sondage (“0” pour une durée illimité) et enfin autoriser ou non les utilisateurs à modifier leur vote.'
	),
	array(
		0 => 'Pourquoi ne puis-je pas ajouter plus d’options au sondage ?',
		1 => 'La limite d’options d’un sondage est réglée par l’administrateur du forum. Si tu souhaites ajouter plus d’options à ton sondage par rapport au nombre autorisé, contacte l’administrateur du forum.'
	),
	array(
		0 => 'Comment puis-je éditer ou supprimer un sondage ?',
		1 => 'Comme pour les messages, les sondages ne peuvent être édités que par leur auteur, un modérateur ou un administrateur. Pour éditer un sondage, clique sur “Éditer” dans le premier message du sujet ; il y aura toujours le sondage associé à celui-ci. Si personne n’a voté, les utilisateurs peuvent supprimer le sondage ou éditer chaque option du sondage. Cependant, si les membres ont déjà exprimés leurs votes, seuls les modérateurs ou les administrateurs peuvent éditer ou supprimer le sondage. Cela empêche la modification des options d’un sondage en cours.'
	),
	array(
		0 => 'Pourquoi ne puis-je pas accéder au forum ?',
		1 => 'Certains forums peuvent être limités à certains utilisateurs ou groupes d’utilisateurs. Pour consulter, lire, publier ou réaliser n’importe quelle autre action, tu as besoin de permissions spéciales. Contacte un modérateur ou un administrateur du forum afin de demander ton accès.'
	),
	array(
		0 => 'Pourquoi ne puis-je pas ajouter de pièces jointes ?',
		1 => 'Les permissions afin d’ajouter des pièces jointes sont accordées par forum, par groupe ou par utilisateur. L’administrateur du forum n’a peut-être pas autorisé l’ajout de pièces jointes dans le forum auquel tu souhaites les insérer, ou seuls certains groupes sont peut-être autorisés à insérer des pièces jointes. Contacte l’administrateur du forum si tu ne sais pas pourquoi tu ne peux pas insérer de pièces jointes.'
	),
	array(
		0 => 'Pourquoi ai-je reçu un avertissement ?',
		1 => 'Chaque administrateur du forum a son propre ensemble de règles pour son site. Si tu ne respectes pas une règle, tu recevras un avertissement. Sache que c’est la décision de l’administrateur de ce forum, le phpBB Group n’a rien à voir avec l’avertissement distribué sur ce site. Contacte l’administrateur du forum si tu ne sais pas pourquoi tu as reçu un avertissement.'
	),
	array(
		0 => 'Comment puis-je rapporter des messages à un modérateur ?',
		1 => 'Si l’administrateur du forum a activé cette fonctionnalité, tu devrais voir un bouton afin de rapporter des messages à côté du message que tu souhaites rapporter. En cliquant sur celui-ci, tu trouveras toutes les étapes nécessaires afin de rapporter le message.'
	),
	array(
		0 => 'Qu’est-ce le bouton “Sauvegarder” lors de la rédaction d’un sujet ?',
		1 => 'Cela autorise à sauvegarder les messages qui doivent être complétés et envoyés à une date ultérieure. Rends-toi sur le panneau de contrôle de l’utilisateur afin de recharger un message sauvegardé.'
	),
	array(
		0 => 'Pourquoi mon message a-t-il besoin d’être approuvé ?',
		1 => 'L’administrateur du forum peut décider que les messages que tu publies sur le forum doivent être vérifiés avant d’être publiés. Il est également possible que l’administrateur t’ai placé dans un groupe d’utilisateurs pour lequel il juge nécessaire que les messages doivent être vérifiés avant d’être publiés. Pour plus d’informations, contacte l’administrateur du forum.'
	),
	array(
		0 => 'Comment puis-je remonter mes sujets ?',
		1 => 'En cliquant sur le lien “Remonter le sujet” lorsque tu es en train de consulter un sujet, tu peux “remonter” celui-ci en haut de la liste des sujets, à la première page du forum. Cependant, si tu ne vois pas ce lien, cette fonctionnalité a peut-être été désactivée ou le temps d’attente nécessaire entre les remontages n’a peut-être pas encore été atteint. Il est également possible de remonter le sujet simplement en y répondant. Cependant, assure-toi de respecter les règles du forum.'
	),
	array(
		0 => '--',
		1 => 'Mise en forme et types de sujets'
	),
	array(
		0 => 'Qu’est-ce que le BBCode ?',
		1 => 'Le BBCode est une implémentation spéciale de l’HTML, offrant un meilleur contrôle sur la mise en forme d’un message. L’utilisation du BBCode est déterminée par l’administrateur mais tu peux également le désactiver sur chacun des messages depuis le formulaire de rédaction. Le BBCode est similaire à l’architecture de l’HTML, les balises sont contenues entre des crochets <strong>[</strong> et <strong>]</strong> à la place de <strong>&lt;</strong> et <strong>&gt;</strong>. Consulte le guide qui est accessible depuis la page de rédaction pour plus d’informations à propos du BBCode.'
	),
	array(
		0 => 'Puis-je utiliser de l’HTML ?',
		1 => 'Désolé, il n’est pas possible d’utiliser de l’HTML sur ce forum. La majeure partie de la mise en forme qui peut être réalisée avec de l’HTML peut être réalisée grâce à l’utilisation du BBCode.'
	),
	array(
		0 => 'Que sont les émoticônes ?',
		1 => 'Les émoticônes sont de petites images qui peuvent être utilisées afin d’exprimer des sentiments en utilisant un code court. Par exemple, “:)” exprime la joie alors que “:(” exprime la tristesse. La liste complète des émoticônes peut être affichée depuis le formulaire de rédaction. Essaie cependant de ne pas abuser des émoticônes, elles peuvent rapidement rendre un message illisible et un modérateur pourrait décider de l’éditer ou de le supprimer complètement. L’administrateur du forum peut également définir une limite du nombre d’émoticônes qui peuvent être utilisées dans un message.'
	),
	array(
		0 => 'Puis-je publier des images ?',
		1 => 'Bien sûr, des images peuvent être insérées dans vos messages. Si l’administrateur du forum a autorisé les pièces jointes, tu peux transférer des images sur le forum. Dans le cas contraire, tu dois faire un lien vers une image stockée sur un serveur Internet accessible publiquement, comme par exemple http://www.exemple.com/mon-image.gif. Tu ne peux ni faire de lien vers des images stockées sur ton propre ordinateur (à moins que celui-ci soit un serveur Internet), ni faire de lien vers des images stockées derrière un quelconque système d’authentification, par exemple les boîtes e-mails “Hotmail” ou “Yahoo!”, les sites protégés par un mot de passe, etc. Pour insérer une image, utilise la balise BBCode [img].'
	),
	array(
		0 => 'Que sont les annonces globales ?',
		1 => 'Les annonces globales contiennent des informations très importantes et tu devrais les consulter aussi vite que possible. Elles apparaissent en haut de chaque forum et dans ton panneau de contrôle de l’utilisateur. Les permissions des annonces globales sont définies par l’administrateur du forum.'
	),
	array(
		0 => 'Que sont les annonces ?',
		1 => 'Les annonces contiennent souvent des informations importantes sur le forum dans lequel tu navigues et tu devrais les consulter aussi vite que possible. Les annonces apparaissent en haut de chaque page du forum dans lequel elles ont été publiées. Tout comme les annonces globales, les permissions des annonces sont définies par l’administrateur du forum.'
	),
	array(
		0 => 'Que sont les notes ?',
		1 => 'Les notes apparaissent sous les annonces et seulement sur la première page du forum consulté. Elles sont souvent assez importantes et tu devrais les consulter dès que tu en as l’occasion. Tout comme les annonces et les annonces globales, les permissions des notes sont définies par l’administrateur du forum.'
	),
	array(
		0 => 'Que sont les sujets verrouillés ?',
		1 => 'Les sujets verrouillés sont les sujets dans lesquels les utilisateurs ne peuvent plus répondre et dans lesquels les sondages sont automatiquement expirés. Les sujets peuvent être verrouillés pour de nombreuses raisons et ont été mis de cette façon par un modérateur ou un administrateur du forum. Tu peux également verrouiller tes propres sujets si l’administrateur t’en a donné les permissions.'
	),
	array(
		0 => 'Que sont les icônes de sujet ?',
		1 => 'Les icônes de sujet sont des images sélectionnées par l’auteur et sont associées à des messages afin d’indiquer leur contenu. La possibilité d’utiliser des icônes de sujet dépendent des permissions définies par l’administrateur du forum.'
	),
	// This block will switch the FAQ-Questions to the second template column
	array(
		0 => '--',
		1 => '--'
	),
	array(
		0 => '--',
		1 => 'Niveaux d’utilisateurs et groupes d’utilisateurs'
	),
	array(
		0 => 'Que sont les administrateurs ?',
		1 => 'Les administrateurs sont des membres possédant le plus haut niveau de contrôle sur le forum. Ces utilisateurs peuvent contrôler chaque facette des opérations du forum, incluant le réglage des permissions, le bannissement d’utilisateurs, la création de groupes d’utilisateurs ou de modérateurs, etc. Cela dépend des attributions du fondateur du forum et les permissions qu’il a attribué aux autres administrateurs. Ils peuvent également détenir les mêmes capacités que les modérateurs et cela dans tous les forums. Tout cela dépend des réglages effectués par le fondateur du forum.'
	),
	array(
		0 => 'Que sont les modérateurs ?',
		1 => 'Les modérateurs sont des utilisateurs individuels (ou groupes d’utilisateurs individuels) qui surveillent jour après jour les forums. Ils ont la possibilité d’éditer ou de supprimer les sujets, les verrouiller, les déverrouiller, les déplacer, les fusionner et les diviser dans le forum qu’ils modèrent. En règle générale, les modérateurs sont présents afin d’empêcher que des utilisateurs fassent du hors-sujet ou publient du contenu abusif ou offensant.'
	),
	array(
		0 => 'Que sont les groupes d’utilisateurs ?',
		1 => 'Les groupes d’utilisateurs sont une façon pour les administrateurs du forum de regrouper plusieurs utilisateurs. Chaque utilisateur peut appartenir à plusieurs groupes et chaque groupe peut être avoir des permissions individuelles. Cela rend les tâches plus faciles aux administrateurs car ils peuvent modifier les permissions de plusieurs utilisateurs en une seule fois, ou encore leur accorder des pouvoirs de modération, ou bien leur donner accès à un forum privé.'
	),
	array(
		0 => 'Où sont les groupes d’utilisateurs et comment puis-je en rejoindre un ?',
		1 => 'Tu peux consulter tous les groupes d’utilisateurs par l’intermédiaire du lien “Groupes d’utilisateurs” depuis ton panneau de contrôle de l’utilisateur. Si tu souhaites en rejoindre un, clique sur le bouton approprié. Cependant, tous les groupes d’utilisateurs ne sont pas ouverts aux nouvelles adhésions. Certains peuvent nécessiter une approbation, d’autres peuvent être fermés et d’autres peuvent même être invisibles. Si le groupe est ouvert, tu peux le rejoindre en cliquant sur le bouton approprié. S’il nécessite une approbation, clique également sur le bouton approprié. Le responsable du groupe devra approuver ta requête et il pourra te demander pourquoi tu souhaites rejoindre le groupe. Merci de ne pas harceler un responsable de groupe s’il refuse ta requête : il doit avoir ses propres raisons.'
	),
	array(
		0 => 'Comment puis-je devenir un responsable de groupe ?',
		1 => 'Un responsable de groupe est généralement assigné lorsque les groupes d’utilisateurs sont initialement créés par un administrateur du forum. Si tu es intéressé par la création d’un groupe d’utilisateurs, ton premier contact devrait être un administrateur ; essaie de lui envoyer un message privé.',
	),
	array(
		0 => 'Pourquoi certains groupes d’utilisateurs apparaissent dans une couleur différente ?',
		1 => 'Les administrateurs du forum peuvent assigner une couleur aux membres d’un groupe d’utilisateurs afin de faciliter l’identification des membres de ce groupe.'
	),
	array(
		0 => 'Qu’est-ce qu’un “Groupe d’utilisateurs par défaut” ?',
		1 => 'Si tu es membre de plus d’un groupe d’utilisateurs, ton groupe d’utilisateurs par défaut est utilisé afin de déterminer quelle couleur et quel rang de groupe doivent être affichés pour toi par défaut. L’administrateur du forum peut te donner la permission de modifier toi-même ton groupe d’utilisateurs par défaut par l’intermédiaire de ton panneau de contrôle de l’utilisateur.'
	),
	array(
		0 => 'Qu’est-ce que le lien “L’équipe” ?',
		1 => 'Cette page liste les membres de l’équipe du forum, incluant les administrateurs, les modérateurs et quelques informations, comme les forums qu’ils modèrent.'
	),
	array(
		0 => '--',
		1 => 'Messagerie privée'
	),
	array(
		0 => 'Je ne peux pas envoyer de messages privés !',
		1 => 'Il y a trois raisons qui peuvent en être la cause ; soit tu n’es pas inscrit ou connecté, soit un administrateur a désactivé entièrement la messagerie privée sur le forum ou soit il t’empêche d’envoyer des messages privés. Si tu es confronté au dernier cas, tu devrais demander la raison de l’administrateur du forum à avoir fait cela.'
	),
	array(
		0 => 'Je continue à recevoir des messages privés non sollicités !',
		1 => 'Tu peux empêcher un utilisateur à t’envoyer des messages privés en utilisant les règles de messages qui te servent de filtres depuis ton panneau de contrôle de l’utilisateur. Si tu reçois des messages privés de manière abusive de la part de quelqu’un, informe-en un administrateur ; il pourra empêcher complètement un utilisateur d’envoyer des messages privés.'
	),
	array(
		0 => 'J’ai reçu un spam ou un e-mail non désiré de la part de quelqu’un sur ce forum !',
		1 => 'Nous en sommes désolés. Le formulaire d’envoi d’e-mail de ce forum possède des protections afin d’essayer de dépister les utilisateurs qui envoient de tels messages. Tu devrais envoyer par e-mail à un administrateur du forum une copie complète de l’e-mail que tu as reçu. Il est très important que celui-ci inclue les en-têtes contenant les informations de l’auteur de l’e-mail. Il pourra alors agir en conséquence.'
	),
	array(
		0 => '--',
		1 => 'Amis et ignorés'
	),
	array(
		0 => 'A quoi sert ma liste d’amis et d’ignorés ?',
		1 => 'Tu peux utiliser ces listes afin d’organiser et trier les membres du forum. Les membres ajoutés dans ta liste d’amis seront listés dans ton panneau de contrôle de l’utilisateur afin de consulter rapidement leur statut en ligne et leur envoyer des messages privés. Selon le style utilisé, les messages publiés par ces utilisateurs peuvent éventuellement être mis en surbrillance. Si tu ajoutes un utilisateur à ta liste d’ignorés, tous les messages qu’il publiera seront masqués par défaut.'
	),
	array(
		0 => 'Comment puis-je ajouter ou supprimer des utilisateurs de ma liste d’amis et d’ignorés ?',
		1 => 'Tu peux ajouter des utilisateurs à ces listes de deux manières. Dans chaque profil d’utilisateurs, il y a un lien afin de les ajouter à ta liste d’amis ou d’ignorés. Alternativement, tu peux ajouter directement des utilisateurs en saisissant leur nom d’utilisateur depuis le panneau de contrôle de l’utilisateur. Tu peux également supprimer des utilisateurs de tes listes en utilisant cette même page.'
	),
	array(
		0 => '--',
		1 => 'Recherche dans les forums'
	),
	array(
		0 => 'Comment puis-je effectuer une recherche dans un ou des forums ?',
		1 => 'Tu peux effectuer une recherche dans un ou des forums en saisissant un terme dans la boîte de recherche située sur l’index, sur les pages des forums et sur les pages des sujets. La recherche avancée peut être accessible en cliquant sur le lien “Recherche” disponible sur toutes les pages du forum. L’accès à la recherche dépend du style utilisé.'
	),
	array(
		0 => 'Pourquoi ma recherche ne renvoie aucun résultat ?',
		1 => 'Ta recherche était probablement trop vague ou incluait trop de termes communs qui ne sont pas indexés par phpBB3. Sois plus précis et utilise les options disponibles dans la recherche avancée.'
	),
	array(
		0 => 'Pourquoi ma recherche renvoie à une page blanche ?!',
		1 => 'Ta recherche a retourné trop de résultats pour que le serveur puisse les afficher. Utilise la recherche avancée et sois plus précis dans les termes utilisés et les forums dans lesquels tu souhaites effectuer une recherche.'
	),
	array(
		0 => 'Comment puis-je rechercher des utilisateurs ?',
		1 => 'Rends-toi sur la page “Membres” et clique sur le lien “Trouver un membre”. Remplis ensuite convenablement les diverses options qui te sont disponibles.'
	),
	array(
		0 => 'Comment puis-je retrouver mes propres messages et sujets ?',
		1 => 'Tes propres messages peuvent être affichés en cliquant sur le lien “Rechercher les messages de l’utilisateur” par l’intermédiaire du panneau de contrôle de l’utilisateur ou de ton propre profil. Pour effectuer une recherche de tes propres sujets, utilise la recherche avancée et remplis convenablement les options qui te sont disponibles.'
	),
	array(
		0 => '--',
		1 => 'Abonnements aux sujets et favoris'
	),
	array(
		0 => 'Quelle est la différence entre la mise en favori et l’abonnement ?',
		1 => 'Dans phpBB3, la mise en favori d’un sujet est similaire à la mise en favori de pages par ton navigateur Internet. Tu ne seras pas averti lors de nouveaux messages, mais tu pourras retourner rapidement au sujet ultérieurement. Par contre, l’abonnement te préviendra lors de nouveaux messages sur le sujet ou forum que tu surveilles.'
	),
	array(
		0 => 'Comment puis-je m’abonner à un forum ou à un sujet spécifique ?',
		1 => 'Pour s’abonner à un forum spécifique, clique sur le lien “Surveiller le forum” dans le forum souhaité. Pour s’abonner à un sujet, répond au sujet en sélectionnant l’option d’abonnement ou clique sur le lien “Surveiller le sujet” dans la page du sujet.'
	),
	array(
		0 => 'Comment puis-je supprimer mes abonnements ?',
		1 => 'Pour supprimer tes abonnements, rends-toi sur le panneau de contrôle de l’utilisateur et suis le lien vers tes abonnements.'
	),
	array(
		0 => '--',
		1 => 'Pièces jointes'
	),
	array(
		0 => 'Quelles sont les pièces jointes autorisées sur ce forum ?',
		1 => 'Chaque administrateur du forum peut autoriser ou interdire certains types de pièces jointes. Si tu n’es pas sûr de ce qui est autorisé ou non, n’hésite pas à demander à l’administrateur du forum.'
	),
	array(
		0 => 'Comment puis-je retrouver toutes mes pièces jointes ?',
		1 => 'Pour retrouver la liste des pièces jointes que tu as transféré, rends-toi sur le panneau de contrôle de l’utilisateur et suis les liens vers la section des pièces jointes.'
	),
	array(
		0 => '--',
		1 => 'Questions à propos de phpBB3'
	),
	array(
		0 => 'Qui a écrit ce système de forum ?',
		1 => 'Ce programme (dans sa forme non modifiée) est produit, distribué et est sous copyright par le <a href="http://www.phpbb.com/">phpBB Group</a>. Il est rendu accessible sous la Licence Publique Générale GNU et peut être distribué gratuitement. Pour plus d’informations, clique sur le lien.'
	),
	array(
		0 => 'Pourquoi la fonctionnalité X n’est pas disponible ?',
		1 => 'Ce programme a été écrit et mis sous licence par le phpBB Group. Si tu penses qu’une fonctionnalité nécessite d’être ajoutée, rends-toi sur le site Internet de phpBB.com, propose-la au phpBB Group et attend leurs avis. Merci de ne pas envoyer directement de requêtes d’ajout de fonctionnalités sur le forum de phpBB.com, le phpBB Group utilise SourceForge afin de gérer ce type de requêtes. Consulte les forums afin de connaitre notre position, si nous en avons une, par rapport à cette fonctionnalité, et suis la procédure spécifiée là-bas.'
	),
	array(
		0 => 'Qui dois-je contacter à propos de problèmes d’abus ou d’ordres légaux liés à ce forum ?',
		1 => 'Tous les administrateurs listés sur la page “L’équipe” devraient être un contact approprié pour ce genre de problèmes. Si tu n’obtiens aucune réponse de leur part, tu devrais alors contacter le propriétaire du domaine (fais un <a href="http://www.google.com/search?q=whois">WHOIS</a>) ou, si celui-ci fonctionne sur un service gratuit (comme Yahoo!, Free.fr, f2s.com, etc.), le service de gestion des abus. Sache que le phpBB Group n’a <strong>absolument aucune juridiction</strong> et ne peut en aucun cas être tenu comme responsable de comment, où et par qui ce forum est utilisé. Ne contacte pas le phpBB Group pour tout problème d’ordre légal (commentaire incessant, insultant, diffamatoire, etc.) qui n’ont <strong>pas directement de relation</strong> avec le site Internet de phpBB.com ou le script phpBB en lui-même. Si tu envoies un e-mail au phpBB Group <strong>à propos d’une utilisation de tierce partie</strong> de ce logiciel, attend-toi à une réponse laconique ou à aucune réponse, tout simplement.'
	)
);

?>