/*
 * $Id: debug.h,v 1.13 2001/07/18 20:01:36 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_DEBUG_H
#define __PLUCKER_DEBUG_H

#include "viewer.h"


#ifdef DEBUG
Char* _( Char* fmt, ... ) __attribute__ ( ( format( printf, 1, 2 ) ) );
void _DebugMsg( Char* fname, Int16 line, Char* title, Char* function, Char* msg );

#define MSG( s )            _DebugMsg( __FILE__,__LINE__,"DEBUG",__FUNCTION__,s )
#define MSG_IF( func,s )    if ( ( func ) ) { MSG( s ); }
#define FATAL( s )          _DebugMsg( __FILE__,__LINE__,"FATAL",__FUNCTION__,s )
#define FATAL_IF( func,s )  if ( ( func ) ) { FATAL( s ); }
#else
#define MSG( s )            /* none */
#define MSG_IF( func,s )    /* none */
#define FATAL( s )          /* none */
#define FATAL_IF( func,s )  /* none */
#endif

#endif
