# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import os, sys, cPickle, string
from cStringIO import StringIO
import Status, MailMessage
from SiteConfiguration import DIR, SYSTEM_DIR

config = None
def Configuration(*args):
	global config
	if config is not None:
		return config
	config = apply(_Configuration, args)
	return config

def execute_file(file):
	temp = sys.stdout 
	try:
		sys.stdout = StringIO()
		execfile(file, {})
		return sys.stdout.getvalue()
	finally:
		sys.stdout = temp

def get_contents(file):
	fp = open(file)
	try:
		return string.strip(fp.read())
	finally:
		fp.close()

class _Configuration:

	'''\
	Public attributes:
	self.aliases -> dictionary: name -> list of addresses
	self.signature -> a string
	self.headers -> a string
	self.status -> a Status.Status
	self.servers -> a dictionary name -> callable
	self.config -> a dictionary mapping area -> configuration directives
	self.special -> a function taking a purpose and returning a 
	                Folder object
	'''
	def __init__(self):
		self.headers = self.signature = ''
		self.aliases = {}
		self.servers = {}
		self.config = {}
		self._special = {}
		for dir in (SYSTEM_DIR, DIR):
			self._read_signature(dir)
			self._read_headers(dir)
			for method in [self._read_aliases, self._read_servers, 
			               self._read_special, self._read_config, 
			               self._execute_scripts]:
				try:
					method(dir)
				except OSError:
					pass
		self._make_status()

	def _read_aliases(self, dir):
		dir = os.path.join(dir, "aliases")
		for alias in os.listdir(dir):
			file = os.path.join(dir, alias)
			self.aliases[alias] = get_contents(file)

	def _read_signature(self, dir):
		sigfile = os.path.join(dir, "signature.py")
		try:
			self.signature = execute_file(sigfile)
		except IOError:
			pass

	def _read_headers(self, dir):
		headfile = os.path.join(dir, "headers.py")
		try:
			self.headers = execute_file(headfile)
			self.headers = MailMessage.parse(StringIO(self.headers))
		except IOError:
			pass

	def _execute_scripts(self, dir):
		for file in os.listdir(os.path.join(dir, "scripts")):
			execfile(os.path.join(dir, "scripts", file), {})

	def _make_status(self):
		status_file = os.path.join(DIR, "status")
		if os.path.isfile(status_file):
			self.status = Status.status(status_file)
		else:
			self.status = Status.Status(status_file)

	def _read_config(self, dir):
		for name in os.listdir(os.path.join(dir, "config")):
			new_dir = os.path.join(dir, "config", name)
			if not os.path.isdir(new_dir):
				continue
			if not self.config.has_key(name):
				self.config[name] = {}
			for directive in os.listdir(new_dir):
				file = os.path.join(new_dir, directive)
				self.config[name][directive]=get_contents(file)

	def _read_servers(self, dir):
		for name in os.listdir(os.path.join(dir, "servers")):
			file = os.path.join(dir, "servers", name)
			if not os.path.isfile(file):
				continue
			d = {}
			execfile(file, d)
			try:
				self.servers[name] = d['server']
			except KeyError:
				pass

	def _read_special(self, dir):
		purposes = os.listdir(os.path.join(dir, "special"))
		for purpose in purposes:
			server = os.path.join(dir, "special", purpose, "server")
			folder = os.path.join(dir, "special", purpose, "folder")
			try:
				self._special[purpose] = map(get_contents, 
				                             (server, folder))
			except (OSError, IOError):
				pass

	def special(self, purpose):
		import Folder
		return apply(Folder.Folder, self._special[purpose])
