# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Configuration, Server, Folder, MailMessage, Log
import nntplib, string
from cStringIO import StringIO

def _parse_lines(lines):
	fp = StringIO()
	for line in lines:
		fp.write(line+'\n')
	fp.seek(0)
	return MailMessage.parse(fp)

class NNTPServer(Server.Server):

	def __init__(self, name, host, port):
		Log.log("creating nntp server with", host, port)
		self.nntp = nntplib.NNTP(host, port)

        def get_message(self, folder, uid):
		Log.log("getting", uid, "from", folder)
		return _parse_lines(self.nntp.article(uid)[3])

	def get_header(self, folder, uid):
		Log.log("getting headers of", uid, "from", folder)
		return _parse_lines(self.nntp.head(uid)[3])
		
	def get_list(self, folder):
		Log.log("getting messages in", folder)
		resp, count, first, last, name = self.nntp.group(folder)
		try:
			Log.log("trying fast method of getting messages")
			return self._fast_get_list(first, last)
		except nntplib.error_reply: 
			Log.log("fast method unsupported...trying slow method")
			return self._slow_get_list(first, last)

	def _fast_get_list(self, first, last):
		Log.log("sending xhdr request", first, last)
		resp, ids = self.nntp.xhdr('message-id', first + '-' + last)
		messages = []
		for (n, id) in ids:
			Log.log("checking", n, id)
			try:
				self.nntp.stat(id)
				Log.log("stat passed")	
			except (nntplib.error_reply, nntplib.error_temp):
				Log.log("stat failed")
				pass
			else:
				Log.log("appending", id)
				messages.append(id)
		return messages
		
        def _slow_get_list(self, first, last):
		Log.log("trying slow method", first, last)
		messages = []
		for i in map(str, range(int(first), int(last)+1)):
			Log.log("testing", i)
			try:	
				id = self.nntp.stat(i)[2]
				Log.log("got id", id)
			except (nntplib.error_reply, nntplib.error_temp):
				Log.log("no such message")
				pass
			else:
				Log.log("appending", id)
				messages.append(id)
		return messages
		
        def get_subfolders(self, folder):
		Log.log("getting subgroups of", folder)
		parts = string.split(folder, '.')
		parts.reverse()
		Log.log("getting list of groups")
		curr = self.groups
		Log.log("got list")
		while parts:
			part = parts.pop()
			Log.log("specializing to", part)
			curr = curr.get(part, {})
		return curr.keys()

	def subfolder(self, folder, name):
		Log.log("getting subfolder", name, "of", folder)
		return Folder.Folder(self.name, folder+'.'+name)

	def __getattr__(self, name):
		if name != 'groups':
			raise AttributeError(name)
		Log.log("getting groups")
		self.groups = {}
		Log.log("issuing list command")
		groups = self.nntp.list()
		Log.log("finished list command")
		for group in groups:
			group = group[0]
			parts = string.split(group, '.')
			parts.reverse()
			curr = self.groups
			while parts:
				part = parts.pop()
				if not curr.has_key(part):
					curr[part] = {}
				curr = curr[part]
		return self.groups
