# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import cPickle, os, Folder

def status(filename):
	fp = open(filename)
	try:
		return cPickle.load(fp)
	finally:
		fp.close()

class Status:

	def __init__(self, filename):
		self.filename = filename
		self.servers = {}
		self.server = None

	def save(self):
		pickle = cPickle.dumps(self, 1)
		temp_name = self.filename+'.tmp'
                fp = open(temp_name, 'w')
		try:
			fp.write(pickle)
		finally:
			fp.close()
		os.rename(temp_name, self.filename)

	def set_server(self, name, folder):
		self.server = name
		if not self.servers.has_key(name):
			self.servers[name] = [Folder.Folder(name, folder)]
		self.save()

	def resync(self, name=None):
		self.get_folder(name).resync()
		self.save()

	def set_folder(self, folder, name=None):
		if name is None:
			name = self.server
		if not self.servers.has_key(name):
			self.servers[name] = [None]
		self.servers[name][-1] = folder
		self.save()

	def push_folder(self, folder, name=None):
		if name is None:
			name = self.server
		if not self.servers.has_key(name):
			self.servers[name] = []
		self.servers[name].append(folder)
		self.save()

	def pop_folder(self, name=None):
		if name is None:
			name = self.server
		if len(self.servers[name])<=1:
			return
		del self.servers[name][-1]
		self.save()

	def remove_server(self, name):
		del self.servers[name]
		if self.server == name:
			self.server = None
		self.save()

	def get_folder(self, name=None):
		if name is None:
			name = self.server
		return self.servers[name][-1]

	def remove_message(self, uid, name=None):
		self.get_folder(name).remove_message(uid)
		self.save()

	def next_message(self, name=None):
		self.get_folder(name).next()
		self.save()
		
	def prev_message(self, name=None):
		self.get_folder(name).prev()
		self.save()

	def first_message(self, name=None):
		self.index_message(0, name)
		self.save()

	def last_message(self, name=None):
		l = len(self.get_folder(name).get_messages())
		self.index_message(l-1, name)

	def index_message(self, i, name=None):
		self.get_folder(name).set_index(i)
		self.save()
