# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import ForwardingFolder, Log

class SubsetFolder(ForwardingFolder.ForwardingFolder):

	def __init__(self, folder, indices):
		Log.log("initialzing SubsetFolder", folder, indices)
		ForwardingFolder.ForwardingFolder.__init__(self)
		self._folder = folder
		self.indices = indices
		self.name = 'subset('+self._folder.name+')'

	def _get_messages(self):
		Log.log("getting messages")
		messages = []
		for i in self.indices:
			Log.log("adding number", i)
			messages.append(self._folder.messages[i])
		Log.log("got", len(messages))
		return messages

	def _get_folders(self):
		Log.log("getting subfolders")
		return self._folder.folders

	def folder(self, folder):
		Log.log("getting subfolder", folder)
		return self._folder.folder(folder)
