//******************************************************************************
// implementation de la classe firstwindow
// programmers	: Bruno Ethvignot									bruno@tlk.fr
// copyright 		: TLK Games 											http://www.tlk.fr
// created			:	2000-05-06
// updates 			: 2000-07-27
//
// This program is free software; you can redistribute it and/or modify it under the terms of the 
// GNU General Public License as published by the Free Software Foundation; either version 2 of the License, 
// or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along with this program; 
// if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//******************************************************************************

#include "xfree.hpp"
#include	"powermanga.hpp"

//------------------------------------------------------------------------------
//constructeur
//------------------------------------------------------------------------------
			xfree::xfree()
{
}

//------------------------------------------------------------------------------
//destructeur
//------------------------------------------------------------------------------
			xfree::~xfree()
{
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void	xfree::razMembres()
{	pConnexionAffichage=0 ;
	pFenetreRacine=0 ;
	pContexteGraphique=0 ;
	iProfondeurEcran=0 ;
	iOctetsParPixel=0 ;
	iPleinEcran=0 ;
	iAccesDirect=0 ;
	iEcranDefaut=0 ;
	iLargeurRacine=0 ;
	iHauteurRacine=0 ;
	iMasque_Evenements=KeyPressMask | KeyReleaseMask | ExposureMask | FocusChangeMask ; 
	pXImage=0 ;
	pFenetre=0 ;
}

//------------------------------------------------------------------------------
//initialisation de notre fenetre / initialize a window 
//------------------------------------------------------------------------------
int		xfree::initialise(unsigned int _iLarge, unsigned int _iHaute)
{	razMembres() ;
	//ouvertue d'un "display" (connexion socket au serveur X) ......................
	if(!pConnexionAffichage)
	{	pConnexionAffichage=XOpenDisplay(0) ;
		if(!pConnexionAffichage)
		{	afficheErreur("XOpenDisplay failed !", "firstwindow.cpp/initialise()") ;
			return 0 ;
		}
	}
	printf("==============>1\n") ;

	//demande la fenetre racine ....................................................
	if(!pFenetreRacine)
	{	pFenetreRacine=DefaultRootWindow(pConnexionAffichage);
		if(!pFenetreRacine)
		{	afficheErreur("DefaultRootWindow failed !", "firstwindow.cpp/initialise()") ;
			return 0 ;
		}
		//printf("==============> fenetre racine : %x\n", pFenetreRacine) ;
	}	
	printf("==============>2\n") ;
	iLargeur=_iLarge ; 
	printf("==============>2a\n") ;
	iHauteur=_iHaute ;
	printf("==============>2b\n") ;
	iLargeurRacine=DisplayWidth(pConnexionAffichage, pFenetreRacine) ;
	printf("==============>2d\n") ;
	iHauteurRacine=DisplayHeight(pConnexionAffichage, pFenetreRacine) ;
	iEcranDefaut=DefaultScreen(pConnexionAffichage) ;
	printf("==============>2c\n") ;

	printf("==============>3\n") ;
	if(!testProfondeurEcran()) return 0 ;
	if(!creeContexteGraphique()) return 0 ; 
	if(!creeFenetre()) return 0 ; 
	if(!initialiseDGA()) return 0 ;
	initialiseCurseurBlanc() ;

	printf("==============>4\n") ;
	if(iOctetsParPixel==1)
	{	pTableCouleur=XCreateColormap(pConnexionAffichage, pFenetre, DefaultVisual(pConnexionAffichage, iEcranDefaut) ,AllocAll) ;
		XSetWindowColormap(pConnexionAffichage, pFenetre, pTableCouleur) ;
	}
	iLargeurTotal=iLargeur;
	iHauteurTotal=iHauteur;
	if(!(pXImage=creeXImage(iLargeurTotal, iHauteurTotal))) return 0 ;
	return 1 ;
}	

//------------------------------------------------------------------------------
// calcul la profondeur ecran / test depth screen
//------------------------------------------------------------------------------
int	xfree::testProfondeurEcran()
{	int										_iCompteur ;
	int					  				_iFormatOK ;
	int										_iFormatCount ;
	XPixmapFormatValues*	_pFormatListe ;
	iProfondeurDefaut=DefaultDepth(pConnexionAffichage, iEcranDefaut) ;
	iProfondeurEcran=iProfondeurDefaut ;
	if(iProfondeurEcran<8)
  {	afficheErreur("this game need 8 bits peer pixels minimum (256 colors)", "firstwindow.cpp/calculProfondeurEcran()") ;
 		return 0 ;
  }
	switch(iProfondeurEcran)
	{	case  8 : iOctetsParPixel=1 ; break ;
		case 15 : iOctetsParPixel=2 ; break ;
		case 16 : iOctetsParPixel=2 ; break ;
		case 24 : iOctetsParPixel=3 ; break ;
		case 32 : iOctetsParPixel=4 ; break ;
	}
	_pFormatListe=XListPixmapFormats(pConnexionAffichage, &_iFormatCount);
 	if(_pFormatListe == NULL)
  {	afficheErreur("cannot get pixmap list format", "firstwindow.cpp/calculProfondeurEcran()") ;
 		return 0 ;
  }
 	_iFormatOK=-1 ;
	for (_iCompteur=0 ; _iCompteur<_iFormatCount ; _iCompteur++)
	{	if( _pFormatListe[_iCompteur].depth == (int)(iProfondeurEcran)) _iFormatOK=_iCompteur;
	}
  if (_iFormatOK == -1)
  {	afficheErreur("erreur profondeur ecran", "firstwindow.cpp/calculProfondeurEcran()") ;
 		return 0 ;
  }
  memcpy(&sPixmapFormat,&_pFormatListe[_iFormatOK], sizeof (sPixmapFormat));
  XFree(_pFormatListe);
	if (iProfondeurEcran==24) iProfondeurEcran = sPixmapFormat.bits_per_pixel;
	return 1 ;
} 	

//------------------------------------------------------------------------------
// creation d'un contexte graphique
//------------------------------------------------------------------------------
int	xfree::creeContexteGraphique()
{	if(!iAccesDirect) 
	{	if(!pContexteGraphique)
		{	//unsigned int _iEcran=DefaultScreen(pConnexionAffichage) ; 
			sValeursGC.foreground=WhitePixel(pConnexionAffichage, iEcranDefaut); ;
  		sValeursGC.background=BlackPixel(pConnexionAffichage, iEcranDefaut); ;
			pContexteGraphique=XCreateGC(pConnexionAffichage, pFenetreRacine, (GCForeground | GCBackground), &sValeursGC);
			if(!pContexteGraphique)
			{	afficheErreur("XCreateGC failed failed !", "firstwindow.cpp/xw_init()") ;
				return 0 ;
			}
		}
	}
	return 1 ;
}

//------------------------------------------------------------------------------
// creation d'une fenetre / create a window
//------------------------------------------------------------------------------
int	xfree::creeFenetre()
{	unsigned int _iX=(iLargeurRacine-iLargeur)>>1 ;
	unsigned int _iY=(iHauteurRacine-iHauteur)>>1 ;

	sAttributFenetre.background_pixel=BlackPixel(pConnexionAffichage, iEcranDefaut);
  sAttributFenetre.border_pixel=BlackPixel(pConnexionAffichage, iEcranDefaut);
	sAttributFenetre.event_mask=iMasque_Evenements ;

	//creation d'une fenetre -------------------------------------------------------
	pFenetre=XCreateWindow(pConnexionAffichage, pFenetreRacine, _iX, _iY, iLargeur, iHauteur, 5, 
	iProfondeurDefaut, InputOutput, CopyFromParent, CWEventMask|CWBackPixel|CWBorderPixel, &sAttributFenetre) ;
	if(!pFenetre)
	{	afficheErreur("XCreateWindow failed", "firstwindow.cpp/creeFenetre()") ;
		return 0 ;
	}
	XStoreName(pConnexionAffichage , pFenetre , "PowerManga by TLK Games");
	XSelectInput(pConnexionAffichage , pFenetre, iMasque_Evenements) ;
 
	//donne les speceficites de notre fenetre  -------------------------------------
	sTailleIndications.flags			=PPosition | PMinSize | PMaxSize ;
  sTailleIndications.x					=(iLargeurRacine-iLargeur)>>1;
  sTailleIndications.y					=(iHauteurRacine-iHauteur)>>1;
  sTailleIndications.x					=(iLargeurRacine-iLargeur)>>1;
  sTailleIndications.y					=(iHauteurRacine-iHauteur)>>1;
  sTailleIndications.min_width	=iLargeur;
  sTailleIndications.min_height	=iHauteur;
  sTailleIndications.max_width	=iLargeur;
	sTailleIndications.max_height	=iHauteur;
  XSetWMNormalHints (pConnexionAffichage , pFenetre , &sTailleIndications);
	XClearWindow (pConnexionAffichage , pFenetre);		//efface la fenetre entierement
	XMapRaised (pConnexionAffichage , pFenetre);			//affiche la fenetre
	XFlush (pConnexionAffichage);
	return 1 ;
}

//------------------------------------------------------------------------------
// initialise le mode DGA / initialize DGA mode
//------------------------------------------------------------------------------
int xfree::initialiseDGA()
{	if(iAccesDirect==1) 								//marche en plein ecran ?
	{ XF86DGAQueryDirectVideo(pConnexionAffichage, iEcranDefaut, &iDGAFlags);
	 	if (!(iDGAFlags & XF86DGADirectPresent))
	  {	afficheErreur ("DGA's not available !", "xwindow/xw_init()") ;
			return 0 ;
	  }
	  XF86DGAGetVideo(pConnexionAffichage, iEcranDefaut, &pDGAmemoire, &iDGAtailleLigne, &iDGAbanksize, &iDGAtailleMemoire );
		XF86DGAGetViewPortSize(pConnexionAffichage, iEcranDefaut,  &iDGALargeur,  &iDGAHauteur);
		XF86DGADirectVideo (pConnexionAffichage, iEcranDefaut, XF86DGADirectGraphics|XF86DGADirectKeyb);
		memset(pDGAmemoire, 0, iDGALargeur*iDGAHauteur*iOctetsParPixel);
	}
	return 1 ;
}

//------------------------------------------------------------------------------
// initialise un curseur blanc / initialize a blank cursor
//------------------------------------------------------------------------------
void xfree::initialiseCurseurBlanc()
{	Cursor _curseur ;
	XColor _couleur ;
	Pixmap _curseurPixmap;
	_couleur.pixel=WhitePixel(pConnexionAffichage, iEcranDefaut);
  _curseurPixmap=XCreatePixmap(pConnexionAffichage, pFenetre, 1, 1, 1);
  _curseur=XCreatePixmapCursor(pConnexionAffichage, _curseurPixmap, _curseurPixmap , &_couleur, &_couleur, 0, 0);
  if (_curseurPixmap) XFreePixmap(pConnexionAffichage, _curseurPixmap);
  XDefineCursor(pConnexionAffichage, pFenetre, _curseur);
}


//------------------------------------------------------------------------------
// cree un XImage / create a XImage
//------------------------------------------------------------------------------
XImage* xfree::creeXImage(unsigned int _iLarge, unsigned int _iHaute)
{	int	_iScanLinePad=sPixmapFormat.scanline_pad ;
	int _iScanLineLength=sPixmapFormat.bits_per_pixel * iLargeurTotal / 8;
	if ( (_iScanLineLength & (sPixmapFormat.scanline_pad/8 -1)) != 0)
	{	_iScanLineLength&=~(sPixmapFormat.scanline_pad/8 -1);
    _iScanLineLength+=sPixmapFormat.scanline_pad/8;
  }
	char* _pMemoire=reserveMemoire(_iLarge*_iHaute*iOctetsParPixel) ; //reserve la memoire
	if(!_pMemoire) {	afficheErreur ("out of memory !", "xwindow/xw_init()") ; return 0 ; }
	XImage* _pXImage=XCreateImage(pConnexionAffichage, CopyFromParent, iProfondeurDefaut, ZPixmap, 0, _pMemoire, _iLarge, _iHaute, _iScanLinePad, _iLarge*iOctetsParPixel);
	if(!_pXImage) {	afficheErreur("XCreateImage() failed", "firstwindow.cpp/creeXImage()") ; return 0 ; }
	return 	_pXImage ;
}


//------------------------------------------------------------------------------
// initialise la palette de couleurs / initialize colors map (256 colors)
//------------------------------------------------------------------------------
int	 xfree::initialise_palette(unsigned char* _pPal)
{	pPalette=_pPal ;
	unsigned int _iIndex ;
	//ecran 8 bits 256 couleurs / 8 bits depth . . . . . . . . . . . . . . . . . . . 
	if(iOctetsParPixel==1)
	{	if(!pXColor) pXColor=(XColor*)reserveMemoire(sizeof(XColor)*256) ;
		if(!pXColor)
		{	afficheErreur("'pXColor' out of memory","firtswindow/initialise_palette()") ;
			return 0 ;
		}
		unsigned char* _p=(unsigned char*)pPalette ;
		for(_iIndex=0 ; _iIndex<256 ; _iIndex++) 
		{	pXColor[_iIndex].red=_p[0]<<8 ;
			pXColor[_iIndex].green=_p[1]<<8 ;
			pXColor[_iIndex].blue=_p[2]<<8 ;
			pXColor[_iIndex].pixel=_iIndex ;
			pXColor[_iIndex].flags=DoRed | DoGreen | DoBlue ;
		_p+=3 ;
		}
		XStoreColors(pConnexionAffichage, pTableCouleur, pXColor, 256) ;
		XInstallColormap(pConnexionAffichage, pTableCouleur) ;
	}
	else
	//ecran 15 ou 16 bits 65536 couleurs / 15 or 16 bits depth   . . . . . . . . . . 
	{	if(iOctetsParPixel==2)
		{	if(!pPalette16) pPalette16=(unsigned short*)reserveMemoire(256*2) ;
			if(!pPalette16) 
			{	afficheErreur("'pPalette16' out of memory","firtswindow/initialise_palette()") ;
				return 0 ;
			}
			if(iProfondeurDefaut==15) convertitPalette24_15(pPalette, pPalette16) ;
			else convertitPalette24_16(pPalette, pPalette16) ;
		}
		else
		//ecran 24 ou 32 bits / 24 or 32 bits depth  . . . . . . . . . . . . . . . . . .
		{	if(iOctetsParPixel>2)
			{	if(!pPalette32) pPalette32=(unsigned int*)reserveMemoire(256*4) ;
				if(!pPalette32) 
				{	afficheErreur("'pPalette32' out of memory", "firtswindow/initialise_palette()") ;
					return 0 ;
				}
				unsigned char* _p=(unsigned char*)pPalette32 ;
				_pPal=pPalette ;
				for(_iIndex=0 ; _iIndex<256 ; _iIndex++)	//_p[3]=? / _p[2]=red / _p[1]=green / _p[0]=blue
				{	_p[0]=_pPal[2] ; _p[1]=_pPal[1] ; _p[2]=_pPal[0] ; _p[3]=0 ; _p+=4 ; _pPal+=3 ;
				}
			}
		}
	}
	return 1 ;
}

//------------------------------------------------------------------------------
// Gestion des evenements / events 
//------------------------------------------------------------------------------
int xfree::execution()
{	//int i ; 
	//int	num_events ;
 	//KeySym key ;
 	XKeyEvent* _pXKeyEvent ;
	XFlush(pConnexionAffichage);
	unsigned int _iNombreEvenements = XPending(pConnexionAffichage);
	//boucle des evenements ........................................................
	while((_iNombreEvenements-- != 0))
	{	XNextEvent(pConnexionAffichage, &sEvenements);
    switch(sEvenements.type)
    {	//touches enfoncees  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
			case KeyPress:
			{	_pXKeyEvent=(XKeyEvent*)&sEvenements;
				if(_pXKeyEvent->keycode==76) { fermerFenetre=1 ; printf("close F10\n") ; }		//touche F10
			} 
			break ;
	 		//touches relachees  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
			case KeyRelease:
  		{	_pXKeyEvent=(XKeyEvent*)&sEvenements;
				printf("KeyRelease : keycode=%i state=%i\n", _pXKeyEvent->keycode, _pXKeyEvent->state) ;
  		}
  		break ;
			// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
			case Expose:
			//iAffiche=0 ;
			break ;
			// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
			case FocusIn:	
			break ;
			// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
			case FocusOut:
				//if(iAccesDirect==1) fermerFenetre=1 ;
			break ;
			// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
			default :
				printf("firstwindow.cpp / execution() : evenement type=%i\n", sEvenements.type) ; 
			break ;
    }
  }
	affiche_ecran() ;
	return 0 ;
}

//------------------------------------------------------------------------------
// test si la fenetre doit etre fermee / test if close window
//------------------------------------------------------------------------------
int xfree::tst_ferme()
{	return fermerFenetre ;
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
int	xfree::ferme()
{	if(pXImage)
	{	libereMemoire(pXImage->data)	;										//libere deja la memoire / free buffer's ximage
		pXImage->data=0 ;
		XDestroyImage(pXImage) ;
	}
	if(pFenetre)
	{	XDestroyWindow(pConnexionAffichage, pFenetre) ;
		pFenetre=0 ;
	}
	if(pContexteGraphique)
	{	XFreeGC(pConnexionAffichage, pContexteGraphique) ;
		pContexteGraphique=0 ;
	}
	if(pConnexionAffichage)
	{	XCloseDisplay(pConnexionAffichage);
		pConnexionAffichage=0 ;
	}
	return 1 ;
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void	xfree::affiche_ecran()
{	XPutImage(pConnexionAffichage, pFenetre,  pContexteGraphique, pXImage, 0, 0,	0, 16, iLargeur ,iHauteur) ;	
}

//------------------------------------------------------------------------------
// decompress pcx file and convert to 8 bits (no change), or 16 bits or 24 bits
// input 	=> _pFichier				: filename
// output <= _pStructureGfx		: pointer to the "sDescriptionGfx" structure / 0=error 
//------------------------------------------------------------------------------
char*	xfree::chargement_pcx(char* _pNomFichier)
{	sDescriptionGfx* _pGfx=load_pcx(_pNomFichier) ;
	if(!_pGfx) return 0 ;
	if(iOctetsParPixel>0)
	{	if(!convertit_16ou24(_pGfx)) 
		{	afficheErreur("convertit_16ou24() failed\n", "xwindow.cpp/Xload_pcx()") ; 	
			return 0 ;
		}
	}
	char* _pMem=_pGfx->pAdresse ;
	libereMemoire((char*)_pGfx) ;
	return _pMem ;
}




