//******************************************************************************
// Declaration de la classe firstwindow
// programmers	: Bruno Ethvignot									bruno@tlk.fr
// copyright 		: TLK Games 											http://www.tlk.fr
// created			:	2000-05-06
// updates 			: 2000-05-06
//
// This program is free software; you can redistribute it and/or modify it under the terms of the 
// GNU General Public License as published by the Free Software Foundation; either version 2 of the License, 
// or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along with this program; 
// if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//******************************************************************************

#ifndef __XFREE__
#define __XFREE__
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/XShm.h>
#include <X11/extensions/xf86vmode.h>
#include <X11/extensions/xf86dga.h>

class xfree
{
	private:
		Display*							pConnexionAffichage ;	//pointeur sur le display
		Window								pFenetreRacine ;			//pointeur fenetre racine (4 octets=pointeur)
		GC										pContexteGraphique ;	//(4 octets=pointeur)
		XGCValues							sValeursGC ;
		unsigned int					iProfondeurDefaut ;		//nombre de bits par pixels
		unsigned int					iProfondeurEcran ;		//nombre de bits par pixels / number of bits peer pixels (8,15,16,24,32)
		unsigned int					iOctetsParPixel ;			//nombre d'octets par pixels / number of bits peer pixels (1,2,3,4)
		unsigned int					iPleinEcran ;					//1=plein ecran (VidMode)
		unsigned int 					iEcranDefaut ;				//numero de l'ecran par defaut 
		unsigned int					iLargeurRacine ;			//largeur de l'ecran
		unsigned int					iHauteurRacine ;			//hauteur de l'ecran
		XPixmapFormatValues		sPixmapFormat ;

		unsigned int					fermerFenetre ;				//1=demande a fermer la fenetre / request close window

		//Caracteristiques de la fenetre ...............................................
		Window								pFenetre;							//pointeur sur notre fenetre (4 octets=pointeur)
		unsigned int 					iLargeur ;						//largeur de la fenetre
		unsigned int					iHauteur ;						//hauteur de la fenetre
		unsigned int 					iLargeurTotal ;				//largeur de l'
		unsigned int					iHauteurTotal ;				//hauteur de la fenetre
		unsigned int					iMasque_Evenements ;
		XSetWindowAttributes	sAttributFenetre ;		
		XSizeHints           	sTailleIndications ;
		XEvent								sEvenements ;
		XImage* 							pXImage ;

		//palette de couleurs / colors palettes ..........................................
		unsigned char* 				pPalette ;					//palette de couleurs 24 bits (3 octets par couleur)
		unsigned int*					pPalette32 ;				//palette de couleurs 24 bits (4 octets par couleur) 
		unsigned short*				pPalette16 ;				//palette de couleurs 16 bits (2 octets par couleur)
		Colormap 							pTableCouleur ;
		XColor								sCouleur ;
		XColor* 							pXColor ;						//tableau XColor
	
		//DGA ..........................................................................
		unsigned int					iAccesDirect ;					//1=DGA
		int										iDGAFlags ;
		char*									pDGAmemoire ;
		int										iDGAtailleLigne ;  			//taille d'une ligne en pixels
		int 									iDGAbanksize;   				//taille d'un banc en octets
		int 									iDGAtailleMemoire; 			//taille memoire en kilo-octets
		int 									iDGALargeur;     				//xwindow's screen width in pixels
		int										iDGAHauteur;     				//xwindow's screen height in pixels 


	public:
													xfree() ;
													~xfree() ;
		int										initialise(unsigned int _iLarge, unsigned int _iHaute) ;
		int										execution() ;
		int										tst_ferme() ;
		int										ferme() ;

	private :
		void									razMembres() ;
		int										testProfondeurEcran() ;
		int										creeContexteGraphique() ;
		int										creeFenetre() ;
		int										initialiseDGA() ;
		void									initialiseCurseurBlanc() ;
		XImage* 							creeXImage(unsigned int _iLarge, unsigned int _iHaute) ;
		int										initialise_palette(unsigned char*) ;
		void									affiche_ecran() ;
		char*									chargement_pcx(char* _pNomFichier) ;

} ;
#endif
