/* C_Polyhedron class implementation (non-inline functions).
   Copyright (C) 2001-2006 Roberto Bagnara <bagnara@cs.unipr.it>

This file is part of the Parma Polyhedra Library (PPL).

The PPL is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

The PPL is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1307, USA.

For the most up-to-date information see the Parma Polyhedra Library
site: http://www.cs.unipr.it/ppl/ . */

#include <config.h>

#include "C_Polyhedron.defs.hh"
#include "NNC_Polyhedron.defs.hh"
#include "algorithms.hh"

namespace PPL = Parma_Polyhedra_Library;

PPL::C_Polyhedron::C_Polyhedron(const NNC_Polyhedron& y)
  : Polyhedron(NECESSARILY_CLOSED, y.space_dimension(), UNIVERSE) {
  const Constraint_System& cs = y.constraints();
  for (Constraint_System::const_iterator i = cs.begin(),
	 cs_end = cs.end(); i != cs_end; ++i) {
    const Constraint& c = *i;
    add_constraint(c.is_strict_inequality() ? (Linear_Expression(c) >= 0) : c);
  }
  assert(OK());
}

PPL::C_Polyhedron::C_Polyhedron(const Congruence_System& cgs)
  : Polyhedron(NECESSARILY_CLOSED,
	       cgs.space_dimension() <= max_space_dimension()
	       ? cgs.space_dimension()
	       : (throw_space_dimension_overflow(NECESSARILY_CLOSED,
						 "C_Polyhedron(cgs)",
						 "the space dimension of cgs "
						 "exceeds the maximum allowed "
						 "space dimension"), 0),
	       UNIVERSE) {
  add_congruences(cgs);
}

PPL::C_Polyhedron::C_Polyhedron(Congruence_System& cgs)
  : Polyhedron(NECESSARILY_CLOSED,
	       cgs.space_dimension() <= max_space_dimension()
	       ? cgs.space_dimension()
	       : (throw_space_dimension_overflow(NECESSARILY_CLOSED,
						 "NNC_Polyhedron(cgs)",
						 "the space dimension of cgs "
						 "exceeds the maximum allowed "
						 "space dimension"), 0),
	       UNIVERSE) {
  add_congruences(cgs);
}

bool
PPL::C_Polyhedron::poly_hull_assign_if_exact(const C_Polyhedron& q) {
  return PPL::poly_hull_assign_if_exact(*this, q);
}
