#include <stdio.h>
#include <termios.h>

#include "fppxp.h"

#include <support.h>
#include <xcio.h>
#include <ppxp.h>

#define	SYSLINE_HEIGHT	20

#define	SYSLINE_RALIGN	2
#define	SYSLINE_BUTTON	4

static struct {
    FL_OBJECT *obj;
    const char *post;
    int w;
    int flags;
} syslines[]={
    {NULL, "PPP status", 70, 0},
    {NULL, "Connected time", 65, 0},
    {NULL, "Bps", 65, SYSLINE_RALIGN},
    {NULL, "Idle", 50, 0},
    {NULL, "Auto Mode", 60, SYSLINE_BUTTON},
    {NULL, "Open Terminal Window", 60, SYSLINE_BUTTON},
};

enum {
    STATUS_SYSLINE,
    CTIME_SYSLINE,
    BPS_SYSLINE,
    IDLE_SYSLINE,
    AUTO_SYSLINE,
    TERM_SYSLINE,
    MAX_SYSLINES
};

void
UpdateSysline(struct pppinfo_s *old, struct pppinfo_s *new)
{
    static const char *phase[]={
	"Dead", "Establish", "Authenticate", "Callback",
	"Network", "Terminate"
    };
    char *mode;
    char tmp[20];
    int dif;

    if (old->phase != new->phase) {
	if (new->phase != PS_ESTABLISH)
	    fl_set_object_label(syslines[STATUS_SYSLINE].obj,
				phase[new->phase]);
    }
    if (new->phase == PS_ESTABLISH && old->l_stat != new->l_stat) {
	char *mode="PPP";

	if (new->l_stat & LSTAT_CHAT) mode = "CHAT";
	else if (new->l_stat & LSTAT_TTY) mode = "TTY";
	fl_set_object_label(syslines[STATUS_SYSLINE].obj, mode);
    }
    if (old->connect != new->connect) {
	sprintf(tmp, "%02d:%02d:%02d", new->connect / 3600,
		(new->connect % 3600) / 60,
		new->connect % 60);
	fl_set_object_label(syslines[CTIME_SYSLINE].obj, tmp);
    }
    dif = new->r.lsize - old->r.lsize + new->s.lsize - old->s.lsize;
    if (dif >= 0) {
	dif <<= 3;
	if (dif > 1000)
	    sprintf(tmp, "%d,%03d", dif / 1000, dif % 1000);
	else
	    sprintf(tmp, "%d", dif);
	fl_set_object_label(syslines[BPS_SYSLINE].obj, tmp);
    }
    if (old->idle != new->idle) {
	sprintf(tmp, "%02d:%02d", new->idle / 60,
		new->idle % 60);
	fl_set_object_label(syslines[IDLE_SYSLINE].obj, tmp);
    }
}

static int
SyslinePostHandler(FL_OBJECT *obj, int event,
		   FL_Coord x, FL_Coord y, int key, void *xevent)
{
    int n;

    if (event != FL_ENTER && event != FL_LEAVE) return(0);
    for (n = 0; n < MAX_SYSLINES; n ++)
	if (syslines[n].obj == obj) break;

    if (n == MAX_SYSLINES) return(-1);
    if (event == FL_ENTER)
	fl_show_oneliner(syslines[n].post, obj->form->x + obj-> x,
			 obj->form->y + obj->form->h);
    else
	fl_hide_oneliner();
}

void
CreateSysline(FL_FORM *form)
{
    FL_OBJECT *obj;
    int n, x;
    extern FL_OBJECT *autoModeObj, *openTermObj;

    obj = fl_add_box(FL_FLAT_BOX, 0, 0, form->w,
		     form->h - SYSLINE_HEIGHT, "");
    fl_set_object_color(obj, FL_SLATEBLUE, FL_RED);

/*    obj = fl_add_frame(FL_EMBOSSED_FRAME, 1,
		       form->h - SYSLINE_HEIGHT - 1,
		       form->w - 2, SYSLINE_HEIGHT, "");
*/

    for (x = n = 0; n < MAX_SYSLINES; n ++) {
	if (syslines[n].flags & SYSLINE_BUTTON) {
	    obj = fl_add_lightbutton(FL_PUSH_BUTTON, x,
				form->h - SYSLINE_HEIGHT,
				syslines[n].w - 1, SYSLINE_HEIGHT, "");
	    fl_set_object_boxtype(obj, FL_EMBOSSED_BOX);
	} else {
	    obj = fl_add_box(FL_EMBOSSED_BOX, x,
			     form->h - SYSLINE_HEIGHT,
			     syslines[n].w - 1, SYSLINE_HEIGHT, "");
	}
	fl_set_object_color(obj, FL_WHITE, FL_RED);
	x = obj->x + obj->w + 1;
	fl_set_object_posthandler(obj, SyslinePostHandler);
	if (syslines[n].flags & SYSLINE_RALIGN)
	    fl_set_object_lalign(obj, FL_ALIGN_INSIDE|FL_ALIGN_RIGHT);
	syslines[n].obj = obj;
    }
    autoModeObj = syslines[AUTO_SYSLINE].obj;
    openTermObj = syslines[TERM_SYSLINE].obj;
}
