#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <sys/types.h>

#include <config.h>
#include <support.h>

#include "str_sysmsg.h"

static char **conMsg;

#ifdef	HAVE_MSGCAT

#include <nl_types.h>

#if defined(linux) || defined(__OpenBSD__) || defined(__NetBSD__)
# define	BAD_MSGCAT
#endif

#ifdef		NL_CAT_LOCALE
# ifdef		BAD_MSGCAT
#  define	CATOPEN_FLAG	0
# else
#  define	CATOPEN_FLAG	NL_CAT_LOCALE
# endif
#else
# ifdef		MCLoadBySet
#  define	CATOPEN_FLAG	MCLoadBySet
# else
#  define	CATOPEN_FLAG	0
# endif
#endif

static nl_catd conCatd, sysCatd;

static char *
MsgFile(const char *file)
{
    char *path;

#ifdef	BAD_MSGCAT
    char *lang, *p;

    if ((p = getenv("LANG")) == NULL) p = "C";
    lang = Strdup(p);
    path = Malloc(sizeof(NLSPATH) + strlen(lang) + strlen(file) + 20);
    sprintf(path, NLSPATH"/%s/%s.cat", lang, file);
    if (access(path, R_OK) && (p = strchr(lang, '.')) != NULL) {
	*p = '\0';
	sprintf(path, NLSPATH"/%s/%s.cat", lang, file);
	if (access(path, R_OK) && (p = strchr(lang, '_')) != NULL) {
	    *p = '\0';
	    sprintf(path, NLSPATH"/%s/%s.cat", lang, file);
	}
	/* :-p */
    }
    Free(lang);
#else
    path = Strdup(file);
#endif	/* BAD_MSGCAT */
    return(path);
}

void
SysMsgInit()
{
    static bool_t initialized=FALSE;
    char *path;

    if (initialized) return;
    initialized = TRUE;
    path = MsgFile("ppxpd");
    sysCatd = catopen(path, CATOPEN_FLAG);
    Free(path);
    return;
}

int
MsgInit(const char *file, char *msgs[])
{
    char *path;

    path = MsgFile(file);
    conCatd = catopen(path, CATOPEN_FLAG);
    Free(path);
    conMsg = msgs;
    return(conCatd == (nl_catd)-1 ? -1: 0);
}

char *
MsgGet(int mno)
{
    return(catgets(conCatd, 1, mno, conMsg ? conMsg[mno-2]:""));
}

char *
SysMsgGet(int mno)
{
    return(catgets(sysCatd, 1, mno,
		   (strMsg && mno <= MAX_STRMSGS) ? strMsg[mno-2]:""));
}

void
MsgClose()
{
    catclose(conCatd);
    conMsg = NULL;
}

#else /* HAVE_MSGCAT */

void
SysMsgInit()
{
    /* do nothing */
}

int
MsgInit(const char *file, char *msgs[])
{
    conMsg = msgs;
    return(0);
}

char *
MsgGet(int mno)
{
    return(conMsg ? conMsg[mno-2]:"");
}

char *
SysMsgGet(int mno)
{
    return((strMsg && mno <= MAX_STRMSGS) ? strMsg[mno-2]:"");
}

void
MsgClose()
{
    conMsg = NULL;
}

#endif /* HAVE_MSGCAT */
