/*
 * This is an implementation of the PPP Deflate protocol described by
 * RFC1979.
 *
 * This implementation uses the zlib library.
 *
 * Global Functions:
 *  void    DeflateInit(int direction)
 *  int     DeflateCompress(u_char *buf, int *lenp, u_int16_t nbo_proto)
 *  u_char *DeflateUncompress(u_char *buf, int *lenp, u_int16_t *nbo_protop)
 *
 */

/*
   Configuration

    0                   1                   2                   3
    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |     Type      |    Length     |Window | Method|    MBZ    |Chk|
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
          1 1 0 1 0             1 1         1 0 0 0 0 0 0 0 0 0 0 0

*/

#include <config.h>
#ifdef	HAVE_DEFLATE

#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#include <zlib.h>

#include <support.h>

void
DeflateInit(int direction)
{
}

int
DeflateCompress(u_char *buf, int *lenp, u_int16_t nbo_proto)
{
}

u_char *
DeflateUncompress(u_char *buf, int *lenp, u_int16_t *nbo_protop)
{
}

#endif	/* HAVE_DEFLATE */
