#ifndef	_PPXP_FSM_H
#define	_PPXP_FSM_H

typedef enum {
    FSM_INITIAL,
    FSM_STARTING,
    FSM_CLOSED,
    FSM_STOPPED,
    FSM_CLOSING,
    FSM_STOPPING,
    FSM_REQSENT,
    FSM_ACKRCVD,
    FSM_ACKSENT,
    FSM_OPENED,
    FSM_UNEXP,
    FSM_KEEP
} fsmstate_t;

struct fsmreg_s {
    const char *name;
    struct timer_s timer;	/* timer_s */
    void *priv;			/* Private Registry */
    void (*tlu)();		/* This-Layer-Up */
    void (*tld)();		/* This-Layer-Down */
    void (*tls)();		/* This-Layer-Start */
    void (*tlf)();		/* This-Layer-Finished */
    void (*scr)();		/* Send-Configure-Request */
    void (*sca)();		/* Send-Configure-Ack */
    void (*scn)();		/* Send-Configure-Nak */
    void (*str)();		/* Send-Terminate-Request */
    void (*sta)();		/* Send-Terminate-Ack */
    void (*scj)();		/* Send-Code-Reject */
    void (*ser)();		/* Send-Echo-Reply */
    u_int r_count;		/* Restart counter */
    u_int init_r_count;		/* Initial restart counter */
    time_t init_r_to;		/* Initial restart timer */
    fsmstate_t state;		/* current state */
    u_int8_t id;		/* ID */
    u_int8_t
	opt_r:1,		/* Restart option */
	opt_p:1,		/* Passive option */
	opt_x:1,		/* Crossed connection */
	nak_rcr:1,		/* RCR nak */
	rej_rcr:1,		/* RCR reject */
	fatal_rxj:1,		/* Receive-{Code,Protocol}-Reject */
	flg_res:3;		/*                 (nonpermitted) */
};

void FsmInit(struct fsmreg_s *);	/* initialize */
void FsmTO(struct fsmreg_s *);		/* Timeout */
int FsmUp(struct fsmreg_s *);		/* lower layer is Up */
int FsmDown(struct fsmreg_s *);	/* lower layer is Down */
int FsmOpen(struct fsmreg_s *);	/* administrative Open */
int FsmClose(struct fsmreg_s *);	/* administrative Close */
int FsmRCR(struct fsmreg_s *);		/* Receive-Configure-Request */
int FsmRCA(struct fsmreg_s *);		/* Receive-Configure-Ack */
int FsmRCN(struct fsmreg_s *);		/* Receive-Configure-Nak/Rej */
int FsmRTR(struct fsmreg_s *);		/* Receive-Terminate-Request */
int FsmRTA(struct fsmreg_s *);		/* Receive-Terminate-Ack */
int FsmRUC(struct fsmreg_s *);		/* Receive-Unknown-Code */
int FsmRXJ(struct fsmreg_s *);		/* Receive-{Code,Protocol}-Reject */
int FsmRXR(struct fsmreg_s *);		/* Receive-Echo-{Request,Reply} */

#endif	/* _PPXP_FSM_H */
