#
#
#
#

Widget:DefineClass MenuEntry ButtonEntry ment:create ment:config ment_proc

proc ment:create {w a} {
    ListboxMenu $w.menu

    $w configure -buttonimage ImageDown -buttoncommand \
	[list ment:post_menu $w.menu $w]
    $w.entry configure -textvariable ment_var($w)
    $w.menu configure -variable ment_var($w)
}

proc ment:post_menu {menu parent} {
    set x [winfo rootx $parent]
    set y [expr [winfo rooty $parent] + [winfo height $parent]]
    $menu post $x $y
}

proc ment:config {w opt val} {
    set change_width 0

    switch -- $opt {
	-width {
	    [$w subwidget entry] configure -width $val
	    set change_width 1
	}
	-items {
	    foreach i $val {
		$w.menu add $i
	    }
	    set change_width 1
	}
	-variable {
	    $w.entry configure -textvariable $val
	    $w.menu configure -variable $val
	}
	default {
	    return 1
	}
    }
    if $change_width {
	set m 0
	foreach i [$w.menu get 0 end] {
	    set l [string length $i]
	    if {$m < $l} {
		set m $l
	    }
	}
	set l [$w.entry cget -width]
	if {$m < $l} {
	    set m $l
	}
	$w.menu configure -width $m
    }
    return 0
}

proc ment:test {} {
    global IMAGEDIR
    set img [image create photo -file [file join $IMAGEDIR open-folder.gif]]
    ButtonEntry .bent -width 12 -buttonimage $img -buttoncommand {puts aho}

    MenuEntry .ment -width 12 -variable test_var
    .ment configure -items {aaaa bbbb cccc ddddddddddd eeeeeeeeeeeeeeeeeeee}
    pack .bent .ment -fill x
}
