#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Vendor.h>
#include <stdio.h>
#include "QstatP.h"
#include "xppxpm.h"

#include "pixmap/mini-0.xpm"
#include "pixmap/mini-1.xpm"
#include "pixmap/mini-2.xpm"
#include "pixmap/mini-3.xpm"
#include "pixmap/mini-4.xpm"
#include "pixmap/mini-5.xpm"
#include "pixmap/mini-5x.xpm"
#include "pixmap/mini-5y.xpm"
#include "pixmap/mini-0a.xpm"
#include "pixmap/mini-1a.xpm"

#include "pixmap16/mini-0.xpm"
#include "pixmap16/mini-1.xpm"
#include "pixmap16/mini-2.xpm"
#include "pixmap16/mini-3.xpm"
#include "pixmap16/mini-4.xpm"
#include "pixmap16/mini-5.xpm"
#include "pixmap16/mini-5x.xpm"
#include "pixmap16/mini-5y.xpm"
#include "pixmap16/mini-0a.xpm"
#include "pixmap16/mini-1a.xpm"

#define sDisp      XtDisplay(qw)
#define sScreen    XtScreen(qw)
#define sRoot      XRootWindowOfScreen(XtScreen(qw))
#define sWidth     qw->core.width
#define sHeight    qw->core.height
#define sPixmap(i) qw->qstat.pixmap[i]
#define sAttr(i)   qw->qstat.attr[i]
#define sState     qw->qstat.state
#define sAuto      qw->qstat.astate
#define sBlink     qw->qstat.blink
#define sTimer     qw->qstat.timer

static char** pixmap_name[][10] =
{{
        mini_0_xpm,  mini_1_xpm,  mini_2_xpm,   mini_3_xpm,
        mini_4_xpm,  mini_5_xpm,  mini_5x_xpm,  mini_5y_xpm,
        mini_0a_xpm, mini_1a_xpm
},{
        mini16_0_xpm,  mini16_1_xpm,  mini16_2_xpm,   mini16_3_xpm,
        mini16_4_xpm,  mini16_5_xpm,  mini16_5x_xpm,  mini16_5y_xpm,
        mini16_0a_xpm, mini16_1a_xpm
}};

#define offset(field) XtOffsetOf(QstatRec, field)
static XtResource resources[] = {
  { XtNstate, XtCState, XtRInt, sizeof(int),
            offset(qstat.state), XtRImmediate, (XtPointer)0 },
  { XtNauto, XtCAuto, XtRInt, sizeof(int),
            offset(qstat.astate), XtRImmediate, (XtPointer)0 },
};
#undef offset

static void QstatBlink();
static void ShowQstat();
static void Initialize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void Destroy();
static XtGeometryResult QueryGeometry();

static char defaultTranslation[] = "";
static XtActionsRec actions[] = {{NULL, NULL}};

QstatClassRec qstatClassRec = {
  {
  /* superclass             */ (WidgetClass) &coreClassRec,
  /* class_name             */ "Qstat",
  /* widget_size            */ sizeof(QstatRec),
  /* class_initialize       */ NULL,
  /* class_part_initialize  */ NULL,
  /* class_inited           */ FALSE,
  /* initialize             */ Initialize,
  /* initialize_hook        */ NULL,
  /* realize                */ XtInheritRealize,
  /* actions                */ actions,
  /* num_actions            */ XtNumber(actions),
  /* resources              */ resources,
  /* num_resourece          */ XtNumber(resources),
  /* xrm_class              */ NULLQUARK,
  /* compress_motion        */ TRUE,
  /* compress_exposure      */ TRUE,
  /* compress_enterleave    */ TRUE,
  /* visible_interest       */ FALSE,
  /* destroy                */ Destroy,
  /* resize                 */ Resize,
  /* expose                 */ Redisplay,
  /* set_values             */ SetValues,
  /* set_values_hook        */ NULL,
  /* set_values_almoset     */ XtInheritSetValuesAlmost,
  /* get_values_hook        */ NULL,
  /* accept_focus           */ NULL,
  /* version                */ XtVersion,
  /* callback_private       */ NULL,
  /* tm_table               */ defaultTranslation,
  /* query_geometry         */ QueryGeometry,
  /* display_accelator      */ XtInheritDisplayAccelerator,
  /* extention              */ NULL
  },{
  /* foo                    */ 0
  }
};
WidgetClass qstatWidgetClass = (WidgetClass)&qstatClassRec;

static void
QstatBlink(QstatWidget qw)
{
        sTimer = False;
        ShowQstat(qw);
}

static void
ShowQstat(QstatWidget qw)
{
        int pn;

        if ((sState==0 || sState==1) && sAuto) {
                pn = sState + 8;
                XtVaSetValues((Widget)qw,
                              XtNbackgroundPixmap, sPixmap(pn), NULL);
        } else if (sState >= 0 && sState<= 6) {
                pn = sState;
                XtVaSetValues((Widget)qw,
                              XtNbackgroundPixmap, sPixmap(pn), NULL);
        } else if (sState > 6 && !sTimer) {
                if (sBlink) {
                        pn = 6;
                        sBlink = False;
                } else {
                        pn = 7;
                        sBlink = True;
                }
                XtVaSetValues((Widget)qw,
                              XtNbackgroundPixmap, sPixmap(pn), NULL);
                XtAppAddTimeOut(XtWidgetToApplicationContext((Widget)qw),
                                (sState - 1) * 50, 
                                (XtTimerCallbackProc) QstatBlink,
                                (Widget)qw);
                sTimer = True;
        }
}

static void
GetPixmap(QstatWidget qw)
{
        int i;
        Pixmap Mask;
        int rst;

        for(i=0; i<10; i++) {
                sAttr(i).valuemask = XpmReturnInfos 
                                   | XpmReturnAllocPixels
                                   | XpmReturnExtensions;
                rst = XpmCreatePixmapFromData(sDisp, sRoot, 
				pixmap_name[app_data.cmode][i],
                                &sPixmap(i), &Mask, &sAttr(i));
                if (rst != 0) XpmError(rst);
                if (Mask) XFreePixmap(sDisp, Mask);
        }
}

static void
Initialize(Widget wreq, Widget wnew)
{
        QstatWidget qw = (QstatWidget) wnew;
        Pixmap Mask;
        int i;
        int rst;

        GetPixmap(qw);
        if (sWidth == 0) {
                sWidth = sAttr(0).width;
        }
        if (sHeight == 0) {
                sHeight = sAttr(0).height;
        }

        sBlink = False;
        sTimer = False;
        ShowQstat(qw);
}

static void
Redisplay(Widget w, XExposeEvent *event)
{
        QstatWidget qw = (QstatWidget) w;

        return;
}

static Boolean
SetValues(Widget wcur, Widget wreq, Widget wnew)
{
        QstatWidget cur = (QstatWidget) wcur;
        QstatWidget qw  = (QstatWidget) wnew;
        Boolean redraw = False;

        if (cur->qstat.state != qw->qstat.state 
            || cur->qstat.astate != qw->qstat.astate ) {
                ShowQstat(qw);
        }

        return redraw;
}

static
void Destroy(Widget w)
{
        QstatWidget qw = (QstatWidget) w;
        Colormap cmap;
        int i;

        cmap=DefaultColormapOfScreen(sScreen);
        for(i=0; i<4; i++) {
                if (sPixmap(i))
                        XFreePixmap(sDisp, sPixmap(i));
                XFreeColors(sDisp, cmap,
                            sAttr(i).alloc_pixels,
                            sAttr(i).nalloc_pixels, 0);
                XpmFreeAttributes(&sAttr(i));
        }
}

static void
Resize(Widget w)
{
        QstatWidget qw = (QstatWidget) w;

        return;
}

static XtGeometryResult
QueryGeometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
        QstatWidget qw = (QstatWidget) w;

        answer->request_mode = CWWidth | CWHeight;
        answer->width  = sWidth;
        answer->height = sHeight;
        return XtGeometryAlmost;
}
