#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <stdio.h>
#include <signal.h>
#include <xcio.h>
#include "xppxp.h"
#include "config.h"

#if RETSIGTYPE==void
# undef	HasVoidSignalReturn
# define HasVoidSignalReturn
#endif

#ifdef HasVoidSignalReturn
#define SigRet void
#else
#define SigRet int
#endif /* HasVoidSignalReturn */

SigRet sigTerminate(int);
SigRet sigConnect(int);
SigRet sigDisconnect(int);

void
signal_init()
{
        signal(SIGTERM, sigTerminate);
        signal(SIGHUP,  sigTerminate);
        signal(SIGINT,  sigTerminate);
        signal(SIGQUIT, sigTerminate);
        signal(SIGUSR1, sigConnect);
        signal(SIGUSR2, sigDisconnect);
}

SigRet
sigTerminate(int sig)
{
        FreeAll();

        if (sig != SIGTERM)
                fprintf(stderr, "%s: signal %d was caught\n", NAME, sig);
        exit(0);
}

SigRet
sigConnect(int sig)
{
        PPxPCommandv(ppxpFd, XCMD_CONNECT, NULL);
#ifdef ONESHOT_SIGNAL
        signal(SIGUSR1, sigConnect);
#endif /* ONESHOT_SIGNAL */
#ifndef HasVoidSignalReturn
        return 0;
#endif /* HasVoidSignalReturn */
}

SigRet
sigDisconnect(int sig)
{
        PPxPCommandv(ppxpFd, XCMD_DISCONNECT, NULL);
#ifdef ONESHOT_SIGNAL
        signal(SIGUSR1, sigDisconnect);
#endif /* ONESHOT_SIGNAL */
#ifndef HasVoidSignalReturn
        return 0;
#endif /* HasVoidSignalReturn */
}
