#define NAME    "xppxpm"
#define VERSION "0.00.45"
#define DATE    "9809121300"

#ifndef XPPXPDIR
#define XPPXPDIR "/usr/local/etc/ppxp/label"
#endif

#ifndef XtNpolling
#define XtNpolling "polling"
#define XtCPolling "Polling"
#endif 

#ifndef XtNdebug
#define XtNdebug "debug"
#define XtCDebug "Debug"
#endif 

#ifndef XtNwmaker
#define XtNwmaker "wmaker"
#define XtCWMaker "WMaker"
#endif 

#ifndef XtNmenu
#define XtNmenu "menu"
#define XtCMenu "Menu"
#endif 

#ifndef XtNshape
#define XtNshape "shape"
#define XtCShape "Shape"
#endif 

#ifndef XtNvcolor
#define XtNvcolor "vcolor"
#define XtCVColor "VColor"
#endif 

#define LabelAutoON "Auto ON"
#define LabelAutoOFF "Auto OFF"
#define	BG_COLOR "#5C5C5C"
#define	FG_COLOR "#C2C2C2"
#define	OFF_COLOR "#858585"
#define	AUTO_COLOR "#E10000"
#define	TERM_COLOR "#EB9C00"

typedef struct st_AppData
{
        int     polling;
        String  label;
        String  directory;
        Boolean debug;
        Boolean wmaker;
        Boolean menu;
        Boolean shape;
	int     cmode;
	String  vcolor;
} AppData, *AppDataPtr;

enum {
    BS_Unchange = -9999,
    BS_False    =     0,
    BS_True     =     1,
};

/* main.c */
extern Widget top, base, panel, qstat, sindc, tdisp;
extern XtAppContext appc;
extern AppData app_data;
extern void FreeAll();
extern void ppxpAddAction();
extern void ppxpTry();
extern void ppxpRetry(Widget);

/* ppxplink.c */
extern int ppxpFd;
extern XtInputId InputId;
extern int ppxpInit(int *, char **);
extern int ppxpCheck(XtPointer, int*, XtInputId *);
extern int ppxpFinish();
extern char * ppxpGetEnv(char *);

/* panel_init.c */
extern void panel_init_m();

/* action.c */
extern void NewLabel(char *);
extern void showLeds(int, int, int, int, int, int);
extern void showMeters(int, int);
extern void showConnectTime(int);

/* signal.c */
extern void signal_init();
