/* $Cambridge: hermes/src/prayer/cmd/cmd_restart.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

static void
generate_error_page(struct session *session)
{
    struct request *request = session->request;
    struct template_vals *tvals = session->template_vals;
    struct buffer *b = request->write_buffer;

    session_seed_template(session, tvals);
    template_expand("restart", tvals, b);
    response_html(request, 200);
}

void cmd_restart(struct session *session)
{
    struct request *request = session->request;
    struct msgmap *zm = session->zm;
    MAILSTREAM *stream;
    struct assoc *h;
    char *s;

    if (request->method != POST) {
        if (session->inbox_stream)
            ml_close(session, session->inbox_stream);

        if (session->other_stream)
            ml_close(session, session->other_stream);

        if (session->draft_stream)
            ml_close(session, session->draft_stream);

        session->inbox_stream = NIL;
        session->other_stream = NIL;
        session->draft_stream = NIL;
        session->stream = NIL;

        session_message_clear(session);

        if (ml_have_error() && (s = ml_errmsg()) && s[0])
            session_message(session, "%s", s);
        else
            session_message(session, "Lost connection to IMAP server ");

        generate_error_page(session);
        return;
    }

    request_decode_form(request);
    h = request->form;

    if (assoc_lookup(h, "exit")) {
        session->draft_stream = NIL;
        session->other_stream = NIL;
        session->inbox_stream = NIL;
        session_redirect(session, request, "exit");
        return;
    }

    if (assoc_lookup(h, "reopen") && session->foldername) {
        if (!strcasecmp(session->foldername, "inbox")) {
            s = session_mailbox(session, request->pool, "inbox");
            /* Reopen inbox folder */
            if ((stream = ml_open(session, NIL, s, 0))) {
                session->inbox_last_ping_time = time(NIL);
                session->stream = session->inbox_stream = stream;
            }
        } else
            if (!strcasecmp
                (session->foldername, session->draft_foldername)) {
            /* Reopen draft folder */
            s = session_mailbox(session, request->pool,
                                session->draft_foldername);
            if ((stream = ml_open(session, NIL, s, 0))) {
                session->draft_last_ping_time = time(NIL);
                session->stream = session->draft_stream = stream;
            }
        } else {
            /* Reopen other folder */
            s = session_mailbox(session, request->pool,
                                session->foldername);
            if ((stream = ml_open(session, NIL, s, 0))) {
                session->other_last_ping_time = time(NIL);
                session->stream = session->other_stream = stream;
            }
        }

        if (!(stream = ml_open(session, NIL, s, 0))) {
            session_message(session, ("Unable to reestablish connection"
                                      " with IMAP server "));
            generate_error_page(session);
            return;
        }

        /* initialise the zoommap */
        msgmap_associate(zm, session, stream);
        msgmap_update(zm);

        /* Set current and last_displayed message to last or first in zoommap
         * (cmd_welcome may override with this last unread message) */
        if (zm->nmsgs > 0) {
            if (zm->sort_reverse)
                session->current = msgmap_value(zm, 1);
            else
                session->current = msgmap_value(zm, zm->nmsgs);
        } else
            session->current = 0;
        session->last_displayed = session->current;

        session_redirect(session, request, "list");
        return;
    }

    /* Shut down other_stream, draft_stream, attempt to reopen INBOX */
    string_free((void **) &session->other_foldername);
    session->other_stream = NIL;
    session->draft_stream = NIL;

    s = session_mailbox(session, request->pool, "inbox");
    if (!(stream = ml_open(session, NIL, s, 0))) {
        session_message(session, ("Unable to reestablish connection"
                                  " with IMAP server "));
        generate_error_page(session);
        return;
    }

    session->inbox_last_ping_time = time(NIL);
    session->stream = session->inbox_stream = stream;

    /* initialise the zoommap */
    msgmap_associate(zm, session, stream);
    msgmap_update(zm);

    /* Set current and last_displayed message to last or first in zoommap
     * (cmd_welcome may override with this last unread message) */
    if (zm->nmsgs > 0) {
        if (zm->sort_reverse)
            session->current = msgmap_value(zm, 1);
        else
            session->current = msgmap_value(zm, zm->nmsgs);
    } else
        session->current = 0;
    session->last_displayed = session->current;

    session_redirect(session, request, "folders");
}
