/* $Cambridge: hermes/src/prayer/session/dictionary.h,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#define DICTIONARY_POOL_SIZE (1024)

struct dictionary {
    struct pool *pool;          /* Allocation pool */
    struct list *list;          /* List of words */
    struct assoc *assoc;        /* Parrellel associative array for fast lookups */
};

struct dictionary *dictionary_create(void);
void dictionary_free(struct dictionary *d);

void
dictionary_parse_line(struct dictionary *dictionary, char *line,
                      struct session *session);

void
dictionary_print_options(struct dictionary *dictionary, struct buffer *b);

void dictionary_add(struct dictionary *d, char *word);
void dictionary_remove(struct dictionary *d, char *word);
BOOL dictionary_lookup(struct dictionary *d, char *word);
