/* $Cambridge: hermes/src/prayer/session/prefs.h,v 1.3 2008/09/16 09:59:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#define PREFS_POOL_SIZE (512)

struct prefs {
    struct pool *pool;          /* Allocation pool                */
    BOOL allow_raven_login;     /* Block Raven logins, if allowed */
    BOOL confirm_expunge;       /* Confirm expunge request        */
    BOOL confirm_logout;        /* Confirm logout                 */
    BOOL confirm_rm;            /* Confirm mailbox deletion       */
    unsigned long msgs_per_page;        /* Max Messages on list screen    */
    unsigned long abook_per_page;       /* Abook entries on list screen   */
    char *template_set;         /* Template set to use            */
    char *maildir;              /* Directory containing mail      */
    char *postponed_folder;     /* Name of postponed msg folder   */
    char *sent_mail_folder;     /* Name of sent mail folder       */
    BOOL suppress_dotfiles;     /* Suppress dotfiles in dir list  */
    char *from_personal;        /* Personal component of From     */
    char *from_address;         /* Address component of From      */
    char *default_reply_to;     /* Default Reply-To               */
    char *signature;            /* Signature                      */
    char *alt_addr;             /* Text version of alt_addr list  */
    char *ispell_language;      /* Current language for ispell    */
    BOOL  spell_skip_quoted;    /* Only if aspell in use          */
    unsigned long small_rows;   /* Rows in small compose window   */
    unsigned long small_cols;   /* Cols in small compose window   */
    unsigned long large_rows;   /* Rows in large compose window   */
    unsigned long large_cols;   /* Cols in large compose window   */
    char *default_domain;       /* Default domain for messages    */

    char *theme_main_name;      /* Name of main theme             */
    char *theme_help_name;      /* Name of help theme             */

    SORTMODE sort_mode;         /* Default sort mode                 */
    BOOL sort_reverse;          /* T => reverse search               */
    abook_sort_mode abook_sort_mode; /* Addressbook default sort mode  */
    BOOL abook_sort_reverse;    /* T => reverse search               */
    unsigned long line_wrap_len;        /* Length to wrap lines at   */
    BOOL line_wrap_advanced;    /* Enable advanced line wrap options */
    BOOL line_wrap_on_reply;    /* Wrap automatically on reply       */
    BOOL line_wrap_on_send;     /* Wrap automatically on send        */
    BOOL line_wrap_on_spell;    /* Wrap automatically on spell       */
    BOOL use_sent_mail;         /* Copy messages to sent-mail       */
    BOOL use_search_zoom;       /* Zoom after search operation      */
    BOOL use_agg_unmark;        /* Unmark after aggregate operation */

    BOOL use_icons;             /* Use icons in folder display      */
    BOOL use_welcome;           /* Use Welcome screen               */
    BOOL use_unread;            /* Start at first unread message    */
    BOOL use_tail_banner;       /* Put banner at the end of certain pages */
    BOOL use_mark_persist;      /* Use persistent mark                */
    BOOL use_cookie;            /* Use cookie for login session       */
    BOOL use_substitution;      /* Use substitution not HTTP redirect */
    BOOL use_http_1_1;          /* Use HTTP/1.1 if available          */
    BOOL use_pipelining;        /* Use HTTP/1.1 Pipelining            */
    BOOL use_persist;           /* Use HTTP links inside HTTPS        */
    BOOL use_short;             /* Use short URLS                     */
    BOOL use_gzip;              /* Use GZIP compression               */
    BOOL html_inline;           /* Display HTML inline when text/html */
    BOOL html_inline_auto;      /* Automatic inline when "<html>"     */
    BOOL html_remote_images;    /* Display remote images in html      */
    BOOL preserve_mimetype;     /* Preserve MIME type in download     */
    BOOL expunge_on_exit;       /* Expunge folders on exit            */
};

struct prefs *prefs_create(struct config *config);

void prefs_free(struct prefs *p);

struct prefs *prefs_copy(struct prefs *src);

void
prefs_parse_option(struct prefs *prefs, char *line,
                   struct session *session);

void prefs_parse_check(struct prefs *prefs);

void
prefs_print_options(struct prefs *prefs,
                    struct config *config, struct buffer *b);
