/* $Cambridge: hermes/src/prayer/session/sieve.h,v 1.3 2008/09/16 09:59:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2003 */
/* See the file NOTICE for conditions of use and distribution. */

#define SIEVE_BLOCKSIZE  (8192)
#define SIEVE_DEFAULT_PORT (2000)

struct sieve {
    struct pool *pool;          /* Allocation pool */
    struct iostream *stream;    /* Connection to sieve server */
    time_t last_ping;           /* Last access time for timeouts */

    /* Sieve status */
    BOOL checked;
    char *current;  /* Current script in user interface */
    char *live;     /* Current script on server. Match unless upload error */

    /* Server response */
    BOOL have_message;
    struct memblock *message;
};

struct sieve *sieve_create(struct pool *pool, struct session *session);

void sieve_free(struct sieve *sieve);

void
sieve_current_record(struct sieve *sieve, char *script);

char *
sieve_current(struct sieve *sieve);

void
sieve_live_record(struct sieve *sieve, char *script);

char *
sieve_live(struct sieve *sieve);

void sieve_close(struct sieve *sieve);

void sieve_timeout_close(struct sieve *sieve, struct session *session);

void sieve_close(struct sieve *sieve);

void sieve_message(struct sieve *sieve, char *fmt, ...);

char *sieve_fetch_message(struct sieve *sieve);

BOOL
sieve_fetch(struct sieve *sieve, struct session *session,
            char *script_name, char **scriptp);

BOOL
sieve_upload(struct sieve *sieve, struct session *session,
             char *script_name, char *script);

BOOL
sieve_activate(struct sieve *sieve, struct session *session,
               char *script_name);

BOOL
sieve_delete(struct sieve *sieve, struct session *session, char *script_name);
