/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.util.StringMatcher;

public class DynamicClassReferenceInitializer
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
AttributeVisitor {
    public static final int X = 0x40000000;
    public static final int Y = 0x40000001;
    public static final int Z = 0x40000002;
    public static final int A = 0x40000003;
    public static final int B = 0x40000004;
    public static final int C = 0x40000005;
    public static final int D = 0x40000006;
    private final Constant[] CLASS_FOR_NAME_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("forName"), new Utf8Constant("(Ljava/lang/String;)Ljava/lang/Class;"), new MethodrefConstant(1, 7, null, null), new NameAndTypeConstant(8, 9), new Utf8Constant("newInstance"), new Utf8Constant("()Ljava/lang/Object;"), new MethodrefConstant(1, 11, null, null), new NameAndTypeConstant(12, 13), new Utf8Constant("getComponentType"), new Utf8Constant("()Ljava/lang/Class;")};
    private final Instruction[] CONSTANT_CLASS_FOR_NAME_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(-72, 0)};
    private final Instruction[] CLASS_FOR_NAME_CAST_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(-72, 0), new ConstantInstruction(-74, 6), new ConstantInstruction(-64, 0x40000000)};
    private final Constant[] DOT_CLASS_JAVAC_CONSTANTS = new Constant[]{new MethodrefConstant(0x40000003, 1, null, null), new NameAndTypeConstant(0x40000004, 2), new Utf8Constant("(Ljava/lang/String;)Ljava/lang/Class;")};
    private final Instruction[] DOT_CLASS_JAVAC_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(-72, 0)};
    private final Constant[] DOT_CLASS_JIKES_CONSTANTS = new Constant[]{new MethodrefConstant(0x40000003, 1, null, null), new NameAndTypeConstant(0x40000004, 2), new Utf8Constant("(Ljava/lang/String;Z)Ljava/lang/Class;")};
    private final Instruction[] DOT_CLASS_JIKES_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new SimpleInstruction(3), new ConstantInstruction(-72, 0)};
    private final Instruction[] DOT_CLASS_JAVAC_IMPLEMENTATION_INSTRUCTIONS = new Instruction[]{new VariableInstruction(42), new ConstantInstruction(-72, 0), new SimpleInstruction(-80)};
    private final Instruction[] DOT_CLASS_JIKES_IMPLEMENTATION_INSTRUCTIONS = new Instruction[]{new VariableInstruction(42), new ConstantInstruction(-72, 0), new VariableInstruction(43), new BranchInstruction(-102, 6), new ConstantInstruction(-74, 10), new SimpleInstruction(-80)};
    private final Instruction[] DOT_CLASS_JIKES_IMPLEMENTATION_INSTRUCTIONS2 = new Instruction[]{new VariableInstruction(42), new ConstantInstruction(-72, 0), new ConstantInstruction(-74, 10), new SimpleInstruction(-80)};
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter missingNotePrinter;
    private final WarningPrinter dependencyWarningPrinter;
    private final WarningPrinter notePrinter;
    private final StringMatcher noteExceptionMatcher;
    private final InstructionSequenceMatcher constantClassForNameMatcher = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.CONSTANT_CLASS_FOR_NAME_INSTRUCTIONS);
    private final InstructionSequenceMatcher classForNameCastMatcher = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.CLASS_FOR_NAME_CAST_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJavacMatcher = new InstructionSequenceMatcher(this.DOT_CLASS_JAVAC_CONSTANTS, this.DOT_CLASS_JAVAC_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJikesMatcher = new InstructionSequenceMatcher(this.DOT_CLASS_JIKES_CONSTANTS, this.DOT_CLASS_JIKES_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJavacImplementationMatcher = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.DOT_CLASS_JAVAC_IMPLEMENTATION_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJikesImplementationMatcher = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.DOT_CLASS_JIKES_IMPLEMENTATION_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJikesImplementationMatcher2 = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.DOT_CLASS_JIKES_IMPLEMENTATION_INSTRUCTIONS2);
    private boolean isClassForNameInvocation;

    public DynamicClassReferenceInitializer(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter, WarningPrinter warningPrinter2, WarningPrinter warningPrinter3, StringMatcher stringMatcher) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.missingNotePrinter = warningPrinter;
        this.dependencyWarningPrinter = warningPrinter2;
        this.notePrinter = warningPrinter3;
        this.noteExceptionMatcher = stringMatcher;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        instruction.accept(clazz, method, codeAttribute, n, this.constantClassForNameMatcher);
        if (this.constantClassForNameMatcher.isMatching()) {
            clazz.constantPoolEntryAccept(this.constantClassForNameMatcher.matchedConstantIndex(0x40000000), this);
            this.classForNameCastMatcher.reset();
        }
        instruction.accept(clazz, method, codeAttribute, n, this.classForNameCastMatcher);
        if (this.classForNameCastMatcher.isMatching()) {
            clazz.constantPoolEntryAccept(this.classForNameCastMatcher.matchedConstantIndex(0x40000000), this);
        }
        instruction.accept(clazz, method, codeAttribute, n, this.dotClassJavacMatcher);
        if (this.dotClassJavacMatcher.isMatching() && this.isDotClassMethodref(clazz, this.dotClassJavacMatcher.matchedConstantIndex(0))) {
            clazz.constantPoolEntryAccept(this.dotClassJavacMatcher.matchedConstantIndex(0x40000000), this);
        }
        instruction.accept(clazz, method, codeAttribute, n, this.dotClassJikesMatcher);
        if (this.dotClassJikesMatcher.isMatching() && this.isDotClassMethodref(clazz, this.dotClassJikesMatcher.matchedConstantIndex(0))) {
            clazz.constantPoolEntryAccept(this.dotClassJikesMatcher.matchedConstantIndex(0x40000000), this);
        }
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        String string = stringConstant.getString(clazz);
        String string2 = ClassUtil.internalClassName(string);
        stringConstant.referencedClass = this.findClass(clazz.getName(), string2);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (this.noteExceptionMatcher == null || !this.noteExceptionMatcher.matches(classConstant.getName(clazz))) {
            this.notePrinter.print(clazz.getName(), classConstant.getName(clazz), "Note: " + ClassUtil.externalClassName(clazz.getName()) + " calls '(" + ClassUtil.externalClassName(classConstant.getName(clazz)) + ")Class.forName(variable).newInstance()'");
        }
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        String string = methodrefConstant.getType(clazz);
        if (string.equals("(Ljava/lang/String;)Ljava/lang/Class;") || string.equals("(Ljava/lang/String;Z)Ljava/lang/Class;")) {
            String string2 = methodrefConstant.getName(clazz);
            boolean bl = this.isClassForNameInvocation = string2.equals("class$") || string2.equals("class");
            if (this.isClassForNameInvocation) {
                return;
            }
            String string3 = methodrefConstant.getClassName(clazz);
            Clazz clazz2 = this.programClassPool.getClass(string3);
            if (clazz2 != null) {
                clazz2.methodAccept(string2, string, new AllAttributeVisitor(this));
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.isClassForNameInvocation = this.isDotClassMethodCode(clazz, method, codeAttribute, this.dotClassJavacImplementationMatcher, 5) || this.isDotClassMethodCode(clazz, method, codeAttribute, this.dotClassJikesImplementationMatcher, 12) || this.isDotClassMethodCode(clazz, method, codeAttribute, this.dotClassJikesImplementationMatcher2, 8);
    }

    private boolean isDotClassMethodref(Clazz clazz, int n) {
        this.isClassForNameInvocation = false;
        clazz.constantPoolEntryAccept(n, this);
        return this.isClassForNameInvocation;
    }

    private boolean isDotClassMethodCode(Clazz clazz, Method method, CodeAttribute codeAttribute, InstructionSequenceMatcher instructionSequenceMatcher, int n) {
        if (codeAttribute.u4codeLength < n) {
            return false;
        }
        instructionSequenceMatcher.reset();
        codeAttribute.instructionsAccept(clazz, method, 0, n, instructionSequenceMatcher);
        return instructionSequenceMatcher.isMatching();
    }

    private Clazz findClass(String string, String string2) {
        if (ClassUtil.isInternalArrayType(string2) && !ClassUtil.isInternalClassType(string2)) {
            return null;
        }
        Clazz clazz = this.programClassPool.getClass(string2);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(string2);
            if (clazz == null && this.missingNotePrinter != null) {
                this.missingNotePrinter.print(string, string2, "Note: " + ClassUtil.externalClassName(string) + ": can't find dynamically referenced class " + ClassUtil.externalClassName(string2));
            }
        } else if (this.dependencyWarningPrinter != null) {
            this.dependencyWarningPrinter.print(string, string2, "Warning: library class " + ClassUtil.externalClassName(string) + " depends dynamically on program class " + ClassUtil.externalClassName(string2));
        }
        return clazz;
    }
}

