# $Id: Help.pm,v 1.3 2001/03/31 09:48:39 muhri Exp $
# -*- perl -*-
package Pronto::Help;
use strict;
use SelfLoader;
1;
__DATA__

sub help_win {
	
	if ($main::HTMLWIDGET eq "text") {
		&main::err_dialog(_("You must be using an HTML widget to access Pronto's help"));
		return 1;
	}
	my ($widget, $node, $x, $y, $filemenu, $bar) = @_;
  	my ($help_window, $window, $bg, $toolbar, $tb_back, $tb_prev, $vbox, $html_view, $body, $root_menu, $rm_file, $file_menu, $fm_top, $fm_prev, $fm_close);
  	$help_window=new Gtk::Window("toplevel");
  	$help_window->set_title(_("Help Viewer"));
  	$help_window->signal_connect("destroy" => sub { $help_window->destroy; });
  	$help_window->signal_connect("delete_event" => \&Gtk::false);
  	if (defined $x and defined $y) { $help_window->set_default_size($x,$y) 
        } else {	
        $help_window->set_default_size('685','400'); }
  	$help_window->set_policy(1,1,0);
  	$help_window->show;
	$window = $help_window->window;
	$bg = $help_window->style->bg('normal');
 	$vbox= new Gtk::VBox('0','0');
  	$vbox->show;
  	$help_window->add($vbox);
  	$root_menu = new Gtk::MenuBar;
  	$rm_file=new Gtk::MenuItem(_("File"));
  	$rm_file->show;
	if (not defined $filemenu) { $root_menu->show; }
  	$root_menu->append($rm_file);
  	$file_menu = new Gtk::Menu;
	$rm_file->set_submenu($file_menu);
  	$fm_top = new Gtk::MenuItem(_("Top"));
  	$fm_top->show;
  	$file_menu->append($fm_top);
  	$fm_prev = new Gtk::MenuItem(_("Previous Node"));
  	$fm_prev->show;
  	$file_menu->append($fm_prev);
  	$fm_close = new Gtk::MenuItem(_("Close"));
  	$fm_close->signal_connect("activate" => sub { $help_window->destroy; });
  	$fm_close->show;
  	$file_menu->append($fm_close);
	$file_menu->show;
	$vbox->pack_start($root_menu,0,0,0);
	$toolbar= new Gtk::Toolbar('horizontal', 'both');
	$toolbar->set_button_relief('none');
	$toolbar->set_tooltips($main::prefs{'ToolTips'});
	$toolbar->border_width('2');
	$vbox->pack_start($toolbar,0,0,0);
	if (not defined $bar) {$toolbar->show;}
	$tb_back = $toolbar->append_item(_("Back"),_("Click here to go back a node"), "",&main::new_pixmap("$main::prefs{'PixmapDir'}/back.xpm", $window, $bg));
	$tb_prev = $toolbar->append_item(_("Top"),_("Click here to jump to the top node"), "",&main::new_pixmap("$main::prefs{'PixmapDir'}/top.xpm", $window, $bg));

  	if ($main::HTMLWIDGET eq "GtkHTML" || $main::HTMLWIDGET eq "CscHTML") {
		if ($main::HTMLWIDGET eq "GtkHTML") {
			$html_view = new Gtk::HTML;
		} elsif ($main::HTMLWIDGET eq "CscHTML") {
			$html_view = new Csc::HTML;
		}
    		$html_view->signal_connect('url_requested' => \&load_help_url);
   		$html_view->signal_connect('link_clicked' => \&help_link_clicked);
		$html_view->signal_connect('title_changed' => sub {$help_window->set_title($html_view->get_title())});
   		$html_view->set_editable(0);
   		$html_view->enable_debug(0);
   		my $sw = new Gtk::ScrolledWindow(undef, undef);
   		$sw->set_policy('automatic', 'automatic');
   		$sw->show;
   		$sw->add($html_view);
   		$vbox->pack_start($sw,1,1,0);
   		$html_view->realize;
   		$html_view->show;
         	} else {
  	 	$html_view = new Gtk::XmHTML;
   		$html_view->set_anchor_buttons(0);
   		$html_view->set_allow_body_colors(1);
   		$html_view->set_hilight_on_enter(0);
   		$html_view->set_allow_font_switching(1);
   		$html_view->set_allow_images(1);
   		$html_view->set_strict_checking(1);
   		$html_view->set_anchor_target_underline_type (1);
   		$html_view->set_anchor_underline_type (1);
   		$html_view->set_anchor_visited_underline_type(1);
		$html_view->signal_connect('activate' => \&help_link_clicked);
   		$html_view->show;
   		$vbox->pack_start($html_view,1,1,0);
  	}
	$tb_back->signal_connect("clicked" => \&view_url, $html_view, $node, 2);
	$tb_prev->signal_connect("clicked" => \&view_url, $html_view, $node, 1);
  	$fm_top->signal_connect("activate" => \&view_url, $html_view, $node, 1);
	$fm_prev->signal_connect("activate" => \&view_url, $html_view, $node, 2);
	&view_url(undef, $html_view, $node, 1);

return 1;
}

sub view_url {
	my ($widget, $html_view, $node, $flag) = @_;
	my ($tmp);
	if ($flag == 1) {
		undef @{$html_view->{'history'}};
	} elsif ($flag == 2) {
		if (defined @{$html_view->{'history'}}) {
			$tmp = pop @{$html_view->{'history'}};
			if ($tmp) { $node = $tmp; }
		} else {
			return 1;
		}
	} else {
		if (defined $html_view->{'current'}) {
			push @{$html_view->{'history'}}, $html_view->{'current'};
		}
	}
	$html_view->{'current'} = $node;
	my $tmpfile = "$main::prefs{'DocDir'}/$node";
	if (open(FILE,"<$tmpfile")) {
	 	undef $/;
	 	my $body = <FILE>;
	 	close(FILE);
	 	$/ = "\n";
		$body =~ s/<--!version-->/$main::version/g;  # find version tag
		$body =~ s/<img src=\"(.+)\">/<img src=\"$main::prefs{'DocDir'}\/$1\">/g;
		if ($main::HTMLWIDGET eq "GtkHTML" || $main::HTMLWIDGET eq "CscHTML") {
			my $file = "$main::prefs{'MailDir'}/help.html";
			open(TEMP,">$file");
			print TEMP $body;
			close(TEMP);
	 	&load_help_url($html_view, $file, $html_view->begin); 
		} else {
	 		$html_view->source($body);
		}
	}
	return 1;
}

sub help_link_clicked {
	my (@fields, $address, $url, $widget, $info);

	if ($main::HTMLWIDGET eq "GtkHTML" || $main::HTMLWIDGET eq "CscHTML") {
		($widget, $url) = @_;
	} else {
		($widget, $info) = @_;
		$url = $info->{'href'};
	}
	if ($url =~ /^mailto:(.+)/) {
		$address = $1;
		$fields[0] = $address;    
		$fields[1] = "";
		$fields[2] = "";
		&Pronto::Compose::init_msg_window(0, undef, \@fields);
	} elsif ($url =~ /^sub:(.+)/) {  # its a special sub url.. lets run the sub...
		no strict 'refs';
		my $sub = $1;
		&{$sub};
	} else {
		&view_url(undef, $widget, $url, 3);
	}
	return 1;
}

sub load_help_url {  
	my ($html, $url, $handle) = @_;
	my ($d);
	my $io = new IO::File($url);
	$io->read($d, 1000000);
	$html->write($handle, $d);
	$io->close;
	$html->end($handle, 'ok');
}


