# $Id: TableEdit.pm,v 1.2 2001/02/03 16:22:54 muhri Exp $
# -*- perl -*-
package Pronto::TableEdit;
use strict;
use SelfLoader;
1;
__DATA__
sub mime_editwin {
	my ($widget, $clist, $action, $row) = @_;
	my ($mw_dlg, $mime, $command, $icon, $mimeid, $lbl1,
	$lbl2, $lbl3, $hbox1, $hbox2, $hbox3, $button, $mw_ok, $mw_cancel, @row,
	@selection,$sql,$query);

  	if ($action eq "edit") {
   		if (not defined $row) {
    			if (@selection = $clist->selection()) {
     			$row = $selection[0];
    			} else {
        		&main::err_dialog(_("Select an entry to edit!"));
        		return 1;
    			}
   		}
   	$mimeid = ${$clist->get_row_data($row)};
  	}
  
  	if ($mimeid) {
   		$sql = "select mime,command,icon from mimetypes where id=?";
   		$query = $main::conn->prepare($sql);
   		$query->execute($mimeid);
   		($mime, $command, $icon) = $query->fetchrow_array();
  	} else {
   		($mime, $command, $icon) = ("","","");
  	}
  
  	$mw_dlg = new Gtk::Dialog;
  	$mw_dlg->position(-mouse);
  	$mw_dlg->{'action'} = $action;
  	$mw_dlg->{'id'} = $mimeid;
  	$mw_dlg->signal_connect("destroy" => sub { $mw_dlg->destroy; });
  	$mw_dlg->signal_connect("delete_event" => \&Gtk::false);
  	$mw_dlg->set_title(_("Mimetype Editor"));
  	$mw_dlg->border_width(0);
  	$lbl1 = new Gtk::Label (_("Mime: "));
  	$lbl1->set_alignment(0.5,0.5);
  	$lbl1->set_usize(55,10);
  	$lbl1->show;
  	$mw_dlg->{'mime'} = new Gtk::Entry;
  	$mw_dlg->{'mime'}->set_text($mime);
  	$mw_dlg->{'mime'}->set_editable('1');
  	$mw_dlg->{'mime'}->show;
  	$hbox1=new Gtk::HBox(0,0);
  	$hbox1->border_width('3');
  	$hbox1->pack_start($lbl1,0,1,0);
  	$hbox1->pack_start($mw_dlg->{'mime'},1,1,0);
  	$lbl2 = new Gtk::Label (_("Command: "));
  	$lbl2->set_usize(55,10);
  	$lbl2->set_alignment(0.5,0.5);
  	$lbl2->show;
  	$mw_dlg->{'command'} = new Gtk::Entry;
  	$mw_dlg->{'command'}->set_text($command);
  	$mw_dlg->{'command'}->set_editable('1');
  	$mw_dlg->{'command'}->show;
  	$hbox2=new Gtk::HBox(0,0);
	$hbox2->border_width('3');
  	$hbox2->pack_start($lbl2,0,1,0);
  	$hbox2->pack_start($mw_dlg->{'command'},1,1,0);
  	$button=new Gtk::Button(_("Browse"));
  	$button->signal_connect("clicked" => \&Pronto::ViewAttachment::init_browse_dlg, $mw_dlg->{'command'}, "attachment_command");
  	$hbox2->pack_start($button,0,0,5);
  	$button->show;
  	$lbl3 = new Gtk::Label (_("Icon: "));
  	$lbl3->set_usize(55,10);
  	$lbl3->set_alignment(0.5,0.5);
  	$lbl3->show;
  	$mw_dlg->{'icon'} = new Gtk::Entry;
  	$mw_dlg->{'icon'}->set_text($icon);
  	$mw_dlg->{'icon'}->set_editable('1');
  	$mw_dlg->{'icon'}->show;
  	$hbox3=new Gtk::HBox(0,0);
  	$hbox3->border_width('3');
  	$hbox3->pack_start($lbl3,0,1,0);
  	$hbox3->pack_start($mw_dlg->{'icon'},1,1,0);
  	$button=new Gtk::Button(_("Browse"));
  	$button->signal_connect("clicked" => \&Pronto::ViewAttachment::init_browse_dlg, $mw_dlg->{'icon'}, "attachment_icon");
  	$hbox3->pack_start($button,0,0,5);
  	$button->show;
  	$hbox1->show;
  	$hbox2->show;
  	$hbox3->show;
  	$mw_dlg->vbox->pack_start($hbox1,1,1,0);
  	$mw_dlg->vbox->pack_start($hbox2,1,1,0);
  	$mw_dlg->vbox->pack_start($hbox3,1,1,0);
  	$mw_ok=new Gtk::Button _("Ok");
  	$mw_ok->signal_connect("clicked" => \&update_mime, $mw_dlg, $clist);
  	$mw_ok->can_default(1);
  	$mw_ok->show;
  	$mw_dlg->action_area->pack_start($mw_ok,1,1,0);
  	$mw_cancel=new Gtk::Button _("Cancel");
  	$mw_cancel->signal_connect("clicked", sub { $mw_dlg->destroy; });
  	$mw_dlg->action_area->pack_start($mw_cancel,1,1,0);
  	$mw_ok->grab_default;
  	$mw_cancel->show;
  	$mw_dlg->show;

	return 1;

}

sub update_mime {
 	
	my ($widget, $dlg, $clist) = @_;
 	my ($mime, $command, $icon, $id, $sql, $query, $action, @tmp);
 	$mime=$dlg->{'mime'}->get_text();
 	if (!$mime) {
     		&main::err_dialog(_("No mime specified!"));
     		return 1;
 	}
 	$command = $dlg->{'command'}->get_text();
 	if (!$command) {
     		&main::err_dialog(_("no command given for mime!"));
     		return 1;
 	}
 	$action = $dlg->{'action'};
 	$icon = $dlg->{'icon'}->get_text();
 	$id = $dlg->{'id'};
 	if ($action eq "new") {
  		$sql = "select mime from mimetypes where mime = ?";
  		$query = $main::conn->prepare($sql);
  		$query->execute($mime);
  	if (@tmp = $query->fetchrow_array()) {
   		&main::err_dialog(_("Mime exists!!"));
   		return 1;
  	} 
  	$sql = "insert into mimetypes (id, mime, command, icon)
          	values (?,?,?,?)";
  	$query = $main::conn->prepare($sql);
  	$query->execute(&main::newid('mimetypes', $main::conn), $mime, $command, $icon);
 	} elsif ($action eq "edit") {
  		$sql = "update mimetypes set mime=?, command=?, icon=?
          	where id=?";
  		$query = $main::conn->prepare($sql);
  		$query->execute($mime, $command, $icon, $id);
 	}
 	&clist_refresh($clist);
 	$dlg->destroy;
 	return 1;
}


sub edit_account {
 
 	my ($widget, $acct_clist, $row) = @_;
 	my (@selection, $acctid, $sql, $query, @entry, @cbox, $count, $i, @sig);
 	if (not defined $row) {
  		if (@selection = $acct_clist->selection) {
   			$row = $selection[0];
  		} else { 
      			return 1; 
  		}
 	}
 	$acctid = ${$acct_clist->get_row_data($row)};
 	$sql = "select descr, friendly, smtp, pop, pport, reply, uname, pass, type
        	 from accounts where id=?";
 	$query=$main::conn->prepare($sql);
 	$query->execute($acctid);
 	@entry=$query->fetchrow_array();
 	$sql = "select include, dm, def, dupecheck
        	 from accounts where id=?";
 	$query=$main::conn->prepare($sql);
 	$query->execute($acctid);
 	@cbox=$query->fetchrow_array();
 	for ($i = 0; $i < 4; $i++) {
  		if (!$cbox[$i] || $cbox[$i] eq "n") { $cbox[$i] = 0;}
  		if ($cbox[$i] eq "y") { $cbox[$i] = 1; }
 	}
 	if (open(TMP, "<$main::prefs{'MailDir'}/sig/$acctid.sig")) {
  		@sig = <TMP>;
  		close(TMP);
 	}
 	&acct_editwin(0,"edit", $acctid, $acct_clist, \@entry, \@cbox, \@sig);
 	return 1;
}

sub acct_editwin {
 	
	my ($aw_cancel, $aw_ok, $action, $mainid, @entry, @cbut, $aw_dlg, $i, @hbox,
      	$name, @en_val, @cb_val, @sig, $acct_clist, @label, $aw_sig, $sig_scroll,
      	$sig_hbox, $sig_label, @ent_labels, $c_type, $c_hbox, $c_label, $account_type, @ent_label);
  	$action = $_[1];
  	$mainid = $_[2];
  	$acct_clist = $_[3];
  	if ($_[4]) { @en_val = @{$_[4]}; } else { @en_val = ("", "","","","","","","",""); }
  	if ($_[5]) { @cb_val = @{$_[5]}; } else {  @cb_val = (1, 1, 0, 0); }
  	if (!$en_val[4]) { $en_val[4] = 110; }
  	if ($_[6]) { @sig = @{$_[6]}; }
  	my @acttypes = ("Pop3", "APop", "mbox", "Maildir");
  	if (defined $en_val[8] && $en_val[8] ne "") { 
		$account_type = $en_val[8];
	} else { 
		$account_type = "Pop3"; 
	}
  	if ($account_type eq "mbox" || $account_type eq "Maildir") { $en_val[8] = $en_val[3]; $en_val[3] = ""; } else { $en_val[8] = ""; }
  	@ent_labels = (_("Account Desc: "), _("Friendly Name: "), _("SMTP Server: "), _("POP3 Server: "), _("Port: "),
	     	       _("Reply Address: "), _("Username: "), _("Password: "), _("Local Spool File: "));
	
	# set the name of the text-label for spoolfile to maildir...
	if ($account_type eq "Maildir"){
		$ent_labels[8]=_("Local Maildir-Path: ");
	}
  	my @buttons = (_(" Include in Full Mail check?"),
        	       _(  " Delete messages from server?"),
			_( " Default account to send messages from?"),
		 	_("Don't download dupes\n(if delete is checked they will get removed!)?"));
  
  	$aw_dlg = new Gtk::Dialog;
  	$aw_dlg->signal_connect("destroy" => sub { $aw_dlg->destroy; });
  	$aw_dlg->signal_connect("delete_event" => \&Gtk::false);
  	$aw_dlg->set_title(_("Account Editor"));
  	$aw_dlg->position(-mouse);
  	$aw_dlg->border_width(0);
  	$i = 0;

  	$c_hbox = new Gtk::HBox(0,0);
  	$c_hbox->border_width(5);
  	$c_label = new Gtk::Label(_("Account Type:"));
  	$c_label->set_usize(100,10);
  	$c_label->set_alignment(0.5,0.5);
  	$c_type = new Gtk::Combo;
  	$c_type->set_case_sensitive('0');
  	$c_type->set_use_arrows('1');
  	$c_type->set_popdown_strings(@acttypes);
  	$c_type->entry->set_text($account_type);
 	$c_type->show;
  	$c_hbox->pack_start($c_label,0,1,0);
 	$c_hbox->pack_start($c_type,1,1,0);
  	$c_hbox->show;
  	$c_label->show;
  	$aw_dlg->vbox->pack_start($c_hbox,1,1,0);

  	foreach $name (@ent_labels) {
   		$hbox[$i]=new Gtk::HBox(0,0);
   		$hbox[$i]->border_width(5);
   		$aw_dlg->vbox->pack_start($hbox[$i],1,1,0);
   		$hbox[$i]->show;
   		$ent_label[$i]=new Gtk::Label "$name ";
   		$ent_label[$i]->set_alignment(0.5,0.5);
   		$ent_label[$i]->set_usize(100,10);
   		$hbox[$i]->pack_start($ent_label[$i],0,1,0);
   		$ent_label[$i]->show;
   		$entry[$i]=new Gtk::Entry;
   		$entry[$i]->set_text($en_val[$i]);
   		$entry[$i]->set_editable('1');
   		$hbox[$i]->pack_start($entry[$i],1,1,0);
   		$entry[$i]->show;
   		$i++;
  	}
  	$entry[7]->set_visibility('0');

  	if ($account_type eq "Pop3" or $account_type eq "APop") { 
  		$hbox[8]->hide;
  	} else {
        	$hbox[3]->hide;
        	$hbox[4]->hide;
        	$hbox[6]->hide;
       		$hbox[7]->hide;
  	}
  	$i = 0;
  	
	foreach $name (@buttons) {
   		my $hbox;
   		$cbut[$i] = new_with_label Gtk::CheckButton("$name");
  		$cbut[$i]->show;
   		$cbut[$i]->set_active($cb_val[$i]);
   		$hbox=new Gtk::HBox(0,0);
   		$hbox->border_width(3);
   		$hbox->pack_start($cbut[$i],1,1,0);
   		$hbox->show;
   		$aw_dlg->vbox->pack_start($hbox,1,1,0);
   		$i++;
  	}
  	$sig_label = new Gtk::Label (_("Signature:"));
  	$sig_label->show;
  	$aw_sig=new Gtk::Text(undef,undef);
  	$aw_sig->set_word_wrap(1);
  	$aw_sig->set_editable('1');
  	$sig_scroll = new Gtk::VScrollbar($aw_sig->vadj);
  	$sig_scroll->show;
  	if (@sig) { 
   		foreach (@sig) {
    			$aw_sig->insert('','','',"$_");
   		}
  	}
  	$aw_sig->show;
  	$sig_hbox= new Gtk::HBox(0,0);
  	$sig_hbox->border_width('3');
  	$sig_hbox->pack_start($aw_sig,1,1,0);
  	$sig_hbox->pack_start($sig_scroll,0,0,0);
  	$sig_hbox->show;
  	$aw_dlg->vbox->pack_start($sig_label,0,0,0);
  	$aw_dlg->vbox->pack_start($sig_hbox,1,1,0);
  	$aw_ok=new Gtk::Button _("Ok");
  	$aw_ok->signal_connect("clicked" => \&update_accounts, $action,
        $mainid, $aw_dlg, $acct_clist, \@entry, \@cbut, $aw_sig, $c_type);
  	$aw_ok->can_default(1);
  	$aw_ok->show;
  	$aw_dlg->action_area->pack_start($aw_ok,1,1,0);

  	$c_type->popwin->signal_connect("hide", \&accttype_change,
    		$c_type, \@hbox, \@ent_label);

  	$aw_cancel=new Gtk::Button _("Cancel");
  	$aw_cancel->signal_connect("clicked", sub { $aw_dlg->destroy; });
  	$aw_dlg->action_area->pack_start($aw_cancel,1,1,0);
  	$aw_ok->grab_default;
  	$aw_cancel->show;
  	$aw_dlg->show;
  	return 1;
}

sub accttype_change {
	my ($widget, $c_type, $ref, $reflabels) = @_;
	my @hbox = @{$ref};
	my @labels = @{$reflabels};
	if ($c_type->entry->get_text() eq "Pop3" or $c_type->entry->get_text() eq "APop") { 
		$hbox[8]->hide;
		$hbox[3]->show;
		$hbox[4]->show;
		$hbox[6]->show;
		$hbox[7]->show;
	} else {
		$hbox[8]->show;
		$hbox[3]->hide;
		$hbox[4]->hide;
		$hbox[6]->hide;
		$hbox[7]->hide;
	}
	if ($c_type->entry->get_text() eq "Maildir"){
		$labels[8]->set_text(_("Local Maildir-Path: "));
	} elsif ($c_type->entry->get_text() eq "mbox"){
		$labels[8]->set_text(_("Local Spool File: "));
	}
}

sub update_filters {
	my ($widget, $action, $fw_dlg, $filter_clist, $e_name, $c_type, $c_boxid, $e_regex, $e_addr, $c_acct, $fltid, $c_score,$cb_regex,$cb_count,$count,$apply) = @_;
	my ($sorder, $type, $boxid, $regex, $addr, $name, $sql, $query, $i, $score);
	$name=$e_name->get_text();
	if (!$name) {
		&main::err_dialog(_("Choose a filter name!"));
		return 1;
	}
	$type = $c_type->entry->get_text();
	if (!$type) { 
		&main::err_dialog(_("Select a filter type!"));
		return 1; 
	}
	if($cb_count->active) {
		if(not defined $count or $count<0) {
			$count = 0;
		}
	}
	else {
		$count = -1;
	}
	if ($type ne _("Scoring")) {
		$boxid = $c_boxid->entry->get_text();
	} else {
		$boxid = $c_score->entry->get_text();
	}
	if (!$boxid) { 
		&main::err_dialog(_("Specify a destination folder!"));
		return 1; 
	}
	if ($type eq _("Account Based")) {
		$regex = $c_acct->entry->get_text();
		$sql = "select id from accounts where descr=?";
		$query = $main::conn->prepare($sql);
		$query->execute($regex);
		($regex) = $query->fetchrow_array();
	} else {
		$regex = $e_regex->get_text();
	}
	if ($type ne _("Scoring")) {
		$boxid = $main::foldernametoid{$boxid};
		if (defined $boxid && $boxid == 2) {
			$addr = $e_addr->get_text();
		} else {
			$addr = "";
		}
	}
	$i = 0;
	foreach (@main::flttypes) {
		if ($type eq $_) {
			$type = $i;
		}
		$i++;
	}
	if ($action eq "new" or $action eq  "newfromlist") {
		$sql = "select sorder from filters order by sorder desc";
		$query = $main::conn->prepare($sql);
		$query->execute();
		$sorder = ($query->fetchrow_array());
		$sorder++;
		$sql = "insert into filters (id, type, boxid, regex, addr, name, sorder, trueregex, count) values (?,?,?,?,?,?,?,?,?)";
		$query = $main::conn->prepare($sql);
		my $fltid = &main::newid('filters', $main::conn);
		$query->execute($fltid, $type, $boxid, $regex, $addr, $name, $sorder,$cb_regex->active,$count);
	} elsif ($action eq "edit") {
		$sql = "update filters set type=?, boxid=?, regex=?, addr=?, name=?, trueregex=?, count=? where id=?";
		$query = $main::conn->prepare($sql);
		$query->execute($type, $boxid, $regex, $addr, $name,$cb_regex->active, $count, $fltid);
	}
	if ($action ne "newfromlist") {
	&clist_refresh($filter_clist);
	}
	$fw_dlg->destroy;
	if ($apply->active) { &Pronto::Data::Message::refilter }
	return 1;
}

sub update_accounts {
 	my ($widget, $action, $mainid, $aw_win, $acct_clist, $entref, $cbref,$aw_sig, $c_type) = @_;
 	my ($i, @entwidg, @cbwidg, $widg, @ent, @cb, $sig, $account_type);
 	@entwidg = @$entref;
 	@cbwidg = @$cbref;
 	$i=0;
 	$account_type = $c_type->entry->get_text();
 	foreach $widg (@entwidg) {
  		$ent[$i] = $widg->get_text;
  		$i++;
 	}
 	if ($account_type eq "mbox" || $account_type eq "Maildir") {
  		if (!$ent[0] || !$ent[1] || !$ent[2] || !$ent[5] || !$ent[8]) { 
      			&main::err_dialog(_("Be sure You have filled all fields"));
      			return 1; 
		}
 	} else {
  	if (!$ent[0] || !$ent[1] || !$ent[2] || !$ent[3] || !$ent[4] || !$ent[5] || !$ent[6] || !$ent[7]) { 
      		&main::err_dialog(_("Be sure You have filled all fields"));
	      	return 1; 
	   	}
 	}
 	$i=0;
 	foreach $widg (@cbwidg) {
  		if ($widg->active) {
    			$cb[$i] = "y";
  		} else {
    			$cb[$i] = "n";
  		}
  	$i++;
 	}
 
 
 	if ($account_type eq "mbox" || $account_type eq "Maildir") {
		$ent[3] = $ent[8];
 	}
 	if ($aw_sig) { $sig = $aw_sig->get_chars(0,-1); } else { $sig = ""; }
 	if ($action eq "new") {
  		my ($sql, $query);
  		$sql = "insert into accounts (id, uname, friendly, smtp, pop, pport, pass,
          		reply, include, dm, def, type, dupecheck, descr) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
  		$query = $main::conn->prepare($sql);
  		my $id = &main::newid('accounts', $main::conn);
  		$query->execute($id, $ent[6], $ent[1], $ent[2], $ent[3], $ent[4], $ent[7],
    		$ent[5], $cb[0], $cb[1], $cb[2], $account_type, $cb[3], $ent[0]) or return;
  		if ($cb[2] eq "y") {
   			$sql = "update accounts set def=?";
   			$query=$main::conn->prepare($sql);
   			$query->execute("n");
   			$sql = "update accounts set def=? where id=?";
   			$query=$main::conn->prepare($sql);
   			$query->execute("y", $id);
  		}
  		my $menuitem=new Gtk::MenuItem("$ent[0]");
  		$menuitem->signal_connect("activate" => \&main::check_mail, $id, "1");
  		$menuitem->show;
  		$main::acct_menu_items{$id} = $menuitem;
  		$main::acct_menu->append($menuitem);
   		my $menuitem2=new Gtk::MenuItem("$ent[0]");
     		$menuitem2->signal_connect("activate" => \&main::check_mail, $id, "1");
       		$menuitem2->show;
         	$main::acct_menu2_items{$id} = $menuitem2;
	   	$main::acct_menu2->append($menuitem2);
	   
  		if ($sig) {
   			open (TMP,">$main::prefs{'MailDir'}/sig/$id.sig");
    			print TMP $sig;
   			close(TMP);
  		} else {
   		unlink("$main::prefs{'MailDir'}/sig/$id.sig");
  		}
 	} elsif ($action eq "edit") {
  		my ($sql, $query);
  		$sql = "update accounts set uname=?, friendly=?, smtp=?, pop=?, pport=?,
          		pass=?, reply=?, include=?, dm=?, def=?, type=?, dupecheck=?, descr=? where id=?";
  		$query = $main::conn->prepare($sql);
  		$query->execute($ent[6], $ent[1], $ent[2], $ent[3], $ent[4], $ent[7],
                $ent[5], $cb[0], $cb[1], $cb[2], $account_type,$cb[3],$ent[0], $mainid) or return;
  		if ($cb[2] eq "y") {
   			$sql = "update accounts set def=?";
   			$query=$main::conn->prepare($sql);
   			$query->execute("n");
   			$sql = "update accounts set def=? where id=?";
   			$query=$main::conn->prepare($sql);
   			$query->execute("y", $mainid);
  		}
  		if ($sig) {
   			open (TMP,">$main::prefs{'MailDir'}/sig/$mainid.sig");
    			print TMP $sig;
   			close(TMP);
  		} else {
   			unlink("$main::prefs{'MailDir'}/sig/$mainid.sig");
  		}
 	}
 	&clist_refresh($acct_clist);
 	$aw_win->destroy;
 
return 1;
}

sub clist_refresh {
	my ($clist) = @_;
 	if (!$clist) { return; }
 	my ($sql, $query, $row, @row, $query2, $flag);
	$flag = $clist->{'name'};
 	$clist->freeze;
 	$clist->clear;
 	if ($flag eq "account") {
  		$sql = "select id, descr, friendly, pop, reply, include, dm, def, dupecheck from
          	accounts";
 	} elsif ($flag eq "filter") {
 		 $sql = "select id, name, type, boxid, regex, addr, sorder,count from
          	filters order by sorder";
 	} elsif ($flag eq "mimetypes") {
  		$sql = "select id, mime, command, icon from
         	mimetypes";
 	}
 	$query=$main::conn->prepare($sql);
 	$query->execute();
 	$row=0;
 	while (@row=$query->fetchrow_array()) {
  		if ($flag eq "mimetypes") {
    			$clist->insert($row,$row[1],$row[2],$row[3]);
  		} elsif ($flag eq "account") {
   			$clist->insert($row,$row[1],$row[2],$row[3],$row[4],$row[5],$row[6],$row[7],($row[8]) ? $row[8] : "n");
  		} elsif ($flag eq "filter") {
   				if ($row[2] == 1) {
    					$sql = "select descr from accounts where id = ?";
    					$query2=$main::conn->prepare($sql);
    					$query2->execute($row[4]);
    					$row[4] = ($query2->fetchrow_array());
   				}
   			if (!$row[5]) { $row[5] = " "; }
   			if (not defined $row[7] or $row[7]<0) { $row[7] = " "; }
   			if ($row[2] != 6) { $row[3] = $main::folderidtoname{$row[3]}; }
  			$clist->insert($row,$row[1],$main::flttypes[$row[2]],$row[3],$row[4],$row[5],$row[7]);
  		}
	$clist->set_row_data($row, \$row[0]);
  	$row++;
 	}
 
 	if ($flag ne "filter") { $clist->sort; }
 	$clist->thaw;
 	return 1;
}



sub init_win {
	my ($widget, $flag, $data) = @_;
	my $winName=$flag."Win";
	if ((defined $data->{'winopen'}) and ($data->{'winopen'} == 1)) {
		return 1;
	}
	$data->{'winopen'} = 1;
	my ($win, $vbox, $hbox, $hbox2, $edit_but, $del_but, $ok_but, $new_but, $scroll, $clist, @headers);
	if ($flag eq "account") {
		(@headers)=(_("Description"),_("Name"),_("Server"),_("Address"),_("Include?"),_("Delete?"),_("Default?"), _("Check dupes?"));
	} elsif ($flag eq "filter") {
		(@headers)=(_("Name"),_("Type"),_("Folder"),_("Expression"),_("Address"),_("Hits"));
	} elsif ($flag eq "mimetypes") {
		(@headers)=(_("Mime"),_("Command"),_("Pixmap"));
	}
	$win = new Gtk::Window("toplevel");
	$win->signal_connect("delete_event" => \&Gtk::false);
	my($width,$height)=&main::get_win_size($winName,500,150);
	$win->set_default_size($width,$height);
	$win->set_policy(1,1,0);
	$win->show;
	$vbox = new Gtk::VBox(0,0);
	$vbox->show;
	$win->add($vbox);
	$clist = new_with_titles Gtk::CList(@headers);
	@{$clist->{'labels'}} = @headers;
	if ($flag ne "filter") {
		$clist->{'sortcol'} = 0;
		$clist->{'sortdir'} = "descending";
		$clist->signal_connect('click_column', \&click_column);
	}
	$clist->{'name'} = $flag;
	$clist->signal_connect('button_press_event', \&click_clist, $data);
	&clist_refresh($clist);
	$clist->show;
	$clist->{'popup'} = new Gtk::Menu;
	$clist->{'popup'}->{'sep1'} = new Gtk::MenuItem;
	$clist->{'popup'}->{'sep1'}->show;
	$clist->{'popup'}->append($clist->{'popup'}->{'sep1'});
	$clist->{'popup'}->{'edit'} = new Gtk::MenuItem(_("Edit"));
	$clist->{'popup'}->{'edit'}->show;
	$clist->{'popup'}->append($clist->{'popup'}->{'edit'});
	$clist->{'popup'}->{'delete'} = new Gtk::MenuItem(_("Delete"));
	$clist->{'popup'}->{'delete'}->show;
	$clist->{'popup'}->append($clist->{'popup'}->{'delete'});
	$clist->{'popup'}->{'delete'}->signal_connect("activate", \&delete_item, $clist);
	$scroll = new Gtk::ScrolledWindow(undef,undef);
	$scroll->set_policy('automatic','automatic');
	$scroll->show;
	$scroll->add($clist);
	$vbox->pack_start($scroll,1,1,0);
	$hbox = new Gtk::HBox(0,0);
	$hbox->border_width('5');
	$hbox->show;
	$new_but = new Gtk::Button(_("New"));
	$new_but->show;
	$new_but->set_usize(55,25);
	$hbox->pack_start($new_but,1,0,0);
	$edit_but = new Gtk::Button(_("Edit"));
	$edit_but->show;
	$edit_but->set_usize(55,25);
	$hbox->pack_start($edit_but,1,0,0);
	$del_but = new Gtk::Button(_("Delete"));
	$del_but->show;
	$del_but->set_usize(55,25);
	$hbox->pack_start($del_but,1,0,0);
	$ok_but = new Gtk::Button(_("Close"));
	$ok_but->show;
	$ok_but->set_usize(55,25);
	$hbox->pack_start($ok_but,1,0,0);
	$vbox->pack_start($hbox,0,1,0);
	$del_but->signal_connect("clicked", \&delete_item, $clist);
	if ($flag eq "account") {
		$clist->set_column_width(0,75);
		$clist->set_column_width(1,75);
		$clist->set_column_width(2,75);
		$clist->set_column_width(3,125);
		$new_but->signal_connect("clicked", \&acct_editwin, "new", 0, $clist);
		$edit_but->signal_connect("clicked", \&edit_account, $clist);
		$clist->{'popup'}->{'edit'}->signal_connect("activate", \&edit_account, $clist);
		$win->set_title(_("Account List"));
	} elsif ($flag eq "filter") {
		$win->set_title(_("Filter List"));
		$clist->set_column_width(0,100);
		$clist->set_column_width(1,100);
		$clist->set_column_width(2,75);
		$clist->set_column_width(3,100);
       		$clist->set_column_justification(5,"center");
		$new_but->signal_connect("clicked", \&Pronto::Filter::filter_editwin, $clist, "new");
		$edit_but->signal_connect("clicked", \&Pronto::Filter::filter_editwin, $clist, "edit");
		$clist->{'popup'}->{'edit'}->signal_connect("activate",\&Pronto::Filter::filter_editwin, $clist, "edit");
		$clist->set_reorderable(1);
		$clist->signal_connect("row_move", \&Pronto::Filter::filter_reorder);
	} elsif ($flag eq "mimetypes") {
		$win->set_title(_("Mimetypes List"));
		$clist->set_column_width(0,100);
                $clist->set_column_width(1,100);
                $clist->set_column_width(1,100);
		$new_but->signal_connect("clicked", \&mime_editwin, $clist, "new");
		$edit_but->signal_connect("clicked", \&mime_editwin, $clist, "edit");
		$clist->{'popup'}->{'edit'}->signal_connect("activate", \&mime_editwin, $clist, "edit");
	}
	if ($flag ne "filter") { &click_column($clist, $clist->{'sortcol'}); }
	$ok_but->signal_connect("clicked" => \&dest_win, $win, $data);
	$win->signal_connect("destroy" => \&dest_win, $win, $data);
	$win->signal_connect("size-request" => \&main::save_win_size, $winName, $win->window);
	return 1;
}

sub dest_win {
	my ($widget, $win, $data) = @_;
	if (defined $data->{'winopen'}) {
		undef $data->{'winopen'};
	}
	$win->destroy;
}

sub click_column {
	my ($clist, $column) = @_;
	if ($column == $clist->{'sortcol'}) {
		if ($clist->{'sortdir'} eq "descending") {
			$clist->{'sortdir'} = "ascending";
		} else {
			$clist->{'sortdir'} = "descending";
		}
	}
	$clist->{'sortcol'} = $column;
	$clist->set_sort_column($clist->{'sortcol'});
	$clist->set_sort_type($clist->{'sortdir'});
	$clist->sort;
	&main::set_labels($clist);
	return 1;
}

sub delete_item {
 
 	my ($widget, $clist) = @_;
 	my (@selection, $id, $sql, $query, @row, $flag);
 	$flag = $clist->{'name'};
 	if (@selection = $clist->selection) {
  	$id = ${$clist->get_row_data($selection[0]);}} else { &main::err_dialog("Select an entry to delete!"); return 1;}
  	if ($flag eq "account") {
   		$sql = "delete from accounts where id=$id";
   		$main::acct_menu_items{$id}->destroy;
   		delete $main::acct_menu_items{$id};
   		$main::acct_menu2_items{$id}->destroy;
   		delete $main::acct_menu2_items{$id};
  	} elsif ($flag eq "filter") {
   		$sql = "delete from filters where id=$id";
  	} elsif ($flag eq "mimetypes") {
   		$sql = "delete from mimetypes where id=$id";
  	}
  	$main::conn->do($sql);
  	&clist_refresh($clist);
 
}


sub click_clist {
  	
	my ($widget, $data, $event) = @_;
      	if ($event->{type} eq "2button_press") {
   		&dblclick_clist($widget, $event, $data);
   	} 

  	if (($event->{button} == 3) and ($widget->{'popup'})) {
   		$widget->{'popup'}->popup(undef,undef,$event->{button},1);
  	}
	return 1;
}

sub dblclick_clist {
  	my ($widget, $event, $data) = @_;
  	my ($x, $y, $flag);
  	$x = $event->{'x'};
  	$y = $event->{'y'};
  	my ($row, $col) = $widget->get_selection_info($x,$y);
  	$flag = $widget->{'name'};
  	if (not defined $row) { return 1; }
  	if ($flag eq "account") {
   		&Pronto::TableEdit::edit_account($widget, $widget, $row);
  	} elsif ($flag eq "filter") {
   		&Pronto::Filter::filter_editwin($widget, $widget, "edit", $row);
    } elsif ($flag eq "mimetypes") {
  		&Pronto::TableEdit::mime_editwin($widget, $widget, "edit", $row);
  	}
  
  	return 1;
}


