#!/usr/bin/python
#-*- coding:utf-8 -*-

#    Pybik -- A 3 dimensional magic cube game.
#    Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


from __future__ import with_statement

import sys, os, re

def main(argv):
    arg_src = argv[0]
    arg_dst = argv[1]
    if not os.path.exists(arg_src):
        print >>sys.stderr, 'error:', arg_src, 'does not exist'
        return 1
    create_pyx(arg_src, arg_dst)
    return 0

def create_pyx(src_path, dst_path):
    with open(src_path,'r') as srcf:
        with open(dst_path,'w') as dstf:
            text = srcf.read()
            ## replace a line with a cdef line
            #text = re.compile(r'^( *)#(cdef .*)\n\1.*$', re.M).sub(r'\1\2\n\1', text)
            # insert a line
            text = re.compile(r'^( *)#px\+', re.M).sub(r'\1', text)
            # remove next line
            text = re.compile(r'^( *)#px-\n.*$', re.M).sub(r'\1\n\1', text)
            # remove next n lines
            for n in range(1,11):
                text = re.compile(r'^( *)#px-%d'%n+r'\n.*'*n+'$', re.M).sub(r'\1'+r'\n\1'*n, text)
            # replace next line with a line
            text = re.compile(r'^( *)#px/(.*)\n.*$', re.M).sub(r'\1\2\n\1', text)
            # remove comment
            text = re.compile(r'^( *)#px .*$', re.M).sub(r'\1', text)
            
            dstf.write(text)
            
if __name__ == '__main__':
    try:
        main(sys.argv[1:])
    except:
        sys.exit(1)
    else:
        sys.exit(0)


