#
# bench.rb
#
#   Copyright (c) 1999-2001 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# usage:
#
#   str = 'test string'
#   benchmark( 'strdup', 10_0000 ) {
#     str.dup
#   }
#

if Process.respond_to? :times then
  TIMES_MODULE = Process
else
  TIMES_MODULE = Time
end

def benchmark( label, times, &block )
  GC.disable
  mod = TIMES_MODULE
  begtime = mod.times.utime
  times.times( &block )
  endtime = mod.times.utime
  GC.enable
  $stderr.printf "%-10s: %f sec\n", label, endtime - begtime
end
