/*
 * Race is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>

#include "game_config.h"
#include "map.h"
#include "texture.h"
#include "track.h"


tileMap* Track::track = NULL;

GLuint Track::terrain_display_list;
GLuint Track::road_display_list;

Texture *Track::road_texture = NULL;
Texture *Track::terrain_texture = NULL;
Texture *Track::water = NULL;

void Track::init()
{
	if( track == NULL )
		track = new tileMap();
}

void Track::deinit()
{
	delete track;
	track = NULL;
}

void Track::load(CL_String track_name)
{
	track->load_map( track_name );
}

