/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/core.h>

#ifdef RACE_SOUND
	#include <ClanLib/sound.h>
#endif

#include "track_sfx.h"
#include "debug.h"
#include "config.h"

CL_SoundBuffer *TrackSfx::start = NULL;

std::vector<CL_SoundBuffer*> TrackSfx::collision;

bool TrackSfx::inited = false;
unsigned int TrackSfx::last_time = 0;

unsigned int TrackSfx::time_between_collision_sfx = 0;
unsigned int TrackSfx::time_of_last_collision = 0;

void TrackSfx::init()
{
#ifdef RACE_SOUND
	if( inited ) return;
	
	last_time = CL_System::get_time();
	
	time_between_collision_sfx = 200; // 0.2 sec.
	time_of_last_collision = CL_System::get_time();
	
	RaceDebug::print("Resources: TrackSfx: resources/sound.res", 7);

	CL_String rpath = DATADIR;
	rpath += "resources/sound.res";

	CL_ResourceManager res( rpath, false );
	
	if( start == NULL )
	{
		try { start = CL_SoundBuffer::load( "start", &res ); }
		catch( CL_Error err )
		{ std::cout << err.message.c_str() << endl; }
	}

	int num_sounds = CL_Integer("num_sounds", &res);

	for( int i=0; i<num_sounds; i++ )
	{
		CL_String str = "sound_";
		str += i;

		collision.push_back( new CL_SoundBuffer(str.get_string(), &res) );
	}

#endif
}


void TrackSfx::play_collision()
{
#ifdef RACE_SOUND
	if( collision.empty() == false
	   && (CL_System::get_time() - time_of_last_collision > time_between_collision_sfx ))
	{
		int num = rand() % collision.size();
		collision[num]->play();
		
		time_of_last_collision = CL_System::get_time();
	}
#endif
}
