
Author   = "Harry Storbacka <harrysto@nic.fi>" (type=string);
Name     = "Fantasy" (type=string);
borders  = false (type = boolean );

description = "blaah" (type=string);

road_speed            = 62 (type=integer);
terrain_speed         = 30 (type=integer);
skid_speed_decrease   = 4  (type=integer);
tyre_grip             = 7  (type=integer);
no_gas_speed_decrease = 5 (type=integer);
brakes_speed_decrease = 40 (type=integer);
update_dir_timer      = 25 (type=integer);

section tiles
{
	section road
	{
		full = tiles/road/full.tga (type=surface);
		n = tiles/road/n.tga (type=surface);
		e = tiles/road/e.tga (type=surface);
		s = tiles/road/s.tga (type=surface);
		w = tiles/road/w.tga (type=surface);		
		ne = tiles/road/ne.tga (type=surface);
		nw = tiles/road/nw.tga (type=surface);
		se = tiles/road/se.tga (type=surface);
		sw = tiles/road/sw.tga (type=surface);
	}
	
	section water
	{
		full = tiles/water/full.tga (type=surface);
		n = tiles/water/n.tga (type=surface);
		e = tiles/water/e.tga (type=surface);
		s = tiles/water/s.tga (type=surface);
		w = tiles/water/w.tga (type=surface);		
		ne = tiles/water/ne.tga (type=surface);
		nw = tiles/water/nw.tga (type=surface);
		se = tiles/water/se.tga (type=surface);
		sw = tiles/water/sw.tga (type=surface);	
	}
}


section trees
{
	num_items = 3 (type=integer);
	
	tree_0 = "trees/tree.h3d" (type=string);
	tree_0_tex = trees/tree2.png (type=surface);

	tree_1 = "trees/spruce.h3d" (type=string);
	tree_1_tex = trees/spruce.png (type=surface);

	tree_2 = "trees/yatree.h3d" (type=string);
	tree_2_tex = trees/yatree.png (type=surface);
}


section scroller_x
{
	num_items = 0 (type=integer);
	
	texture_0 = scroller/texture.tga (type=surface);
	texture_0_overlay = scroller/overlay.tga (type=surface);
}

section water_objects
{
	num_items = 1 (type=integer);
	
	water_obj_0 = water_obj/fountain.png
	(
		type=surface,
		x=0,y=0,
		width=30,
		height=30,
		array=3x1
	);

	water_obj_0_frame_time = 60 (type=integer);
}




section houses
{
	section 1x1
	{
		num_items = 0 (type=integer);
	}

	section 2x2
	{
		num_items = 3 (type=integer);
		
		house_0     = houses/2x2/stonehouse.h3d (type=string);
		house_0_tex = houses/2x2/stonehouse.jpg (type=surface);
		
		house_1     = houses/2x2/tower.h3d (type=string);
		house_1_tex = houses/2x2/tower.jpg (type=surface);
		
		house_2     = houses/2x2/house.h3d (type=string);
		house_2_tex = houses/2x2/house.png (type=surface);
	}

	section 5x3
	{
		num_items = 1 (type=integer);

		house_0     = houses/5x3/h5x3_2.h3d (type=string);
		house_0_tex = houses/5x3/h5x3_2.jpg (type=surface);		
	}

	section 3x5
	{
		num_items = 0 (type=integer);
	}

	section 5x5
	{
		num_items = 0 (type=integer);
	}
}






section ground
{
	ground_texture = ground.jpg ( type = surface );	
	road_texture = road.jpg ( type = surface );
	water_texture = water2.jpg ( type = surface );
}





section dust
{
	dust = dust.tga ( type=surface );
	w_dust = w_dust.tga ( type=surface );
}




section bridges
{
	bridge_L_h = bridges/l_h.png ( type=surface );
	bridge_L_v = bridges/l_v.png ( type=surface );
	bridge_s_h = bridges/s_h.png ( type=surface );
	bridge_s_v = bridges/s_v.png ( type=surface );
}





section sfx
{
	collision_number = 3 (type=integer);
	
	collision_0 = themes/dirt/col_1.wav (type=sample);
	collision_1 = themes/dirt/col_2.wav (type=sample);
	collision_2 = themes/dirt/col_3.wav (type=sample);
	
	extra_number = 0 (type=integer);

	// extra_0 = mywave.wav (type=sample)
}

section ramp
{
	ramp_0 = ramps/up.png (type=surface);
	ramp_1 = ramps/down.png (type=surface);
	ramp_2 = ramps/left.png (type=surface);
	ramp_3 = ramps/right.png (type=surface);
}

season_bg = season.jpg (type=surface);

fence_tex = fence.jpg (type=surface);
fence = "fence.h3d" (type=string);

