/* 
 * Copyright (c) 2001 Secure Software Solutions
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef PYTHON_TOKENS_H
#define PYTHON_TOKENS_H

/*
 * Tokens that are specific to the Python language
 */

#define NEWLINE             (TOKEN_PY_START +  0)
#define AND                 (TOKEN_PY_START +  1)
#define ASSERT              (TOKEN_PY_START +  2)
#define CLASS               (TOKEN_PY_START +  3)
#define DEF                 (TOKEN_PY_START +  4)
#define DEL                 (TOKEN_PY_START +  5)
#define ELIF                (TOKEN_PY_START +  6)
#define EXCEPT              (TOKEN_PY_START +  7)
#define EXEC                (TOKEN_PY_START +  8)
#define FINALLY             (TOKEN_PY_START +  9)
#define FROM                (TOKEN_PY_START + 10)
#define GLOBAL              (TOKEN_PY_START + 11)
#define IMPORT              (TOKEN_PY_START + 12)
#define IN                  (TOKEN_PY_START + 13)
#define IS                  (TOKEN_PY_START + 14)
#define LAMBDA              (TOKEN_PY_START + 15)
#define NOT                 (TOKEN_PY_START + 16)
#define OR                  (TOKEN_PY_START + 17)
#define PASS                (TOKEN_PY_START + 18)
#define PRINT               (TOKEN_PY_START + 19)
#define RAISE               (TOKEN_PY_START + 20)
#define TRY                 (TOKEN_PY_START + 21)

#define SSTRING_LITERAL     STRING_CONST 
#define LSTRING_LITERAL     STRING_CONST 

#define EXP_ASSIGN          (TOKEN_PY_START + 25)
#define EXP_OP              (TOKEN_PY_START + 26)

#endif
