#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define INCL_RXSHV
#define INCL_RXFUNC
#define INCL_RXSYSEXIT
#define INCL_RXSUBCOM

#include "rexxsaa.h"

#define STARTUPMSG "       +++ Interactive trace. TRACE OFF to end debug, ENTER to continue. +++"


void message( char *msg )
{
   printf( "  %s", msg ) ;
   fflush(stdout) ;
}


void mycomplain( char *msg )
{
   fprintf( stderr, "Complaint: %s\n", msg ) ;
}

void iverify( char *msg, int first, int second )
{
   if (first != second)
      printf( "\nInt verify: %s: %d ^= %d\n", msg, first, second ) ;
}

void sverify( char *msg, PRXSTRING first, char *second )
{
   if (!second)
   {
      if (first->strptr)
         printf( "\nSecond is null, first: %d<%s>\n", (int) first->strlength,
                 first->strptr  ) ;
   }
   else if (strlen(second) != first->strlength)
   {
      printf( "\nString length: %s: %d ^=%d\n", msg,
              (int) first->strlength, (int) strlen(second)) ;
      printf( "   first=%4d<%s>\n", (int) first->strlength, first->strptr ) ;
      printf( "   secnd=%4d<%s>\n", (int) strlen(second), second ) ;
   }
   else
      if (memcmp(second, first->strptr, first->strlength))
         printf( "\nString contents: %s: <%s> ^== <%s>\n", msg,
                 first->strptr, second ) ;
}




LONG APIENTRY instore_exit( LONG ExNum, LONG Subfun, PEXIT PBlock )
{
#ifdef UNION_EXIT
#else
   RXSIOSAY_PARM *psiosay;
#endif
   iverify( "Exitfunction", ExNum, RXSIO ) ;
   iverify( "Subfunction", Subfun, RXSIOSAY ) ;
#ifdef UNION_EXIT
   sverify( "Exit string", &(PBlock->siosay.rxsio_string), "foobar" ) ;
#else
   psiosay = (RXSIOSAY_PARM *)PBlock;
   sverify( "Exit string", &(psiosay->rxsio_string), "foobar" ) ;
#endif

   return RXEXIT_HANDLED ;
}

void instore( void )
{
   RXSTRING Instore[2] ;
   RXSYSEXIT Exits[2] ;
   int rc ;

   message( "instore" ) ;

   RexxRegisterExitExe( "Foo", (PFN)instore_exit, NULL ) ;

   Exits[0].sysexit_name = "Foo" ;
   Exits[0].sysexit_code = RXSIO ;
   Exits[1].sysexit_code = RXENDLST ;

   Instore[0].strptr = "say 'foobar'" ;
   Instore[0].strlength = strlen( Instore[0].strptr ) ;
   Instore[1].strptr = NULL ;
   rc = RexxStart( 0, NULL, "Testing", Instore, "Foo", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   rc = RexxStart( 0, NULL, "Testing", Instore, "", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   Instore[0].strptr = NULL ;
   rc = RexxStart( 0, NULL, "Testing", Instore, "", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   rc = RexxStart( 0, NULL, "Testing", Instore, "", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   RexxFreeMemory( Instore[1].strptr ) ;
   RexxDeregisterExit( "Foo", NULL ) ;
}


LONG APIENTRY trace_exit( LONG ExNum, LONG Subfun, PEXIT PBlock )
{
#ifdef UNION_EXIT
#else
   RXSIOTRC_PARM *psiotrc;
#endif
   iverify( "Exitfunction", ExNum, RXSIO ) ;
   if (Subfun==RXSIOTRC)
   {
#ifdef UNION_EXIT
      sverify( "Exit string", &(PBlock->siotrc.rxsio_string),
               "     1 *-* trace off" ) ;
#else
      psiotrc = (RXSIOTRC_PARM *)PBlock;
      sverify( "Exit string", &(psiotrc->rxsio_string),
               "     1 *-* trace off" ) ;
   }
#endif
   else
      mycomplain( "Unexpected subfunction\n" ) ;

   return RXEXIT_HANDLED ;
}

void trace( void )
{
   RXSTRING Instore[2] ;
   RXSYSEXIT Exits[2] ;
   int rc ;

   message( "trace" ) ;

   RexxRegisterExitExe( "Foo", (PFN)trace_exit, NULL ) ;

   Exits[0].sysexit_name = "Foo" ;
   Exits[0].sysexit_code = RXSIO ;
   Exits[1].sysexit_code = RXENDLST ;

   Instore[0].strptr = "trace all;trace off" ;
   Instore[0].strlength = strlen( Instore[0].strptr ) ;
   Instore[1].strptr = NULL ;

   rc = RexxStart( 0, NULL, "Testing", Instore, "Foo", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   RexxDeregisterExit( "Foo", NULL ) ;
}


LONG APIENTRY intertrc_exit( LONG ExNum, LONG Subfun, PEXIT PBlock )
{
   static int cnt=0 ;
   static char *data[] = {
      "",
      "     2 *-* say 'hallo'",
      "       >L>   \"hallo\"",
      "hallo",
      STARTUPMSG,
      "=",
      "       *-* say 'hallo'",
      "       >L>   \"hallo\"",
      "hallo",
      "",
      "       *-* trace off",
      "",
   };
#ifdef UNION_EXIT
#else
   RXSIOTRC_PARM *psiotrc;
   RXSIOSAY_PARM *psiosay;
   RXSIODTR_PARM *psiodtr;
#endif

   iverify( "Exitfunction", ExNum, RXSIO ) ;
   switch (++cnt)
   {
       case 1:
       case 2:
       case 4:
#ifdef FGC
       case 6:
       case 7:
#endif
       case 10:
       case 11:
          iverify( "Subfunction", Subfun, RXSIOTRC ) ;
#ifdef UNION_EXIT
          sverify( "Trace output", &(PBlock->siotrc.rxsio_string),data[cnt]);
#else
          psiotrc = (RXSIOTRC_PARM *)PBlock;
          sverify( "Trace output", &(psiotrc->rxsio_string),data[cnt]);
#endif
          break ;

       case 3:
#ifdef FGC
       case 8:
#endif
          iverify( "Subfunction", Subfun, RXSIOSAY ) ;
#ifdef UNION_EXIT
          sverify( "Say output", &(PBlock->siosay.rxsio_string), data[cnt]);
#else
          psiosay = (RXSIOSAY_PARM *)PBlock;
          sverify( "Say output", &(psiosay->rxsio_string), data[cnt]);
#endif
          break ;

       case 5:
#ifndef FGC
       case 6:
       case 7:
       case 8:
#endif
       case 9:
          iverify( "Subfunction", Subfun, RXSIODTR ) ;
#ifdef UNION_EXIT
          PBlock->siodtr.rxsiodtr_retc.strptr = data[cnt] ;
          PBlock->siodtr.rxsiodtr_retc.strlength = strlen(data[cnt]) ;
#else
          psiodtr = (RXSIODTR_PARM *)PBlock;
          psiodtr->rxsiodtr_retc.strptr = data[cnt] ;
          psiodtr->rxsiodtr_retc.strlength = strlen(data[cnt]) ;
#endif
          break ;

       default:
          fprintf( stderr, "Out of order msg subfunc=%ld\n", Subfun) ;
          return RXEXIT_NOT_HANDLED ;
   }
   return RXEXIT_HANDLED ;
}

void intertrc( void )
{
   RXSTRING Instore[2] ;
   RXSYSEXIT Exits[2] ;
   int rc ;

   message( "intertrc" ) ;

   RexxRegisterExitExe( "Foo", (PFN)intertrc_exit, NULL ) ;

   Exits[0].sysexit_name = "Foo" ;
   Exits[0].sysexit_code = RXSIO ;
   Exits[1].sysexit_code = RXENDLST ;

   Instore[0].strptr = "trace ?int\nsay 'hallo'; trace off" ;
   Instore[0].strlength = strlen( Instore[0].strptr ) ;
   Instore[1].strptr = NULL ;

   rc = RexxStart( 0, NULL, "Testing", Instore, "Foo", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   RexxDeregisterExit( "Foo", NULL ) ;
}





LONG APIENTRY pull_exit( LONG ExNum, LONG Subfun, PEXIT PBlock )
{
   static int cnt=0 ;
   static char *data[] = {
      "",
      "alpha",
      "ALPHA",
      "FOO",
      "beta",
      "beta",
   };
#ifdef UNION_EXIT
#else
   RXSIOSAY_PARM *psiosay;
   RXSIOTRD_PARM *psiotrd;
#endif

   iverify( "Exitfunction", ExNum, RXSIO ) ;
   switch (++cnt)
   {
       case 2:
       case 3:
       case 5:
          iverify( "Subfunction", Subfun, RXSIOSAY ) ;
#ifdef UNION_EXIT
          sverify( "Trace output", &(PBlock->siosay.rxsio_string),data[cnt]);
#else
          psiosay = (RXSIOSAY_PARM *)PBlock;
          sverify( "Trace output", &(psiosay->rxsio_string),data[cnt]);
#endif
          break ;

       case 1:
       case 4:
          iverify( "Subfunction", Subfun, RXSIOTRD ) ;
#ifdef UNION_EXIT
          strcpy(PBlock->siotrd.rxsiotrd_retc.strptr,data[cnt]) ;
          PBlock->siotrd.rxsiotrd_retc.strlength = strlen(data[cnt]) ;
#else
          psiotrd = (RXSIOTRD_PARM *)PBlock;
          strcpy(psiotrd->rxsiotrd_retc.strptr,data[cnt]) ;
          psiotrd->rxsiotrd_retc.strlength = strlen(data[cnt]) ;
#endif
          break ;

       default:
          fprintf( stderr, "Out of order msg subfunc=%ld\n", Subfun) ;
          return RXEXIT_NOT_HANDLED ;
   }
   return RXEXIT_HANDLED ;
}

void pull( void )
{
   RXSTRING Instore[2] ;
   RXSYSEXIT Exits[2] ;
   int rc ;

   message( "pull" ) ;

   RexxRegisterExitExe( "Foo", (PFN)pull_exit, NULL ) ;

   Exits[0].sysexit_name = "Foo" ;
   Exits[0].sysexit_code = RXSIO ;
   Exits[1].sysexit_code = RXENDLST ;

   Instore[0].strptr =
     "pull bar;say bar;push 'foo';pull bar;say bar;parse pull bar;say bar" ;
   Instore[0].strlength = strlen( Instore[0].strptr ) ;
   Instore[1].strptr = NULL ;

   rc = RexxStart( 0, NULL, "Testing", Instore, "Foo", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   RexxDeregisterExit( "Foo", NULL ) ;
}





LONG APIENTRY it_init_exit( LONG ExNum, LONG Subfun, PEXIT PBlock )
{
   SHVBLOCK shv ;
   char *name="FOO" ;
   int rc ;
   char *value="foz" ;

   shv.shvnext = NULL ;
   shv.shvname.strptr = name ;
   shv.shvnamelen = shv.shvname.strlength = strlen(name) ;
   shv.shvvalue.strptr = value ;
   shv.shvvaluelen = shv.shvvalue.strlength = strlen(value) ;
   shv.shvcode = RXSHV_SYSET ;

   rc = RexxVariablePool( &shv ) ;
   iverify( "Init exit", rc, RXSHV_NEWV ) ;
   iverify( "Init exit", shv.shvret, RXSHV_NEWV ) ;
   return RXEXIT_HANDLED ;
}


LONG APIENTRY it_term_exit( LONG ExNum, LONG Subfun, PEXIT PBlock )
{
   SHVBLOCK shv ;
   char *name ;
   int rc ;
   char value[64] ;

   shv.shvnext = NULL ;
   name = "MYVAR" ;
   shv.shvname.strptr = name ;
   shv.shvnamelen = shv.shvname.strlength = strlen(name) ;
   shv.shvvalue.strptr = value ;
   shv.shvvaluelen = 64 ;
   shv.shvcode = RXSHV_SYFET ;

   rc = RexxVariablePool( &shv ) ;
   iverify( "Term exit", rc, RXSHV_NEWV ) ;
   iverify( "Term exit", shv.shvret, RXSHV_NEWV ) ;
   sverify( "Term exit:", &(shv.shvvalue), "MYVAR" ) ;

   shv.shvnext = NULL ;
   name = "bar" ;
   shv.shvname.strptr = name ;
   shv.shvnamelen = shv.shvname.strlength = strlen(name) ;
   shv.shvvalue.strptr = value ;
   shv.shvvaluelen = 64 ;
   shv.shvvalue.strlength = strlen(value) ;
   shv.shvcode = RXSHV_SYFET ;

   rc = RexxVariablePool( &shv ) ;
   iverify( "Term exit", rc, RXSHV_OK ) ;
   iverify( "Term exit", shv.shvret, RXSHV_OK ) ;
   sverify( "Term exit:", &(shv.shvvalue), "baz" ) ;

   return RXEXIT_HANDLED ;
}


LONG APIENTRY it_say_exit( LONG ExNum, LONG Subfun, PEXIT PBlock )
{
   SHVBLOCK shv ;
   char *name ;
   int rc ;
   char value[64] ;
#ifdef UNION_EXIT
#else
   RXSIOSAY_PARM *psiosay;
#endif

   iverify( "Say exit", ExNum, RXSIO ) ;
   iverify( "Say exit", Subfun, RXSIOSAY ) ;
#ifdef UNION_EXIT
   sverify( "Say exit", &(PBlock->siosay.rxsio_string), "foz" ) ;
#else
   psiosay = (RXSIOSAY_PARM *)PBlock;
   sverify( "Say exit", &(psiosay->rxsio_string), "foz" ) ;
#endif

   shv.shvnext = NULL ;
   name = "myvar.1" ;
   shv.shvname.strptr = name ;
   shv.shvnamelen = shv.shvname.strlength = strlen(name) ;
   shv.shvvalue.strptr = value ;
   shv.shvvaluelen = 64 ;
   shv.shvcode = RXSHV_SYFET ;

   rc = RexxVariablePool( &shv ) ;
   iverify( "Say exit", rc, RXSHV_NEWV ) ;
   iverify( "Say exit", shv.shvret, RXSHV_NEWV ) ;
   sverify( "Say exit:", &(shv.shvvalue), "MYVAR.1" ) ;

   return RXEXIT_HANDLED ;
}

void init_term()
{
   RXSTRING Instore[2] ;
   RXSYSEXIT Exits[4] ;
   int rc ;

   message( "init/term" ) ;

   RexxRegisterExitExe( "init", (PFN)it_init_exit, NULL ) ;
   RexxRegisterExitExe( "term", (PFN)it_term_exit, NULL ) ;
   RexxRegisterExitExe( "say", (PFN)it_say_exit, NULL ) ;

   Exits[0].sysexit_name = "init" ;
   Exits[0].sysexit_code = RXINI ;
   Exits[1].sysexit_name = "term" ;
   Exits[1].sysexit_code = RXTER ;
   Exits[2].sysexit_name = "say" ;
   Exits[2].sysexit_code = RXSIO ;
   Exits[3].sysexit_code = RXENDLST ;

   Instore[0].strptr =
     "say foo\n\n\nbar='baz'\nexit" ;
   Instore[0].strlength = strlen( Instore[0].strptr ) ;
   Instore[1].strptr = NULL ;

   rc = RexxStart( 0, NULL, "Testing", Instore, "Foo", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   RexxDeregisterExit( "init", NULL ) ;
   RexxDeregisterExit( "term", NULL ) ;
   RexxDeregisterExit( "say", NULL ) ;
}



LONG APIENTRY vars_exit( LONG ExNum, LONG Subfun, PEXIT PBlock )
{
   SHVBLOCK shv[10] ;
   int rc ;
#ifdef UNION_EXIT
#else
   RXSIOSAY_PARM *psiosay;
#endif

   iverify( "Say exit", ExNum, RXSIO ) ;
   iverify( "Say exit", Subfun, RXSIOSAY ) ;

#ifdef UNION_EXIT
   sverify( "Say exit", &(PBlock->siosay.rxsio_string), "Hello" ) ;
#else
   psiosay = (RXSIOSAY_PARM *)PBlock;
   sverify( "Say exit", &(psiosay->rxsio_string), "Hello" ) ;
#endif

   shv[0].shvnext = &(shv[1]) ;
   shv[0].shvname.strptr = "BAR" ;
   shv[0].shvname.strlength = strlen( shv[0].shvname.strptr ) ;
   shv[0].shvnamelen = shv[0].shvname.strlength ;
   shv[0].shvvalue.strptr = "B-value-AR" ;
   shv[0].shvvalue.strlength = strlen( shv[0].shvvalue.strptr ) ;
   shv[0].shvvaluelen = shv[0].shvvalue.strlength ;
   shv[0].shvcode = RXSHV_SYSET ;

   /* Try to get it with lower case letters */
   shv[1].shvnext = &(shv[2]) ;
   shv[1].shvname.strptr = "bar " ;
   shv[1].shvname.strlength = strlen( shv[1].shvname.strptr ) ;
   shv[1].shvnamelen = shv[1].shvname.strlength ;
   shv[1].shvvalue.strptr = RexxAllocateMemory( 64 ) ;
   shv[1].shvvalue.strlength = 64 ;
   shv[1].shvvaluelen = shv[1].shvvalue.strlength ;
   shv[1].shvcode = RXSHV_SYFET ;

   /* then we use capital letters */
   shv[2].shvnext = &(shv[3]) ;
   shv[2].shvname.strptr = "BAR" ;
   shv[2].shvname.strlength = strlen( shv[2].shvname.strptr ) ;
   shv[2].shvnamelen = shv[2].shvname.strlength ;
   shv[2].shvvalue.strptr = RexxAllocateMemory( 64 ) ;
   shv[2].shvvalue.strlength = 64 ;
   shv[2].shvvaluelen = shv[2].shvvalue.strlength ;
   shv[2].shvcode = RXSHV_SYFET ;

   /* Then we set it to something else */
   shv[3].shvnext = &(shv[4]) ;
   shv[3].shvname.strptr = "BAR" ;
   shv[3].shvname.strlength = strlen( shv[3].shvname.strptr ) ;
   shv[3].shvnamelen = shv[3].shvname.strlength ;
   shv[3].shvvalue.strptr = "new value" ;
   shv[3].shvvalue.strlength = strlen( shv[3].shvvalue.strptr ) ;
   shv[3].shvvaluelen = shv[3].shvvalue.strlength ;
   shv[3].shvcode = RXSHV_SYSET ;

   /* And get it */
   shv[4].shvnext = &(shv[5]) ;
   shv[4].shvname.strptr = "BAR" ;
   shv[4].shvname.strlength = strlen( shv[4].shvname.strptr ) ;
   shv[4].shvnamelen = shv[4].shvname.strlength ;
   shv[4].shvvalue.strptr = RexxAllocateMemory( 64 ) ;
   shv[4].shvvalue.strlength =  64 ;
   shv[4].shvvaluelen = shv[4].shvvalue.strlength ;
   shv[4].shvcode = RXSHV_SYFET ;

   /* And drop it */
   shv[5].shvnext = &(shv[6]) ;
   shv[5].shvname.strptr = "BAR" ;
   shv[5].shvname.strlength = strlen( shv[5].shvname.strptr ) ;
   shv[5].shvnamelen = shv[5].shvname.strlength ;
   shv[5].shvvalue.strptr = NULL ;
   shv[5].shvvalue.strlength = 0 ;
   shv[5].shvvaluelen = shv[5].shvvalue.strlength ;
   shv[5].shvcode = RXSHV_SYDRO ;

   /* And then we try to get it again */
   shv[6].shvnext = &(shv[7]) ;
   shv[6].shvname.strptr = "BAR" ;
   shv[6].shvname.strlength = strlen( shv[6].shvname.strptr ) ;
   shv[6].shvnamelen = shv[6].shvname.strlength ;
   shv[6].shvvalue.strptr = RexxAllocateMemory( 64 ) ;
   shv[6].shvvalue.strlength = 64 ;
   shv[6].shvvaluelen = shv[6].shvvalue.strlength ;
   shv[6].shvcode = RXSHV_SYFET ;

   shv[7].shvnext = &(shv[8]) ;
   shv[7].shvname.strptr = "FOO" ;
   shv[7].shvname.strlength = strlen( shv[7].shvname.strptr ) ;
   shv[7].shvnamelen = shv[7].shvname.strlength ;
   shv[7].shvvalue.strptr = "OOPS" ;
   shv[7].shvvalue.strlength = strlen( shv[7].shvvalue.strptr ) ;
   shv[7].shvvaluelen = shv[7].shvvalue.strlength ;
   shv[7].shvcode = RXSHV_SYSET ;

   shv[8].shvnext = &(shv[9]) ;
   shv[8].shvname.strptr = "ABC.FOO" ;
   shv[8].shvname.strlength = strlen( shv[8].shvname.strptr ) ;
   shv[8].shvnamelen = shv[8].shvname.strlength ;
   shv[8].shvvalue.strptr = "hello, there! ... this is a long string" ;
   shv[8].shvvalue.strlength = strlen( shv[8].shvvalue.strptr ) ;
   shv[8].shvvaluelen = shv[8].shvvalue.strlength ;
   shv[8].shvcode = RXSHV_SYSET ;

   shv[9].shvnext = NULL ;
   shv[9].shvname.strptr = "ABC.OOPS" ;
   shv[9].shvname.strlength = strlen( shv[9].shvname.strptr ) ;
   shv[9].shvnamelen = shv[9].shvname.strlength ;
   shv[9].shvvalue.strptr = RexxAllocateMemory(16) ;
   shv[9].shvvalue.strlength = 16 ;
   shv[9].shvvaluelen = shv[9].shvvalue.strlength ;
   shv[9].shvcode = RXSHV_SYFET ;


   rc = RexxVariablePool( shv ) ;
   iverify( "Term exit", rc, RXSHV_TRUNC | RXSHV_BADN | RXSHV_NEWV ) ;

   iverify( "Term exit1 ", shv[0].shvret, RXSHV_NEWV ) ;
   iverify( "Term exit2 ", shv[1].shvret, RXSHV_BADN ) ;
   iverify( "Term exit3 ", shv[2].shvret, RXSHV_OK ) ;
   iverify( "Term exit4 ", shv[3].shvret, RXSHV_OK ) ;
   iverify( "Term exit5 ", shv[4].shvret, RXSHV_OK ) ;
   iverify( "Term exit6 ", shv[5].shvret, RXSHV_OK ) ;
   iverify( "Term exit7 ", shv[6].shvret, RXSHV_NEWV ) ;
   iverify( "Term exit8 ", shv[7].shvret, RXSHV_NEWV ) ;
   iverify( "Term exit9 ", shv[8].shvret, RXSHV_NEWV ) ;
   iverify( "Term exit10", shv[9].shvret, RXSHV_TRUNC ) ;


   sverify( "Term exit1 ", &(shv[2].shvvalue), "B-value-AR" ) ;
   sverify( "Term exit2 ", &(shv[4].shvvalue), "new value" ) ;
   sverify( "Term exit3 ", &(shv[6].shvvalue), "BAR" ) ;
   sverify( "Term exit4 ", &(shv[9].shvvalue), "hello, there! .." ) ;

   return RXEXIT_HANDLED ;
}

void vars()
{
   RXSTRING Instore[2] ;
   RXSYSEXIT Exits[4] ;
   int rc ;

   message( "vars" ) ;

   RexxRegisterExitExe( "hepp", (PFN)vars_exit, NULL ) ;

   Exits[0].sysexit_name = "hepp" ;
   Exits[0].sysexit_code = RXSIO ;
   Exits[1].sysexit_code = RXENDLST ;

   Instore[0].strptr =
     "say 'Hello'" ;
   Instore[0].strlength = strlen( Instore[0].strptr ) ;
   Instore[1].strptr = NULL ;

   rc = RexxStart( 0, NULL, "Testing", Instore, "Foo", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   RexxDeregisterExit( "hepp", NULL ) ;
}




LONG APIENTRY source_exit( LONG code, LONG subcode, PEXIT ptr )
{
   SHVBLOCK Req[6] ;

   Req[0].shvnext = &(Req[1]) ;
   Req[0].shvcode = RXSHV_PRIV ;
   Req[0].shvname.strptr = "SOURCE" ;
   Req[0].shvname.strlength = strlen( Req[0].shvname.strptr ) ;
   Req[0].shvnamelen = Req[0].shvname.strlength ;
   Req[0].shvvalue.strptr = NULL ;

   Req[1].shvnext = &(Req[2]) ;
   Req[1].shvcode = RXSHV_PRIV ;
   Req[1].shvname.strptr = "VERSION" ;
   Req[1].shvname.strlength = strlen( Req[1].shvname.strptr ) ;
   Req[1].shvnamelen = Req[1].shvname.strlength ;
   Req[1].shvvalue.strptr = NULL ;

   Req[2].shvnext = &(Req[3]) ;
   Req[2].shvcode = RXSHV_PRIV ;
   Req[2].shvname.strptr = "PARM" ;
   Req[2].shvname.strlength = strlen( Req[2].shvname.strptr ) ;
   Req[2].shvnamelen = Req[2].shvname.strlength ;
   Req[2].shvvalue.strptr = NULL ;

   Req[3].shvnext = &(Req[4]) ;
   Req[3].shvcode = RXSHV_PRIV ;
   Req[3].shvname.strptr = "PARM.1" ;
   Req[3].shvname.strlength = strlen( Req[3].shvname.strptr ) ;
   Req[3].shvnamelen = Req[3].shvname.strlength ;
   Req[3].shvvalue.strptr = NULL ;

   Req[4].shvnext = &(Req[5]) ;
   Req[4].shvcode = RXSHV_PRIV ;
   Req[4].shvname.strptr = "PARM.2" ;
   Req[4].shvname.strlength = strlen( Req[4].shvname.strptr ) ;
   Req[4].shvnamelen = Req[4].shvname.strlength ;
   Req[4].shvvalue.strptr = NULL ;

   Req[5].shvnext = NULL ;
   Req[5].shvcode = RXSHV_PRIV ;
   Req[5].shvname.strptr = "QUENAME" ;
   Req[5].shvname.strlength = strlen( Req[5].shvname.strptr ) ;
   Req[5].shvnamelen = Req[5].shvname.strlength ;
   Req[5].shvvalue.strptr = NULL ;

   iverify( "Termin exit", code, RXTER ) ;
   iverify( "Termin exit", subcode, RXTEREXT ) ;

   RexxVariablePool( Req ) ;

   iverify( "Source", Req[0].shvret, RXSHV_OK ) ;
   iverify( "Version", Req[1].shvret, RXSHV_OK ) ;
   if (memcmp(Req[1].shvvalue.strptr, "REXX", 4 ))
      mycomplain( "Invalid Rexx source string\n" ) ;

   iverify( "Parms", Req[2].shvret, RXSHV_OK ) ;
   sverify( "Parms", &(Req[2].shvvalue), "1" ) ;

   iverify( "Parm1a", Req[3].shvret, RXSHV_OK ) ;
   sverify( "Parm1b", &(Req[3].shvvalue), "one two three" ) ;

   iverify( "Parm2a", Req[4].shvret, RXSHV_OK ) ;
   sverify( "Parm2b", &(Req[4].shvvalue), NULL ) ;

   iverify( "QueName", Req[5].shvret, RXSHV_OK ) ;
   sverify( "QueName", &(Req[5].shvvalue), "default" ) ;

   return RXEXIT_HANDLED ;
}



void source( void )
{
   RXSYSEXIT Exits[2] ;
   RXSTRING Instore[2] ;
   RXSTRING Params[2] ;
   int rc ;

   message("private") ;

   RexxRegisterExitExe("hei", (PFN)source_exit, NULL ) ;

   Exits[0].sysexit_name = "hei" ;
   Exits[0].sysexit_code = RXTER ;
   Exits[1].sysexit_code = RXENDLST ;

   Params[0].strptr = "one two three" ;
   Params[0].strlength = strlen( Params[0].strptr ) ;

   Instore[0].strptr = "nop" ;
   Instore[0].strlength = strlen( Instore[0].strptr ) ;
   Instore[1].strptr = NULL ;

   rc = RexxStart( 1, Params, "Testing", Instore, "Foo", RXCOMMAND,
                   Exits, NULL, NULL ) ;

   RexxDeregisterExit( "hei", NULL ) ;
}




LONG APIENTRY parms( LONG code, LONG subcode, PEXIT ptr )
{
   RXSYSEXIT Exits[2] ;
   RXSTRING Instore[2] ;
   RXSTRING Params[5] ;
   int rc ;
   static int done = 0 ;

   if (code == -1)
   {
      message("parms") ;

      RexxRegisterExitExe("hei", (PFN)parms, NULL ) ;

      Exits[0].sysexit_name = "hei" ;
      Exits[0].sysexit_code = RXTER ;
      Exits[1].sysexit_code = RXENDLST ;

      Params[0].strptr = "one two three" ;
      Params[0].strlength = strlen( Params[0].strptr ) ;
      Params[1].strptr = NULL ;
      Params[1].strlength = 5 ;
      Params[2].strptr = "" ;
      Params[2].strlength = strlen( Params[2].strptr ) ;
      Params[3].strptr = "four five" ;
      Params[3].strlength = strlen( Params[3].strptr ) ;
      Params[4].strptr = NULL ;
      Params[4].strlength = 10 ;

      Instore[0].strptr = "nop" ;
      Instore[0].strlength = strlen( Instore[0].strptr ) ;
      Instore[1].strptr = NULL ;

      rc = RexxStart( 5, Params, "Testing", Instore, "Foo", RXFUNCTION,
                      Exits, NULL, NULL ) ;

      if (!done)
         printf("not done\n") ;

      RexxDeregisterExit( "hei", NULL ) ;
      return 0 ;
   }
   else
   {
      SHVBLOCK Req[7] ;

      done = 1 ;
      Req[0].shvnext = &(Req[1]) ;
      Req[0].shvcode = RXSHV_PRIV ;
      Req[0].shvname.strptr = "PARM" ;
      Req[0].shvname.strlength = strlen( Req[0].shvname.strptr ) ;
      Req[0].shvnamelen = Req[0].shvname.strlength ;
      Req[0].shvvalue.strptr = NULL ;

      Req[1].shvnext = &(Req[2]) ;
      Req[1].shvcode = RXSHV_PRIV ;
      Req[1].shvname.strptr = "PARM.1" ;
      Req[1].shvname.strlength = strlen( Req[1].shvname.strptr ) ;
      Req[1].shvnamelen = Req[1].shvname.strlength ;
      Req[1].shvvalue.strptr = NULL ;

      Req[2].shvnext = &(Req[3]) ;
      Req[2].shvcode = RXSHV_PRIV ;
      Req[2].shvname.strptr = "PARM.2" ;
      Req[2].shvname.strlength = strlen( Req[2].shvname.strptr ) ;
      Req[2].shvnamelen = Req[2].shvname.strlength ;
      Req[2].shvvalue.strptr = NULL ;

      Req[3].shvnext = &(Req[4]) ;
      Req[3].shvcode = RXSHV_PRIV ;
      Req[3].shvname.strptr = "PARM.3" ;
      Req[3].shvname.strlength = strlen( Req[3].shvname.strptr ) ;
      Req[3].shvnamelen = Req[3].shvname.strlength ;
      Req[3].shvvalue.strptr = NULL ;

      Req[4].shvnext = &(Req[5]) ;
      Req[4].shvcode = RXSHV_PRIV ;
      Req[4].shvname.strptr = "PARM.4" ;
      Req[4].shvname.strlength = strlen( Req[4].shvname.strptr ) ;
      Req[4].shvnamelen = Req[4].shvname.strlength ;
      Req[4].shvvalue.strptr = NULL ;

      Req[5].shvnext = &(Req[6]) ;
      Req[5].shvcode = RXSHV_PRIV ;
      Req[5].shvname.strptr = "PARM.5" ;
      Req[5].shvname.strlength = strlen( Req[5].shvname.strptr ) ;
      Req[5].shvnamelen = Req[5].shvname.strlength ;
      Req[5].shvvalue.strptr = NULL ;

      Req[6].shvnext = NULL ;
      Req[6].shvcode = RXSHV_PRIV ;
      Req[6].shvname.strptr = "PARM.6" ;
      Req[6].shvname.strlength = strlen( Req[6].shvname.strptr ) ;
      Req[6].shvnamelen = Req[6].shvname.strlength ;
      Req[6].shvvalue.strptr = NULL ;

      iverify( "Termin exit", code, RXTER ) ;
      iverify( "Termin exit", subcode, RXTEREXT ) ;

      RexxVariablePool( Req ) ;

      iverify( "Parm", Req[0].shvret, RXSHV_OK ) ;
      sverify( "Parm", &(Req[0].shvvalue), "5" ) ;

      iverify( "Parm1", Req[1].shvret, RXSHV_OK ) ;
      sverify( "Parm1", &(Req[1].shvvalue), "one two three" ) ;

      iverify( "Parm2", Req[2].shvret, RXSHV_OK ) ;
      sverify( "Parm2", &(Req[2].shvvalue), NULL ) ;

      iverify( "Parm3", Req[3].shvret, RXSHV_OK ) ;
      sverify( "Parm3", &(Req[3].shvvalue), "" ) ;

      iverify( "Parm4", Req[4].shvret, RXSHV_OK ) ;
      sverify( "Parm4", &(Req[4].shvvalue), "four five" ) ;

      iverify( "Parm5", Req[5].shvret, RXSHV_OK ) ;
      sverify( "Parm5", &(Req[5].shvvalue), NULL ) ;

      iverify( "Parm6", Req[6].shvret, RXSHV_OK ) ;
      sverify( "Parm6", &(Req[6].shvvalue), NULL ) ;

      return RXEXIT_HANDLED ;
   }
}





LONG APIENTRY allvars( LONG code, LONG subcode, PEXIT ptr )
{
   RXSYSEXIT Exits[2] ;
   RXSTRING Instore[2] ;
   RXSTRING Params[5] ;
   int rc ;
   static int done = 0 ;

   if (code == -1)
   {
      message("allvars") ;

      RexxRegisterExitExe("hei", (PFN)allvars, NULL ) ;

      Exits[0].sysexit_name = "hei" ;
      Exits[0].sysexit_code = RXTER ;
      Exits[1].sysexit_code = RXENDLST ;

      Params[0].strptr = "one two three" ;
      Params[0].strlength = strlen( Params[0].strptr ) ;
      Params[1].strptr = NULL ;
      Params[1].strlength = 5 ;
      Params[2].strptr = "" ;
      Params[2].strlength = strlen( Params[2].strptr ) ;
      Params[3].strptr = "four five" ;
      Params[3].strlength = strlen( Params[3].strptr ) ;
      Params[4].strptr = NULL ;
      Params[4].strlength = 10 ;

      Instore[0].strptr = "foo='one';bar='';foo.='two';foo.bar='three';"
                          "foo.4='four';foo.5='five';drop foo.5 foo.6" ;

      Instore[0].strlength = strlen( Instore[0].strptr ) ;
      Instore[1].strptr = NULL ;

      rc = RexxStart( 5, Params, "Testing", Instore, "Foo", RXFUNCTION,
                      Exits, NULL, NULL ) ;

      if (!done)
         printf("not done\n") ;

      RexxDeregisterExit( "hei", NULL ) ;
      return 0 ;
   }
   else
   {
      SHVBLOCK Req[10] ;
      int i ;

      done = 1 ;
      for (i=0; i<10; i++)
      {
          Req[i].shvnext = (i<10-1) ? (&(Req[i+1])) : NULL ;
          Req[i].shvcode = RXSHV_NEXTV ;
          Req[i].shvname.strptr = Req[i].shvvalue.strptr = NULL ;
      }

      iverify( "Termin exit", code, RXTER ) ;
      iverify( "Termin exit", subcode, RXTEREXT ) ;

      RexxVariablePool( Req ) ;

      iverify( "Parm0", Req[0].shvret, RXSHV_OK ) ;
      sverify( "Parm0a", &(Req[0].shvname), "BAR" ) ;
      sverify( "Parm0b", &(Req[0].shvvalue), "" ) ;

      iverify( "Parm1", Req[1].shvret, RXSHV_OK ) ;
      sverify( "Parm1a", &(Req[1].shvname), "FOO." ) ;
      sverify( "Parm1b", &(Req[1].shvvalue), "three" ) ;

      iverify( "Parm2", Req[2].shvret, RXSHV_OK ) ;
      sverify( "Parm2a", &(Req[2].shvname), "FOO.4" ) ;
      sverify( "Parm2b", &(Req[2].shvvalue), "four" ) ;

      iverify( "Parm3", Req[3].shvret, RXSHV_OK ) ;
      sverify( "Parm3a", &(Req[3].shvname), "FOO.5" ) ;
      sverify( "Parm3b", &(Req[3].shvvalue), "FOO.5" ) ;

      iverify( "Parm4", Req[4].shvret, RXSHV_OK ) ;
      sverify( "Parm4a", &(Req[4].shvname), "FOO.6" ) ;
      sverify( "Parm4b", &(Req[4].shvvalue), "FOO.6" ) ;

      iverify( "Parm5", Req[5].shvret, RXSHV_OK ) ;
      sverify( "Parm5a", &(Req[5].shvname), "FOO." ) ;
      sverify( "Parm5b", &(Req[5].shvvalue), "two" ) ;

      iverify( "Parm6", Req[6].shvret, RXSHV_OK ) ;
      sverify( "Parm6a", &(Req[6].shvname), "FOO" ) ;
      sverify( "Parm6b", &(Req[6].shvvalue), "one" ) ;

      iverify( "Parm", Req[7].shvret, RXSHV_LVAR ) ;
      iverify( "Parm", Req[8].shvret, RXSHV_OK ) ;
      iverify( "Parm", Req[9].shvret, RXSHV_OK ) ;

      return RXEXIT_HANDLED ;
   }
}






ULONG APIENTRY extfunc( PUCHAR name, ULONG params, RXSTRING *parm, PSZ stck, RXSTRING *ptr )
{
   RXSTRING Instore[2] ;
   RXSTRING Result ;
   int rc ;
   short nret ;
   static int done = 0 ;

   if (name == NULL)
   {
      message("extfunc") ;

      RexxRegisterFunctionExe("EXTFUNC", (PFN)extfunc ) ;

      Instore[0].strptr = "return extfunc('asdf','qwer',,'zxcv') + 'EXTFUNC'('asdf',,'wer','werrew')" ;
      Instore[0].strlength = strlen( Instore[0].strptr ) ;
      Instore[1].strptr = NULL ;

      Result.strlength = 10 ;
      Result.strptr = RexxAllocateMemory( 10 ) ;

      rc = RexxStart( 0, NULL, "Testing", Instore, "Foo", RXFUNCTION,
                      NULL, &nret, &Result ) ;

      sverify( "extfunc", &Result, "7" ) ;
      iverify( "extfunc", nret, 7 ) ;

      if (!done)
         printf("not done\n") ;

      RexxDeregisterFunction( "EXTFUNC" ) ;
      return 0 ;
   }
   else
   {
      static int once=0 ;

      done = 1 ;
      if (!once)
      {
         ptr->strptr[0] = '3' ;
         ptr->strlength = 1 ;
         once = 1 ;
      }
      else
      {
         ptr->strptr[0] = '4' ;
         ptr->strlength = 1 ;
      }
      return 0 ;
   }
}

LONG APIENTRY subcom_exit( LONG ExNum, LONG Subfun, PEXIT PBlock )
{
#ifdef UNION_EXIT
#else
   RXCMDHST_PARM *pcmdhst;
#endif

   iverify( "Subcom Funcion", ExNum, RXCMD ) ;
   iverify( "Subcom Subfunc", Subfun, RXCMDHST ) ;
#ifdef UNION_EXIT
   sverify( "Subcom Command", &(PBlock->cmdhst.rxcmd_command), "foobar asdf qwer" ) ;
   PBlock->cmdhst.rxcmd_retc.strlength = 2;
   strcpy(PBlock->cmdhst.rxcmd_retc.strptr,"16");
#else
   pcmdhst = (RXCMDHST_PARM *)PBlock;
   pcmdhst->rxcmd_retc.strlength = 2;
   strcpy(pcmdhst->rxcmd_retc.strptr,"16");
#endif

   return RXEXIT_HANDLED ;
}

ULONG APIENTRY run_subcom(PRXSTRING Command, PUSHORT Flags, PRXSTRING Retstr)
{
   RXSYSEXIT Exits[4] ;
   RXSTRING Instore[2] ;
   RXSTRING Result ;
   int rc ;
   short nret ;

   if (Command == NULL)
   {
      message("subcom") ;

      RexxRegisterExitExe( "slhepp", (PFN)subcom_exit, NULL ) ;

      Exits[0].sysexit_name = "slhepp" ;
      Exits[0].sysexit_code = RXCMD ;
      Exits[1].sysexit_code = RXENDLST ;

      RexxRegisterSubcomExe("SUBCOM", (PFN)run_subcom, NULL ) ;

      Instore[0].strptr = "'foobar asdf qwer'" ;
      Instore[0].strlength = strlen( Instore[0].strptr ) ;
      Instore[1].strptr = NULL ;

      Result.strlength = 20 ;
      Result.strptr = RexxAllocateMemory( 20 ) ;

      rc = RexxStart( 0, NULL, "Testing", Instore, "SUBCOM", RXCOMMAND,
                      Exits, &nret, &Result ) ;

/*      sverify( "subcom result", &Result, "16" ) ; */
/*      iverify( "subcom retc", nret, 16 ) ; */

      RexxDeregisterSubcom( "SUBCOM" , NULL) ;
      RexxDeregisterExit( "slhepp", NULL ) ;

      return 0 ;
   }
   else
   {
      sprintf(Retstr->strptr,"%ld",Command->strlength) ;
      Retstr->strlength = strlen(Retstr->strptr);
      *Flags = RXSUBCOM_OK;
      return 0 ;
   }

}

void (*(routines[]))() = {
    instore,
    trace,
    intertrc,
    pull,
    init_term,
    vars,
    source,
    NULL
} ;


RexxExitHandler *(exits[]) = {
   parms,
   allvars,
   NULL
} ;


RexxFunctionHandler *(efuncs[]) = {
   extfunc,
   NULL
} ;

RexxSubcomHandler *(scfuncs[]) = {
   run_subcom,
   NULL
} ;


int main( int argc, char *argv[] )
{
   void (**fptr)( void ) ;
   RexxExitHandler **eptr ;
   RexxFunctionHandler **gptr ;
   RexxSubcomHandler **sptr;

   printf( "Regina Rexx API Tester\n" );
   printf( "----------------------\n" );
   for( fptr=routines; *fptr; fptr++ )
      (*fptr)() ;

   for( eptr=exits; *eptr; eptr++ )
      (*eptr)( -1, -1, NULL ) ;

   for( gptr=efuncs; *gptr; gptr++ )
      (*gptr)( NULL, 0, NULL, NULL, NULL ) ;

   for( sptr=scfuncs; *sptr; sptr++ )
      (*sptr)( NULL, 0, NULL ) ;

   printf( "\n" ) ;
   return 0 ;

}

