/*
 *
 */
Trace O
validargs = '-s -d -a -A -p -P -S -l -L -u'
vars = '_srcdir _tmpdir _abiminor _abimajor _rxlibpre _rxlibpst _shl _libpre _libpst _useabi'
mandatory = '1 1 1 1 1 1 1 1 1 1'
valuereq  = '1 1 1 1 0 0 0 0 0 1'
If ValidOpts( Arg(1), validargs, mandatory, valuereq ) = 0 Then
exes = 'rexx regina rxqueue rxstack'
Parse Source os .
Select
   When os = 'BEOS' Then
      Do
         from = 'COPYING-LIB BUGS       TODO       README.BeOS README.2?  demo/*.rexx rexxsaa.h' /**/
         to =   'doc/regina  doc/regina doc/regina doc/regina  doc/regina bin         headers'
         extn_dir = 'add-ons/rexx'
      End
   Otherwise
      Do
         from = 'COPYING-LIB BUGS       TODO       README.Unix README.2?  rexx.1   demo/*.rexx rexxsaa.h' /**/
         to =   'doc/regina  doc/regina doc/regina doc/regina  doc/regina man/man1 rexx        include'
         extn_dir = 'lib'
      End
End

Do i = 1 To Words(exes)
   fn = Word(exes,i)
   If Stream(fn, 'C', 'QUERY EXISTS') \= '' Then Call copy fn,_tmpdir'/bin'
End
/*
 * Copy test libraries if they exist
 */
fn = _rxlibpre || 'test1' || _rxlibpst
If Stream( fn, 'C', 'QUERY EXISTS') \= '' Then Call copy fn,_tmpdir'/'extn_dir
fn = _rxlibpre || 'test2' || _rxlibpst
If Stream( fn, 'C', 'QUERY EXISTS') \= '' Then Call copy fn,_tmpdir'/'extn_dir
/*
 * Copy static library
 */
fn = _libpre'regina.'_libpst
If Stream( fn, 'C', 'QUERY EXISTS') \= '' Then Call copy fn,_tmpdir'/lib'

/*
 * Copy shared library
 */
fn = _libpre'regina.'_shl
If _useabi = 'yes' Then
   Do
      fn_abi_major = fn'.'_abimajor
      fn_abi = fn_abi_major'.'_abiminor
      If Stream( fn_abi, 'C', 'QUERY EXISTS') \= '' Then Call copy fn_abi,_tmpdir'/lib'
      Address System 'ln -s' _tmpdir'/lib/'fn_abi _tmpdir'/lib/'fn_abi_major
      Address System 'ln -s' _tmpdir'/lib/'fn_abi _tmpdir'/lib/'fn
   End
Else
   Do
      If Stream( fn, 'C', 'QUERY EXISTS') \= '' Then Call copy fn,_tmpdir'/lib'
   End
/*
 * Copy all files in 'from' variable to their appropriate
 * destination in 'to'.
 */
Do i = 1 To Words(from)
  Call copy _srcdir'/'Word(from,i),_tmpdir'/'Word(to,i)
End
Return 0

Copy: Procedure
Parse Arg from, to
Address System 'cp' from to
Return 0

/*
 * Validate the input arguments
 */
ValidOpts: Procedure Expose (vars)
Parse Arg args, validargs, mandatory, valuereq
Do i = 1 To Words(args)
   optarg = Word(args,i)
   Do j = 1 To Words(validargs)
      If Substr(optarg,1,Length(Word(validargs,j))) = Word(validargs,j) Then
         Do
            optval = Strip(Substr(optarg,1+Length(Word(validargs,j))))
            optvar = Word(vars,j)
            Interpret optvar "=optval"
            Leave j
         End
   End
End
error = 0
Do i = 1 To Words(vars)
   Select
      When Translate(Value(Word(vars,i))) = Translate(Word(vars,i)) & Word(mandatory,i) = 1 Then
         Do
            Say 'Mandatory parameter' Word(validargs,i) 'not supplied'
            error = 1
         End
      When Word(valuereq,i) = 1 & Value(Word(vars,i)) = '' Then
         Do
            Say 'No value supplied for parameter' Word(validargs,i)
            error = 1
         End
      Otherwise Nop
   End
End

Return error
