/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "OXConnectionOptions.h"

#include <xclass/OXClient.h>
#include <xclass/OXTransientFrame.h>
#include <xclass/OXButton.h>
#include <xclass/OXTextButton.h>
#include <xclass/OXCheckButton.h>
#include <xclass/OXRadioButton.h>
#include <xclass/OXGroupFrame.h>
#include <xclass/OXLabel.h>
#include <xclass/OXSpinner.h>
#include <xclass/OString.h>
#include <xclass/OXFont.h>
#include <xclass/OXIcon.h>
#include <xclass/OPicture.h>

namespace rfb {

class OXConnectionOptions : public OXTransientFrame {
public:
  OXConnectionOptions(ConnectionInfo &info, const OXWindow *p, const OXWindow *m, int w = 438, int h = 231);
  virtual ~OXConnectionOptions();

  virtual int ProcessMessage(OMessage *msg);

protected:

  ConnectionInfo *connectionInfo;

  OXRadioButton *radioButtonHextile;
  OXRadioButton *radioButtonCoRRE;
  OXRadioButton *radioButtonRRE;
  OXRadioButton *radioButtonRaw;
  OXCheckButton *checkButtonCopyRect;

  OXCheckButton *checkButtonShared;
//  OXCheckButton *checkButtonDeiconify;
  OXCheckButton *checkButtonDisableTransfer;
  OXCheckButton *checkButtonUseZlib;
  OXSpinner     *spinnerUseZlib;

  OXCheckButton *checkButtonFramerate;
  OXSpinner     *spinnerFramerate;
  OXCheckButton *checkButtonMovements;
  OXSpinner     *spinnerMovements;
/*
  OXCheckButton *checkButtonEmulate;
  OXCheckButton *checkButtonSwap;
*/

  OXCheckButton *checkButtonRestrict;
  OXCheckButton *checkButtonViewonly;
  OXCheckButton *checkButtonFullscreen;
  OXCheckButton *checkButtonScale;
  OXTextEntry   *entryMul;
  OXTextEntry   *entryDiv;
  OXCheckButton *checkButtonScaleSmooth;

  OLayoutHints *_lh;
};


void getConnectionOptions( ConnectionInfo &info, const OXWindow *p, const OXWindow *m ) {
  new OXConnectionOptions( info, p, m );
}


OXConnectionOptions::OXConnectionOptions(ConnectionInfo &info, const OXWindow *p, const OXWindow *m, int w, int h) 
  : OXTransientFrame(p, m, w, h, 0)
  , connectionInfo( &info )
{
  
  OFontPool *fp = new OFontPool( _client );
  OXFont *font = fp->GetFont("-adobe-helvetica-medium-r-normal-*-11-*-*-*-*-*-*-*");

  ChangeOptions((GetOptions() & ~VERTICAL_FRAME) | HORIZONTAL_FRAME);

  SetWindowName("Connection Options...");

  OXCompositeFrame *frameLeft = new OXCompositeFrame(this, 60, 20, VERTICAL_FRAME | FIXED_WIDTH);
  OXCompositeFrame *frameRight = new OXCompositeFrame(this, 60, 20, VERTICAL_FRAME | FIXED_WIDTH);
  
  OXGroupFrame *groupFrameEncoding = new OXGroupFrame( frameLeft, new OString("Preferred encoding"));
  OXGroupFrame *groupFrameMisc     = new OXGroupFrame( frameLeft, new OString("Misc"));
  OXCompositeFrame *frameButtons   = new OXCompositeFrame( frameRight, 60, 20, HORIZONTAL_FRAME | FIXED_WIDTH);

  radioButtonHextile = new OXRadioButton( groupFrameEncoding, new OHotString("Hextile"), 101 );
  radioButtonCoRRE   = new OXRadioButton( groupFrameEncoding, new OHotString("CoRRE"),   102 );
  radioButtonRRE     = new OXRadioButton( groupFrameEncoding, new OHotString("RRE"),     103 );
  radioButtonRaw     = new OXRadioButton( groupFrameEncoding, new OHotString("Raw"),     104 );
  checkButtonCopyRect= new OXCheckButton( groupFrameEncoding, new OHotString("Allow CopyRect encoding"), -1 );
  radioButtonHextile->SetFont( font );
  radioButtonCoRRE->SetFont( font );
  radioButtonRRE->SetFont( font );
  radioButtonRaw->SetFont( font );
  checkButtonCopyRect->SetFont( font );


//  radioButtonHextile->SetState( BUTTON_DOWN );
//  checkButtonCopyRect->SetState( BUTTON_DOWN );

  radioButtonHextile->Associate(this);
  radioButtonCoRRE  ->Associate(this);
  radioButtonRRE    ->Associate(this);
  radioButtonRaw    ->Associate(this);


  checkButtonShared = new OXCheckButton( groupFrameMisc, new OHotString("Request shared session"), -1 );
  checkButtonShared->SetFont( font );
//  checkButtonDeiconify = new OXCheckButton( groupFrameMisc, new OHotString("Deiconify on Bell"), -1 );
//  checkButtonDeiconify->SetFont( font );
//  checkButtonDeiconify->Disable();
  checkButtonDisableTransfer = new OXCheckButton( groupFrameMisc, new OHotString("Disable clipboard transfer"), -1 );
  checkButtonDisableTransfer->SetFont( font );
  checkButtonDisableTransfer->Disable();


  OXCompositeFrame *frameUseZlib = new OXCompositeFrame( groupFrameMisc, 60, 20, HORIZONTAL_FRAME | FIXED_WIDTH);

  checkButtonUseZlib = new OXCheckButton( frameUseZlib, new OHotString("use Zlib: level "), -1 );
  checkButtonUseZlib->SetFont( font );

  spinnerUseZlib = new OXSpinner( frameUseZlib,"Framerate", 111);
  spinnerUseZlib->SetEditable(true);
  spinnerUseZlib->SetPrec(0);
  spinnerUseZlib->SetPercent(false);
  spinnerUseZlib->SetRollOver(false);
  spinnerUseZlib->SetRange(1, 9, 1.0);
  spinnerUseZlib->Resize(32, spinnerUseZlib->GetDefaultHeight());

  _lh = new OLayoutHints(LHINTS_CENTER_Y | LHINTS_LEFT, 0, 0, 0, 0);
  frameUseZlib->AddFrame( checkButtonUseZlib, _lh );
  frameUseZlib->AddFrame( spinnerUseZlib, _lh );

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, -4, 0, 6, 0);
  groupFrameEncoding->AddFrame( radioButtonHextile, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, -4, 0, 4, 0);
  groupFrameEncoding->AddFrame( radioButtonCoRRE,   _lh );
  groupFrameEncoding->AddFrame( radioButtonRRE,     _lh );
  groupFrameEncoding->AddFrame( radioButtonRaw,     _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, -4, 0, 10, -3);
  groupFrameEncoding->AddFrame( checkButtonCopyRect,     _lh );

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, -4, 0, 3, 0);
  groupFrameMisc->AddFrame( checkButtonShared, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, -4, 0, 3, 0);
//  groupFrameMisc->AddFrame( checkButtonDeiconify, _lh );
  groupFrameMisc->AddFrame( checkButtonDisableTransfer, _lh );

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_EXPAND_X, -4, 0, 0, -10);
  groupFrameMisc->AddFrame( frameUseZlib, _lh );



  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_EXPAND_X, 10, 0, 8, 0);
  frameLeft->AddFrame( groupFrameEncoding, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_EXPAND_X, 10, 0, 4, 0);
  frameLeft->AddFrame( groupFrameMisc, _lh );

  frameLeft->Resize( groupFrameEncoding->GetDefaultWidth()+4, GetDefaultHeight() );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 0, 0, 0, 0);
  AddFrame( frameLeft, _lh );


  OXGroupFrame *groupFrameLimits = new OXGroupFrame( frameRight, new OString("Limits"));
  OXGroupFrame *groupFrameDisplay = new OXGroupFrame( frameRight, new OString("Display"));

  OXCompositeFrame *frameFramerate = new OXCompositeFrame( groupFrameLimits, 60, 20, HORIZONTAL_FRAME | FIXED_WIDTH);

  checkButtonFramerate = new OXCheckButton( frameFramerate, new OHotString("framerate: max "), -1 );
  checkButtonFramerate->SetFont( font );

  spinnerFramerate = new OXSpinner( frameFramerate,"Framerate", 112);

  spinnerFramerate->SetEditable(true);
  spinnerFramerate->SetPrec(0);
  spinnerFramerate->SetPercent(false);
  spinnerFramerate->SetRollOver(false);
  spinnerFramerate->SetRange(1, 30, 1.0);

  spinnerFramerate->Resize(40, spinnerFramerate->GetDefaultHeight());

  OXLabel *labelFPS = new OXLabel( frameFramerate, new OString(" fps") );
  labelFPS->SetFont( font );


  _lh = new OLayoutHints(LHINTS_CENTER_Y | LHINTS_LEFT, 0, 0, 0, 0);
  frameFramerate->AddFrame( checkButtonFramerate, _lh );
  frameFramerate->AddFrame( spinnerFramerate, _lh );
  frameFramerate->AddFrame( labelFPS, _lh );

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_EXPAND_X, -4, 0, 2, 0);
  groupFrameLimits->AddFrame( frameFramerate, _lh );


  OXCompositeFrame *frameMovements = new OXCompositeFrame( groupFrameLimits, 60, 20, HORIZONTAL_FRAME | FIXED_WIDTH);

  checkButtonMovements = new OXCheckButton( frameMovements, new OHotString("mouse movement: max "), -1 );
  checkButtonMovements->SetFont( font );

  spinnerMovements = new OXSpinner( frameMovements,"Movements", 112);

  spinnerMovements->SetEditable(true);
  spinnerMovements->SetPrec(0);
  spinnerMovements->SetPercent(false);
  spinnerMovements->SetRollOver(false);
  spinnerMovements->SetRange(1, 30, 1.0);

  spinnerMovements->Resize(40, spinnerMovements->GetDefaultHeight());

  OXLabel *labelMovements = new OXLabel( frameMovements, new OString(" moves/sec") );
  labelMovements->SetFont( font );

  _lh = new OLayoutHints(LHINTS_CENTER_Y | LHINTS_LEFT, 0, 0, 0, 0);
  frameMovements->AddFrame( checkButtonMovements, _lh );
  frameMovements->AddFrame( spinnerMovements, _lh );
  frameMovements->AddFrame( labelMovements, _lh );

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_EXPAND_X, -4, -6, 2, -9);
  groupFrameLimits->AddFrame( frameMovements, _lh );

/*
  checkButtonEmulate = new OXCheckButton( groupFrameMouse, new OHotString("Emulate 3 Buttons (with 2-button click)"), -1 );
  checkButtonEmulate->SetFont( font );
  checkButtonEmulate->Disable();
  checkButtonSwap = new OXCheckButton( groupFrameMouse, new OHotString("Swap mouse buttons 2 and 3"), -1 );
  checkButtonSwap->SetFont( font );
  checkButtonSwap->Disable();

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, -4, 0, 3, 0);
  groupFrameMouse->AddFrame( checkButtonEmulate, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, -4, 0, 3, -6);
  groupFrameMouse->AddFrame( checkButtonSwap, _lh );
*/


  checkButtonRestrict = new OXCheckButton( groupFrameDisplay, new OHotString("Restrict pixels to 8-bit (for slow networks)"), -1 );
  checkButtonRestrict->SetFont( font );
  checkButtonViewonly = new OXCheckButton( groupFrameDisplay, new OHotString("View only (inputs ignored)"), -1 );
  checkButtonViewonly->SetFont( font );
  checkButtonFullscreen = new OXCheckButton( groupFrameDisplay, new OHotString("Full-screen mode"), -1 );
  checkButtonFullscreen->SetFont( font );
  checkButtonFullscreen->Disable();

  OXCompositeFrame *frameScale   = new OXCompositeFrame( groupFrameDisplay, 60, 20, HORIZONTAL_FRAME | FIXED_WIDTH);

  checkButtonScale = new OXCheckButton( frameScale, new OHotString("Scale by"), -1 );
  checkButtonScale->SetFont( font );
  entryMul = new OXTextEntry( frameScale, new OTextBuffer(3) );
  entryMul->Resize( 24, entryMul->GetDefaultHeight()-2 );
  OXLabel *labelSep = new OXLabel( frameScale, new OString("/") );
  entryDiv = new OXTextEntry( frameScale, new OTextBuffer(3) );
  entryDiv->Resize( 24, entryDiv->GetDefaultHeight()-2 );
  checkButtonScaleSmooth = new OXCheckButton( frameScale, new OHotString("smooth"), -1 );
  checkButtonScaleSmooth->SetFont( font );

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 0, 4, 3, 0);
  frameScale->AddFrame( checkButtonScale, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 0, 4, 0, 0);
  frameScale->AddFrame( entryMul, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 0, 4, 3, 0);
  frameScale->AddFrame( labelSep, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 0, 4, 0, 0);
  frameScale->AddFrame( entryDiv, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 0, 4, 3, 0);
  frameScale->AddFrame( checkButtonScaleSmooth, _lh );


  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, -4, 0, 3, 0);
  groupFrameDisplay->AddFrame( checkButtonRestrict, _lh );
  groupFrameDisplay->AddFrame( checkButtonViewonly, _lh );
  groupFrameDisplay->AddFrame( checkButtonFullscreen, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_EXPAND_X, -4, 0, 1, -10);
  groupFrameDisplay->AddFrame( frameScale, _lh );





  
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_EXPAND_X, 12, 10, 8, 0);
  frameRight->AddFrame( groupFrameLimits, _lh );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_EXPAND_X, 12, 10, 4, 0);
  frameRight->AddFrame( groupFrameDisplay, _lh );

  OXButton *buttonOK = new OXTextButton( frameButtons, new OString("      OK      "), 105 );
  OXButton *buttonCancel = new OXTextButton( frameButtons, new OString("   Cancel   "), 106 );
  buttonOK->Associate( this );
  buttonCancel->Associate( this );

  SetDefaultAcceptButton(buttonOK);
  SetDefaultCancelButton(buttonCancel);

  _lh = new OLayoutHints(LHINTS_BOTTOM | LHINTS_LEFT, 10, 0, 0, 0);
  frameButtons->AddFrame( buttonOK, _lh );
  frameButtons->AddFrame( buttonCancel, _lh );

  frameButtons->Resize( buttonOK->GetDefaultWidth()+buttonCancel->GetDefaultWidth()+20, frameButtons->GetDefaultHeight() );

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_RIGHT, 0, 10, 16, 0);
  frameRight->AddFrame( frameButtons, _lh );

//  frameRight->Resize( groupFrameMouse->GetDefaultWidth()+20, GetDefaultHeight() );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT | LHINTS_EXPAND_X, 0, 0, 0, 0);
  AddFrame( frameRight, _lh );


  switch ( connectionInfo->preferredEncoding ) {
    case 0: radioButtonRaw    ->SetState( BUTTON_DOWN ); break;
    case 2: radioButtonRRE    ->SetState( BUTTON_DOWN ); break;
    case 4: radioButtonCoRRE  ->SetState( BUTTON_DOWN ); break;
    case 5: radioButtonHextile->SetState( BUTTON_DOWN ); break;
    default: break;
  }
  if ( connectionInfo->allowCopyRect            ) checkButtonCopyRect       ->SetState( BUTTON_DOWN );

  if ( connectionInfo->requestSharedSession     ) checkButtonShared         ->SetState( BUTTON_DOWN );
//  if ( connectionInfo->deiconifyOnBell          ) checkButtonDeiconify      ->SetState( BUTTON_DOWN );
  if ( connectionInfo->disableClipboardTransfer ) checkButtonDisableTransfer->SetState( BUTTON_DOWN );
  if ( connectionInfo->useZlib                  ) checkButtonUseZlib        ->SetState( BUTTON_DOWN );
  if ( connectionInfo->useZlib                  ) spinnerUseZlib            ->SetValue( connectionInfo->useZlib );
                                             else spinnerUseZlib            ->SetValue( 9 );

  if ( connectionInfo->framerate                ) checkButtonFramerate      ->SetState( BUTTON_DOWN );
  if ( connectionInfo->framerate                ) spinnerFramerate          ->SetValue( connectionInfo->framerate );
                                             else spinnerFramerate          ->SetValue( 20 );
/*
  if ( connectionInfo->emulate3Buttons          ) checkButtonEmulate        ->SetState( BUTTON_DOWN );
  if ( connectionInfo->swapMouseButtons         ) checkButtonSwap           ->SetState( BUTTON_DOWN );
*/
  if ( connectionInfo->restrictPixels           ) checkButtonRestrict       ->SetState( BUTTON_DOWN );
  if ( connectionInfo->viewOnly                 ) checkButtonViewonly       ->SetState( BUTTON_DOWN );
  if ( connectionInfo->fullscreenMode           ) checkButtonFullscreen     ->SetState( BUTTON_DOWN );
  if ( connectionInfo->scale                    ) checkButtonScale          ->SetState( BUTTON_DOWN );
  if ( connectionInfo->scaleSmooth              ) checkButtonScaleSmooth    ->SetState( BUTTON_DOWN );

  char tmp[16];
  sprintf( tmp, "%i", connectionInfo->scaleFactor );
  entryMul->AddText( 0, tmp );
  sprintf( tmp, "%i", connectionInfo->scaleDivisor );
  entryDiv->AddText( 0, tmp );

  SetFocusOwner( radioButtonHextile );

  Resize(GetDefaultSize());
  Resize(w, h);
  SetWMSize(w, h);
  SetWMSizeHints(w, h, w, h, 0, 0);
  MapSubwindows();

  Move((_client->GetDisplayWidth() - GetWidth()) >> 1,
       (_client->GetDisplayHeight() - GetHeight()) >> 1);

  SetMWMHints(MWM_DECOR_ALL | MWM_DECOR_MAXIMIZE | MWM_DECOR_MENU,
              MWM_FUNC_ALL | MWM_FUNC_MAXIMIZE | MWM_FUNC_RESIZE,
              MWM_INPUT_MODELESS);

  MapWindow();
  _client->WaitFor( this );
}

OXConnectionOptions::~OXConnectionOptions()
{
}



int OXConnectionOptions::ProcessMessage(OMessage *msg) {
  OWidgetMessage *wmsg = (OWidgetMessage *) msg;

  switch(msg->action) {
    case MSG_CLICK:
      switch(msg->type) {
        case MSG_BUTTON:

// Button OK
          if ( wmsg->id == 105 ) {
	    if ( radioButtonHextile->GetState() == BUTTON_DOWN ) connectionInfo->preferredEncoding = 5;
	    if ( radioButtonCoRRE  ->GetState() == BUTTON_DOWN ) connectionInfo->preferredEncoding = 4;
	    if ( radioButtonRRE    ->GetState() == BUTTON_DOWN ) connectionInfo->preferredEncoding = 2;
	    if ( radioButtonRaw    ->GetState() == BUTTON_DOWN ) connectionInfo->preferredEncoding = 0;
	    connectionInfo->allowCopyRect            = ( checkButtonCopyRect       ->GetState() == BUTTON_DOWN );

	    connectionInfo->requestSharedSession     = ( checkButtonShared         ->GetState() == BUTTON_DOWN );
//	    connectionInfo->deiconifyOnBell          = ( checkButtonDeiconify      ->GetState() == BUTTON_DOWN );
	    connectionInfo->disableClipboardTransfer = ( checkButtonDisableTransfer->GetState() == BUTTON_DOWN );

	    connectionInfo->useZlib = (checkButtonUseZlib->GetState() == BUTTON_DOWN)?
               (int) spinnerUseZlib->GetValue() : 0;
/*
	    connectionInfo->emulate3Buttons          = ( checkButtonEmulate        ->GetState() == BUTTON_DOWN );
	    connectionInfo->swapMouseButtons         = ( checkButtonSwap           ->GetState() == BUTTON_DOWN );
*/
	    connectionInfo->framerate = (checkButtonFramerate->GetState() == BUTTON_DOWN)?
               (int) spinnerFramerate->GetValue() : 0;


	    connectionInfo->restrictPixels           = ( checkButtonRestrict       ->GetState() == BUTTON_DOWN );
	    connectionInfo->viewOnly                 = ( checkButtonViewonly       ->GetState() == BUTTON_DOWN );
	    connectionInfo->fullscreenMode           = ( checkButtonFullscreen     ->GetState() == BUTTON_DOWN );
	    connectionInfo->scale                    = ( checkButtonScale          ->GetState() == BUTTON_DOWN );
	    connectionInfo->scaleFactor  = atoi( entryMul->GetString() );
	    connectionInfo->scaleDivisor = atoi( entryDiv->GetString() );
	    connectionInfo->scaleSmooth              = ( checkButtonScaleSmooth    ->GetState() == BUTTON_DOWN );

	    delete this;
	  }

// Button Cancel
          if ( wmsg->id == 106 ) {
	    delete this;
	  }
	  break;
        case MSG_RADIOBUTTON:
          if (wmsg->id >= 101 && wmsg->id <= 104) {
            if (radioButtonHextile->WidgetID() != wmsg->id) radioButtonHextile->SetState(BUTTON_UP);
            if (radioButtonCoRRE  ->WidgetID() != wmsg->id) radioButtonCoRRE  ->SetState(BUTTON_UP);
            if (radioButtonRRE    ->WidgetID() != wmsg->id) radioButtonRRE    ->SetState(BUTTON_UP);
            if (radioButtonRaw    ->WidgetID() != wmsg->id) radioButtonRaw    ->SetState(BUTTON_UP);
          }
          break;

        default:
          break;
      }
      break;

    default:
      break;
  }

  return True;
}


}
