/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */


#include <iostream>

#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <xclass/utils.h>
#include <xclass/OXClient.h>
#include <xclass/OXWindow.h>
#include <xclass/OXMainFrame.h>
#include <xclass/OXFileDialog.h>
#include <xclass/OFileHandler.h>
#include <xclass/OTimer.h>
#include <xclass/OXMenu.h>
#include <xclass/OXSlider.h>

#include <xclass/OXMsgBox.h>

#include <xclass/OXButton.h>
#include <xclass/OXComboBox.h>
#include <xclass/OXLabel.h>
#include <xclass/OString.h>
#include <xclass/OXFont.h>
#include <xclass/OXIcon.h>
#include <xclass/OPicture.h>
#include <xclass/OXCanvas.h>

#include "../icons/begin.xpm"
#include "../icons/rewind.xpm"
#include "../icons/play.xpm"
#include "../icons/eject.xpm"
#include "../icons/forward.xpm"
#include "../icons/end.xpm"
#include "../icons/fbs_player.xpm"


#include "rfb.h"
#include "OXAbout.h"
#include "version.h"




class OXFBSPlayerMainFrame: public OXMainFrame
{
    public:
        OXFBSPlayerMainFrame( OXClient *_clientX );
	virtual ~OXFBSPlayerMainFrame();
	
	virtual int ProcessMessage( OMessage *msg );
        virtual int HandleFileEvent(OFileHandler *fh, unsigned int mask);
        virtual int HandleTimer( OTimer *_timer );

	void MenuOpenFile();
	void MenuCloseFile();
	
	void OpenFile( char *filename );
	void CloseFile();

    protected:
        int inputFd;
        OFileHandler *inputFh;
        int outputFd;
        OFileHandler *outputFh;
	OTimer *timer;
};


#define MENU_OPEN_FILE       100
#define MENU_CLOSE_FILE      101
#define MENU_EXIT            102
#define MENU_ABOUT           103
#define MENU_SETTINGS        104

#define BUTTON_EJECT         200
#define BUTTON_BEGIN         201
#define BUTTON_REWIND        202
#define BUTTON_PLAY          203
#define BUTTON_FORWARD       204
#define BUTTON_END           205


OXFBSPlayerMainFrame::OXFBSPlayerMainFrame( OXClient *_clientX )
  : OXMainFrame( _clientX->GetRoot(), 250, 100 )
  , inputFh( NULL )
  , outputFh( NULL )
{
  SetWindowName( "heXoNet FBS Player V" VERSION_xplayfbs );
  ChangeOptions( ( GetOptions() & ~HORIZONTAL_FRAME ) | VERTICAL_FRAME );

  OXMenuBar *menuBar = new OXMenuBar( this, 16, 16 );
  OLayoutHints *lh_menuBar = new OLayoutHints( LHINTS_TOP | LHINTS_EXPAND_X, 0, 0, 0, 0 );
  
  OXPopupMenu *popupMenuFile = new OXPopupMenu( _client->GetRoot() );
  OLayoutHints *lh_popupMenuFile = new OLayoutHints( LHINTS_LEFT, 4, 4, 0, 0 );
  popupMenuFile->AddEntry( new OHotString( "&Open" ), MENU_OPEN_FILE );
  popupMenuFile->AddEntry( new OHotString( "&Close" ), MENU_CLOSE_FILE );
  popupMenuFile->AddSeparator();
  popupMenuFile->AddEntry( new OHotString( "E&xit" ), MENU_EXIT );
  popupMenuFile->Associate( this );
  menuBar->AddPopup( new OHotString( "&File" ), popupMenuFile, lh_popupMenuFile );

  OXPopupMenu *popupMenuOptions = new OXPopupMenu( _client->GetRoot() );
  OLayoutHints *lh_popupMenuOptions = new OLayoutHints( LHINTS_LEFT, 4, 4, 0, 0 );
  popupMenuOptions->AddEntry( new OHotString( "&Settings..." ), MENU_SETTINGS );
  popupMenuOptions->Associate( this );
  menuBar->AddPopup( new OHotString( "&Options" ), popupMenuOptions, lh_popupMenuOptions );

  OXPopupMenu *popupMenuHelp = new OXPopupMenu( _client->GetRoot() );
  OLayoutHints *lh_popupMenuHelp = new OLayoutHints( LHINTS_RIGHT, 4, 4, 0, 0 );
  popupMenuHelp->AddEntry( new OHotString( "&About" ), MENU_ABOUT );
  popupMenuHelp->Associate( this );
  menuBar->AddPopup( new OHotString( "&Help" ), popupMenuHelp, lh_popupMenuHelp );

  OXHSlider *sliderPosition = new OXHSlider( this, 16, SLIDER_1 );
  sliderPosition->SetRange( 0, 32767 );
  sliderPosition->SetPosition( 0 );
  OLayoutHints *lh_sliderPosition = new OLayoutHints( LHINTS_CENTER_Y | LHINTS_EXPAND_X, 16, 16, 8, 8 );
  
  OXCompositeFrame *frameControls = new OXCompositeFrame( this, 16, 16, HORIZONTAL_FRAME );
  OLayoutHints *lh_frameControls = new OLayoutHints( LHINTS_BOTTOM | LHINTS_CENTER_X, 4, 4, 4, 8 );

  OXButton *buttonEject = new OXPictureButton( frameControls,
                                               _client->GetPicture( "eject.xpm", eject_xpm ),
				               BUTTON_EJECT );
  OLayoutHints *lh_buttonEject = new OLayoutHints( LHINTS_TOP | LHINTS_LEFT, 4, 8, 0, 0 );
  frameControls->AddFrame( buttonEject, lh_buttonEject );
  
  OXButton *buttonBegin = new OXPictureButton( frameControls,
                                               _client->GetPicture( "begin.xpm", begin_xpm ),
			                       BUTTON_BEGIN );
  OLayoutHints *lh_buttonBegin = new OLayoutHints( LHINTS_TOP | LHINTS_LEFT, 4, 4, 0, 0 );
  frameControls->AddFrame( buttonBegin, lh_buttonBegin );
  
  OXButton *buttonRewind = new OXPictureButton( frameControls,
                                                _client->GetPicture( "rewind.xpm", rewind_xpm ),
						BUTTON_REWIND );
  OLayoutHints *lh_buttonRewind = new OLayoutHints( LHINTS_TOP | LHINTS_LEFT, 4, 4, 0, 0 );
  frameControls->AddFrame( buttonRewind, lh_buttonRewind );
  
  OXButton *buttonPlay = new OXPictureButton( frameControls,
                                              _client->GetPicture( "play.xpm", play_xpm ),
			                     BUTTON_PLAY );
  OLayoutHints *lh_buttonPlay = new OLayoutHints( LHINTS_TOP | LHINTS_LEFT, 4, 4, 0, 0 );
  buttonPlay->SetType( BUTTON_ONOFF );
  frameControls->AddFrame( buttonPlay, lh_buttonPlay );
  
  OXButton *buttonForward = new OXPictureButton( frameControls,
                                                 _client->GetPicture( "forward.xpm", forward_xpm ),
					 	 BUTTON_FORWARD );
  OLayoutHints *lh_buttonForward = new OLayoutHints( LHINTS_TOP | LHINTS_LEFT, 4, 4, 0, 0 );
  frameControls->AddFrame( buttonForward, lh_buttonForward );
  
  OXButton *buttonEnd = new OXPictureButton( frameControls,
                                                 _client->GetPicture( "end.xpm", end_xpm ),
					 	 BUTTON_END );
  OLayoutHints *lh_buttonEnd = new OLayoutHints( LHINTS_TOP | LHINTS_LEFT, 4, 4, 0, 0 );
  frameControls->AddFrame( buttonEnd, lh_buttonEnd );
  
  
  AddFrame( menuBar, lh_menuBar );
  AddFrame( sliderPosition, lh_sliderPosition );
  AddFrame( frameControls, lh_frameControls );

  Layout();
  
  popupMenuFile->DisableEntry( MENU_CLOSE_FILE );

  MapSubwindows();
}


OXFBSPlayerMainFrame::~OXFBSPlayerMainFrame()
{
}


int OXFBSPlayerMainFrame::ProcessMessage( OMessage *msg )
{
    if ((msg->type == MSG_MENU) &&
        (msg->action == MSG_CLICK)) {
        OWidgetMessage *wmsg = (OWidgetMessage *) msg;
        switch ( wmsg->id ) {
            case MENU_EXIT: delete this; break;
	    case MENU_OPEN_FILE: MenuOpenFile(); break;
	    case MENU_ABOUT: {
                OXAbout *about = new OXAbout( _client->GetRoot(),
                                              this,
		                              "About: heXoNet xplayfbs V" VERSION_xplayfbs,
                                              "xplayfbs version " VERSION_xplayfbs,
				              "The FBS player from heXoNet",
				              _client->GetPicture( "fbs_player", fbs_player_xpm )
				            );
		about->MapWindow();
		_client->WaitFor( about );
	    } break;
        }
    }
    return True;
}

int oldTimestamp = 0;

int OXFBSPlayerMainFrame::HandleFileEvent(OFileHandler *fh, unsigned int mask)
{
    if ( fh == inputFh ) {
        if ( mask == XCM_EXCEPTION )
	  exit( 1 );
        rfb::CARD32 size;
        rfb::CARD32 timestamp;
	int bytesRead;
        bytesRead = read( inputFd, &size, 4 );
	if ( bytesRead <= 0 ) {
	  delete inputFh;
	  return true;
	}
	int s = (size + 3) & 0x7FFFFFFC;
        char tmp[s];
	bytesRead = read( inputFd, &tmp, s );
	if ( bytesRead <= 0 ) {
	  delete inputFh;
	  return true;
	}
        bytesRead = read( inputFd, &timestamp, 4 );
	if ( bytesRead <= 0 ) {
	  delete inputFh;
	  return true;
	}
        usleep( (timestamp - oldTimestamp) * 1000 );
	oldTimestamp = timestamp;
	write( 1, &tmp, size );
	return true;
    }
    return false;
}


int OXFBSPlayerMainFrame::HandleTimer( OTimer *_timer )
{
    return false;
}


void OXFBSPlayerMainFrame::MenuOpenFile()
{
    OFileInfo finfo;
    char *filetypes[] = { "FrameBuffer Streams [*.fbs]", "*.fbs",
                          "All Files", "*",
                          NULL, NULL };
    finfo.file_types = filetypes;
    new OXFileDialog ( _client->GetRoot(), this, FDLG_OPEN, &finfo );
    if ( finfo.filename ) {
        OpenFile( finfo.filename );
    }
}


void OXFBSPlayerMainFrame::OpenFile( char *filename )
{
    CloseFile();
    inputFd = open( filename, O_RDONLY );
    char fbsVersion[13];
    read( inputFd, &fbsVersion, 12 );
    fbsVersion[12] = 0;
    if ( !memcmp( fbsVersion, "FBS 001.000", 12 ) ) {
        new OXMsgBox( _client->GetRoot(),
                      this,
                      new OString( "Wrong file header" ),
	    	      new OString( fbsVersion ),
		      MB_ICONSTOP,
		      ID_OK );
        CloseFile();
	return;
    }
    inputFh = new OFileHandler( this, inputFd, XCM_READABLE | XCM_EXCEPTION );
}


void OXFBSPlayerMainFrame::CloseFile()
{
}


void printVersion_xplayfbs()
{
  cerr << endl << "heXoNet FBS player"
       << endl << "Version " << VERSION_xplayfbs
       << endl;
}


void printHelp_xplayfbs()
{
  printVersion_xplayfbs();
  cerr 
    << endl 
    << "usage: xplayfbs [<options>] [file]" << endl
    << "       xplayfbs [<options>] -stdout [file]" << endl
    << "       xplayfbs [<options>] -connect [<host>][:<display>] [file]" << endl
    << "       xplayfbs -about" << endl
    << endl
    << "<options>" << endl
    << "       " << endl
  ;
  exit( 1 );
}



void parseCommandLine_xplayfbs( int argc, char **argv )
{
  enum { UNDEF, STDOUT, CONNECT, ABOUT } mode;
  mode = UNDEF;

  char connectHost[256] = "";
  int connectDisplay = 0;
  char fbsFile[1024] = "";

  int i = 1;
  while ( i < argc ) {

    if ( !strcmp( argv[i], "-help" ) ) {
      printHelp_xplayfbs();
    } else

    if ( !strcmp( argv[i], "-stdout" ) ) {
      if ( mode == UNDEF ) mode = STDOUT;
      else printHelp_xplayfbs();
      i++;
    } else
    
    if ( !strcmp( argv[i], "-connect" ) ) {
      if ( mode == UNDEF ) {
        char *pos = strstr( argv[i], ":" );
        if ( pos ) {
          strncpy( connectHost, argv[i], pos - argv[i] );
          connectHost[pos - argv[i]] = 0;
  	  connectDisplay = atoi(pos+1);
        } else strcpy( connectHost, argv[i] );
        mode = STDOUT;
      }
      else printHelp_xplayfbs();
      i += 2;
    } else
    if ( !strcmp( argv[i], "-about" ) ) {
      if ( mode == UNDEF ) mode = ABOUT;
      else printHelp_xplayfbs();
      i++;
    } else
      printHelp_xplayfbs();
  }


  switch( mode ) {
    case UNDEF: {
      int modus[2];
      pipe( modus );
      dup2( modus[1], 1 );
      if ( !fork() ) {
        int fdNull = open( "/dev/null", O_WRONLY );
	dup2( modus[0], 0 );
	dup2( fdNull, 1 );
	char command[ 2048 ];
	strcpy( command, argv[0] );
	command[ strlen( command ) - 8 ] = 0;
	strcat( command, "xrfbviewer -spf -stdio" );
	system( command  );
      } else {
        OXClient *clientX = new OXClient();
        OXFBSPlayerMainFrame *mainFrame = new OXFBSPlayerMainFrame( clientX );
        mainFrame->MapWindow();
        mainFrame->MenuOpenFile();
        clientX->Run();
        exit( 0 );
      }
    }
    break;

    case STDOUT: {
    }
    break;
    
    case CONNECT: {
    }
    break;
    
    case ABOUT: {
      OXClient *clientX = new OXClient();
      OXAbout *about = new OXAbout( clientX->GetRoot(),
                                    NULL,
				    "About: heXoNet xplayfbs V" VERSION_xplayfbs,
				    "xplayfbs version " VERSION_xplayfbs,
				    "The FBS player from heXoNet",
                                    clientX->GetPicture( "fbs_player", fbs_player_xpm )
				  );
      about->MapWindow();
      clientX->WaitFor( about );
      exit( 0 );
    }
    break;
    
  }
}




int main( int argc, char **argv ) {
  parseCommandLine_xplayfbs( argc, argv );
  return 0;
}





void init_sockaddr (struct sockaddr_in *name, const char *hostname, uint16_t port)
{
  struct hostent *hostinfo;
  name->sin_family = AF_INET;
  name->sin_port = htons (port);
  hostinfo = gethostbyname (hostname);
  if (hostinfo == NULL)
    {
      printf( "Error\n" );
      exit (EXIT_FAILURE);
    }
  name->sin_addr = *(struct in_addr *) hostinfo->h_addr;
}


int doConnect( char *hostname, int port )
{
    struct sockaddr_in name;
    int s = socket( PF_INET, SOCK_STREAM, 0 );
    init_sockaddr( &name, hostname, port );

    if ( connect( s, (struct sockaddr*) &name, sizeof( name ) ) ) {
        printf( "connect Error\n" );
    }
    return s;
}

