#line 1 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
|| $Id: iterators.cmod,v 1.34 2003/09/11 19:23:54 mast Exp $
*/

#include "global.h"
RCSID("$Id: iterators.cmod,v 1.34 2003/09/11 19:23:54 mast Exp $");
#include "main.h"
#include "object.h"
#include "mapping.h"
#include "multiset.h"
#include "svalue.h"
#include "array.h"
#include "pike_macros.h"
#include "pike_error.h"
#include "pike_memory.h"
#include "dynamic_buffer.h"
#include "interpret.h"
#include "las.h"
#include "gc.h"
#include "stralloc.h"
#include "security.h"
#include "block_alloc.h"
#include "opcodes.h"
#include "pike_error.h"
#include "program.h"
#include "operators.h"
#include "builtin_functions.h"
#include "constants.h"

#define sp Pike_sp


#undef class_mapping_iterator_defined
#define class_mapping_iterator_defined
struct program *mapping_iterator_program=0;
/* All variables *must* be before all functions! */
  
#undef var_bucket_mapping_iterator_defined
#define var_bucket_mapping_iterator_defined

#undef var_m_mapping_iterator_defined
#define var_m_mapping_iterator_defined

#undef var_md_mapping_iterator_defined
#define var_md_mapping_iterator_defined

#undef var_current_mapping_iterator_defined
#define var_current_mapping_iterator_defined

#undef THIS
#define THIS ((struct mapping_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MAPPING_ITERATOR
#define THIS_MAPPING_ITERATOR ((struct mapping_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MAPPING_ITERATOR
#define OBJ2_MAPPING_ITERATOR(o) ((struct mapping_iterator_struct *)(o->storage+mapping_iterator_storage_offset))

#undef GET_MAPPING_ITERATOR_STORAGE
#define GET_MAPPING_ITERATOR_STORAGE ((struct mapping_iterator_struct *)(o->storage+mapping_iterator_storage_offset)
static ptrdiff_t mapping_iterator_storage_offset;
struct mapping_iterator_struct {

#ifdef var_bucket_mapping_iterator_defined
#line 40 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int bucket;
#endif /* var_bucket_mapping_iterator_defined */

#ifdef var_m_mapping_iterator_defined
#line 41 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct mapping *m;
#endif /* var_m_mapping_iterator_defined */

#ifdef var_md_mapping_iterator_defined
#line 42 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct mapping_data *md;
#endif /* var_md_mapping_iterator_defined */

#ifdef var_current_mapping_iterator_defined
#line 43 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct keypair *current;
#endif /* var_current_mapping_iterator_defined */
};
#define f_mapping_iterator_value_defined
void f_mapping_iterator_value(INT32 args) {
#line 45 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
      if(THIS->current)
	push_svalue(& THIS->current->val);
      else
      {
	push_undefined();
      }
    }

  }
#define f_mapping_iterator_index_defined
void f_mapping_iterator_index(INT32 args) {
#line 55 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
{
      if(THIS->current)
	push_svalue(& THIS->current->ind);
      else
      {
	push_undefined();
      }
    }

  }
#line 65 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
static int step_bucket(struct mapping_iterator_struct *i)
    {
      while(! i->current)
      {
	i->bucket++;
	if(i->bucket >= i->md->hashsize)
	  return 0;
	i->current=i->md->hash[i->bucket];
      }
      return 1;
    }

  static int mi_step(struct mapping_iterator_struct *i)
    {
      if(! i->current) return 0;
      i->current=i->current->next;
      return step_bucket(i);
    }
  
  #define f_mapping_iterator_cq__backtick_add_defined
void f_mapping_iterator_cq__backtick_add(INT32 args) {
#line 84 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 84 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 84 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 85 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      struct object *o=low_clone(mapping_iterator_program);
      OBJ2_MAPPING_ITERATOR(o)[0] = *THIS;
      add_ref(THIS->m);
      add_ref(THIS->md);
      THIS->md->valrefs++;
      while(--steps>=0 && mi_step(OBJ2_MAPPING_ITERATOR(o)));
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 93 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_mapping_iterator_cq__backtick_add_eq_defined
void f_mapping_iterator_cq__backtick_add_eq(INT32 args) {
#line 95 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 95 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 95 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+=",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 96 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      while(--steps>=0 && mi_step(THIS));
      do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 99 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_mapping_iterator_first_defined
void f_mapping_iterator_first(INT32 args) {
#line 101 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("first",args,0);
{
      THIS->current=0;
      THIS->bucket=-1;
      do { INT_TYPE ret_=(step_bucket(THIS));  push_int(ret_); return; }while(0);
#line 106 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#line 108 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
/* Hubbe: Should this really be destructive ?? */
  #define f_mapping_iterator_cq__random_defined
void f_mapping_iterator_cq__random(INT32 args) {
#line 109 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("_random",args,0);
{
      if(THIS->md->hashsize)
      {
	size_t k;
	struct keypair *tmp;
	THIS->bucket=my_rand() % THIS->md->hashsize;
	k=0;
	for(tmp=THIS->md->hash[THIS->bucket];tmp;tmp=tmp->next) k++;
	tmp=THIS->md->hash[THIS->bucket];
	if(k)
	{
	  k=my_rand() % k;
	  while(--k > 0) tmp=tmp->next;
	}
	THIS->current=tmp;
      }else{
	THIS->bucket=-1;
	THIS->current=0;
      }
      step_bucket(THIS);
      do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_);  push_object(ret_); return; }while(0);
#line 131 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_mapping_iterator_next_defined
void f_mapping_iterator_next(INT32 args) {
#line 133 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
#line 133 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{ do { INT_TYPE ret_=(mi_step(THIS));  push_int(ret_); return; }while(0);}
  }
#define f_mapping_iterator_cq__backtick_21_defined
void f_mapping_iterator_cq__backtick_21(INT32 args) {
#line 134 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
#line 134 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{ do { INT_TYPE ret_=(!THIS->current);  push_int(ret_); return; }while(0);}

  }
#define f_mapping_iterator_create_defined
void f_mapping_iterator_create(INT32 args) {
#line 136 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct mapping * map;
#line 136 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 136 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("create",1,"mapping(mixed:mixed)");
#line 136 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
debug_malloc_pass(map=Pike_sp[0-1].u.mapping);
{
      if(THIS->m)
	Pike_error("Mapping iterators cannot be reused.\n");

      add_ref(THIS->m=map);
      THIS->md=map->data;
      add_ref(THIS->md);
      THIS->md->valrefs++;
      THIS->bucket=-1;
      step_bucket(THIS);
    }

  }

#undef internal_init_mapping_iterator_defined
#define internal_init_mapping_iterator_defined

#undef mapping_iterator_event_handler_defined
#define mapping_iterator_event_handler_defined
static void init_mapping_iterator_struct(void)
#line 150 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      THIS->m=0;
      THIS->md=0;
      THIS->current=0;
      THIS->bucket=0;
    }

  
#undef internal_exit_mapping_iterator_defined
#define internal_exit_mapping_iterator_defined

#undef mapping_iterator_event_handler_defined
#define mapping_iterator_event_handler_defined
static void exit_mapping_iterator_struct(void)
#line 158 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      free_mapping(THIS->m);
      THIS->md->valrefs--;
      free_mapping_data(THIS->md);
    }

#ifdef mapping_iterator_event_handler_defined
static void mapping_iterator_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_mapping_iterator_defined
  case PROG_EVENT_INIT: init_mapping_iterator_struct(); break;

#endif /* internal_init_mapping_iterator_defined */

#ifdef internal_exit_mapping_iterator_defined
  case PROG_EVENT_EXIT: exit_mapping_iterator_struct(); break;

#endif /* internal_exit_mapping_iterator_defined */
  default: break; 
  }
}

#endif /* mapping_iterator_event_handler_defined */
#line 163 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
;


#undef class_array_iterator_defined
#define class_array_iterator_defined
struct program *array_iterator_program=0;

#undef var_pos_array_iterator_defined
#define var_pos_array_iterator_defined

#undef var_a_array_iterator_defined
#define var_a_array_iterator_defined

#undef THIS
#define THIS ((struct array_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_ARRAY_ITERATOR
#define THIS_ARRAY_ITERATOR ((struct array_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_ARRAY_ITERATOR
#define OBJ2_ARRAY_ITERATOR(o) ((struct array_iterator_struct *)(o->storage+array_iterator_storage_offset))

#undef GET_ARRAY_ITERATOR_STORAGE
#define GET_ARRAY_ITERATOR_STORAGE ((struct array_iterator_struct *)(o->storage+array_iterator_storage_offset)
static ptrdiff_t array_iterator_storage_offset;
struct array_iterator_struct {

#ifdef var_pos_array_iterator_defined
#line 167 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int pos;
#endif /* var_pos_array_iterator_defined */

#ifdef var_a_array_iterator_defined
#line 168 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct array *a;
#endif /* var_a_array_iterator_defined */
};
#define f_array_iterator_value_defined
void f_array_iterator_value(INT32 args) {
#line 170 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
      if(!THIS->a || THIS->pos < 0 || THIS->pos >= THIS->a->size)
      {
	push_int(0);
	Pike_sp[-1].subtype=NUMBER_UNDEFINED;
      }else{
	push_svalue(THIS->a->item + THIS->pos);
      }
    }

  }
#define f_array_iterator_index_defined
void f_array_iterator_index(INT32 args) {
#line 181 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
{
      if(!THIS->a || THIS->pos < 0 || THIS->pos >= THIS->a->size)
      {
	push_int(0);
	Pike_sp[-1].subtype=NUMBER_UNDEFINED;
      }else{
	do { INT_TYPE ret_=(THIS->pos);  push_int(ret_); return; }while(0);
#line 189 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}
    }

  }
#define f_array_iterator_cq__backtick_add_defined
void f_array_iterator_cq__backtick_add(INT32 args) {
#line 192 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 192 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 192 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 193 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      struct object *o=low_clone(array_iterator_program);
      OBJ2_ARRAY_ITERATOR(o)[0]=*THIS;
      add_ref(THIS->a);
      OBJ2_ARRAY_ITERATOR(o)->pos+=steps;
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 199 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_array_iterator_cq__backtick_add_eq_defined
void f_array_iterator_cq__backtick_add_eq(INT32 args) {
#line 201 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 201 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 201 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+=",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 202 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
    THIS->pos+=steps;
    do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 205 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_array_iterator_cq__backtick_2D_defined
void f_array_iterator_cq__backtick_2D(INT32 args) {
#line 207 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 207 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`-",args,1);
#line 207 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`-",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 208 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
    struct object *o=low_clone(array_iterator_program);
    OBJ2_ARRAY_ITERATOR(o)[0]=*THIS;
    add_ref(THIS->a);
    OBJ2_ARRAY_ITERATOR(o)->pos-=steps;
    do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 214 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_array_iterator_first_defined
void f_array_iterator_first(INT32 args) {
#line 216 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("first",args,0);
{
      THIS->pos=0;
      do { INT_TYPE ret_=(THIS->a && THIS->pos < THIS->a->size);  push_int(ret_); return; }while(0);
#line 220 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#line 222 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
/* Hubbe: Should this really be destructive ?? */
  #define f_array_iterator_cq__random_defined
void f_array_iterator_cq__random(INT32 args) {
#line 223 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("_random",args,0);
{
      if(THIS->a->size)
	THIS->pos=my_rand() % THIS->a->size;
      else
	THIS->pos=0;
      do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_);  push_object(ret_); return; }while(0);
#line 230 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_array_iterator_next_defined
void f_array_iterator_next(INT32 args) {
#line 232 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
{
      THIS->pos++;
      do { INT_TYPE ret_=(THIS->a && THIS->pos >= 0 && THIS->pos < THIS->a->size);  push_int(ret_); return; }while(0);
#line 236 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_array_iterator_cq__backtick_21_defined
void f_array_iterator_cq__backtick_21(INT32 args) {
#line 238 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
{
      do { INT_TYPE ret_=(!(THIS->a && THIS->pos >= 0 && THIS->pos < THIS->a->size));  push_int(ret_); return; }while(0);
#line 241 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_array_iterator_create_defined
void f_array_iterator_create(INT32 args) {
#line 243 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct array * a;
#line 243 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 243 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("create",1,"array");
#line 243 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
debug_malloc_pass(a=Pike_sp[0-1].u.array);
{
      if(THIS->a)
	Pike_error("Array iterators cannot be reused.\n");
      
      add_ref(THIS->a=a);
    }
  
  }

#undef internal_init_array_iterator_defined
#define internal_init_array_iterator_defined

#undef array_iterator_event_handler_defined
#define array_iterator_event_handler_defined
static void init_array_iterator_struct(void)
#line 252 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      THIS->a=0;
      THIS->pos=0;
    }

  
#undef internal_exit_array_iterator_defined
#define internal_exit_array_iterator_defined

#undef array_iterator_event_handler_defined
#define array_iterator_event_handler_defined
static void exit_array_iterator_struct(void)
#line 258 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      free_array(THIS->a);
    }
    

#ifdef array_iterator_event_handler_defined
static void array_iterator_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_array_iterator_defined
  case PROG_EVENT_INIT: init_array_iterator_struct(); break;

#endif /* internal_init_array_iterator_defined */

#ifdef internal_exit_array_iterator_defined
  case PROG_EVENT_EXIT: exit_array_iterator_struct(); break;

#endif /* internal_exit_array_iterator_defined */
  default: break; 
  }
}

#endif /* array_iterator_event_handler_defined */
#line 262 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
;

#ifdef PIKE_NEW_MULTISETS


#undef class_multiset_iterator_defined
#define class_multiset_iterator_defined
struct program *multiset_iterator_program=0;

#undef var_l_multiset_iterator_defined
#define var_l_multiset_iterator_defined

#undef var_lock_index_multiset_iterator_defined
#define var_lock_index_multiset_iterator_defined

#undef var_nodepos_multiset_iterator_defined
#define var_nodepos_multiset_iterator_defined

#undef THIS
#define THIS ((struct multiset_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MULTISET_ITERATOR
#define THIS_MULTISET_ITERATOR ((struct multiset_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MULTISET_ITERATOR
#define OBJ2_MULTISET_ITERATOR(o) ((struct multiset_iterator_struct *)(o->storage+multiset_iterator_storage_offset))

#undef GET_MULTISET_ITERATOR_STORAGE
#define GET_MULTISET_ITERATOR_STORAGE ((struct multiset_iterator_struct *)(o->storage+multiset_iterator_storage_offset)
static ptrdiff_t multiset_iterator_storage_offset;
struct multiset_iterator_struct {

#ifdef var_l_multiset_iterator_defined
#line 268 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct multiset *l;
#endif /* var_l_multiset_iterator_defined */

#ifdef var_lock_index_multiset_iterator_defined
#line 269 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int lock_index;
#endif /* var_lock_index_multiset_iterator_defined */

#ifdef var_nodepos_multiset_iterator_defined
#line 270 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
ptrdiff_t nodepos;
#endif /* var_nodepos_multiset_iterator_defined */
};
#define f_multiset_iterator_value_defined
void f_multiset_iterator_value(INT32 args) {
#line 272 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      if (THIS->nodepos < 0 || msnode_is_deleted (THIS->l, THIS->nodepos))
	push_undefined();
      else
	push_multiset_value (THIS->l, THIS->nodepos);
    }

  }
#define f_multiset_iterator_index_defined
void f_multiset_iterator_index(INT32 args) {
#line 281 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
{
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      if (THIS->nodepos < 0 || msnode_is_deleted (THIS->l, THIS->nodepos))
	push_undefined();
      else
	push_multiset_index (THIS->l, THIS->nodepos);
    }

  }
#line 290 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
static struct object *li_copy (struct multiset_iterator_struct *li)
    {
      struct object *o = low_clone (multiset_iterator_program);
      struct multiset_iterator_struct *copy = OBJ2_MULTISET_ITERATOR (o);
      add_ref (copy->l = li->l);
      if ((copy->nodepos = li->nodepos) >= 0) add_msnode_ref (copy->l);
      if ((copy->lock_index = li->lock_index)) {
	add_ref (copy->l->msd);
	copy->l->msd->noval_refs++;
      }
      return o;
    }

  static void li_step (struct multiset_iterator_struct *li, int steps)
    {
      ptrdiff_t newpos = li->nodepos;

      if (li->nodepos < 0) return;

      if (steps > 0)
	do {
	  newpos = multiset_next (li->l, newpos);
	  if (newpos < 0) {
	    sub_msnode_ref (li->l);
	    break;
	  }
	} while (--steps);
      else if (steps < 0)
	do {
	  newpos = multiset_prev (li->l, newpos);
	  if (newpos < 0) {
	    sub_msnode_ref (li->l);
	    break;
	  }
	} while (++steps);

      li->nodepos = newpos;
    }

  #define f_multiset_iterator_cq__backtick_add_eq_defined
void f_multiset_iterator_cq__backtick_add_eq(INT32 args) {
#line 329 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 329 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 329 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+=",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 330 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      li_step (THIS, steps);
      do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 334 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_cq__backtick_add_defined
void f_multiset_iterator_cq__backtick_add(INT32 args) {
#line 336 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 336 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 336 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 337 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      struct object *o;
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      o = li_copy (THIS);
      li_step (OBJ2_MULTISET_ITERATOR (o), steps);
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 343 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_cq__backtick_2D_defined
void f_multiset_iterator_cq__backtick_2D(INT32 args) {
#line 345 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 345 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`-",args,1);
#line 345 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`-",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 346 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      struct object *o;
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      o = li_copy (THIS);
      li_step (OBJ2_MULTISET_ITERATOR (o), -steps);
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 352 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_first_defined
void f_multiset_iterator_first(INT32 args) {
#line 354 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("first",args,0);
{
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      if (THIS->nodepos >= 0) sub_msnode_ref (THIS->l);
      THIS->nodepos = multiset_first (THIS->l);
      do { INT_TYPE ret_=(THIS->nodepos >= 0);  push_int(ret_); return; }while(0);
#line 360 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_next_defined
void f_multiset_iterator_next(INT32 args) {
#line 362 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
{
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      if (THIS->nodepos >= 0) {
	THIS->nodepos = multiset_next (THIS->l, THIS->nodepos);
	if (THIS->nodepos >= 0) do { INT_TYPE ret_=(1);  push_int(ret_); return; }while(0);
#line 368 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
sub_msnode_ref (THIS->l);
      }
      do { INT_TYPE ret_=(0);  push_int(ret_); return; }while(0);
#line 371 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_cq__backtick_21_defined
void f_multiset_iterator_cq__backtick_21(INT32 args) {
#line 373 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
{
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      do { INT_TYPE ret_=(THIS->nodepos < 0 || msnode_is_deleted (THIS->l, THIS->nodepos));  push_int(ret_); return; }while(0);
#line 377 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#line 379 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
/* Hubbe: Should this really be destructive ??
   * I let this question stand; I'm only adapting multiset_iterator. /mast */
  #define f_multiset_iterator_cq__random_defined
void f_multiset_iterator_cq__random(INT32 args) {
#line 381 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("_random",args,0);
{
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      if (THIS->nodepos >= 0) {
	sub_msnode_ref (THIS->l);
	THIS->nodepos = -1;
      }
      if (!multiset_is_empty (THIS->l))
	THIS->nodepos =
	  multiset_get_nth (THIS->l, my_rand() % multiset_sizeof (THIS->l));
      do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_);  push_object(ret_); return; }while(0);
#line 392 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_lock_index_defined
void f_multiset_iterator_lock_index(INT32 args) {
#line 394 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("lock_index",args,0);
{
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      if (!THIS->lock_index) {
	add_ref (THIS->l->msd);
	THIS->l->msd->noval_refs++;
	THIS->lock_index = 1;
      }
    }

  }
#define f_multiset_iterator_unlock_index_defined
void f_multiset_iterator_unlock_index(INT32 args) {
#line 404 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("unlock_index",args,0);
{
      if (!THIS->l) Pike_error ("Iterator not initialized.\n");
      if (THIS->lock_index) {
	THIS->l->msd->noval_refs--;
	sub_ref (THIS->l->msd);
#ifdef PIKE_DEBUG
	if (THIS->l->msd->refs <= 0) Pike_fatal ("msd ran out of refs unexpectedly.\n");
#endif
	THIS->lock_index = 0;
      }
    }

  }
#line 417 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
/* FIXME: Add more functions, e.g. insert, delete, add. */

  /* FIXME: Maybe the index should be locked when the iterator is used
   * in foreach, to behave more like the mapping iterator. */

  #define f_multiset_iterator_create_defined
void f_multiset_iterator_create(INT32 args) {
#line 422 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct multiset * l;
#line 422 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 422 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_MULTISET) SIMPLE_BAD_ARG_ERROR("create",1,"multiset");
#line 422 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
debug_malloc_pass(l=Pike_sp[0-1].u.multiset);
{
      if (THIS->l) Pike_error ("Multiset iterators cannot be reused.\n");
      add_ref (THIS->l = l);
      THIS->lock_index = 0;
      THIS->nodepos = multiset_first (THIS->l);
    }

  }

#undef internal_init_multiset_iterator_defined
#define internal_init_multiset_iterator_defined

#undef multiset_iterator_event_handler_defined
#define multiset_iterator_event_handler_defined
static void init_multiset_iterator_struct(void)
#line 431 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      THIS->l = NULL;
    }

  
#undef internal_exit_multiset_iterator_defined
#define internal_exit_multiset_iterator_defined

#undef multiset_iterator_event_handler_defined
#define multiset_iterator_event_handler_defined
static void exit_multiset_iterator_struct(void)
#line 436 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      if (THIS->l) {
	if (THIS->nodepos >= 0) sub_msnode_ref (THIS->l);
	if (THIS->lock_index) {
	  THIS->l->msd->noval_refs--;
	  sub_ref (THIS->l->msd);
#ifdef PIKE_DEBUG
	  if (THIS->l->msd->refs <= 0) Pike_fatal ("msd ran out of refs unexpectedly.\n");
#endif
	}
	free_multiset (THIS->l);
	THIS->l = NULL;
      }
    }

#ifdef multiset_iterator_event_handler_defined
static void multiset_iterator_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_multiset_iterator_defined
  case PROG_EVENT_INIT: init_multiset_iterator_struct(); break;

#endif /* internal_init_multiset_iterator_defined */

#ifdef internal_exit_multiset_iterator_defined
  case PROG_EVENT_EXIT: exit_multiset_iterator_struct(); break;

#endif /* internal_exit_multiset_iterator_defined */
  default: break; 
  }
}

#endif /* multiset_iterator_event_handler_defined */
#line 450 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
;

#else  /* PIKE_NEW_MULTISETS */


#undef class_multiset_iterator_defined_2
#define class_multiset_iterator_defined_2
struct program *multiset_iterator_program=0;

#undef var_pos_multiset_iterator_defined
#define var_pos_multiset_iterator_defined

#undef var_a_multiset_iterator_defined
#define var_a_multiset_iterator_defined

#undef THIS
#define THIS ((struct multiset_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MULTISET_ITERATOR
#define THIS_MULTISET_ITERATOR ((struct multiset_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MULTISET_ITERATOR
#define OBJ2_MULTISET_ITERATOR(o) ((struct multiset_iterator_struct *)(o->storage+multiset_iterator_storage_offset))

#undef GET_MULTISET_ITERATOR_STORAGE
#define GET_MULTISET_ITERATOR_STORAGE ((struct multiset_iterator_struct *)(o->storage+multiset_iterator_storage_offset)
static ptrdiff_t multiset_iterator_storage_offset;
struct multiset_iterator_struct {

#ifdef var_pos_multiset_iterator_defined
#line 456 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int pos;
#endif /* var_pos_multiset_iterator_defined */

#ifdef var_a_multiset_iterator_defined
#line 457 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct array *a;
#endif /* var_a_multiset_iterator_defined */
};
#define f_multiset_iterator_value_defined_2
void f_multiset_iterator_value(INT32 args) {
#line 459 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
      if(!THIS->a || THIS->pos < 0 || THIS->pos >= THIS->a->size)
      {
	push_int(0);
	Pike_sp[-1].subtype=NUMBER_UNDEFINED;
      }else{
	push_int(1);
      }
    }

  }
#define f_multiset_iterator_index_defined_2
void f_multiset_iterator_index(INT32 args) {
#line 470 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
{
      if(!THIS->a || THIS->pos < 0 || THIS->pos >= THIS->a->size)
      {
	push_int(0);
	Pike_sp[-1].subtype=NUMBER_UNDEFINED;
      }else{
	push_svalue(THIS->a->item + THIS->pos);
      }
    }

  }
#define f_multiset_iterator_cq__backtick_add_defined_2
void f_multiset_iterator_cq__backtick_add(INT32 args) {
#line 481 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 481 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 481 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 482 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      struct object *o=low_clone(multiset_iterator_program);
      OBJ2_MULTISET_ITERATOR(o)[0]=*THIS;
      add_ref(THIS->a);
      OBJ2_MULTISET_ITERATOR(o)->pos+=steps;
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 488 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_cq__backtick_add_eq_defined_2
void f_multiset_iterator_cq__backtick_add_eq(INT32 args) {
#line 490 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 490 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 490 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+=",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 491 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
    THIS->pos+=steps;
    do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 494 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_cq__backtick_2D_defined_2
void f_multiset_iterator_cq__backtick_2D(INT32 args) {
#line 496 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 496 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`-",args,1);
#line 496 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`-",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 497 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
    struct object *o=low_clone(multiset_iterator_program);
    OBJ2_MULTISET_ITERATOR(o)[0]=*THIS;
    add_ref(THIS->a);
    OBJ2_MULTISET_ITERATOR(o)->pos-=steps;
    do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 503 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_first_defined_2
void f_multiset_iterator_first(INT32 args) {
#line 505 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("first",args,0);
{
      THIS->pos=0;
      do { INT_TYPE ret_=(THIS->a && THIS->pos < THIS->a->size);  push_int(ret_); return; }while(0);
#line 509 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#line 511 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
/* Hubbe: Should this really be destructive ?? */
  #define f_multiset_iterator_cq__random_defined_2
void f_multiset_iterator_cq__random(INT32 args) {
#line 512 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("_random",args,0);
{
      if(THIS->a->size)
	THIS->pos=my_rand() % THIS->a->size;
      else
	THIS->pos=0;
      do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_);  push_object(ret_); return; }while(0);
#line 519 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_next_defined_2
void f_multiset_iterator_next(INT32 args) {
#line 521 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
{
      THIS->pos++;
      do { INT_TYPE ret_=(THIS->a && THIS->pos >= 0 && THIS->pos < THIS->a->size);  push_int(ret_); return; }while(0);
#line 525 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_cq__backtick_21_defined_2
void f_multiset_iterator_cq__backtick_21(INT32 args) {
#line 527 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
{
      do { INT_TYPE ret_=(!(THIS->a && THIS->pos >= 0 && THIS->pos < THIS->a->size));  push_int(ret_); return; }while(0);
#line 530 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_multiset_iterator_create_defined_2
void f_multiset_iterator_create(INT32 args) {
#line 532 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct multiset * m;
#line 532 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 532 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_MULTISET) SIMPLE_BAD_ARG_ERROR("create",1,"multiset");
#line 532 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.multiset);
{
      if(THIS->a)
	Pike_error("Multiset iterators cannot be reused.\n");
      
      add_ref(THIS->a=m->ind);
    }
  
  }

#undef internal_init_multiset_iterator_defined_2
#define internal_init_multiset_iterator_defined_2

#undef multiset_iterator_event_handler_defined_2
#define multiset_iterator_event_handler_defined_2
static void init_multiset_iterator_struct(void)
#line 541 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      THIS->a=0;
      THIS->pos=0;
    }

  
#undef internal_exit_multiset_iterator_defined_2
#define internal_exit_multiset_iterator_defined_2

#undef multiset_iterator_event_handler_defined_2
#define multiset_iterator_event_handler_defined_2
static void exit_multiset_iterator_struct(void)
#line 547 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      free_array(THIS->a);
    }
    

#ifdef multiset_iterator_event_handler_defined_2
static void multiset_iterator_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_multiset_iterator_defined_2
  case PROG_EVENT_INIT: init_multiset_iterator_struct(); break;

#endif /* internal_init_multiset_iterator_defined_2 */

#ifdef internal_exit_multiset_iterator_defined_2
  case PROG_EVENT_EXIT: exit_multiset_iterator_struct(); break;

#endif /* internal_exit_multiset_iterator_defined_2 */
  default: break; 
  }
}

#endif /* multiset_iterator_event_handler_defined_2 */
#line 551 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
;

#endif	/* PIKE_NEW_MULTISETS */


#undef class_string_iterator_defined
#define class_string_iterator_defined
struct program *string_iterator_program=0;

#undef var_pos_string_iterator_defined
#define var_pos_string_iterator_defined

#undef var_s_string_iterator_defined
#define var_s_string_iterator_defined

#undef THIS
#define THIS ((struct string_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_STRING_ITERATOR
#define THIS_STRING_ITERATOR ((struct string_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_STRING_ITERATOR
#define OBJ2_STRING_ITERATOR(o) ((struct string_iterator_struct *)(o->storage+string_iterator_storage_offset))

#undef GET_STRING_ITERATOR_STORAGE
#define GET_STRING_ITERATOR_STORAGE ((struct string_iterator_struct *)(o->storage+string_iterator_storage_offset)
static ptrdiff_t string_iterator_storage_offset;
struct string_iterator_struct {

#ifdef var_pos_string_iterator_defined
#line 557 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int pos;
#endif /* var_pos_string_iterator_defined */

#ifdef var_s_string_iterator_defined
#line 558 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct pike_string *s;
#endif /* var_s_string_iterator_defined */
};
#define f_string_iterator_value_defined
void f_string_iterator_value(INT32 args) {
#line 560 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
      if(!THIS->s || THIS->pos < 0 || THIS->pos >= THIS->s->len)
      {
	push_undefined();
      }else{
	do { INT_TYPE ret_=(index_shared_string(THIS->s, THIS->pos));  push_int(ret_); return; }while(0);
#line 567 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}
    }

  }
#define f_string_iterator_index_defined
void f_string_iterator_index(INT32 args) {
#line 570 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
{
      if(!THIS->s || THIS->pos < 0 || THIS->pos >= THIS->s->len)
      {
	push_undefined();
      }else{
	do { INT_TYPE ret_=(THIS->pos);  push_int(ret_); return; }while(0);
#line 577 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}
    }

  }
#define f_string_iterator_cq__backtick_add_defined
void f_string_iterator_cq__backtick_add(INT32 args) {
#line 580 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 580 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 580 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 581 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      struct object *o=low_clone(string_iterator_program);
      OBJ2_STRING_ITERATOR(o)[0]=*THIS;
      add_ref(THIS->s);
      OBJ2_STRING_ITERATOR(o)->pos+=steps;
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 587 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_iterator_cq__backtick_add_eq_defined
void f_string_iterator_cq__backtick_add_eq(INT32 args) {
#line 589 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 589 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 589 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+=",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 590 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
    THIS->pos+=steps;
    do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 593 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_iterator_cq__backtick_2D_defined
void f_string_iterator_cq__backtick_2D(INT32 args) {
#line 595 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 595 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`-",args,1);
#line 595 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`-",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 596 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
    struct object *o=low_clone(string_iterator_program);
    OBJ2_STRING_ITERATOR(o)[0]=*THIS;
    add_ref(THIS->s);
    OBJ2_STRING_ITERATOR(o)->pos-=steps;
    do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 602 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_iterator_first_defined
void f_string_iterator_first(INT32 args) {
#line 604 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("first",args,0);
{
      THIS->pos=0;
      do { INT_TYPE ret_=(THIS->s && THIS->pos < THIS->s->len);  push_int(ret_); return; }while(0);
#line 608 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#line 610 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
/* Hubbe: Should this really be destructive ?? */
  #define f_string_iterator_cq__random_defined
void f_string_iterator_cq__random(INT32 args) {
#line 611 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("_random",args,0);
{
      if(THIS->s->len)
	THIS->pos=my_rand() % THIS->s->len;
      else
	THIS->pos=0;
      do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_);  push_object(ret_); return; }while(0);
#line 618 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_iterator_next_defined
void f_string_iterator_next(INT32 args) {
#line 620 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
{
      THIS->pos++;
      do { INT_TYPE ret_=(THIS->s && THIS->pos >= 0 && THIS->pos < THIS->s->len);  push_int(ret_); return; }while(0);
#line 624 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_iterator_cq__backtick_21_defined
void f_string_iterator_cq__backtick_21(INT32 args) {
#line 626 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
{
      do { INT_TYPE ret_=(!(THIS->s && THIS->pos >= 0 && THIS->pos < THIS->s->len));  push_int(ret_); return; }while(0);
#line 629 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_iterator_create_defined
void f_string_iterator_create(INT32 args) {
#line 631 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct pike_string * s;
#line 631 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 631 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",1,"string");
#line 631 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
{
      if(THIS->s)
	Pike_error("String iterators cannot be reused.\n");
      
      add_ref(THIS->s=s);
    }
  
  }

#undef internal_init_string_iterator_defined
#define internal_init_string_iterator_defined

#undef string_iterator_event_handler_defined
#define string_iterator_event_handler_defined
static void init_string_iterator_struct(void)
#line 640 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      THIS->s=0;
      THIS->pos=0;
    }

  
#undef internal_exit_string_iterator_defined
#define internal_exit_string_iterator_defined

#undef string_iterator_event_handler_defined
#define string_iterator_event_handler_defined
static void exit_string_iterator_struct(void)
#line 646 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      free_string(THIS->s);
    }

#ifdef string_iterator_event_handler_defined
static void string_iterator_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_string_iterator_defined
  case PROG_EVENT_INIT: init_string_iterator_struct(); break;

#endif /* internal_init_string_iterator_defined */

#ifdef internal_exit_string_iterator_defined
  case PROG_EVENT_EXIT: exit_string_iterator_struct(); break;

#endif /* internal_exit_string_iterator_defined */
  default: break; 
  }
}

#endif /* string_iterator_event_handler_defined */
#line 649 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
;

/* Interal (for Stdio.File) class: Stdio.File->line_iterator.
 * Splits on lines, does only handle 8-bit characters.
 */

#undef class_file_line_iterator_defined
#define class_file_line_iterator_defined
struct program *file_line_iterator_program=0;

#undef var_buffer_file_line_iterator_defined
#define var_buffer_file_line_iterator_defined

#undef var_current_file_line_iterator_defined
#define var_current_file_line_iterator_defined

#undef var_offset_file_line_iterator_defined
#define var_offset_file_line_iterator_defined

#undef var_index_file_line_iterator_defined
#define var_index_file_line_iterator_defined

#undef var_feed_file_line_iterator_defined
#define var_feed_file_line_iterator_defined

#undef THIS
#define THIS ((struct file_line_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_FILE_LINE_ITERATOR
#define THIS_FILE_LINE_ITERATOR ((struct file_line_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_FILE_LINE_ITERATOR
#define OBJ2_FILE_LINE_ITERATOR(o) ((struct file_line_iterator_struct *)(o->storage+file_line_iterator_storage_offset))

#undef GET_FILE_LINE_ITERATOR_STORAGE
#define GET_FILE_LINE_ITERATOR_STORAGE ((struct file_line_iterator_struct *)(o->storage+file_line_iterator_storage_offset)
static ptrdiff_t file_line_iterator_storage_offset;
struct file_line_iterator_struct {

#ifdef var_buffer_file_line_iterator_defined
#line 656 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct pike_string *buffer;
#endif /* var_buffer_file_line_iterator_defined */

#ifdef var_current_file_line_iterator_defined
#line 657 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct pike_string *current;
#endif /* var_current_file_line_iterator_defined */

#ifdef var_offset_file_line_iterator_defined
#line 658 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int offset;
#endif /* var_offset_file_line_iterator_defined */

#ifdef var_index_file_line_iterator_defined
#line 659 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int index;
#endif /* var_index_file_line_iterator_defined */

#ifdef var_feed_file_line_iterator_defined
#line 660 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct svalue feed;
#endif /* var_feed_file_line_iterator_defined */
};
static void fl_find_next(struct file_line_iterator_struct *ssi)
  {
    unsigned char *ptr, *eptr, *start;
    int start_off = ssi->offset;

    if (ssi->current)
    {
      free_string(ssi->current);
      ssi->current = NULL;
    }

    if (!ssi->buffer)
      return;

  again:
      start = ssi->buffer->str + start_off;
      ptr   = ssi->buffer->str + ssi->offset;
      eptr  = ssi->buffer->str + ssi->buffer->len;

      /* Loop until we find a '\n'. */
      while( ptr < eptr )
	if( *ptr != '\n'  )
	  ptr++;
	else
	{
	  ssi->current = make_shared_binary_string( start, ptr-start );
	  /* skip the '\n' */
	  ssi->offset =  ptr - ((unsigned char *)ssi->buffer->str) + 1;
	  ssi->index++;
	  return;
	}

      apply_svalue( &ssi->feed, 0 );
      if( Pike_sp[-1].type == PIKE_T_STRING &&
	  Pike_sp[-1].u.string->len )
      {
	push_string(make_shared_binary_string( ssi->buffer->str+start_off,
					       ssi->buffer->len-start_off));
	free_string( ssi->buffer );
	stack_swap();
	f_add( 2 );
	ssi->buffer = Pike_sp[-1].u.string;
	Pike_sp--;

	if( !ssi->buffer->size_shift )
	{
	  ssi->offset -= start_off;
	  start_off = 0;
	  goto again;
	}
      }
      else
	pop_stack();
      free_string( ssi->buffer );
      ssi->buffer = NULL;
      return;
   }
  
  #define f_file_line_iterator_value_defined
void f_file_line_iterator_value(INT32 args) {
#line 721 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
      if (THIS->current) {
	ref_push_string(THIS->current);
      } else {
	push_undefined();
      }
    }

  }
#define f_file_line_iterator_index_defined
void f_file_line_iterator_index(INT32 args) {
#line 730 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
{
      if (!THIS->current) {
	push_undefined();
      }else{
	do { INT_TYPE ret_=(THIS->index);  push_int(ret_); return; }while(0);
#line 736 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}
    }

  }
#define f_file_line_iterator_cq__backtick_add_defined
void f_file_line_iterator_cq__backtick_add(INT32 args) {
#line 739 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 739 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 739 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 740 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      struct object *o=low_clone(file_line_iterator_program);
      struct file_line_iterator_struct *ssi;
      (ssi = OBJ2_FILE_LINE_ITERATOR(o))[0]=*THIS;
      if (THIS->buffer) {
	add_ref(THIS->buffer);
      }
      if (THIS->current) {
	add_ref(THIS->current);
      }
      add_ref_svalue(&THIS->feed);
      while( steps-- )
	fl_find_next(ssi);
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 754 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_file_line_iterator_cq__backtick_add_eq_defined
void f_file_line_iterator_cq__backtick_add_eq(INT32 args) {
#line 756 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 756 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 756 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+=",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 757 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      while( steps-- )
	fl_find_next(THIS);
      do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 761 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_file_line_iterator_next_defined
void f_file_line_iterator_next(INT32 args) {
#line 763 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
{
      fl_find_next(THIS);
      do { INT_TYPE ret_=(!!THIS->current);  push_int(ret_); return; }while(0);
#line 767 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_file_line_iterator_cq__backtick_21_defined
void f_file_line_iterator_cq__backtick_21(INT32 args) {
#line 769 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
{
      do { INT_TYPE ret_=(!THIS->current);  push_int(ret_); return; }while(0);
#line 772 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_file_line_iterator_create_defined
void f_file_line_iterator_create(INT32 args) {
#line 774 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct svalue * feed;
#line 774 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
if(args > 0) { 
#line 774 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
feed=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
}else{
feed=0;
}
#line 775 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      if (THIS->buffer) {
	Pike_error("iterators cannot be reused.\n");
      }
      assign_svalue( &THIS->feed, feed );
      apply_svalue( &THIS->feed, 0 );
      if( Pike_sp[-1].type != PIKE_T_STRING )
	Pike_error("Feed function returned illegal value\n");
      THIS->buffer = Pike_sp[-1].u.string;
      Pike_sp--;
      THIS->offset = 0;
      THIS->current = NULL;
      THIS->index = -1;
      fl_find_next(THIS);
    }
  
  }

#undef internal_init_file_line_iterator_defined
#define internal_init_file_line_iterator_defined

#undef file_line_iterator_event_handler_defined
#define file_line_iterator_event_handler_defined
static void init_file_line_iterator_struct(void)
#line 792 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      THIS->buffer = NULL;
      THIS->current = NULL;
      THIS->offset = 0;
      THIS->index = 0;
      THIS->feed.type = T_INT;
      THIS->feed.u.integer = 0;
    }

  
#undef internal_exit_file_line_iterator_defined
#define internal_exit_file_line_iterator_defined

#undef file_line_iterator_event_handler_defined
#define file_line_iterator_event_handler_defined
static void exit_file_line_iterator_struct(void)
#line 802 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      if (THIS->buffer) {
	free_string(THIS->buffer);
	THIS->buffer = NULL;
      }
      if (THIS->current) {
	free_string(THIS->current);
	THIS->current = NULL;
      }
      free_svalue(&THIS->feed);
      THIS->feed.type = T_INT;
      THIS->feed.u.integer = 0;
    }
  
  

#ifdef file_line_iterator_event_handler_defined
static void file_line_iterator_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_file_line_iterator_defined
  case PROG_EVENT_INIT: init_file_line_iterator_struct(); break;

#endif /* internal_init_file_line_iterator_defined */

#ifdef internal_exit_file_line_iterator_defined
  case PROG_EVENT_EXIT: exit_file_line_iterator_struct(); break;

#endif /* internal_exit_file_line_iterator_defined */
  default: break; 
  }
}

#endif /* file_line_iterator_event_handler_defined */
/*! @module String
 */

/*! @class SplitIterator
 */

#undef class_string_split_iterator_defined
#define class_string_split_iterator_defined
struct program *string_split_iterator_program=0;

#undef var_buffer_string_split_iterator_defined
#define var_buffer_string_split_iterator_defined

#undef var_current_string_split_iterator_defined
#define var_current_string_split_iterator_defined

#undef var_offset_string_split_iterator_defined
#define var_offset_string_split_iterator_defined

#undef var_index_string_split_iterator_defined
#define var_index_string_split_iterator_defined

#undef var_split_set_string_split_iterator_defined
#define var_split_set_string_split_iterator_defined

#undef var_split_set_size_string_split_iterator_defined
#define var_split_set_size_string_split_iterator_defined

#undef var_flags_string_split_iterator_defined
#define var_flags_string_split_iterator_defined

#undef var_feed_string_split_iterator_defined
#define var_feed_string_split_iterator_defined

#undef THIS
#define THIS ((struct string_split_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_STRING_SPLIT_ITERATOR
#define THIS_STRING_SPLIT_ITERATOR ((struct string_split_iterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_STRING_SPLIT_ITERATOR
#define OBJ2_STRING_SPLIT_ITERATOR(o) ((struct string_split_iterator_struct *)(o->storage+string_split_iterator_storage_offset))

#undef GET_STRING_SPLIT_ITERATOR_STORAGE
#define GET_STRING_SPLIT_ITERATOR_STORAGE ((struct string_split_iterator_struct *)(o->storage+string_split_iterator_storage_offset)
static ptrdiff_t string_split_iterator_storage_offset;
struct string_split_iterator_struct {

#ifdef var_buffer_string_split_iterator_defined
#line 826 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct pike_string *buffer;
#endif /* var_buffer_string_split_iterator_defined */

#ifdef var_current_string_split_iterator_defined
#line 827 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct pike_string *current;
#endif /* var_current_string_split_iterator_defined */

#ifdef var_offset_string_split_iterator_defined
#line 828 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int offset;
#endif /* var_offset_string_split_iterator_defined */

#ifdef var_index_string_split_iterator_defined
#line 829 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int index;
#endif /* var_index_string_split_iterator_defined */

#ifdef var_split_set_string_split_iterator_defined
#line 830 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
p_wchar2 *split_set;
#endif /* var_split_set_string_split_iterator_defined */

#ifdef var_split_set_size_string_split_iterator_defined
#line 831 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int split_set_size;
#endif /* var_split_set_size_string_split_iterator_defined */

#ifdef var_flags_string_split_iterator_defined
#line 832 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
int flags;
#endif /* var_flags_string_split_iterator_defined */

#ifdef var_feed_string_split_iterator_defined
#line 833 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct svalue feed;
#endif /* var_feed_string_split_iterator_defined */
};
#line 835 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
#define SIMPLE_SKIP(THIS, SHIFT, OFF) 	 	\
  do {						\
    PIKE_CONCAT(p_wchar, SHIFT) *s = 		\
      PIKE_CONCAT(STR,SHIFT)(THIS->buffer);	\
    while((OFF < THIS->buffer->len) &&		\
          s[OFF] == THIS->split_set[0]) {	\
      OFF++;					\
    }						\
  } while(0)

#define SIMPLE_SKIP_CASE(THIS, SHIFT, OFF)	\
  case SHIFT:					\
    SIMPLE_SKIP(THIS, SHIFT, OFF);		\
    break

#define COMPLEX_SKIP(THIS, SHIFT, OFF)	 		\
  do {							\
    PIKE_CONCAT(p_wchar, SHIFT) *s = 			\
      PIKE_CONCAT(STR,SHIFT)(THIS->buffer);		\
    while(OFF < THIS->buffer->len) {			\
      int i;						\
      p_wchar2 ch = s[OFF];				\
      for (i=0; i < THIS->split_set_size; i++) {	\
	if (ch == THIS->split_set[i]) {			\
	  goto PIKE_CONCAT(continue_skip,SHIFT);	\
	}						\
      }							\
      break;						\
    PIKE_CONCAT(continue_skip,SHIFT):			\
      OFF++;						\
    }							\
  } while(0)
  
#define COMPLEX_SKIP_CASE(THIS, SHIFT, OFF)	\
  case SHIFT:					\
    COMPLEX_SKIP(THIS, SHIFT, OFF);		\
    break

#define SIMPLE_SCAN(THIS, SHIFT, OFF)		\
  do {						\
    PIKE_CONCAT(p_wchar, SHIFT) *s = 		\
      PIKE_CONCAT(STR,SHIFT)(THIS->buffer);	\
    while((OFF < THIS->buffer->len) &&		\
          s[OFF] != THIS->split_set[0]) {	\
      OFF++;					\
    }						\
  } while(0)

#define SIMPLE_SCAN_CASE(THIS, SHIFT, OFF)	\
  case SHIFT:					\
    SIMPLE_SCAN(THIS, SHIFT, OFF);		\
    break

#define COMPLEX_SCAN(THIS, SHIFT, OFF)				\
  do {								\
    PIKE_CONCAT(p_wchar, SHIFT) *s = 				\
      PIKE_CONCAT(STR,SHIFT)(THIS->buffer);			\
    while(OFF < THIS->buffer->len) {				\
      int i;							\
      p_wchar2 ch = s[OFF];					\
      for (i=0; i < THIS->split_set_size; i++) {		\
	if (ch == THIS->split_set[i]) {				\
	  goto PIKE_CONCAT(break_scan,SHIFT);			\
	}							\
      }								\
      OFF++;							\
    }								\
  PIKE_CONCAT(break_scan, SHIFT): ;/* gcc complains without ;*/ \
  } while(0)

#define COMPLEX_SCAN_CASE(THIS, SHIFT, OFF)	\
  case SHIFT:					\
    COMPLEX_SCAN(THIS, SHIFT, OFF);		\
    break

#define SIMPLE_SCAN_PUSH(THIS, SHIFT, OFF)			\
  do {								\
    PIKE_CONCAT(p_wchar, SHIFT) *s = 				\
      PIKE_CONCAT(STR,SHIFT)(THIS->buffer);			\
    while((OFF < THIS->buffer->len) &&				\
          s[OFF] != THIS->split_set[0]) {			\
      OFF++;							\
    }								\
    push_string(PIKE_CONCAT(make_shared_binary_string, SHIFT)	\
      (s+offset, OFF-offset));					\
  } while(0)

#define SIMPLE_SCAN_CASE_PUSH(THIS, SHIFT, OFF)	\
  case SHIFT:					\
    SIMPLE_SCAN_PUSH(THIS, SHIFT, OFF);		\
    break

#define COMPLEX_SCAN_PUSH(THIS, SHIFT, OFF)				\
  do {									\
    PIKE_CONCAT(p_wchar, SHIFT) *s = 					\
      PIKE_CONCAT(STR,SHIFT)(THIS->buffer);				\
    while(OFF < THIS->buffer->len) {					\
      int i;								\
      p_wchar2 ch = s[OFF];						\
      for (i=0; i < THIS->split_set_size; i++) {			\
	if (ch == THIS->split_set[i]) {					\
	  push_string(PIKE_CONCAT(make_shared_binary_string, SHIFT)	\
	    (s+offset, OFF-offset));					\
	  goto PIKE_CONCAT(break_scan,SHIFT);				\
	}								\
      }									\
      OFF++;								\
    }									\
    push_string(PIKE_CONCAT(make_shared_binary_string, SHIFT)		\
      (s+offset, OFF-offset));						\
  PIKE_CONCAT(break_scan, SHIFT):					\
    ;									\
  } while(0)

#define COMPLEX_SCAN_CASE_PUSH(THIS, SHIFT, OFF)	\
  case SHIFT:						\
    COMPLEX_SCAN_PUSH(THIS, SHIFT, OFF);		\
    break

#define NEW_SKIP_CASE(SHIFT, FLAGS)				\
  case SHIFT:							\
    if (FLAGS) {						\
      /* Skip empty */						\
      if (ssi->split_set_size == 1) {				\
	SIMPLE_SKIP(ssi, SHIFT, offset);			\
      } else {							\
        COMPLEX_SKIP(ssi, SHIFT, offset);			\
      }								\
    }								\
    if (offset >= ssi->buffer->len) {				\
      free_string(ssi->buffer);					\
      ssi->buffer = NULL;					\
      ssi->offset = 0;						\
      offset = 0;						\
      if (ssi->feed.type == T_INT) {				\
	if (!(FLAGS)) {						\
	  MAKE_CONSTANT_SHARED_STRING(ssi->current, "");	\
	  ssi->index++;						\
	}							\
	return;							\
      } else {							\
	/* Attempt to fill the buffer with some more. */	\
	apply_svalue(&ssi->feed, 0);				\
	if ((Pike_sp[-1].type == T_STRING) &&			\
	    (Pike_sp[-1].u.string->len)) {			\
	  ssi->buffer = Pike_sp[-1].u.string;			\
	  Pike_sp--;						\
	  goto reskip_empty;					\
	}							\
	free_svalue(&ssi->feed);				\
	ssi->feed.type = T_INT;					\
	ssi->feed.u.integer = 0;				\
	pop_stack();						\
	if (!(FLAGS)) {						\
	  MAKE_CONSTANT_SHARED_STRING(ssi->current, "");	\
	  ssi->index++;						\
	}							\
	return;							\
      }								\
    }								\
    ssi->index++;						\
    end = offset;						\
    goto PIKE_CONCAT(scan_more_,SHIFT)

#define NEW_SCAN_MORE_CASE(SHIFT)				\
  case SHIFT:							\
  PIKE_CONCAT(scan_more_,SHIFT):				\
    if (ssi->split_set_size == 1) {				\
      SIMPLE_SCAN_PUSH(ssi, SHIFT, end);			\
    } else {							\
      COMPLEX_SCAN_PUSH(ssi, SHIFT, end);			\
    }								\
    if ((end == ssi->buffer->len) &&				\
	(ssi->feed.type != T_INT)) {				\
      apply_svalue(&ssi->feed, 0);				\
      if ((Pike_sp[-1].type == T_STRING) &&			\
	  (Pike_sp[-1].u.string->len)) {			\
	f_add(2);						\
	if (Pike_sp[-1].type != T_STRING) {			\
	  Pike_error("Bad result from concatenation!\n");	\
	}							\
	free_string(ssi->buffer);				\
	ssi->buffer = Pike_sp[-1].u.string;			\
	Pike_sp--;						\
	end -= offset;						\
	offset = 0;						\
	goto scan_more;						\
      }								\
      pop_stack();	/* Pop the end of stream marker. */	\
      								\
      /* Make sure we don't call feed() any more. */		\
      free_svalue(&ssi->feed);					\
      ssi->feed.type = T_INT;					\
      ssi->feed.u.integer = 0;					\
    }								\
    ssi->offset = end+1;					\
    ssi->current = Pike_sp[-1].u.string;			\
    Pike_sp--;							\
    if (ssi->offset > ssi->buffer->len) {			\
      free_string(ssi->buffer);					\
      ssi->buffer = 0;						\
    }								\
    break
  
  static void find_next(struct string_split_iterator_struct *ssi)
    {
      int offset = ssi->offset;
      int end;
      if (ssi->current) {
	free_string(ssi->current);
      }
      ssi->current = NULL;
      if (!ssi->buffer) {
	return;
      }
    reskip_empty:
      switch(ssi->buffer->size_shift) {
	NEW_SKIP_CASE(0, ssi->flags);
	NEW_SKIP_CASE(1, ssi->flags);
	NEW_SKIP_CASE(2, ssi->flags);
      default:
	Pike_fatal("Unsupported size shift!\n");
      }
    scan_more:
      switch(ssi->buffer->size_shift)
      {
	NEW_SCAN_MORE_CASE(0);
	NEW_SCAN_MORE_CASE(1);
	NEW_SCAN_MORE_CASE(2);
      default:
	Pike_fatal("Unsupported size shift!\n");
      }
    }

  #define f_string_split_iterator_value_defined
void f_string_split_iterator_value(INT32 args) {
#line 1069 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
      if (THIS->current) {
	ref_push_string(THIS->current);
      } else {
	push_undefined();
      }
    }

  }
#define f_string_split_iterator_index_defined
void f_string_split_iterator_index(INT32 args) {
#line 1078 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
{
      if (!THIS->current) {
	push_undefined();
      }else{
	do { INT_TYPE ret_=(THIS->index);  push_int(ret_); return; }while(0);
#line 1084 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}
    }

  }
#define f_string_split_iterator_cq__backtick_add_defined
void f_string_split_iterator_cq__backtick_add(INT32 args) {
#line 1087 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 1087 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 1087 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 1088 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      struct object *o=low_clone(string_split_iterator_program);
      int i;
      struct string_split_iterator_struct *ssi;
      (ssi = OBJ2_STRING_SPLIT_ITERATOR(o))[0]=*THIS;
      if (THIS->buffer) {
	add_ref(THIS->buffer);
      }
      if (THIS->current) {
	add_ref(THIS->current);
      }
      add_ref_svalue(&THIS->feed);
      for (i=0; i < steps; i++) {
	find_next(ssi);
      }
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 1104 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_split_iterator_cq__backtick_add_eq_defined
void f_string_split_iterator_cq__backtick_add_eq(INT32 args) {
#line 1106 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
INT_TYPE steps;
#line 1106 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 1106 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+=",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 1107 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
    int i;
    for(i = 0; i < steps; i++) {
      find_next(THIS);
    }
    do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 1113 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_split_iterator_next_defined
void f_string_split_iterator_next(INT32 args) {
#line 1115 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
{
      find_next(THIS);
      do { INT_TYPE ret_=(!!THIS->current);  push_int(ret_); return; }while(0);
#line 1119 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_split_iterator_cq__backtick_21_defined
void f_string_split_iterator_cq__backtick_21(INT32 args) {
#line 1121 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
{
      do { INT_TYPE ret_=(!THIS->current);  push_int(ret_); return; }while(0);
#line 1124 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
#define f_string_split_iterator_cq__sizeof_defined
void f_string_split_iterator_cq__sizeof(INT32 args) {
#line 1126 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 0) wrong_number_of_args_error("_sizeof",args,0);
{
    INT_TYPE res = 0;
    if (THIS->buffer) {
      int i, off;
      ref_push_string(THIS->buffer);
      if (THIS->offset) {
	push_int(THIS->offset);
	push_int(THIS->buffer->len);
	o_range();
      }
      for (i = 1; THIS->feed.type != T_INT; i++) {
	apply_svalue(&THIS->feed, 0);
	if ((Pike_sp[-1].type != T_STRING) ||
	    (!Pike_sp[-1].u.string->len)) {
	  /* End of stream marker. */
	  pop_stack();
	  free_svalue(&THIS->feed);
	  THIS->feed.type = T_INT;
	  THIS->feed.u.integer = 0;
	  break;
	}
      }
      f_add(i);	/* Join the segments. */
      free_string(THIS->buffer);
      THIS->buffer = Pike_sp[-1].u.string;
      THIS->offset = 0;
      Pike_sp--;

      /* Perform the scan. */
      for (off=0; off < THIS->buffer->len; off++) {
	if (THIS->flags) {
	  if (THIS->split_set_size == 1) {
	    switch(THIS->buffer->size_shift) {
	      SIMPLE_SKIP_CASE(THIS, 0, off);
	      SIMPLE_SKIP_CASE(THIS, 1, off);
	      SIMPLE_SKIP_CASE(THIS, 2, off);
	    default:
	      Pike_fatal("Unsupported size shift!\n");
	    }
	  } else {
	    switch(THIS->buffer->size_shift) {
	      COMPLEX_SKIP_CASE(THIS, 0, off);
	      COMPLEX_SKIP_CASE(THIS, 1, off);
	      COMPLEX_SKIP_CASE(THIS, 2, off);
	    default:
	      Pike_fatal("Unsupported size shift!\n");
	    }	  
	  }
	  if (off >= THIS->buffer->len) {
	    break;
	  }
	}
	res++;
	if (THIS->split_set_size == 1) {
	  switch(THIS->buffer->size_shift) {
	    SIMPLE_SCAN_CASE(THIS, 0, off);
	    SIMPLE_SCAN_CASE(THIS, 1, off);
	    SIMPLE_SCAN_CASE(THIS, 2, off);
	  default:
	    Pike_fatal("Unsupported size shift!\n");
	  }
	} else {
	  switch(THIS->buffer->size_shift) {
	    COMPLEX_SCAN_CASE(THIS, 0, off);
	    COMPLEX_SCAN_CASE(THIS, 1, off);
	    COMPLEX_SCAN_CASE(THIS, 2, off);
	  default:
	    Pike_fatal("Unsupported size shift!\n");
	  }
	}
      }
      if ((!THIS->flags) && (off == THIS->buffer->len)) {
	/* Ends with an empty segment. */
	res++;
      }
    }
    if (THIS->current) {
      res++;
    }
    do { INT_TYPE ret_=(res);  push_int(ret_); return; }while(0);
#line 1207 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

  }
/*! @decl void create(string buffer, int|array(int)|multiset(int) split_set,@
   *!                   int|void flags, function(:string)|void feed)
   */
  #define f_string_split_iterator_create_defined
void f_string_split_iterator_create(INT32 args) {
#line 1212 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct pike_string * buffer;
#line 1212 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct svalue * split_set;
struct svalue * flags;
#line 1213 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct svalue * feed;
#line 1212 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args < 2) wrong_number_of_args_error("create",args,2);
#line 1212 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args > 4) wrong_number_of_args_error("create",args,4);
#line 1212 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",1,"string");
#line 1212 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
debug_malloc_pass(buffer=Pike_sp[0-args].u.string);
#line 1212 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
split_set=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
if(args > 2) { flags=Pike_sp+2-args; dmalloc_touch_svalue(Pike_sp+2-args);
}else{
flags=0;
}if(args > 3) { 
#line 1213 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
feed=Pike_sp+3-args; dmalloc_touch_svalue(Pike_sp+3-args);
}else{
feed=0;
}
#line 1214 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      if (THIS->buffer) {
	Pike_error("String.split() iterators cannot be reused.\n");
      }
      if (split_set->type == T_INT) {
	THIS->split_set = (p_wchar2 *)xalloc(sizeof(p_wchar2));
	THIS->split_set[0] = split_set->u.integer;
	THIS->split_set_size = 1;
      } else {
	struct array *a;
	int i;
	if (split_set->type == T_ARRAY) {
	  a = split_set->u.array;
	} else if (split_set->type == T_MULTISET) {
#ifdef PIKE_NEW_MULTISETS
	  a = multiset_indices (split_set->u.multiset);
	  push_array (a);
#else
	  a = split_set->u.multiset->ind;
#endif
	} else {
	  SIMPLE_BAD_ARG_ERROR("String.split", 2,
			       "int|array(int)|multiset(int)");
	}
	if (!a->size) {
	  SIMPLE_BAD_ARG_ERROR("String.split", 2,
			       "int|array(int)|multiset(int)");
	}
	for (i=0; i < a->size; i++) {
	  if (a->item[i].type != T_INT) {
	    SIMPLE_BAD_ARG_ERROR("String.split", 2,
				 "int|array(int)|multiset(int)");
	  }
	}
	THIS->split_set = (p_wchar2 *)xalloc(a->size * sizeof(p_wchar2));
	for (i=0; i < a->size; i++) {
	  THIS->split_set[i] = a->item[i].u.integer;
	}
	THIS->split_set_size = a->size;
#ifdef PIKE_NEW_MULTISETS
	if (split_set->type == T_MULTISET) pop_stack();
#endif
      }
      add_ref(THIS->buffer = buffer);
      if (args > 2) {
	if (flags->type == T_INT) {
	  THIS->flags = flags->u.integer;
	} else {
	  THIS->flags = 0;
	}
	if (args > 3) {
	  assign_svalue(&THIS->feed, feed);
	} else {
	  /* NB: THIS->feed has already been set to 0 by the init code. */
	}
      } else {
	THIS->flags = 0;
      }
      THIS->offset = 0;
      THIS->current = NULL;
      THIS->index = -1;
      find_next(THIS);
    }
  
  }

#undef internal_init_string_split_iterator_defined
#define internal_init_string_split_iterator_defined

#undef string_split_iterator_event_handler_defined
#define string_split_iterator_event_handler_defined
static void init_string_split_iterator_struct(void)
#line 1279 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      THIS->buffer = NULL;
      THIS->current = NULL;
      THIS->offset = 0;
      THIS->index = 0;
      THIS->split_set = NULL;
      THIS->split_set_size = 0;
      THIS->flags = 0;
      THIS->feed.type = T_INT;
      THIS->feed.u.integer = 0;
    }

  
#undef internal_exit_string_split_iterator_defined
#define internal_exit_string_split_iterator_defined

#undef string_split_iterator_event_handler_defined
#define string_split_iterator_event_handler_defined
static void exit_string_split_iterator_struct(void)
#line 1292 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      if (THIS->buffer) {
	free_string(THIS->buffer);
	THIS->buffer = NULL;
      }
      if (THIS->current) {
	free_string(THIS->current);
	THIS->current = NULL;
      }
      free(THIS->split_set);
      THIS->split_set = NULL;
      free_svalue(&THIS->feed);
      THIS->feed.type = T_INT;
      THIS->feed.u.integer = 0;
    }

  
#undef internal_optimize_string_split_iterator_defined
#define internal_optimize_string_split_iterator_defined

#undef string_split_iterator_optimize_callback_defined
#define string_split_iterator_optimize_callback_defined
static node *optimize_string_split_iterator_struct(node *n)
#line 1309 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
{
      if (CDR(n) && (CDR(n)->token == F_ARG_LIST) &&
	  CADR(n) && (CADR(n)->token == F_APPLY) &&
	  CAADR(n) && (CAADR(n)->token == F_CONSTANT) &&
	  (CAADR(n)->u.sval.type == T_FUNCTION) &&
	  (CAADR(n)->u.sval.subtype == FUNCTION_BUILTIN) &&
	  (CAADR(n)->u.sval.u.efun->function == f_replace)) {
	/* String.SplitIterator(replace(...),...) */
	node *repl_args = CDADR(n);
	node **str = my_get_arg(&repl_args, 0);
	node **from = my_get_arg(&repl_args, 1);
	node **to = my_get_arg(&repl_args, 2);

	if (str && from && to) {
	  /* String.SplitIterator(replace(str, from, to), ...) */

	  int num;

	  if (((*to)->token == F_APPLY) &&
	      CAR(*to) && (CAR(*to)->token == F_CONSTANT) &&
	      (CAR(*to)->u.sval.type == T_FUNCTION) &&
	      (CAR(*to)->u.sval.subtype == FUNCTION_BUILTIN) &&
	      (CAR(*to)->u.sval.u.efun->function == f_allocate) &&
	      CDR(*to) && (CDR(*to)->token == F_ARG_LIST) &&
	      CADR(*to) && (CADR(*to)->token == F_CONSTANT) &&
	      (CADR(*to)->u.sval.type == T_INT) &&
	      (num = CADR(*to)->u.sval.u.integer) &&
	      CDDR(*to) && (CDDR(*to)->token == F_CONSTANT) &&
	      (CDDR(*to)->u.sval.type == T_STRING) &&
	      (CDDR(*to)->u.sval.u.string->len == 1)) {
	    /* String.SplitIterator(replace(str, from, allocate(num, "x")),
	     *                      ...) */
	    int split_val = index_shared_string(CDDR(*to)->u.sval.u.string, 0);

	    if (CDDR(n) &&
		(((CDDR(n)->token == F_CONSTANT) &&
		  (CDDR(n)->u.sval.type == T_INT) &&
		  (CDDR(n)->u.sval.u.integer == split_val)) ||
		 ((CDDR(n)->token == F_ARG_LIST) &&
		  CADDR(n) && (CADDR(n)->token == F_CONSTANT) &&
		  (CADDR(n)->u.sval.type == T_INT) &&
		  (CADDR(n)->u.sval.u.integer == split_val)))) {
	      /* String.SplitIterator(replace(str, from, allocate(n, "x")),
	       *                      'x', ...)
	       */
	      struct array *split = NULL;
	      node *res = NULL;

	      switch((*from)->token) {
	      case F_CONSTANT:
		if (((*from)->u.sval.type == T_ARRAY) &&
		    ((*from)->u.sval.u.array->size == num)) {
		  int i;
		  for (i=0; i < num; i++) {
		    if (((*from)->u.sval.u.array->item[i].type != T_STRING) ||
			((*from)->u.sval.u.array->item[i].u.string->len != 1)) {
		      return NULL;
		    }
		  }
		  split = allocate_array(num+1);
		  split->item[0].type = T_INT;
		  split->item[0].u.integer = split_val;
		  for (i=0; i < num; i++) {
		    split->item[i+1].type = T_INT;
		    split->item[i+1].u.integer =
		      index_shared_string((*from)->u.sval.u.array->
					  item[i].u.string, 0);
		  }		  
		}
		break;
	      case F_APPLY:
		if (CAR(*from) && (CAR(*from)->token == F_CONSTANT) &&
		    (CAR(*from)->u.sval.type == T_FUNCTION) &&
		    (CAR(*from)->u.sval.subtype == FUNCTION_BUILTIN)) {
		  if (CAR(*from)->u.sval.u.efun->function == f_allocate) {
		    /* FIXME: Not likely */
		  } else if (CAR(*from)->u.sval.u.efun->function ==
			     debug_f_aggregate) {
		    node *tmp = CDR(*from);
		    int i;
		    for (i = 0; tmp && (tmp->token == F_ARG_LIST);
			 tmp = CDR(tmp)) {
		      if (!CAR(tmp)) continue;
		      if ((CAR(tmp)->token != F_CONSTANT) || 
			  (CAR(tmp)->u.sval.type != T_STRING) ||
			  (CAR(tmp)->u.sval.u.string->len != 1)) {
			return NULL;
		      }
		      i++;
		    }
		    if (i != num) {
		      return NULL;
		    }
		    split = allocate_array(num+1);
		    split->item[0].type = T_INT;
		    split->item[0].u.integer = split_val;
		    tmp = CDR(*from);
		    for (i = 1; tmp && (tmp->token == F_ARG_LIST);
			 tmp = CDR(tmp)) {
		      if (!CAR(tmp)) continue;
		      split->item[i].type = T_INT;
		      split->item[i].u.integer =
			index_shared_string(CAR(tmp)->u.sval.u.string, 0);
		      i++;
		    }		    
		  }
		} else {
		  return NULL;
		}
		break;
	      default:
		return NULL;
	      }
	      if (!split) {
		return NULL;
	      }
	      push_array(split);	/* Simplify error-handling... */

	      /* Create the result...
	       *
	       * String.SplitIterator(str, split, ...)
	       */
	      if (CDDR(n)->token == F_ARG_LIST) {
		ADD_NODE_REF2(CAR(n),
		ADD_NODE_REF2(*str,
		ADD_NODE_REF2(CDDDR(n),
		  res =
		    mkapplynode(CAR(n),
			        mknode(F_ARG_LIST, *str,
				       mknode(F_ARG_LIST,
					      mkconstantsvaluenode(Pike_sp-1),
					      CDDDR(n))));
		)));
	      } else {
		ADD_NODE_REF2(CAR(n),
		ADD_NODE_REF2(*str,
		  res =
		    mkapplynode(CAR(n),
			        mknode(F_ARG_LIST, *str,
				       mkconstantsvaluenode(Pike_sp-1)));
		));
	      }
	      pop_stack();
	      return res;
	    }
	  }
	}
      }
      return NULL;
    }

#ifdef string_split_iterator_event_handler_defined
static void string_split_iterator_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_string_split_iterator_defined
  case PROG_EVENT_INIT: init_string_split_iterator_struct(); break;

#endif /* internal_init_string_split_iterator_defined */

#ifdef internal_exit_string_split_iterator_defined
  case PROG_EVENT_EXIT: exit_string_split_iterator_struct(); break;

#endif /* internal_exit_string_split_iterator_defined */
  default: break; 
  }
}

#endif /* string_split_iterator_event_handler_defined */
#line 1459 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
;

/*! @endclass
 */

/*! @endmodule
 */

#define f_Iterator_defined
void f_Iterator(INT32 args) {
#line 1467 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
struct svalue * data;
#line 1467 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
if(args != 1) wrong_number_of_args_error("Iterator",args,1);
#line 1467 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
data=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
  switch(data->type)
  {
    case PIKE_T_STRING:
      push_object(clone_object(string_iterator_program, 1));
      return;

    case PIKE_T_MAPPING:
      push_object(clone_object(mapping_iterator_program,1));
      return;

    case PIKE_T_MULTISET:
      push_object(clone_object(multiset_iterator_program, 1));
      return;

    case PIKE_T_ARRAY:
      push_object(clone_object(array_iterator_program, 1));
      return;


    case PIKE_T_OBJECT:
      if(!data->u.object->prog)
	Pike_error("Argument 1 to Iterator() is a destructed object.\n");

      if(FIND_LFUN(data->u.object->prog, LFUN__GET_ITERATOR) != -1)
      {
	apply_lfun(data->u.object, LFUN__GET_ITERATOR, 0);
	stack_unlink(1);
	return;
      }

      /* Assume it already is an iterator... */
      return;

    default:
      SIMPLE_BAD_ARG_ERROR("Iterator", 1, "multiset|array|string|mapping|object");
  }
}

}
#line 1507 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
/* sp[-4] = index; sp[-2] = value */
int foreach_iterate(struct object *o, int do_step)
{
  struct program *prog = o->prog;
  int fun;

  if(!prog)
    Pike_error("foreach on destructed iterator.\n");

  if(prog->flags & PROGRAM_HAS_C_METHODS)
  {
    if(prog == mapping_iterator_program)
    {
      struct mapping_iterator_struct *i=OBJ2_MAPPING_ITERATOR(o);

      if (!i->current) return 0;
      if (do_step) {
	mi_step (i);
	if (!i->current) return 0;
      }

      if(Pike_sp[-4].type != T_INT)
	assign_lvalue(Pike_sp-4, & i->current->ind);
	
      if(Pike_sp[-2].type != T_INT)
	assign_lvalue(Pike_sp-2, & i->current->val);

      return 1;
    }

    else if(prog == string_split_iterator_program)
    {
      struct string_split_iterator_struct *i=OBJ2_STRING_SPLIT_ITERATOR(o);

      if (!i->current) return 0;
      if (do_step) {
	find_next (i);
	if (!i->current) return 0;
      }

      if(Pike_sp[-4].type != T_INT)
      {
	/* Black Magic... */
	push_int(i->index);
	Pike_sp--;
	assign_lvalue(Pike_sp-4, Pike_sp);
      }

      if(Pike_sp[-2].type != T_INT)
      {
	/* Black Magic... */
	push_string(i->current);
	dmalloc_touch_svalue(Pike_sp-1);
	Pike_sp--;
	assign_lvalue(Pike_sp-2, Pike_sp);
      }

      return 1;
    }

    else if(prog == file_line_iterator_program)
    {
      struct file_line_iterator_struct *i=OBJ2_FILE_LINE_ITERATOR(o);

      if (!i->current) return 0;
      if (do_step) {
	fl_find_next (i);
	if (!i->current) return 0;
      }

      if(Pike_sp[-4].type != T_INT)
      {
	/* Black Magic... */
	push_int(i->index);
	Pike_sp--;
	assign_lvalue(Pike_sp-4, Pike_sp);
      }

      if(Pike_sp[-2].type != T_INT)
      {
	/* Black Magic... */
	push_string(i->current);
	dmalloc_touch_svalue(Pike_sp-1);
	Pike_sp--;
	assign_lvalue(Pike_sp-2, Pike_sp);
      }

      return 1;
    }

    else if(prog == array_iterator_program)
    {
      struct array_iterator_struct *i=OBJ2_ARRAY_ITERATOR(o);

      if (i->pos < 0 || i->pos >= i->a->size) return 0;
      if (do_step)
	if (++i->pos == i->a->size) return 0;

      if(Pike_sp[-4].type != T_INT)
      {
	push_int(i->pos);
	assign_lvalue(Pike_sp-5, Pike_sp-1);
	pop_stack();
      }

      if(Pike_sp[-2].type != T_INT)
	assign_lvalue(Pike_sp-2, i->a->item + i->pos);

      return 1;
    }

    else if(prog == multiset_iterator_program)
    {
      struct multiset_iterator_struct *i=OBJ2_MULTISET_ITERATOR(o);

#ifdef PIKE_NEW_MULTISETS
      struct svalue ind;

      if (i->nodepos < 0) return 0;
      if (do_step) {
	i->nodepos = multiset_next (i->l, i->nodepos);
	if (i->nodepos < 0) {
	  sub_msnode_ref (i->l);
	  return 0;
	}
      }

      if (Pike_sp[-4].type != T_INT)
	assign_lvalue (Pike_sp - 4, use_multiset_index (i->l, i->nodepos, ind));
      if (Pike_sp[-2].type != T_INT)
	assign_lvalue (Pike_sp - 2, get_multiset_value (i->l, i->nodepos));

      return 1;

#else  /* PIKE_NEW_MULTISETS */
      if (i->pos < 0 || i->pos >= i->a->size) return 0;
      if (do_step)
	if (++i->pos == i->a->size) return 0;

      if(Pike_sp[-4].type != T_INT)
	assign_lvalue(Pike_sp-4, i->a->item + i->pos);

      if(Pike_sp[-2].type != T_INT)
      {
	push_int(1);
	assign_lvalue(Pike_sp-3, Pike_sp-1);
	pop_stack();
      }

      return 1;

#endif	/* PIKE_NEW_MULTISETS */
    }

    else if(prog == string_iterator_program)
    {
      struct string_iterator_struct *i=OBJ2_STRING_ITERATOR(o);

      if (i->pos < 0 || i->pos >= i->s->len) return 0;
      if (do_step)
	if (++i->pos == i->s->len) return 0;

      if(Pike_sp[-4].type != T_INT)
      {
	push_int(i->pos);
	assign_lvalue(Pike_sp-5, Pike_sp-1);
	pop_stack();
      }

      if(Pike_sp[-2].type != T_INT)
      {
	push_int(index_shared_string(i->s, i->pos));
	assign_lvalue(Pike_sp-3, Pike_sp-1);
	pop_stack();
      }

      return 1;
    }
  }

  /* Generic iteration */

  if (do_step) {
    fun = FIND_LFUN (prog, LFUN_ADD_EQ);
    if (fun < 0) Pike_error ("Iterator object lacks `+=.\n");
    push_int(1);
    apply_low(o, fun, 1);
    pop_stack();
  }

  fun = FIND_LFUN (o->prog, LFUN_NOT);
  if (fun < 0) Pike_error ("Iterator object lacks `!.\n");
  apply_low(o, fun, 0);
  if(UNSAFE_IS_ZERO(Pike_sp-1))
  {
    pop_stack();

    if(Pike_sp[-4].type != T_INT)
    {
      fun = find_identifier ("index", o->prog);
      if (fun < 0) Pike_error ("Iterator object lacks index().\n");
      apply_low(o, fun, 0);
      assign_lvalue(Pike_sp-5,Pike_sp-1);
      pop_stack();
    }

    if(Pike_sp[-2].type != T_INT)
    {
      fun = find_identifier ("value", o->prog);
      if (fun < 0) Pike_error ("Iterator object lacks value().\n");
      apply_low(o, fun, 0);
      assign_lvalue(Pike_sp-3,Pike_sp-1);
      pop_stack();
    }

    return 1;
  }else{
    pop_stack();
    return 0;
  }
}


void init_iterators(void)
{
  
#ifdef class_mapping_iterator_defined

#ifdef PROG_MAPPING_ITERATOR_ID
  START_NEW_PROGRAM_ID(MAPPING_ITERATOR);
#else
  start_new_program();

#endif /* PROG_MAPPING_ITERATOR_ID */

#ifdef THIS_MAPPING_ITERATOR

  mapping_iterator_storage_offset=ADD_STORAGE(struct mapping_iterator_struct);

#endif /* THIS_MAPPING_ITERATOR */

#ifdef mapping_iterator_event_handler_defined
  pike_set_prog_event_callback(mapping_iterator_event_handler);

#endif /* mapping_iterator_event_handler_defined */

#ifdef f_mapping_iterator_value_defined
#line 45 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("value", f_mapping_iterator_value, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mapping_iterator_value_defined */

#ifdef f_mapping_iterator_index_defined
#line 55 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("index", f_mapping_iterator_index, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mapping_iterator_index_defined */

#ifdef f_mapping_iterator_cq__backtick_add_defined
#line 84 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+", f_mapping_iterator_cq__backtick_add, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mapping_iterator_cq__backtick_add_defined */

#ifdef f_mapping_iterator_cq__backtick_add_eq_defined
#line 95 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+=", f_mapping_iterator_cq__backtick_add_eq, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mapping_iterator_cq__backtick_add_eq_defined */

#ifdef f_mapping_iterator_first_defined
#line 101 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("first", f_mapping_iterator_first, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mapping_iterator_first_defined */

#ifdef f_mapping_iterator_cq__random_defined
#line 109 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("_random", f_mapping_iterator_cq__random, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mapping_iterator_cq__random_defined */

#ifdef f_mapping_iterator_next_defined
#line 133 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("next", f_mapping_iterator_next, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mapping_iterator_next_defined */

#ifdef f_mapping_iterator_cq__backtick_21_defined
#line 134 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`!", f_mapping_iterator_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mapping_iterator_cq__backtick_21_defined */

#ifdef f_mapping_iterator_create_defined
#line 136 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("create", f_mapping_iterator_create, tFunc(tMapping,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mapping_iterator_create_defined */
  mapping_iterator_program=end_program();
  add_program_constant("mapping_iterator",mapping_iterator_program,0);

#endif /* class_mapping_iterator_defined */

#ifdef class_array_iterator_defined

#ifdef PROG_ARRAY_ITERATOR_ID
  START_NEW_PROGRAM_ID(ARRAY_ITERATOR);
#else
  start_new_program();

#endif /* PROG_ARRAY_ITERATOR_ID */

#ifdef THIS_ARRAY_ITERATOR

  array_iterator_storage_offset=ADD_STORAGE(struct array_iterator_struct);

#endif /* THIS_ARRAY_ITERATOR */

#ifdef array_iterator_event_handler_defined
  pike_set_prog_event_callback(array_iterator_event_handler);

#endif /* array_iterator_event_handler_defined */

#ifdef f_array_iterator_value_defined
#line 170 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("value", f_array_iterator_value, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_value_defined */

#ifdef f_array_iterator_index_defined
#line 181 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("index", f_array_iterator_index, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_index_defined */

#ifdef f_array_iterator_cq__backtick_add_defined
#line 192 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+", f_array_iterator_cq__backtick_add, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_cq__backtick_add_defined */

#ifdef f_array_iterator_cq__backtick_add_eq_defined
#line 201 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+=", f_array_iterator_cq__backtick_add_eq, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_cq__backtick_add_eq_defined */

#ifdef f_array_iterator_cq__backtick_2D_defined
#line 207 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`-", f_array_iterator_cq__backtick_2D, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_cq__backtick_2D_defined */

#ifdef f_array_iterator_first_defined
#line 216 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("first", f_array_iterator_first, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_first_defined */

#ifdef f_array_iterator_cq__random_defined
#line 223 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("_random", f_array_iterator_cq__random, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_cq__random_defined */

#ifdef f_array_iterator_next_defined
#line 232 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("next", f_array_iterator_next, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_next_defined */

#ifdef f_array_iterator_cq__backtick_21_defined
#line 238 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`!", f_array_iterator_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_cq__backtick_21_defined */

#ifdef f_array_iterator_create_defined
  ADD_FUNCTION2("create", f_array_iterator_create, tFunc(tArray,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_array_iterator_create_defined */
  array_iterator_program=end_program();
  add_program_constant("array_iterator",array_iterator_program,0);

#endif /* class_array_iterator_defined */

#ifdef class_multiset_iterator_defined

#ifdef PROG_MULTISET_ITERATOR_ID
  START_NEW_PROGRAM_ID(MULTISET_ITERATOR);
#else
  start_new_program();

#endif /* PROG_MULTISET_ITERATOR_ID */

#ifdef THIS_MULTISET_ITERATOR

  multiset_iterator_storage_offset=ADD_STORAGE(struct multiset_iterator_struct);

#endif /* THIS_MULTISET_ITERATOR */

#ifdef multiset_iterator_event_handler_defined
  pike_set_prog_event_callback(multiset_iterator_event_handler);

#endif /* multiset_iterator_event_handler_defined */

#ifdef f_multiset_iterator_value_defined
  ADD_FUNCTION2("value", f_multiset_iterator_value, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_value_defined */

#ifdef f_multiset_iterator_index_defined
#line 281 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("index", f_multiset_iterator_index, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_index_defined */

#ifdef f_multiset_iterator_cq__backtick_add_eq_defined
#line 329 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+=", f_multiset_iterator_cq__backtick_add_eq, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__backtick_add_eq_defined */

#ifdef f_multiset_iterator_cq__backtick_add_defined
#line 336 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+", f_multiset_iterator_cq__backtick_add, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__backtick_add_defined */

#ifdef f_multiset_iterator_cq__backtick_2D_defined
#line 345 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`-", f_multiset_iterator_cq__backtick_2D, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__backtick_2D_defined */

#ifdef f_multiset_iterator_first_defined
#line 354 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("first", f_multiset_iterator_first, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_first_defined */

#ifdef f_multiset_iterator_next_defined
#line 362 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("next", f_multiset_iterator_next, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_next_defined */

#ifdef f_multiset_iterator_cq__backtick_21_defined
#line 373 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`!", f_multiset_iterator_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__backtick_21_defined */

#ifdef f_multiset_iterator_cq__random_defined
#line 381 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("_random", f_multiset_iterator_cq__random, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__random_defined */

#ifdef f_multiset_iterator_lock_index_defined
#line 394 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("lock_index", f_multiset_iterator_lock_index, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_lock_index_defined */

#ifdef f_multiset_iterator_unlock_index_defined
#line 404 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("unlock_index", f_multiset_iterator_unlock_index, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_unlock_index_defined */

#ifdef f_multiset_iterator_create_defined
#line 422 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("create", f_multiset_iterator_create, tFunc(tMultiset,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_create_defined */
  multiset_iterator_program=end_program();
  add_program_constant("multiset_iterator",multiset_iterator_program,0);

#endif /* class_multiset_iterator_defined */

#ifdef class_multiset_iterator_defined_2

#ifdef PROG_MULTISET_ITERATOR_ID
  START_NEW_PROGRAM_ID(MULTISET_ITERATOR);
#else
  start_new_program();

#endif /* PROG_MULTISET_ITERATOR_ID */

#ifdef THIS_MULTISET_ITERATOR

  multiset_iterator_storage_offset=ADD_STORAGE(struct multiset_iterator_struct);

#endif /* THIS_MULTISET_ITERATOR */

#ifdef multiset_iterator_event_handler_defined_2
  pike_set_prog_event_callback(multiset_iterator_event_handler);

#endif /* multiset_iterator_event_handler_defined_2 */

#ifdef f_multiset_iterator_value_defined_2
#line 459 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("value", f_multiset_iterator_value, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_value_defined_2 */

#ifdef f_multiset_iterator_index_defined_2
#line 470 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("index", f_multiset_iterator_index, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_index_defined_2 */

#ifdef f_multiset_iterator_cq__backtick_add_defined_2
#line 481 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+", f_multiset_iterator_cq__backtick_add, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__backtick_add_defined_2 */

#ifdef f_multiset_iterator_cq__backtick_add_eq_defined_2
#line 490 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+=", f_multiset_iterator_cq__backtick_add_eq, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__backtick_add_eq_defined_2 */

#ifdef f_multiset_iterator_cq__backtick_2D_defined_2
#line 496 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`-", f_multiset_iterator_cq__backtick_2D, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__backtick_2D_defined_2 */

#ifdef f_multiset_iterator_first_defined_2
#line 505 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("first", f_multiset_iterator_first, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_first_defined_2 */

#ifdef f_multiset_iterator_cq__random_defined_2
#line 512 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("_random", f_multiset_iterator_cq__random, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__random_defined_2 */

#ifdef f_multiset_iterator_next_defined_2
#line 521 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("next", f_multiset_iterator_next, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_next_defined_2 */

#ifdef f_multiset_iterator_cq__backtick_21_defined_2
#line 527 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`!", f_multiset_iterator_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_cq__backtick_21_defined_2 */

#ifdef f_multiset_iterator_create_defined_2
  ADD_FUNCTION2("create", f_multiset_iterator_create, tFunc(tMultiset,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multiset_iterator_create_defined_2 */
  multiset_iterator_program=end_program();
  add_program_constant("multiset_iterator",multiset_iterator_program,0);

#endif /* class_multiset_iterator_defined_2 */

#ifdef class_string_iterator_defined

#ifdef PROG_STRING_ITERATOR_ID
  START_NEW_PROGRAM_ID(STRING_ITERATOR);
#else
  start_new_program();

#endif /* PROG_STRING_ITERATOR_ID */

#ifdef THIS_STRING_ITERATOR

  string_iterator_storage_offset=ADD_STORAGE(struct string_iterator_struct);

#endif /* THIS_STRING_ITERATOR */

#ifdef string_iterator_event_handler_defined
  pike_set_prog_event_callback(string_iterator_event_handler);

#endif /* string_iterator_event_handler_defined */

#ifdef f_string_iterator_value_defined
#line 560 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("value", f_string_iterator_value, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_value_defined */

#ifdef f_string_iterator_index_defined
#line 570 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("index", f_string_iterator_index, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_index_defined */

#ifdef f_string_iterator_cq__backtick_add_defined
#line 580 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+", f_string_iterator_cq__backtick_add, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_cq__backtick_add_defined */

#ifdef f_string_iterator_cq__backtick_add_eq_defined
#line 589 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+=", f_string_iterator_cq__backtick_add_eq, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_cq__backtick_add_eq_defined */

#ifdef f_string_iterator_cq__backtick_2D_defined
#line 595 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`-", f_string_iterator_cq__backtick_2D, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_cq__backtick_2D_defined */

#ifdef f_string_iterator_first_defined
#line 604 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("first", f_string_iterator_first, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_first_defined */

#ifdef f_string_iterator_cq__random_defined
#line 611 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("_random", f_string_iterator_cq__random, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_cq__random_defined */

#ifdef f_string_iterator_next_defined
#line 620 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("next", f_string_iterator_next, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_next_defined */

#ifdef f_string_iterator_cq__backtick_21_defined
#line 626 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`!", f_string_iterator_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_cq__backtick_21_defined */

#ifdef f_string_iterator_create_defined
  ADD_FUNCTION2("create", f_string_iterator_create, tFunc(tString,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_iterator_create_defined */
  string_iterator_program=end_program();
  add_program_constant("string_iterator",string_iterator_program,0);

#endif /* class_string_iterator_defined */

#ifdef class_file_line_iterator_defined

#ifdef PROG_FILE_LINE_ITERATOR_ID
  START_NEW_PROGRAM_ID(FILE_LINE_ITERATOR);
#else
  start_new_program();

#endif /* PROG_FILE_LINE_ITERATOR_ID */

#ifdef THIS_FILE_LINE_ITERATOR

  file_line_iterator_storage_offset=ADD_STORAGE(struct file_line_iterator_struct);

#endif /* THIS_FILE_LINE_ITERATOR */

#ifdef file_line_iterator_event_handler_defined
  pike_set_prog_event_callback(file_line_iterator_event_handler);

#endif /* file_line_iterator_event_handler_defined */

#ifdef f_file_line_iterator_value_defined
#line 721 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("value", f_file_line_iterator_value, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_file_line_iterator_value_defined */

#ifdef f_file_line_iterator_index_defined
#line 730 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("index", f_file_line_iterator_index, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_file_line_iterator_index_defined */

#ifdef f_file_line_iterator_cq__backtick_add_defined
#line 739 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+", f_file_line_iterator_cq__backtick_add, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_file_line_iterator_cq__backtick_add_defined */

#ifdef f_file_line_iterator_cq__backtick_add_eq_defined
#line 756 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+=", f_file_line_iterator_cq__backtick_add_eq, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_file_line_iterator_cq__backtick_add_eq_defined */

#ifdef f_file_line_iterator_next_defined
#line 763 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("next", f_file_line_iterator_next, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_file_line_iterator_next_defined */

#ifdef f_file_line_iterator_cq__backtick_21_defined
#line 769 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`!", f_file_line_iterator_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_file_line_iterator_cq__backtick_21_defined */

#ifdef f_file_line_iterator_create_defined
  ADD_FUNCTION2("create", f_file_line_iterator_create, tFunc(tOr(tFunc(tNone,tString),tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_file_line_iterator_create_defined */
  file_line_iterator_program=end_program();
  add_program_constant("file_line_iterator",file_line_iterator_program,0);

#endif /* class_file_line_iterator_defined */

#ifdef class_string_split_iterator_defined

#ifdef PROG_STRING_SPLIT_ITERATOR_ID
  START_NEW_PROGRAM_ID(STRING_SPLIT_ITERATOR);
#else
  start_new_program();

#endif /* PROG_STRING_SPLIT_ITERATOR_ID */

#ifdef THIS_STRING_SPLIT_ITERATOR

  string_split_iterator_storage_offset=ADD_STORAGE(struct string_split_iterator_struct);

#endif /* THIS_STRING_SPLIT_ITERATOR */

#ifdef string_split_iterator_event_handler_defined
  pike_set_prog_event_callback(string_split_iterator_event_handler);

#endif /* string_split_iterator_event_handler_defined */

#ifdef string_split_iterator_optimize_callback_defined
  pike_set_prog_optimize_callback(optimize_string_split_iterator_struct);

#endif /* string_split_iterator_optimize_callback_defined */

#ifdef f_string_split_iterator_value_defined
#line 1069 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("value", f_string_split_iterator_value, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_split_iterator_value_defined */

#ifdef f_string_split_iterator_index_defined
#line 1078 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("index", f_string_split_iterator_index, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_split_iterator_index_defined */

#ifdef f_string_split_iterator_cq__backtick_add_defined
#line 1087 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+", f_string_split_iterator_cq__backtick_add, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_split_iterator_cq__backtick_add_defined */

#ifdef f_string_split_iterator_cq__backtick_add_eq_defined
#line 1106 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`+=", f_string_split_iterator_cq__backtick_add_eq, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_split_iterator_cq__backtick_add_eq_defined */

#ifdef f_string_split_iterator_next_defined
#line 1115 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("next", f_string_split_iterator_next, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_split_iterator_next_defined */

#ifdef f_string_split_iterator_cq__backtick_21_defined
#line 1121 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("`!", f_string_split_iterator_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_split_iterator_cq__backtick_21_defined */

#ifdef f_string_split_iterator_cq__sizeof_defined
  ADD_FUNCTION2("_sizeof", f_string_split_iterator_cq__sizeof, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_split_iterator_cq__sizeof_defined */

#ifdef f_string_split_iterator_create_defined
#line 1212 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("create", f_string_split_iterator_create, tFunc(tString tOr3("\10\200\0\0\0\177\377\377\377",tArr("\10\200\0\0\0\177\377\377\377"),tSet("\10\200\0\0\0\177\377\377\377")) tOr("\10\200\0\0\0\177\377\377\377",tVoid) tOr(tFunc(tNone,tString),tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_string_split_iterator_create_defined */
  string_split_iterator_program=end_program();
  add_program_constant("string_split_iterator",string_split_iterator_program,0);

#endif /* class_string_split_iterator_defined */

#ifdef f_Iterator_defined
#line 1467 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
  ADD_FUNCTION2("Iterator", f_Iterator, tFunc(tOr5(tObj,tArray,tMapping,tMultiset,tString),tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Iterator_defined */
#line 1733 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

void exit_iterators(void)
{
  
#ifdef class_mapping_iterator_defined
  if(mapping_iterator_program) {
    free_program(mapping_iterator_program);
    mapping_iterator_program=0;
  }

#endif /* class_mapping_iterator_defined */

#ifdef class_array_iterator_defined
  if(array_iterator_program) {
    free_program(array_iterator_program);
    array_iterator_program=0;
  }

#endif /* class_array_iterator_defined */

#ifdef class_multiset_iterator_defined
  if(multiset_iterator_program) {
    free_program(multiset_iterator_program);
    multiset_iterator_program=0;
  }

#endif /* class_multiset_iterator_defined */

#ifdef class_multiset_iterator_defined_2
  if(multiset_iterator_program) {
    free_program(multiset_iterator_program);
    multiset_iterator_program=0;
  }

#endif /* class_multiset_iterator_defined_2 */

#ifdef class_string_iterator_defined
  if(string_iterator_program) {
    free_program(string_iterator_program);
    string_iterator_program=0;
  }

#endif /* class_string_iterator_defined */

#ifdef class_file_line_iterator_defined
  if(file_line_iterator_program) {
    free_program(file_line_iterator_program);
    file_line_iterator_program=0;
  }

#endif /* class_file_line_iterator_defined */

#ifdef class_string_split_iterator_defined
  if(string_split_iterator_program) {
    free_program(string_split_iterator_program);
    string_split_iterator_program=0;
  }

#endif /* class_string_split_iterator_defined */
#line 1738 "/home/distmaker/tmp/build/pike.srcbuild/../pike-cvs/src/iterators.cmod"
}

