/***  WINDOWS.C: Contains standard Window-Handling UWM-routines  ***/

/* ########################################################################

   uwm - THE ude WINDOW MANAGER

   ########################################################################

   Copyright (c) : Christian Ruppert

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ######################################################################## */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>

#include <stdlib.h>

#include "uwm.h"
#include "init.h"
#include "properties.h"
#include "nodes.h"
#include "menu.h"
#include "workspaces.h"
#include "widgets.h"
#include "placement.h"
#include "special.h"
#include "ude-i18n.h"
#include "windows.h"

extern Display *disp;
extern UDEScreen TheScreen;
extern InitStruct InitS;
extern XContext UWMContext;
extern HandlerTable *Handle;
extern HandlerTable MoveHandle[LASTEvent];
extern HandlerTable ResizeHandle[LASTEvent];
extern Atom WM_STATE_PROPERTY;
extern Atom WM_TAKE_FOCUS;
extern Atom WM_DELETE_WINDOW;

UltimateContext *ActiveWin=NULL;
UltimateContext *RaisedWin=NULL;

/***  Will update the given UltimateContext-structure  ***
 ***  uc->win has to be preinitialized                 ***/

void UpdateUWMContext(UltimateContext *uc)
{
  XGetWindowAttributes(disp,uc->win,&(uc->Attributes));
  if(uc->frame) XGetWindowAttributes(disp,uc->frame,&(uc->Attr));
}

char WinVisible(UltimateContext *uc)
{
  if(OnActiveWS(uc->WorkSpace) && (uc->status & MAPPED)) return(-1);
  else return(0);
}

void SetWinMapState(UltimateContext *uc,int state)
{
  unsigned long data[2];

  data[0] = (unsigned long) state;
  if(uc->WMHints) data[1] = (unsigned long) uc->WMHints->icon_window;

  XChangeProperty(disp,uc->win,WM_STATE_PROPERTY,WM_STATE_PROPERTY,32,\
                              PropModeReplace,(unsigned char *)data,2);
}

void DrawWinBorder(UltimateContext *uc)
{
  if(uc->frame==None) return;
  if(uc==ActiveWin){
    XSetWindowBackground(disp,uc->border,TheScreen.ActiveBorder\
                           [TheScreen.desktop.ActiveWorkSpace]);
    XClearWindow(disp,uc->border);
    if(uc->title!=None) {
      if(uc->name && (!(uc->status & SHAPED)) && (InitS.BorderTitleFlags &\
                                                         BT_ACTIVE_TITLE)){
        XSetWindowBackground(disp,uc->title,TheScreen.ActiveBorder\
                              [TheScreen.desktop.ActiveWorkSpace]);
        XClearWindow(disp,uc->title);
        XRaiseWindow(disp,uc->title);
        DrawTitle(uc,-1);
      } else {
        XLowerWindow(disp,uc->title);
      }
    }
  } else {
    XSetWindowBackground(disp,uc->border,TheScreen.InactiveBorder\
                             [TheScreen.desktop.ActiveWorkSpace]);
    XClearWindow(disp,uc->border);
    if(uc->title!=None) {
      if(uc->name && (!(uc->status & SHAPED)) && (InitS.BorderTitleFlags &\
                                                       BT_INACTIVE_TITLE)){
        XSetWindowBackground(disp,uc->title,TheScreen.InactiveBorder\
                                [TheScreen.desktop.ActiveWorkSpace]);
        XClearWindow(disp,uc->title);
        XRaiseWindow(disp,uc->title);
        DrawTitle(uc,0);
      } else {
        XLowerWindow(disp,uc->title);
      }
    }
  }  
  DrawFrameBevel(uc,uc==ActiveWin);
}

void ShapeFrame(UltimateContext *uc)
{
  int a,shaped,wbs,hbs;
  XRectangle rects[4];

  XShapeQueryExtents(disp,uc->win,&shaped,&a,&a,&wbs,&hbs,&a,&a,&a,&a,&a);
  if(shaped && (uc->frame!=None)){
    uc->status|=SHAPED;
    for(a=0;a<4;a++) rects[a].width=rects[a].height=uc->BorderWidth;
    rects[0].x=rects[0].y=rects[1].x=rects[2].y=0;
    rects[1].y=rects[3].y=hbs+uc->BorderWidth+TheScreen.TitleHeight;
    rects[2].x=rects[3].x=wbs+uc->BorderWidth;
    XShapeCombineShape(disp,uc->frame,ShapeBounding,uc->BorderWidth,\
                      uc->BorderWidth+TheScreen.TitleHeight,uc->win,\
                                             ShapeBounding,ShapeSet);
    XShapeCombineRectangles(disp,uc->frame,ShapeBounding,0,0,rects,4,\
                                                        ShapeUnion,0);
  } else {
    uc->status&=~SHAPED;
  }
}

/*** width and hight of frame window! ***/

void MoveResizeWin(UltimateContext *uc,int x,int y,int width,int height)
{
  int ow,oh,ox,oy;
  if(((x==(ox=uc->Attr.x))&&(y==(oy=uc->Attr.y)))&&\
       ((width==(ow=uc->Attr.width))||(width==0))&&\
      ((height==(oh=uc->Attr.height))||(height==0)))
    return;

  if(!(width||height)){
    XMoveWindow(disp,uc->frame,x,y);
  } else {
    XMoveResizeWindow(disp,uc->frame,x,y,width,height);
    XResizeWindow(disp,uc->border,width,height);
    XResizeWindow(disp,uc->win,width-2*uc->BorderWidth,\
        height-2*uc->BorderWidth-TheScreen.TitleHeight);
    if(InitS.BorderTitleFlags & BT_CENTER_TITLE) {
      XMoveWindow(disp,uc->title,(width-uc->TitleWidth)/2,\
                  (uc->BorderWidth-TheScreen.desktop.FrameBevelWidth-1) / 2\
                  + TheScreen.desktop.FrameBevelWidth);
    }
  }
  UpdateUWMContext(uc);
  if(((x!=ox)||(y!=ox))&&(((width==0)||(width==ow))&&\
                         ((height==0)||(height==oh))))
    SendConfigureEvent(uc);
}

/***  Will add a Frame-Window behind (and around) the   ***
 ***  real Window. The Frame Window is used as an eazy  ***
 ***  realisation of window borders etc...              ***/

void EnborderWin(UltimateContext *uc)
{
  XSetWindowAttributes SAttr;
  Node *p;
  Window dummy;
  int a,w,h;
  char HasTitle=-1;

  if(uc->frame) return; /* frame already existing... */

  UpdateUWMContext(uc);
  if(uc->Attributes.override_redirect) return;
  if(XGetTransientForHint(disp,uc->win,&dummy)) {
    uc->BorderWidth=TheScreen.BorderWidth2;
    uc->status &= ~PLACEIT;
  }
  else if(!uc->BorderWidth) uc->BorderWidth=TheScreen.BorderWidth1;

  if(uc->MotifWMHints){
    if((uc->MotifWMHints->flags & MWM_HINTS_FUNCTIONS)
       && (uc->MotifWMHints->functions==0))
      uc->BorderWidth=0;
    if(uc->MotifWMHints->flags & MWM_HINTS_DECORATIONS) {
      if(uc->MotifWMHints->decorations==0) uc->BorderWidth=0;
      HasTitle = (uc->MotifWMHints->decorations & MWM_DECOR_TITLE);
    }
  }

  if((InitS.PlacementStrategy & 1) && ((uc->Attributes.x!=0) ||\
                 (uc->Attributes.y!=0))) uc->status &= ~PLACEIT;

DBG(fprintf(TheScreen.errout,"reparenting: %d\n",uc->win);)
  GrabServer();

  /*** create a frame to keep the window and its border ***/
  SAttr.override_redirect=True;
  SAttr.cursor=TheScreen.Mice[C_WINDOW];
  uc->frame=XCreateWindow(disp,uc->parent,uc->Attributes.x,uc->Attributes.y,\
                                     uc->Attributes.width+2*uc->BorderWidth,\
               uc->Attributes.height+2*uc->BorderWidth+TheScreen.TitleHeight\
                               ,0,CopyFromParent,InputOutput,CopyFromParent,\
                                         CWCursor|CWOverrideRedirect,&SAttr);
  if(XSaveContext(disp,uc->frame,UWMContext,(XPointer)uc))
    fprintf(TheScreen.errout,"UWM FATAL: Couldn't save Context\n");
  XSelectInput(disp,uc->frame,FRAME_EVENTS);

  ShapeFrame(uc);                  /* adjust frame to shaped window */

  /*** create an independent border-window ***/
  SAttr.override_redirect=True;
  SAttr.background_pixel=TheScreen.InactiveBorder
                         [TheScreen.desktop.ActiveWorkSpace];
  SAttr.cursor=TheScreen.Mice[C_BORDER];
  uc->border=XCreateWindow(disp,uc->frame,0,0,uc->Attributes.width+\
                           2*uc->BorderWidth,uc->Attributes.height+\
                           2*uc->BorderWidth+TheScreen.TitleHeight,\
                       0,CopyFromParent,InputOutput,CopyFromParent,\
                    CWCursor|CWOverrideRedirect|CWBackPixel,&SAttr);
  if(XSaveContext(disp,uc->border,UWMContext,(XPointer)uc))
    fprintf(TheScreen.errout,"UWM FATAL: Couldn't save Context\n");
  XSelectInput(disp,uc->border,BORDER_EVENTS);
  XMapWindow(disp,uc->border);

  /*** create title-window if needed ***/
  if((InitS.BorderTitleFlags & (BT_INACTIVE_TITLE|BT_ACTIVE_TITLE)) && HasTitle)
  {
    SAttr.override_redirect=True;
    SAttr.background_pixel=TheScreen.InactiveBorder
                           [TheScreen.desktop.ActiveWorkSpace];
    SAttr.cursor=TheScreen.Mice[C_BORDER];
    a = (uc->BorderWidth-TheScreen.desktop.FrameBevelWidth-1)
        / 2 + TheScreen.desktop.FrameBevelWidth;
    uc->title=XCreateWindow(disp,uc->frame,a,a,1,1,0,CopyFromParent,InputOutput\
                ,CopyFromParent,CWCursor|CWOverrideRedirect|CWBackPixel,&SAttr);
    if(XSaveContext(disp,uc->title,UWMContext,(XPointer)uc))
      fprintf(TheScreen.errout,"UWM FATAL: Couldn't save Context\n");
    XSelectInput(disp,uc->title,TITLE_EVENTS);
    XMapRaised(disp,uc->title);
  }

  XAddToSaveSet(disp,uc->win);
  
  uc->status|=REPARENTING; /* prevent unmapping of an already mapped window */
  XReparentWindow(disp,uc->win,uc->frame,uc->BorderWidth-\
             uc->Attributes.border_width,uc->BorderWidth+\
             TheScreen.TitleHeight-uc->Attributes.border_width);

  UpdateUWMContext(uc);
  UpdateWMProtocols(uc);
  SendConfigureEvent(uc);

  if(uc->MySibling){
    XWindowChanges xc;
    if(uc->MySibling->frame) xc.sibling=uc->MySibling->frame;
    else xc.sibling=uc->MySibling->win;
    xc.stack_mode=uc->StackMode;
    XConfigureWindow(disp,uc->win,CWSibling|CWStackMode,&xc);
  }

  p= NULL;
  while((p= NodeNext(uc->SiblingTo,p)))
    {
      XWindowChanges xc;
      xc.sibling=uc->frame;
      xc.stack_mode=((UltimateContext *)p)->StackMode;
      if(((UltimateContext *)p)->frame)
	XConfigureWindow(disp,((UltimateContext *)p)->frame,\
			 CWSibling|CWStackMode,&xc);
      else
	XConfigureWindow(disp,((UltimateContext *)p)->win,\
			 CWSibling|CWStackMode,&xc);
    }

  UngrabServer();

  UpdateName(uc);
  Updatera(uc);

  if(TheScreen.MaxWinWidth||TheScreen.MaxWinHeight){
    w=TheScreen.MaxWinWidth?((TheScreen.MaxWinWidth<uc->Attr.width)?\
                TheScreen.MaxWinWidth:uc->Attr.width):uc->Attr.width;
    w=(w-2*uc->BorderWidth)<uc->ra.minw?uc->ra.minw:w;
    w=((int)((w-uc->ra.bw)/uc->ra.wi))*uc->ra.wi+uc->ra.bw;
    h=TheScreen.MaxWinHeight?((TheScreen.MaxWinHeight<uc->Attr.height)?\
                TheScreen.MaxWinHeight:uc->Attr.height):uc->Attr.height;
    h=(h-2*uc->BorderWidth-uc->TitleHeight)<uc->ra.minh?uc->ra.minh:h;
    h=((int)((h-uc->ra.bh)/uc->ra.hi))*uc->ra.hi+uc->ra.bh;
    if((uc->Attr.width!=w)||(uc->Attr.height!=h))
      MoveResizeWin(uc,uc->Attr.x,uc->Attr.y,w,h);
  }
}

void UnmapWin(UltimateContext *uc)
{
  XUnmapWindow(disp,uc->win);
}

void MapWin(UltimateContext *uc,Bool NoPlacement)
{
  if(uc->frame==None) EnborderWin(uc);

  if(OnActiveWS(uc->WorkSpace)) {
    if(!NoPlacement) PlaceWin(uc);
    XMapRaised(disp,uc->win);
    if(uc->frame!=None){
      XMapSubwindows(disp,uc->frame);
      XMapRaised(disp,uc->frame);
      DrawWinBorder(uc);
    }
    if(InitS.WarpPointerToNewWin && (!NoPlacement))
      XWarpPointer(disp, None, uc->win, 0, 0, 0, 0, uc->Attributes.width/2,
                   uc->Attributes.height/2);
  }
  uc->status |= MAPPED;
  uc->status &= ~ICONIFIED;
  SetWinMapState(uc,NormalState);
}

void ActivateWin(UltimateContext *uc)
{
  UltimateContext *OldActive;

  if((Handle==MoveHandle)||(Handle==ResizeHandle)) return;
                       /* Don't confuse window moving or resizing routines!!! */
  if(uc) if(!OnActiveWS(uc->WorkSpace)) return;

  OldActive=ActiveWin;
  ActiveWin=uc;
  
  if(uc!=OldActive){
    if(OldActive){
      XSetInputFocus(disp,PointerRoot,RevertToPointerRoot,CurrentTime);
      DrawWinBorder(OldActive);
    }
    if(uc){
      UpdateUWMContext(uc);
      XInstallColormap(disp,uc->Attributes.colormap);
      if(!((uc->WMHints)&&(uc->WMHints->flags&InputHint)&&\
                                    (!uc->WMHints->input)))
        XSetInputFocus(disp,ActiveWin->win,RevertToPointerRoot,CurrentTime);

      UpdateWMProtocols(ActiveWin);
      if(ActiveWin->ProtocolFlags & TAKE_FOCUS)
        SendWMProtocols(ActiveWin,WM_TAKE_FOCUS);
      DrawWinBorder(ActiveWin);
    }
  }
}

void DisenborderWin(UltimateContext *uc,Bool alive)
{
  if(uc->frame!=None) {
    if(alive){
      uc->status|=REPARENTING;
      XReparentWindow(disp,uc->win,uc->parent,uc->Attr.x,uc->Attr.y);
    }
    XDeleteContext(disp,uc->border,UWMContext);
    XDestroyWindow(disp,uc->border);
    if(uc->title!=None) {
      XDeleteContext(disp,uc->title,UWMContext);
      XDestroyWindow(disp,uc->title);
    }
    XDeleteContext(disp,uc->frame,UWMContext);
    XDestroyWindow(disp,uc->frame);
    uc->frame=uc->border=uc->title=None;
  }
}

Node* DeUltimizeWin(UltimateContext *uc,Bool alive)
{
  Node *n;

  n=NodeDelete(TheScreen.UltimateList,InNodeList(TheScreen.UltimateList,uc));
  XDeleteContext(disp,uc->win,UWMContext);

  if(alive) XSetWindowBorderWidth(disp,uc->win,uc->OldBorderWidth);
  DisenborderWin(uc,alive);

  if(uc==ActiveWin) ActivateWin(NULL);

  NodeListDelete(&(uc->SiblingTo));
  free(uc);

  return(n);
}

UltimateContext *UltimizeWin(Window win,Window parent)
{
  UltimateContext *uc;
  XWindowAttributes Attr;

  XGetWindowAttributes(disp,win,&Attr);
  if(Attr.override_redirect) return(NULL);

DBG(fprintf(TheScreen.errout,"ULTIMIZING WIN #%d: no override redirect.\n",win);)
  if(!(uc=malloc(sizeof(UltimateContext)))) {
    fprintf(TheScreen.errout,"UWM: Cannot create Window. (Not enough Memory)\n");
    return(NULL); }
  uc->win=win;
  uc->parent=parent;
  uc->frame=None;
  uc->border=None;
  uc->title=None;
  uc->BorderWidth=0;
  uc->OldBorderWidth=Attr.border_width;
  uc->status=PLACEIT;
  uc->WMHints=NULL;
  uc->MotifWMHints=NULL;
  uc->WorkSpace=TheScreen.desktop.ActiveWorkSpace;
  uc->name=NULL;

  XSetWindowBorderWidth(disp,uc->win,0);
  if(!(uc->SiblingTo=NodeListCreate()))
    SeeYa(1,"UWM FATAL: out of memory");
  uc->MySibling=NULL;
  uc->StackMode=0;
  if(XSaveContext(disp,uc->win,UWMContext,(XPointer)uc))
   fprintf(TheScreen.errout,"UWM FATAL: Couldn't save Context\n");
  XSelectInput(disp,uc->win,WINDOW_EVENTS);
  XShapeSelectInput(disp,uc->win,ShapeNotifyMask);

  UpdateUWMContext(uc);
  UpdateName(uc);
  UpdateWMHints(uc);
  UpdateMotifHints(uc);
  if(!NodeAppend(TheScreen.UltimateList,uc))
    SeeYa(1,"FATAL: out of memory!");
  return(uc);
}

void IconifyWin(UltimateContext *uc)
{
  if(uc->status&ICONIFIED) return;

  uc->status|=KEEPENBORDERED;
  UnmapWin(uc);
  uc->status|=ICONIFIED;

  if(uc->WMHints){
    uc->WMHints->flags|=StateHint;
    uc->WMHints->initial_state=IconicState;
    XSetWMHints(disp,uc->win,uc->WMHints);
    UpdateWMHints(uc);
  }
  SetWinMapState(uc,IconicState);
}

void DeiconifyWin(UltimateContext *uc)
{
  if(!(uc->status&ICONIFIED)) return;

  uc->status&=~ICONIFIED;

  ChangeWS(uc->WorkSpace);

  MapWin(uc,False);
  
  if(uc->WMHints){
    uc->WMHints->flags|=StateHint;
    uc->WMHints->initial_state=NormalState;
    XSetWMHints(disp,uc->win,uc->WMHints);
    UpdateWMHints(uc);
    UpdateWMProtocols(uc);
  }
}

void CloseWin(UltimateContext *uc)
{
  if(uc->ProtocolFlags & DELETE_WINDOW)
    SendWMProtocols(uc,WM_DELETE_WINDOW);
}

void DeiconifyMenu(int x,int y)
{
  int a;
  Node *ucn;
  Menu *men,**wspaces=NULL,*sticky;
  MenuItem *item;

  men=MenuCreate(_("Windows Menu"));
  if(!men)
    SeeYa(1, "FATAL: out of memory!");

  wspaces=MyCalloc(TheScreen.desktop.WorkSpaces,sizeof(Menu *));
  if(TheScreen.desktop.WorkSpaces>1){
    for(a=0;a<TheScreen.desktop.WorkSpaces;a++){
      wspaces[a]=MenuCreate(TheScreen.WorkSpace[a]);
      AppendMenuItem(men,TheScreen.WorkSpace[a],wspaces[a],I_SUBMENU);
    }
    AppendMenuItem (men, NULL, NULL, I_LINE);
    sticky=MenuCreate (_("Sticky Windows"));
    AppendMenuItem (men, _("Sticky Windows"), sticky, I_SUBMENU);
  } else {
    wspaces[0]=men;
  }

  GrabServer();

  ucn=NULL;
  while(ucn=NodeNext(TheScreen.UltimateList,ucn)){
    UltimateContext *uc;
    uc=ucn->data;
    if((uc->status&(ICONIFIED|MAPPED))&&uc->name){
      if(uc->WorkSpace==-1)
        AppendMenuItem(sticky,uc->name,uc,uc->status&ICONIFIED ?\
                                     I_SWITCH_OFF : I_SWITCH_ON);
      else
        AppendMenuItem(wspaces[uc->WorkSpace],uc->name,uc,uc->status&ICONIFIED?\
                                                    I_SWITCH_OFF : I_SWITCH_ON);
    }
  }

  if(x>(TheScreen.width-men->width))
    x=TheScreen.width-men->width;
  if(y>(TheScreen.height-men->height-1))
    y=TheScreen.height-men->height-1;
  if(item=StartMenu(men,x,y,True,True,NULL)){
    if(SWITCHTYPE(item->type)){
      UltimateContext *uc;
      uc=item->data;
      if(uc->status&ICONIFIED) {
        DeiconifyWin(uc);
      } else {
        ChangeWS(uc->WorkSpace);
        ActivateWin(uc);
        if(uc->frame!=None) {
          XRaiseWindow(disp,uc->frame);
        } else {
          XRaiseWindow(disp,uc->win);
        }
      }
    }
    if(item->type==I_SUBMENU) {
      for(a=0;a<TheScreen.desktop.WorkSpaces;a++)
        if(wspaces[a]==item->data) { ChangeWS(a);break;}
    }
  }

  UngrabServer();

  DestroyMenu(men);
  if(wspaces) free(wspaces);
}
